/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.Collection;
import nl.ibs.esp.uiobjects.APITable;
import nl.ibs.esp.uiobjects.OutputField;
import nl.ibs.esp.uiobjects.TableHeader;
import nl.ibs.esp.uiobjects.TableHeaderField;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.fis.FISBooking;
import nl.ibs.fac.fis.FISHelper;

public class FISBookingsTable
extends APITable {
    private static final long serialVersionUID = -635692085789838527L;
    private String companyId;
    private int bookYear;
    private int batchId;
    private String voucherId;
    private FISHelper fisHelper;
    private static final String[] LABELS = new String[]{"Label.Period", "Label.Amount", "Label.Description", "Label.MainAccount", "Label.Kostenplaats", "Label.Kostendrager", "Label.Statistieknummer1", "Label.Statistieknummer2", "Label.Statistieknummer3", "Label.Systnr"};
    private boolean moreRecs = true;

    public FISBookingsTable(LoginHelper loginHelper, String companyId, int bookYear, int batchId, String voucherId) throws Exception {
        super(12);
        this.companyId = companyId;
        this.bookYear = bookYear;
        this.batchId = batchId;
        this.voucherId = voucherId;
        this.fisHelper = new FISHelper(loginHelper);
    }

    protected TableHeader createTableHeader() throws Exception {
        TableHeader header = new TableHeader();
        header.add(new TableHeaderField(LABELS[0], 80));
        header.add(new TableHeaderField(LABELS[1], 80));
        header.add(new TableHeaderField(LABELS[2], 200));
        header.add(new TableHeaderField(LABELS[3], 80));
        header.add(new TableHeaderField(LABELS[4], 80));
        header.add(new TableHeaderField(LABELS[5], 80));
        header.add(new TableHeaderField(LABELS[6], 80));
        header.add(new TableHeaderField(LABELS[7], 80));
        header.add(new TableHeaderField(LABELS[8], 80));
        header.add(new TableHeaderField(LABELS[9], 80));
        return header;
    }

    protected TableRow createTableRow(Object object) throws Exception {
        TableRow row = new TableRow();
        FISBooking fisBooking = (FISBooking)object;
        row.add(new OutputField(PeriodHelper.toString(this.bookYear, fisBooking.getPeriode())));
        OutputField of = new OutputField(IBSDecimal.format(fisBooking.getBedrag()));
        of.setType("decimal");
        row.add(of);
        row.add(new OutputField(fisBooking.getOmschr()));
        row.add(new OutputField(fisBooking.getRekening()));
        row.add(new OutputField(FISBookingsTable.format(fisBooking.getKostenpl())));
        row.add(new OutputField(FISBookingsTable.format(fisBooking.getKostendr())));
        row.add(new OutputField(FISBookingsTable.format(fisBooking.getStatnr1())));
        row.add(new OutputField(FISBookingsTable.format(fisBooking.getStatnr2())));
        row.add(new OutputField(FISBookingsTable.format(fisBooking.getStatnr3())));
        row.add(new OutputField(String.valueOf(fisBooking.getSystnr()) + "/" + fisBooking.getSysvolg()));
        return row;
    }

    private static String format(int i) {
        if (i == 0) {
            return "";
        }
        return "" + i;
    }

    protected Collection getNextCollection(Object previousObject, String filter, String filterField, boolean position, int max) throws Exception {
        if (!this.moreRecs && previousObject != null) {
            return null;
        }
        Collection result = this.fisHelper.getNextBookingsCollection(previousObject, max, filter, filterField, position, this.companyId, this.bookYear, this.batchId, this.voucherId);
        if (result == null) {
            this.moreRecs = false;
            return null;
        }
        this.moreRecs = result.size() >= max;
        return result;
    }
}

