/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.Collection;
import nl.ibs.esp.uiobjects.APITable;
import nl.ibs.esp.uiobjects.OutputField;
import nl.ibs.esp.uiobjects.TableHeader;
import nl.ibs.esp.uiobjects.TableHeaderField;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.fac.IBSDecimal;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.fms.FMSBooking;
import nl.ibs.fac.fms.FMSHelper;

public class FMSBookingsTable
extends APITable {
    private static final long serialVersionUID = -2218934380796380409L;
    private String companyId;
    private int bookYear;
    private String daybookId;
    private String voucherId;
    private FMSHelper fmsHelper;
    private static final String[] LABELS = new String[]{"Label.Period", "Label.Amount", "Label.Description", "Label.MainAccount", "Label.Kostenplaats", "Label.Kostendrager", "Label.Aktiviteit", "Label.Prestatie", "Label.Systnr"};
    private boolean moreRecs = true;

    public FMSBookingsTable(LoginHelper loginHelper, String companyId, int bookYear, String daybookId, String voucherId) throws Exception {
        super(12);
        this.companyId = companyId;
        this.bookYear = bookYear;
        this.daybookId = daybookId;
        this.voucherId = voucherId;
        this.fmsHelper = new FMSHelper(loginHelper);
    }

    protected TableHeader createTableHeader() throws Exception {
        TableHeader header = new TableHeader();
        header.add(new TableHeaderField(LABELS[0], 80));
        header.add(new TableHeaderField(LABELS[1], 80));
        header.add(new TableHeaderField(LABELS[2], 200));
        header.add(new TableHeaderField(LABELS[3], 80));
        header.add(new TableHeaderField(LABELS[4], 80));
        header.add(new TableHeaderField(LABELS[5], 80));
        header.add(new TableHeaderField(LABELS[6], 80));
        header.add(new TableHeaderField(LABELS[7], 80));
        header.add(new TableHeaderField(LABELS[8], 80));
        return header;
    }

    protected TableRow createTableRow(Object object) throws Exception {
        TableRow row = new TableRow();
        FMSBooking fmsBooking = (FMSBooking)object;
        row.add(new OutputField(PeriodHelper.toString(this.bookYear, fmsBooking.getPeriode())));
        OutputField of = new OutputField(IBSDecimal.format(fmsBooking.getBedrag()));
        of.setType("decimal");
        row.add(of);
        row.add(new OutputField(fmsBooking.getOmschr()));
        row.add(new OutputField(fmsBooking.getRekening()));
        row.add(new OutputField(fmsBooking.getKostenpl()));
        row.add(new OutputField(fmsBooking.getKostendr()));
        row.add(new OutputField(fmsBooking.getAktiviteit()));
        row.add(new OutputField(fmsBooking.getPrestatie()));
        row.add(new OutputField(fmsBooking.getSystnr()));
        return row;
    }

    protected Collection getNextCollection(Object previousObject, String filter, String filterField, boolean position, int max) throws Exception {
        if (!this.moreRecs && previousObject != null) {
            return null;
        }
        Collection result = this.fmsHelper.getNextBookingsCollection(previousObject, max, filter, filterField, position, this.companyId, this.bookYear, this.daybookId, this.voucherId);
        if (result == null) {
            this.moreRecs = false;
            return null;
        }
        this.moreRecs = result.size() >= max;
        return result;
    }
}

