/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import java.util.Collection;
import nl.ibs.esp.event.EventListener;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.OutputField;
import nl.ibs.esp.uiobjects.TableHeader;
import nl.ibs.esp.uiobjects.TableHeaderField;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserErrorMessage;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.util.NameValuePair;

public class FMSReferenceField
extends FinancialReferenceField {
    private static final long serialVersionUID = 2846852398310739108L;
    private FMSHelper fmsHelper;
    private boolean checkEvent = true;

    public FMSReferenceField(LoginHelper loginHelper, String label, int index, Company company) throws Exception {
        this(loginHelper, label, index, true);
        this.company = company;
    }

    public FMSReferenceField(LoginHelper loginHelper, String label, int index, boolean validate) throws Exception {
        super(loginHelper, label, index, validate);
        this.index = index;
        this.fmsHelper = new FMSHelper(loginHelper);
        if (index == -2) {
            this.setLength(5);
            this.setMaxLength(5);
            this.setType("upper");
        } else {
            String[] dimensionAttributes = this.fmsHelper.getDimensionAttributes(index);
            if (dimensionAttributes[0].equals("N")) {
                this.setType("number");
            } else {
                this.setType("upper");
            }
            this.setMaxLength(Integer.parseInt(dimensionAttributes[1]));
            this.setLength(10);
        }
        this.setPositionFields(new String[]{NAMES[0]});
        this.setSearchFields(new String[]{NAMES[1]});
        this.setDescriptionLength(40);
        this.determineHelpId();
        this.addOnChangeListener(new MyListener());
    }

    private void determineHelpId() throws Exception {
        switch (this.index) {
            case -1: {
                this.setHelpId("GLDayBook");
                break;
            }
            case 0: {
                this.setHelpId("GLMainAccount");
                break;
            }
            case 11: {
                this.setHelpId("EXTDimension");
                break;
            }
            case 10: {
                this.setHelpId("EXTDimension");
                break;
            }
            case 12: {
                this.setHelpId("EXTDimension");
                break;
            }
            default: {
                this.setHelpId("FINDimension");
            }
        }
    }

    protected TableHeader createTableHeader() throws Exception {
        TableHeader header = new TableHeader();
        header.add(new TableHeaderField(LABELS[0], 80));
        header.add(new TableHeaderField(LABELS[1], 280));
        return header;
    }

    protected TableRow createTableRow(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        NameValuePair pair = (NameValuePair)object;
        TableRow row = new TableRow();
        row.add(new OutputField(pair.getName()));
        row.add(new OutputField(pair.getValue()));
        return row;
    }

    protected Collection getNextCollection(Object previousObject, String filter, String filterField, boolean position, int max) throws Exception {
        if (!this.moreRecs && previousObject != null) {
            return null;
        }
        Collection result = this.fmsHelper.getNextCollection(previousObject, max, filter, filterField, position, this.index);
        if (result == null) {
            this.moreRecs = false;
            return null;
        }
        this.moreRecs = result.size() >= max;
        return result;
    }

    public void validate() throws Exception {
        super.validate();
        if (!this.validate || this.getReadonly()) {
            this.formattedId = this.fmsHelper.formatId(this.getValue().trim(), this.index);
            return;
        }
        if (this.getValue().trim().length() == 0) {
            this.formattedId = "";
            this.setDescription("");
            return;
        }
        NameValuePair pair = this.fmsHelper.getNameValuePair(this.getValue(), this.index);
        if (pair == null) {
            this.setInvalidTag();
            throw new UserErrorMessage("key_not_found");
        }
        this.formattedId = pair.getName();
        this.setDescription(pair.getValue());
        if (this.company == null) {
            return;
        }
        Company dataSet = this.company.getDataSet();
        if (dataSet == null) {
            dataSet = this.company;
        }
        String fromId = "";
        String toId = "";
        switch (this.index) {
            case 1: {
                fromId = dataSet.getFD1From();
                toId = dataSet.getFD1To();
                break;
            }
            case 2: {
                fromId = dataSet.getFD2From();
                toId = dataSet.getFD2To();
                break;
            }
            case 3: {
                fromId = dataSet.getFD3From();
                toId = dataSet.getFD3To();
                break;
            }
            case 4: {
                fromId = dataSet.getFD4From();
                toId = dataSet.getFD4To();
            }
        }
        if (this.getType().equals("number")) {
            if (fromId.trim().length() > 0 && new BigDecimal(this.getValue().trim()).compareTo(new BigDecimal(fromId.trim())) < 0) {
                this.setInvalidTag();
                throw new UserErrorMessage("not_in_range");
            }
            if (toId.trim().length() > 0 && new BigDecimal(this.getValue().trim()).compareTo(new BigDecimal(toId.trim())) > 0) {
                this.setInvalidTag();
                throw new UserErrorMessage("not_in_range");
            }
            return;
        }
        if (fromId.trim().length() > 0 && this.getValue().compareTo(fromId) < 0) {
            this.setInvalidTag();
            throw new UserErrorMessage("not_in_range");
        }
        if (toId.trim().length() > 0 && this.getValue().compareTo(toId) > 0) {
            this.setInvalidTag();
            throw new UserErrorMessage("not_in_range");
        }
    }

    protected void setSelectedObject(Object object) throws Exception {
        NameValuePair pair = (NameValuePair)object;
        this.checkEvent = false;
        this.setValue(pair.getName().trim());
        this.checkEvent = true;
        this.setDescription(pair.getValue());
    }

    public Field setValue(String value) {
        return super.setValue(this.fmsHelper.unFormatId(value, this.index));
    }

    private class MyListener
    implements EventListener {
        private static final long serialVersionUID = 2680984705342842641L;

        private MyListener() {
        }

        public void event(UIObject object, String eventType) throws Exception {
            if (!FMSReferenceField.this.checkEvent) {
                return;
            }
            if (FMSReferenceField.this.getValue().trim().length() == 0 || FMSReferenceField.this.index == -2) {
                FMSReferenceField.this.setDescription("");
                return;
            }
            String description = null;
            description = FMSReferenceField.this.index == -2 ? FMSReferenceField.this.fmsHelper.getAdministrationDescription(FMSReferenceField.this.getValue()) : FMSReferenceField.this.fmsHelper.getDescription(FMSReferenceField.this.getValue(), FMSReferenceField.this.index);
            if (description != null) {
                FMSReferenceField.this.setDescription(description);
                return;
            }
            FMSReferenceField.this.setDescription("");
        }
    }
}

