/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import nl.ibs.esp.uiobjects.CollectionReferenceField;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.fis.FISHelper;
import nl.ibs.fac.fms.FMSHelper;
import nl.ibs.fac.queries.CompanyQuery;
import nl.ibs.jsql.DBData;

public class FinancialCompanyReferenceField
extends CollectionReferenceField {
    private static final long serialVersionUID = -2931193939017700915L;
    private static final String[] NAMES = new String[]{"id", "description"};
    private static final String[] LABELS = new String[]{"Label.Company", "Label.Description"};
    private static final short[] SIZES = new short[]{70, 500};
    private DBData dbData;
    private FISHelper fisHelper = null;
    private FMSHelper fmsHelper = null;
    private Collection collection = null;

    public FinancialCompanyReferenceField(LoginHelper loginHelper, Environment environment) throws Exception {
        super(LABELS[0], "upper", null, Company.class);
        this.dbData = EnvironmentBO.getDBData(environment.getFacLib());
        if (environment.getOperationArea().length() > 0) {
            this.fmsHelper = new FMSHelper(loginHelper);
        } else {
            this.fisHelper = new FISHelper(loginHelper);
        }
        this.setName(((Object)((Object)this)).getClass().getName());
        this.setTableFields(NAMES);
        this.setTableHeaderLabels(LABELS);
        this.setValueField(NAMES[0]);
        this.setDescriptionField(NAMES[1]);
        this.setTableKeys(new String[]{NAMES[0]});
        this.setTableHeaderSizes(SIZES);
        this.setLength(7);
        this.setMaxLength(7);
        this.setDescriptionLength(50);
        this.setSearchFields(NAMES);
        this.setSearchFieldLabels(LABELS);
        this.getCollection();
        this.addValidation();
    }

    public Collection getCollection() throws Exception {
        if (this.collection == null) {
            this.collection = new CompanyQuery(this.dbData).fetchData(null, "id", null, 0);
            Set names = this.fmsHelper != null ? this.fmsHelper.getAdministrations() : this.fisHelper.getAdministrations();
            Iterator iterator = this.collection.iterator();
            while (iterator.hasNext()) {
                Company company = (Company)iterator.next();
                if (names.contains(company.getId())) continue;
                iterator.remove();
            }
        }
        return this.collection;
    }

    public Field setValue(String id) {
        super.setValue(id);
        this.setDescription("");
        if (id == null) {
            return this;
        }
        try {
            Company company = this.getCompany();
            if (company == null) {
                return this;
            }
            this.setDescription(company.getDescription());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public Company getCompany() throws Exception {
        Object[] all = this.getCollection().toArray();
        int i = 0;
        while (i < all.length) {
            Company company = (Company)all[i];
            if (this.getValue().equals(company.getId())) {
                return company;
            }
            ++i;
        }
        return null;
    }
}

