/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import com.ibm.as400.access.AS400;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Separator;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserMessageException;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.ComparisonValue;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.TransactionTypeEnum;
import nl.ibs.fac.adapters.BookYearField;
import nl.ibs.fac.adapters.ComparisonDifferenceImageTransformer;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionDetailAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionImageTransformer;
import nl.ibs.fac.adapters.MultipleTypesImageTransformer;
import nl.ibs.fac.adapters.TransactionAdapter;
import nl.ibs.fac.adapters.TransactionStateImageTransformer;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.ComparisonBP;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.fac.queries.TransactionQuery;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;

public class GLComparisonAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -7259799335509142079L;
    public static final String PAGE = GLComparisonAdapter.class.getName();
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private Company company;
    private int numberOfCorrectionPeriods;
    private int theNumberOfPeriods;
    private int year;
    private int accountingPrinciple;
    private String cora = "A";
    private int mainTransactionType;
    private int period;
    private String[] typeIds;
    private int greaterThanPeriod;
    private ComparisonBP businessProcess;
    private ComparisonValue glComparisonValue;
    private ComparisonValue previousComparisonValue;
    private ComparisonValue nextComparisonValue;
    private Collection glComparisonValues;
    private Collection<Serializable> mainGLComparisonValues;
    private Collection<Serializable> subGLComparisonValues;
    private FieldGroup fg1;
    private BookYearField byfYear;
    private ComboBox cbAccountingPrinciple;
    private FloatBar fb1;
    private Action ok;
    private FloatBar fb2;
    private FloatBar fb3B;
    private Action previousType;
    private Action nextType;
    private Action previousAccount;
    private Action nextAccount;
    private String subScreenName;
    private FieldGroup fg3;
    private Field fYear;
    private Field aPrinciple;
    private ReferenceField rfMA1;
    private int mainAccountSeqNr = 0;
    private int currentIndex;
    private Action[] rowActions;
    private boolean mainAccountViewInitialized = false;
    private boolean multipleTypesViewInitialized = false;
    private boolean investmentAndDisinvestmentViewInitialized = false;
    private boolean transactionViewInitialized = false;
    private CollectionTable table = null;
    private static final String[] NAMES = new String[]{"acquisitionAccountDescription", "multipleTypes", "gLAcquisitionTotal", "fACAcquisitionTotal", "acquisitionTotalDifference", "gLDepreciationTotal", "fACDepreciationTotal", "depreciationTotalDifference"};
    private static final String[] LABELS = new String[]{"Label.Description", "Label.MultipleTypes", "Label.AcquisitionValue_GL", "Label.AcquisitionValue_FAC", "Label.AcquisitionTotalDifference", "Label.DepreciationValue_GL", "Label.DepreciationValue_FAC", "Label.DepreciationTotalDifference"};
    private static final String[] TOOLTIPS = new String[]{"Label.MultipleTypes", "Label.AcquisitionTotalDifference", "Label.DepreciationTotalDifference"};
    private static final short[] SIZES = new short[]{150, 20, 120, 120, 20, 120, 120, 20};
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final ComparisonDifferenceImageTransformer DIFFERENCETRANSFORMER = new ComparisonDifferenceImageTransformer();
    private static final MultipleTypesImageTransformer MULTIPLETYPESTRANSFORMER = new MultipleTypesImageTransformer();
    private Transformer[] transformers;
    private Action[] MAV_rowActions;
    private CollectionTable mainAccountViewTable;
    private static final String[] MAV_NAMES = new String[]{"period", "amount1", "amount2", "differenceIndicator_1", "amount3", "amount4"};
    private static final String[] MAV_LABELS = new String[]{"Label.Period.short", "Label.GeneralLedger", "FAC", "Label.Difference", "Label.GeneralLedger", "FAC"};
    private static final String[] MAV_TOOLTIPS = new String[]{"Label.Difference"};
    private static final short[] MAV_SIZES = new short[]{30, 202, 120, 20, 202, 120};
    private Transformer[] MAV_transformers;
    private static String[] T_NAMES = new String[]{"assetId", "AssetDescription", "valueForAmount1", "documentAndSequenceNumber", "description", "daybookId", "voucherId", "state", "incomingFinancialTransaction"};
    private static String[] T_LABELS = new String[]{"Label.Id", "Label.Description", "Label.Amount", "Label.TransNbrShort", "Label.Description", "Label.Daybook", "Label.VoucherId", "Label.State", "Label.IncomingFinancialTransaction"};
    private static String[] T_TOOLTIPS = new String[]{"Label.State", "Label.IncomingFinancialTransaction"};
    private static short[] T_SIZES = new short[]{80, 180, 110, 80, 180, 60, 60, 20, 20};
    private static String[] T_TYPES;
    private static final ZeroBigDecimalToBlankTransformer ZBD_DECIMALTRANSFORMER;
    private static Transformer[] T_TRANSFORMERS;
    private static boolean[] T_COLUMNNOWRAPS;
    private static boolean[] T_SORTABLE;
    private static String[] T_SEARCH_NAMES;
    private static String[] T_SEARCH_LABELS;
    private CollectionTable subTable;
    private static final String[] SUB_NAMES;
    private static final String[] SUB_LABELS;
    private static final String[] SUB_TOOLTIPS;
    private static final short[] SUB_SIZES;
    private Transformer[] SUB_transformers;
    private Action[] IAD_rowActions;
    private CollectionTable iadTable;
    private static final String[] IAD_NAMES;
    private static final String[] IAD_LABELS;
    private static final String[] IAD_TOOLTIPS;
    private static final short[] IAD_SIZES;
    private Transformer[] IAD_transformers;
    private static final String[] TT_NAMES;
    private static final String[] TT_LABELS;
    private static final String[] TT_TOOLTIPS;
    private static final short[] TT_SIZES;
    private static final String[] TT_TYPES;
    private static final Transformer[] TT_TRANSFORMERS;
    private static final boolean[] TT_COLUMNNOWRAPS;
    private static final boolean[] TT_SORTABLE;
    private static final String[] TT_SEARCH_NAMES;
    private static final String[] TT_SEARCH_LABELS;
    private ODBTable transactionTable;
    private CommonTable.SearchPanel searchPanel;
    private Map<String, ComboBox> inputComponents;
    private Action[] transactionRowActions;
    private boolean isFMS;

    static {
        String[] stringArray = new String[9];
        stringArray[0] = "text";
        T_TYPES = stringArray;
        ZBD_DECIMALTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
        Transformer[] transformerArray = new Transformer[9];
        transformerArray[2] = ZBD_DECIMALTRANSFORMER;
        transformerArray[7] = new TransactionStateImageTransformer();
        transformerArray[8] = new IncomingFinancialTransactionImageTransformer();
        T_TRANSFORMERS = transformerArray;
        T_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true};
        boolean[] blArray = new boolean[9];
        blArray[0] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        T_SORTABLE = blArray;
        T_SEARCH_NAMES = new String[]{"assetId", "documentNr", "voucherId", "transactionType"};
        T_SEARCH_LABELS = new String[]{"Label.AssetId", "Label.Transaction", "Label.VoucherId", "Label.TransactionType"};
        SUB_NAMES = new String[]{"assetTypeId", "assetTypeDescription", "fACAcquisitionTotal", "acquisitionTotalDifference", "fACDepreciationTotal", "depreciationTotalDifference", "fACCostTotal", "costTotalDifference"};
        SUB_LABELS = new String[]{"Label.Id", "Label.Description", "Label.AcquisitionValue", "Label.AcquisitionTotalDifference", "Label.Depreciations", "Label.DepreciationTotalDifference", "Label.DepreciationCosts", "Label.CostTotalDifference"};
        SUB_TOOLTIPS = new String[]{"Label.AcquisitionTotalDifference", "Label.DepreciationTotalDifference", "Label.CostTotalDifference"};
        SUB_SIZES = new short[]{100, 200, 120, 20, 120, 20, 120, 20};
        IAD_NAMES = new String[]{"description", "amount1", "differenceIndicator_1", "amount2", "differenceIndicator_2", "amount3"};
        IAD_LABELS = new String[]{"Label.Description", "Label.AcquisitionValue_FAC", "Label.AcquisitionTotalDifference", "Label.DepreciationValue_FAC", "Label.DepreciationTotalDifference", "Label.BookValue"};
        IAD_TOOLTIPS = new String[]{"Label.AcquisitionTotalDifference", "Label.DepreciationTotalDifference"};
        IAD_SIZES = new short[]{200, 120, 20, 120, 20, 120};
        TT_NAMES = new String[]{"periodForJournalization", "assetId", "AssetDescription", "valueForAmount1", "valueForAmount2", "documentAndSequenceNumber", "description", "daybookId", "voucherId", "state", "incomingFinancialTransaction"};
        TT_LABELS = new String[]{"Label.Period.short", "Label.Id", "Label.Description", "Label.Acquisition", "Label.Depreciation", "Label.TransNbrShort", "Label.Description", "Label.Daybook", "Label.VoucherId", "Label.State", "Label.IncomingFinancialTransaction"};
        TT_TOOLTIPS = new String[]{"Label.State", "Label.IncomingFinancialTransaction"};
        TT_SIZES = new short[]{30, 80, 180, 110, 110, 80, 180, 60, 60, 20, 20};
        String[] stringArray2 = new String[11];
        stringArray2[1] = "text";
        TT_TYPES = stringArray2;
        Transformer[] transformerArray2 = new Transformer[11];
        transformerArray2[3] = ZBD_DECIMALTRANSFORMER;
        transformerArray2[4] = ZBD_DECIMALTRANSFORMER;
        transformerArray2[9] = new TransactionStateImageTransformer();
        transformerArray2[10] = new IncomingFinancialTransactionImageTransformer();
        TT_TRANSFORMERS = transformerArray2;
        TT_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true};
        boolean[] blArray2 = new boolean[11];
        blArray2[0] = true;
        blArray2[1] = true;
        blArray2[6] = true;
        blArray2[7] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        blArray2[10] = true;
        TT_SORTABLE = blArray2;
        TT_SEARCH_NAMES = new String[]{"periodForJournalization", "assetId", "documentNr", "voucherId", "transactionType"};
        TT_SEARCH_LABELS = new String[]{"Label.Period", "Label.AssetId", "Label.Transaction", "Label.VoucherId", "Label.TransactionType"};
    }

    public GLComparisonAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        Transformer[] transformerArray = new Transformer[8];
        transformerArray[1] = MULTIPLETYPESTRANSFORMER;
        transformerArray[2] = DECIMALTRANSFORMER;
        transformerArray[3] = DECIMALTRANSFORMER;
        transformerArray[4] = DIFFERENCETRANSFORMER;
        transformerArray[5] = DECIMALTRANSFORMER;
        transformerArray[6] = DECIMALTRANSFORMER;
        transformerArray[7] = DIFFERENCETRANSFORMER;
        this.transformers = transformerArray;
        this.mainAccountViewTable = null;
        Transformer[] transformerArray2 = new Transformer[6];
        transformerArray2[1] = DECIMALTRANSFORMER;
        transformerArray2[2] = DECIMALTRANSFORMER;
        transformerArray2[3] = DIFFERENCETRANSFORMER;
        transformerArray2[4] = DECIMALTRANSFORMER;
        transformerArray2[5] = DECIMALTRANSFORMER;
        this.MAV_transformers = transformerArray2;
        this.subTable = null;
        Transformer[] transformerArray3 = new Transformer[8];
        transformerArray3[2] = DECIMALTRANSFORMER;
        transformerArray3[3] = DIFFERENCETRANSFORMER;
        transformerArray3[4] = DECIMALTRANSFORMER;
        transformerArray3[5] = DIFFERENCETRANSFORMER;
        transformerArray3[6] = DECIMALTRANSFORMER;
        transformerArray3[7] = DIFFERENCETRANSFORMER;
        this.SUB_transformers = transformerArray3;
        this.iadTable = null;
        Transformer[] transformerArray4 = new Transformer[6];
        transformerArray4[1] = DECIMALTRANSFORMER;
        transformerArray4[2] = DIFFERENCETRANSFORMER;
        transformerArray4[3] = DECIMALTRANSFORMER;
        transformerArray4[4] = DIFFERENCETRANSFORMER;
        transformerArray4[5] = DECIMALTRANSFORMER;
        this.IAD_transformers = transformerArray4;
        this.inputComponents = new HashMap<String, ComboBox>();
        this.isFMS = false;
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.numberOfCorrectionPeriods = this.company.getNumberOfCorrectionPeriods();
        this.theNumberOfPeriods = this.numberOfPeriods;
        if (this.numberOfCorrectionPeriods > 0) {
            ++this.theNumberOfPeriods;
        }
        if (this.env.getOperationArea().trim().length() > 0) {
            this.isFMS = true;
        }
        this.businessProcess = new ComparisonBP(this.dbData, (AS400)this.loginHelper.getAs400(), this.env, this.company, this.numberOfPeriods, this.isFMS);
        this.fg1 = new FieldGroup("");
        this.byfYear = new BookYearField("Label.BookYear", this.bookYear, this.bookYearMin, this.bookYearMax);
        this.byfYear.setReadonly(false);
        this.fg1.add((Field)this.byfYear);
        this.cbAccountingPrinciple = new ComboBox("Label.AccountingPrinciple");
        this.cbAccountingPrinciple.addOption(this.env.getAPName1(), "1");
        this.cbAccountingPrinciple.setSelectedOptionValue("1");
        this.cbAccountingPrinciple.setReadonly(true);
        this.fg1.add(this.cbAccountingPrinciple);
        this.fb1 = new FloatBar();
        this.ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("internalShow");
        this.ok.setValidationEnabled(true);
        this.ok.setDefault(true);
        this.fb1.addAction(this.ok);
        this.fb1.addAction(this.finish);
        this.fb2 = new FloatBar();
        this.fb2.addAction(new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show"));
        this.fb2.addAction(this.finish);
        Action action_1 = new Action("Label.AcquisitionValue").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showAcquisitionAccount");
        Action action_2 = new Action("Label.Depreciations").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showDepreciationAccount");
        Action action_3 = new Action("Label.DepreciationCosts").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showCostAccount");
        Action action_4 = new Action("Label.MultipleTypes").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showMultipleTypes");
        Action action_5 = new Action("Label.InvestmentsAndDisinvestments").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showInvestmentAndDisinvestment");
        this.rowActions = new Action[]{action_1, action_2, action_3, action_4, action_5};
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.GLComparison", "screen_name"));
        this.byfYear.setMandatory(true);
        object.addUIObject((UIObject)this.fg1);
        object.addUIObject((UIObject)this.fb1);
        DBData defaultDBData = DBData.getDefaultDBData("fac");
        DBPersistenceManager.setDefaultDataBase(this.dbData);
        BigDecimal[] totals = ComparisonBP.retrieveCompanyTotals(this.company, 1, true, true);
        DBPersistenceManager.setDefaultDataBase(defaultDBData);
        if (totals[0].doubleValue() != totals[1].doubleValue() || totals[2].doubleValue() != totals[3].doubleValue()) {
            this.ok.setConfirmationMessage("InternalDifferencesFound");
        }
        return object;
    }

    public DataObject internalShow(DataObject object) throws Exception {
        this.year = Integer.parseInt(this.byfYear.getValue());
        this.accountingPrinciple = Integer.parseInt(this.cbAccountingPrinciple.getValue());
        if (this.table == null) {
            this.glComparisonValues = this.businessProcess.retrieveGLComparisonValues(this.accountingPrinciple, this.year);
            if (this.glComparisonValues == null || this.glComparisonValues.isEmpty()) {
                object.addUIObject((UIObject)new Message("MainAccountSchemesOnAssetTypeLevelInvalid", "error"));
                return object;
            }
            this.createTable();
        }
        if (!this.mainAccountViewInitialized) {
            this.initializeMainAccountView();
        }
        this.byfYear.setReadonly(true);
        this.byfYear.setMandatory(false);
        this.rfMA1.setValue(object.translate("Label.NotApplicable.short", object.getLocale()));
        this.rfMA1.setDescription("");
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.GLComparison", "screen_name"));
        object.addUIObject((UIObject)new Header("Label.Common", "sub_screen_name"));
        object.addUIObject((UIObject)this.fg3);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fb2);
        return object;
    }

    private void createTable() throws Exception {
        int index = 0;
        this.mainGLComparisonValues = new Vector<Serializable>();
        for (ComparisonValue glComparisonValue : this.glComparisonValues) {
            if (glComparisonValue.getBeanType() != 0) continue;
            glComparisonValue.setCurrentIndex(index);
            this.mainGLComparisonValues.add(glComparisonValue);
            ++index;
        }
        this.table = new CollectionTable(ComparisonValue.class, this.mainGLComparisonValues, 12);
        this.table.setName(PAGE);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setDisplayTransformers(this.transformers);
        this.table.setSortable(false);
        this.table.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.table, null, (Action[])this.rowActions, (TableRowMethod)new GLComparisonValueTableRowMethod());
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    public DataObject showAcquisitionAccount(DataObject object) throws Exception {
        this.glComparisonValue = (ComparisonValue)TableHelper.getSelectedItem((DataObject)object);
        this.currentIndex = this.glComparisonValue.getCurrentIndex();
        this.mainAccountSeqNr = 1;
        return this.createMainAccountView(object);
    }

    public DataObject showDepreciationAccount(DataObject object) throws Exception {
        this.glComparisonValue = (ComparisonValue)TableHelper.getSelectedItem((DataObject)object);
        if (this.glComparisonValue.getDepreciationAccount().length() == 0) {
            TokenList tl = new TokenList();
            tl.addNonTranslatable(this.glComparisonValue.getAcquisitionAccount());
            tl.addNonTranslatable(this.glComparisonValue.getAcquisitionAccountDescription());
            tl.addTranslatable("nl.ibs.fac.language", "Depreciations");
            throw new UserMessageException(LanguageHelper.getString("nl.ibs.fac.language", "no_main_account_defined", tl));
        }
        this.currentIndex = this.glComparisonValue.getCurrentIndex();
        this.mainAccountSeqNr = 2;
        return this.createMainAccountView(object);
    }

    public DataObject showCostAccount(DataObject object) throws Exception {
        this.glComparisonValue = (ComparisonValue)TableHelper.getSelectedItem((DataObject)object);
        if (this.glComparisonValue.getCostAccount().length() == 0) {
            TokenList tl = new TokenList();
            tl.addNonTranslatable(this.glComparisonValue.getAcquisitionAccount());
            tl.addNonTranslatable(this.glComparisonValue.getAcquisitionAccountDescription());
            tl.addTranslatable("nl.ibs.fac.language", "DepreciationCosts");
            throw new UserMessageException(LanguageHelper.getString("nl.ibs.fac.language", "no_main_account_defined", tl));
        }
        this.currentIndex = this.glComparisonValue.getCurrentIndex();
        this.mainAccountSeqNr = 3;
        return this.createMainAccountView(object);
    }

    private void initializeMainAccountView() throws Exception {
        this.fg3 = new FieldGroup("");
        this.fYear = new Field("Label.BookYear");
        this.fYear.setValue(this.byfYear.getValue());
        this.fYear.setReadonly(true);
        this.rfMA1 = new ReferenceField("Label.MainAccount");
        this.rfMA1.setDescriptionLength(40);
        this.rfMA1.setReadonly(true);
        this.aPrinciple = new Field("Label.AccountingPrinciple");
        this.aPrinciple.setValue(this.cbAccountingPrinciple.getSelectedOption().getLabel());
        this.aPrinciple.setReadonly(true);
        this.previousType = new Action("Button.PreviousType").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showPreviousType");
        this.nextType = new Action("Button.NextType").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showNextType");
        this.fg3.add(this.fYear);
        this.fg3.add(this.aPrinciple);
        this.fg3.add((Field)this.rfMA1);
        this.fb3B = new FloatBar();
        this.fb3B.addAction(new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("internalShow"));
        this.previousAccount = new Action("< Account").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showPreviousAccount");
        this.nextAccount = new Action("Account >").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showNextAccount");
        this.fb3B.addAction(this.previousType);
        this.fb3B.addAction(this.nextType);
        this.fb3B.addAction(this.previousAccount);
        this.fb3B.addAction(this.nextAccount);
        this.fb3B.addAction(this.finish);
        Action action = new Action("Label.Transactions").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showMAVTransactions");
        this.MAV_rowActions = new Action[]{action};
        action = new Action("Label.Transactions").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showIADTransactions");
        this.IAD_rowActions = new Action[]{action};
    }

    /*
     * WARNING - void declaration
     */
    private void determinePreviousAndNextComparisonValue(boolean evokedFromPrevious) throws Exception {
        void var3_8;
        this.nextComparisonValue = null;
        this.previousComparisonValue = null;
        ComparisonValue currentComparisonValue = null;
        Object var3_3 = null;
        for (ComparisonValue comparisonValue : this.mainGLComparisonValues) {
            if (!comparisonValue.equals(this.glComparisonValue)) {
                if (currentComparisonValue == null) {
                    this.previousComparisonValue = comparisonValue;
                    continue;
                }
                this.nextComparisonValue = comparisonValue;
                break;
            }
            currentComparisonValue = comparisonValue;
        }
        if (evokedFromPrevious && this.previousComparisonValue == null || !evokedFromPrevious && this.nextComparisonValue == null) {
            return;
        }
        if (evokedFromPrevious) {
            ComparisonValue comparisonValue = this.previousComparisonValue;
        } else {
            ComparisonValue comparisonValue = this.nextComparisonValue;
        }
        if (this.mainAccountSeqNr == 2) {
            if (var3_8.getDepreciationAccount().length() == 0) {
                TokenList tl = new TokenList();
                tl.addNonTranslatable(var3_8.getAcquisitionAccount());
                tl.addNonTranslatable(var3_8.getAcquisitionAccountDescription());
                tl.addTranslatable("nl.ibs.fac.language", "Depreciations");
                throw new UserMessageException(LanguageHelper.getString("nl.ibs.fac.language", "no_main_account_defined", tl));
            }
        } else if (this.mainAccountSeqNr == 3 && var3_8.getCostAccount().length() == 0) {
            TokenList tl = new TokenList();
            tl.addNonTranslatable(var3_8.getAcquisitionAccount());
            tl.addNonTranslatable(var3_8.getAcquisitionAccountDescription());
            tl.addTranslatable("nl.ibs.fac.language", "DepreciationCosts");
            throw new UserMessageException(LanguageHelper.getString("nl.ibs.fac.language", "no_main_account_defined", tl));
        }
    }

    public DataObject showPreviousType(DataObject object) throws Exception {
        this.determinePreviousAndNextComparisonValue(true);
        if (this.previousComparisonValue == null) {
            return object;
        }
        this.glComparisonValue = this.previousComparisonValue;
        --this.currentIndex;
        return this.createMainAccountView(object);
    }

    public DataObject showNextType(DataObject object) throws Exception {
        this.determinePreviousAndNextComparisonValue(false);
        if (this.nextComparisonValue == null) {
            return object;
        }
        this.glComparisonValue = this.nextComparisonValue;
        ++this.currentIndex;
        return this.createMainAccountView(object);
    }

    public DataObject showPreviousAccount(DataObject object) throws Exception {
        this.mainAccountSeqNr = this.mainAccountSeqNr == 1 ? 2 : 1;
        return this.createMainAccountView(object);
    }

    public DataObject showNextAccount(DataObject object) throws Exception {
        this.mainAccountSeqNr = this.mainAccountSeqNr == 3 ? 2 : 3;
        return this.createMainAccountView(object);
    }

    private DataObject createMainAccountView(DataObject object) throws Exception {
        this.businessProcess.retrieveGLComparisonValueDetails(this.glComparisonValue);
        this.subScreenName = this.glComparisonValue.getAcquisitionAccountDescription();
        switch (this.mainAccountSeqNr) {
            case 1: {
                this.rfMA1.setDescription(this.glComparisonValue.getAcquisitionAccountDescription());
                this.rfMA1.setValue("" + Integer.parseInt(this.glComparisonValue.getAcquisitionAccount().trim()));
                break;
            }
            case 2: {
                this.rfMA1.setDescription(this.glComparisonValue.getDepreciationAccountDescription());
                this.rfMA1.setValue("" + Integer.parseInt(this.glComparisonValue.getDepreciationAccount().trim()));
                break;
            }
            case 3: {
                this.rfMA1.setDescription(this.glComparisonValue.getCostAccountDescription());
                this.rfMA1.setValue("" + Integer.parseInt(this.glComparisonValue.getCostAccount().trim()));
            }
        }
        Vector<InternalRow> maRows = new Vector<InternalRow>();
        int figureType = (this.mainAccountSeqNr - 1) * 2;
        int period = 0;
        while (period <= this.theNumberOfPeriods) {
            InternalRow maRow = new InternalRow();
            maRow.period = period;
            maRow.amount1 = this.glComparisonValue.getFigure(figureType, period);
            maRow.amount3 = this.glComparisonValue.getFigureYTD(figureType, period);
            maRow.amount2 = this.glComparisonValue.getFigure(figureType + 1, period);
            maRow.amount4 = this.glComparisonValue.getFigureYTD(figureType + 1, period);
            switch (this.mainAccountSeqNr) {
                case 1: {
                    maRow.differenceIndicator_1 = this.glComparisonValue.getAcquisitionDetailDifference(period);
                    break;
                }
                case 2: {
                    maRow.differenceIndicator_1 = this.glComparisonValue.getDepreciationDetailDifference(period);
                    break;
                }
                case 3: {
                    maRow.differenceIndicator_1 = this.glComparisonValue.getCostDetailDifference(period);
                }
            }
            maRows.add(maRow);
            ++period;
        }
        this.mainAccountViewTable = new CollectionTable(InternalRow.class, maRows, this.theNumberOfPeriods + 1);
        this.mainAccountViewTable.setName(String.valueOf(PAGE) + "-mavTable");
        this.mainAccountViewTable.setColumnNames(MAV_NAMES);
        this.mainAccountViewTable.setColumnLabels(MAV_LABELS);
        this.mainAccountViewTable.setColumnSizes(MAV_SIZES);
        this.mainAccountViewTable.setDisplayTransformers(this.MAV_transformers);
        this.mainAccountViewTable.setSortable(false);
        this.mainAccountViewTable.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.mainAccountViewTable, null, (Action[])this.MAV_rowActions, (TableRowMethod)new MainAccountViewTableRowMethod());
        this.mainAccountViewTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.mainAccountViewTable, (String[])MAV_TOOLTIPS);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.GLComparison", "screen_name"));
        object.addUIObject((UIObject)new Header(this.subScreenName, "sub_screen_name"));
        object.addUIObject((UIObject)this.fg3);
        object.addUIObject((UIObject)this.mainAccountViewTable);
        this.previousAccount.setEnabled(true);
        this.nextAccount.setEnabled(true);
        this.previousType.setEnabled(true);
        this.nextType.setEnabled(true);
        if (this.currentIndex == 0) {
            this.previousType.setEnabled(false);
        }
        if (this.currentIndex == this.mainGLComparisonValues.size() - 1) {
            this.nextType.setEnabled(false);
        }
        if (this.mainAccountSeqNr == 1) {
            this.previousAccount.setLabel("Label.Depreciation");
            if (this.glComparisonValue.getDepreciationAccount().length() == 0) {
                this.previousAccount.setEnabled(false);
            }
            this.nextAccount.setLabel("Label.DepreciationCosts.short");
            if (this.glComparisonValue.getCostAccount().length() == 0) {
                this.nextAccount.setEnabled(false);
            }
        } else if (this.mainAccountSeqNr == 2) {
            this.previousAccount.setLabel("Label.AcquisitionValue.short");
            this.nextAccount.setLabel("Label.DepreciationCosts.short");
            if (this.glComparisonValue.getCostAccount().length() == 0) {
                this.nextAccount.setEnabled(false);
            }
        } else {
            this.previousAccount.setLabel("Label.AcquisitionValue.short");
            this.nextAccount.setLabel("Label.Depreciation");
            if (this.glComparisonValue.getDepreciationAccount().length() == 0) {
                this.nextAccount.setEnabled(false);
            }
        }
        object.addUIObject((UIObject)this.fb3B);
        return object;
    }

    private void initializeTransactionView() throws Exception {
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(TransactionAdapter.PAGE)).setMethod("show");
        Action incomingFinancialTransaction = new Action("Button.IncomingFinancialTransaction").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE)).setMethod("showDetails");
        this.transactionRowActions = new Action[]{details, incomingFinancialTransaction};
        ComboBox comboBox = EnumHelper.createComboBox("Label.TransactionType", TransactionTypeEnum.getCollection(), true);
        comboBox.setWidth("170");
        this.inputComponents.put("transactionType", comboBox);
    }

    public DataObject showMAVTransactions(DataObject object) throws Exception {
        if (!this.transactionViewInitialized) {
            this.initializeTransactionView();
        }
        InternalRow row = (InternalRow)TableHelper.getSelectedItem((DataObject)object);
        if (row.period == 0) {
            return object;
        }
        Window window = new Window();
        window.setLabel(String.valueOf(object.translate("Label.Transactions", object.getLocale())) + " " + this.year + "-" + row.period);
        if (this.mainAccountSeqNr == 1) {
            this.mainTransactionType = 1;
            GLComparisonAdapter.T_NAMES[2] = "valueForAmount1";
        }
        if (this.mainAccountSeqNr == 2) {
            this.mainTransactionType = 99;
            GLComparisonAdapter.T_NAMES[2] = "valueForAmount2";
        }
        if (this.mainAccountSeqNr == 3) {
            this.mainTransactionType = 3;
            GLComparisonAdapter.T_NAMES[2] = "valueForAmount2";
        }
        this.period = row.period;
        this.greaterThanPeriod = 0;
        if (this.period > this.numberOfPeriods) {
            this.greaterThanPeriod = this.numberOfPeriods;
        }
        this.typeIds = this.glComparisonValue.retrieveAssetTypeIds();
        this.createMAVTransactionTable();
        window.add((Panel)this.searchPanel);
        window.add((Table)this.transactionTable);
        object.addUIObject((UIObject)window);
        return object;
    }

    private void createMAVTransactionTable() throws Exception {
        this.transactionTable = new ODBTable(Transaction.class, (ODBQuery)new TransactionQuery(this.dbData, this.company, this.accountingPrinciple, this.cora, this.mainTransactionType, this.year, this.period, this.typeIds, this.greaterThanPeriod), new String[]{"bookYear", "period", "documentNr", "seqNr"}, 12);
        this.transactionTable.setName("mavTTable");
        this.transactionTable.setColumnNames(T_NAMES);
        this.transactionTable.setColumnLabels(T_LABELS);
        this.transactionTable.setColumnSizes(T_SIZES);
        this.transactionTable.setColumnTypes(T_TYPES);
        this.transactionTable.setDisplayTransformers(T_TRANSFORMERS);
        this.transactionTable.setColumnNoWraps(T_COLUMNNOWRAPS);
        this.transactionTable.setColumnSortable(T_SORTABLE);
        this.transactionTable.setInputComponents(this.inputComponents);
        this.transactionTable.setSortable(true);
        this.transactionTable.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.transactionTable, null, (Action[])this.transactionRowActions, (TableRowMethod)new TransactionTableRowMethod());
        this.searchPanel = this.transactionTable.createSearch(T_SEARCH_NAMES, T_SEARCH_LABELS);
        Action filterAction = this.transactionTable.createFilterAction(T_SEARCH_NAMES, T_SEARCH_LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.transactionTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.transactionTable, (String[])T_TOOLTIPS);
    }

    public DataObject showMultipleTypes(DataObject object) throws Exception {
        this.glComparisonValue = (ComparisonValue)TableHelper.getSelectedItem((DataObject)object);
        return this.createMultipleTypesView(object);
    }

    public DataObject createMultipleTypesView(DataObject object) throws Exception {
        if (!this.multipleTypesViewInitialized) {
            this.initializemultipleTypesView();
        }
        this.businessProcess.retrieveGLComparisonValueDetails(this.glComparisonValue);
        this.subGLComparisonValues = new Vector<Serializable>();
        for (ComparisonValue subBean : this.glComparisonValues) {
            if (subBean.getBeanType() == 0 || !subBean.getAcquisitionAccount().equals(this.glComparisonValue.getAcquisitionAccount())) continue;
            this.subGLComparisonValues.add(subBean);
        }
        ComparisonValue totals = (ComparisonValue)this.glComparisonValue.clone();
        totals.setAssetTypeId(TranslationHelperImpl.getInstance().translate("Label.Total"));
        totals.setAssetTypeDescription(this.glComparisonValue.getAcquisitionAccountDescription());
        this.subGLComparisonValues.add(totals);
        this.subTable = new CollectionTable(ComparisonValue.class, this.subGLComparisonValues, 12);
        this.subTable.setName(String.valueOf(PAGE) + "-subTable");
        this.subTable.setColumnNames(SUB_NAMES);
        this.subTable.setColumnLabels(SUB_LABELS);
        this.subTable.setColumnSizes(SUB_SIZES);
        this.subTable.setDisplayTransformers(this.SUB_transformers);
        this.subTable.setSortable(false);
        this.subTable.setSelectable(false);
        TableHelper.createMenu((Table)this.subTable, null, null);
        this.subTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.subTable, (String[])SUB_TOOLTIPS);
        Window window = new Window();
        window.setLabel(String.valueOf(this.glComparisonValue.getAcquisitionAccountDescription()) + " - " + object.translate("Label.MultipleTypesView", object.getLocale()));
        window.add((Table)this.subTable);
        object.addUIObject((UIObject)window);
        return object;
    }

    private void initializemultipleTypesView() throws Exception {
    }

    public DataObject showInvestmentAndDisinvestment(DataObject object) throws Exception {
        this.glComparisonValue = (ComparisonValue)TableHelper.getSelectedItem((DataObject)object);
        return this.createInvestmentAndDisinvestmentView(object);
    }

    public DataObject createInvestmentAndDisinvestmentView(DataObject object) throws Exception {
        if (!this.investmentAndDisinvestmentViewInitialized) {
            this.initializeInvestmentAndDisinvestmentView();
        }
        this.businessProcess.retrieveGLComparisonValueDetails(this.glComparisonValue);
        Vector<InternalRow> rows = new Vector<InternalRow>();
        int i = 0;
        while (i < 5) {
            InternalRow row = new InternalRow();
            row.seqNbr = i;
            switch (i) {
                case 0: {
                    row.description = object.translate("Label.OpeningBalance", object.getLocale());
                    row.amount1 = this.glComparisonValue.getFigureYTD(1, 0);
                    row.amount2 = this.glComparisonValue.getFigureYTD(3, 0);
                    break;
                }
                case 1: {
                    row.description = object.translate("Label.Investments", object.getLocale());
                    row.amount1 = this.glComparisonValue.getInvestmentTotalAcquisition();
                    row.amount2 = ZERO;
                    break;
                }
                case 2: {
                    row.description = object.translate("Label.Disinvestments", object.getLocale());
                    row.amount1 = this.glComparisonValue.getDisinvestmentTotalAcquisition();
                    row.amount2 = this.glComparisonValue.getDisinvestmentTotalDepreciation();
                    break;
                }
                case 3: {
                    row.description = object.translate("Label.DepreciationCosts", object.getLocale());
                    row.amount1 = ZERO;
                    row.amount2 = this.glComparisonValue.getFACCostTotal();
                    break;
                }
                case 4: {
                    row.description = object.translate("Label.ClosingBalance", object.getLocale());
                    row.amount1 = this.glComparisonValue.getFACAcquisitionTotal();
                    row.amount2 = this.glComparisonValue.getFACDepreciationTotal();
                    row.differenceIndicator_1 = this.glComparisonValue.getAcquisitionTotalDifference();
                    row.differenceIndicator_2 = this.glComparisonValue.getDepreciationTotalDifference();
                }
            }
            row.amount3 = row.amount1.subtract(row.amount2);
            rows.add(row);
            ++i;
        }
        this.iadTable = new CollectionTable(InternalRow.class, rows, 12);
        this.iadTable.setName(String.valueOf(PAGE) + "-iadTable");
        this.iadTable.setColumnNames(IAD_NAMES);
        this.iadTable.setColumnLabels(IAD_LABELS);
        this.iadTable.setColumnSizes(IAD_SIZES);
        this.iadTable.setDisplayTransformers(this.IAD_transformers);
        this.iadTable.setSortable(false);
        this.iadTable.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.iadTable, null, (Action[])this.IAD_rowActions, (TableRowMethod)new InvestmentAndDisinvestmentTableRowMethod());
        this.iadTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.iadTable, (String[])IAD_TOOLTIPS);
        Window window = new Window();
        window.setLabel(String.valueOf(this.glComparisonValue.getAcquisitionAccountDescription()) + " - " + object.translate("Label.InvestmentsAndDisinvestments", object.getLocale()) + " " + this.byfYear.getValue());
        window.add((Table)this.iadTable);
        object.addUIObject((UIObject)window);
        return object;
    }

    private void initializeInvestmentAndDisinvestmentView() throws Exception {
    }

    public DataObject showIADTransactions(DataObject object) throws Exception {
        if (!this.transactionViewInitialized) {
            this.initializeTransactionView();
        }
        InternalRow row = (InternalRow)TableHelper.getSelectedItem((DataObject)object);
        if (row.seqNbr != 1 && row.seqNbr != 2) {
            return object;
        }
        Window window = new Window();
        if (row.seqNbr == 1) {
            window.setLabel(String.valueOf(this.glComparisonValue.getAcquisitionAccountDescription()) + " - " + object.translate("Label.Investments", object.getLocale()) + " " + this.year);
            this.mainTransactionType = 1;
        }
        if (row.seqNbr == 2) {
            window.setLabel(String.valueOf(this.glComparisonValue.getAcquisitionAccountDescription()) + " - " + object.translate("Label.Disinvestments", object.getLocale()) + " " + this.year);
            this.mainTransactionType = 2;
        }
        this.period = 99;
        this.greaterThanPeriod = 0;
        this.typeIds = this.glComparisonValue.retrieveAssetTypeIds();
        this.createIADTransactionTable();
        window.add((Panel)this.searchPanel);
        window.add((Table)this.transactionTable);
        object.addUIObject((UIObject)window);
        return object;
    }

    private void createIADTransactionTable() throws Exception {
        TransactionQuery query = new TransactionQuery(this.dbData, this.company, this.accountingPrinciple, this.cora, this.mainTransactionType, this.year, this.period, this.typeIds, this.greaterThanPeriod);
        this.transactionTable = new ODBTable(Transaction.class, (ODBQuery)query, new String[]{"bookYear", "period", "documentNr", "seqNr"}, 12);
        this.transactionTable.setName("iadTTable");
        this.transactionTable.setCounter((ODBCounter)query);
        this.transactionTable.setColumnNames(TT_NAMES);
        this.transactionTable.setColumnLabels(TT_LABELS);
        this.transactionTable.setColumnSizes(TT_SIZES);
        this.transactionTable.setColumnTypes(TT_TYPES);
        this.transactionTable.setDisplayTransformers(TT_TRANSFORMERS);
        this.transactionTable.setColumnNoWraps(TT_COLUMNNOWRAPS);
        this.transactionTable.setColumnSortable(TT_SORTABLE);
        this.transactionTable.setInputComponents(this.inputComponents);
        this.transactionTable.setSortable(true);
        this.transactionTable.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.transactionTable, null, (Action[])this.transactionRowActions, (TableRowMethod)new TransactionTableRowMethod());
        this.searchPanel = this.transactionTable.createSearch(TT_SEARCH_NAMES, TT_SEARCH_LABELS);
        Action filterAction = this.transactionTable.createFilterAction(TT_SEARCH_NAMES, TT_SEARCH_LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.transactionTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.transactionTable, (String[])TT_TOOLTIPS);
    }

    private class GLComparisonValueTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 8783248279555229442L;

        private GLComparisonValueTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            ComparisonValue glComparisonValue = (ComparisonValue)row.getObject();
            ContextMenu menu = new ContextMenu();
            int i = 0;
            while (i < rowActions.length) {
                block4: {
                    block3: {
                        if (i != 3) break block3;
                        menu.addContextMenuItem(new Separator());
                        if (!glComparisonValue.getMultipleTypes()) break block4;
                    }
                    ContextAction rowAction = new ContextAction(rowActions[i].getName());
                    rowAction.setAdapter(rowActions[i].getPageid());
                    rowAction.setMethod(rowActions[i].getMethod());
                    menu.addContextMenuItem(rowAction);
                }
                ++i;
            }
            row.setContextMenu(menu);
        }
    }

    public class InternalRow
    implements Serializable {
        private static final long serialVersionUID = 6253036941608626499L;
        public static final String PERIOD = "period";
        public static final String DESCRIPTION = "description";
        public static final String AMOUNT1 = "amount1";
        public static final String AMOUNT2 = "amount2";
        public static final String AMOUNT3 = "amount3";
        public static final String AMOUNT4 = "amount4";
        public static final String DIFFERENCE_INDICATOR_1 = "differenceIndicator_1";
        public static final String DIFFERENCE_INDICATOR_2 = "differenceIndicator_2";
        int seqNbr;
        int period;
        String description;
        BigDecimal amount1;
        BigDecimal amount2;
        BigDecimal amount3;
        BigDecimal amount4;
        BigDecimal differenceIndicator_1;
        BigDecimal differenceIndicator_2;

        InternalRow() {
        }

        public int getPeriod() {
            return this.period;
        }

        public String getDescription() {
            return this.description;
        }

        public BigDecimal getAmount1() {
            return this.amount1;
        }

        public BigDecimal getAmount2() {
            return this.amount2;
        }

        public BigDecimal getAmount3() {
            return this.amount3;
        }

        public BigDecimal getAmount4() {
            return this.amount4;
        }

        public BigDecimal getDifferenceIndicator_1() {
            return this.differenceIndicator_1;
        }

        public BigDecimal getDifferenceIndicator_2() {
            return this.differenceIndicator_2;
        }
    }

    private class InvestmentAndDisinvestmentTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 8385678926615648537L;

        private InvestmentAndDisinvestmentTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            InternalRow internalRow = (InternalRow)row.getObject();
            ContextMenu menu = new ContextMenu();
            ContextAction rowAction = new ContextAction(rowActions[0].getName());
            if (internalRow.seqNbr == 1 || internalRow.seqNbr == 2) {
                rowAction.setAdapter(rowActions[0].getPageid());
                rowAction.setMethod(rowActions[0].getMethod());
            } else {
                rowAction.setEnabled(false);
            }
            menu.addContextMenuItem(rowAction);
            row.setContextMenu(menu);
        }
    }

    private class MainAccountViewTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 173490715489703693L;

        private MainAccountViewTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            InternalRow internalRow = (InternalRow)row.getObject();
            ContextMenu menu = new ContextMenu();
            ContextAction rowAction = new ContextAction(rowActions[0].getName());
            if (internalRow.period > 0) {
                rowAction.setAdapter(rowActions[0].getPageid());
                rowAction.setMethod(rowActions[0].getMethod());
            } else {
                rowAction.setEnabled(false);
            }
            menu.addContextMenuItem(rowAction);
            row.setContextMenu(menu);
        }
    }

    private class TransactionTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 1831254000940657085L;

        private TransactionTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Transaction transaction = (Transaction)row.getObject();
            ContextMenu menu = new ContextMenu();
            int i = 0;
            while (i < rowActions.length) {
                if (i != 1 || transaction.getIncomingFinancialTransaction() != null) {
                    ContextAction rowAction = new ContextAction(rowActions[i].getName());
                    rowAction.setAdapter(rowActions[i].getPageid());
                    rowAction.setMethod(rowActions[i].getMethod());
                    menu.addContextMenuItem(rowAction);
                }
                ++i;
            }
            row.setContextMenu(menu);
        }
    }
}

