/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Option;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserMessageCollection;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.DisinvestmentReasonCodeEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.adapters.AssetReferenceField;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FISReferenceField;
import nl.ibs.fac.adapters.FMSReferenceField;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.IncomingFinancialTransactionDetailAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionIdImageTransformer;
import nl.ibs.fac.adapters.IncomingFinancialTransactionMultipleTransactionsAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionTransactionAdapter;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.ParentAssetAdapter;
import nl.ibs.fac.adapters.ProofDisInvestmentAdapter;
import nl.ibs.fac.adapters.ZeroLongToBlankTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyAccountingPrincipleDefaultBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.boadapters.MainAccountSchemeBO;
import nl.ibs.fac.boadapters.ProcessParametersBO;
import nl.ibs.fac.bp.AssetBP;
import nl.ibs.fac.bp.DisInvestmentBP;
import nl.ibs.fac.bp.IncomingFinancialTransactionBP;
import nl.ibs.fac.bp.InvestmentBP;
import nl.ibs.fac.bp.LedgerCorrectionBP;
import nl.ibs.fac.bp.ProofDisInvestmentBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.MainAccountScheme;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.gov.GovernmentEnumHelper;
import nl.ibs.fac.gov.adapters.BBVCategoryImageTransformer;
import nl.ibs.fac.gov.adapters.CreditReferenceField;
import nl.ibs.fac.gov.adapters.IFTGovernmentCodeImageTransformer;
import nl.ibs.fac.gov.boadapters.TotalEstimationTransactionBO;
import nl.ibs.fac.gov.bp.GenericGovernmentBP;
import nl.ibs.fac.gov.bp.LoanAndPayOffBP;
import nl.ibs.fac.queries.IncomingFinancialTransactionQuery;

public class IncomingFinancialTransactionAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -4577360479978865994L;
    public static final String PAGE = IncomingFinancialTransactionAdapter.class.getName();
    public String tableName0 = "IFTAdapter0";
    public String tableName1 = "IFTAdapter1";
    public String tableName2 = "IFTAdapter2";
    public static final String INCOMINGFINANCIALTRANSACTION = "IncomingFinancialTransaction";
    public static final String INCOMINGFINANCIALTRANSACTIONS = "IncomingFinancialTransactions";
    public static final String ASSET = "Asset";
    public static final String ALLOCATE_ENTRY = "allocateEntry";
    public static final String CONFIRM_ENTRY = "confirmEntry";
    public static final String CONFIRM_ENTRY_MULTIPLE_TRNS = "confirmEntryMultipleTransactions";
    public static final String CONFIRM = "confirm";
    public static final String UPDATE_TABLE = "updateTable";
    public static final String UPDATE_TABLE_MT = "updateTableMultipleTransactions";
    private static final String REFRESH = "refresh";
    private static final String ALLOCATE = "allocate";
    private static final String CREATEASSET = "createAsset";
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    private static final String EDIT = "editBBVCategoryWindow";
    private Company company;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final ZeroLongToBlankTransformer ZLTBTRANSFORMER = new ZeroLongToBlankTransformer();
    private static final BBVCategoryImageTransformer BBVTRANSFORMER = new BBVCategoryImageTransformer();
    private static final IFTGovernmentCodeImageTransformer GOVCDETRANSFORMER = new IFTGovernmentCodeImageTransformer();
    private static final String[] TOOLTIPS = new String[]{"Label.AlreadyAllocated", "Label.BBVCategory", "Label.Remark"};
    private String[] NAMES0;
    private String[] shortLabels0;
    private short[] SIZES0;
    private String[] SEARCHNAMES0;
    private String[] searchLabels0;
    private Transformer[] transformers0;
    private static final String[] NAMES1 = new String[]{"bookYear", "period", "transactionValue", "id", "bBVCategory", "governmentCode", "description", "systemItemNumber", "voucherId", "internalInvoiceId"};
    private String[] NAMES2;
    private static final NumericIdTransformer NUMERICIDTRANSFORMER = new NumericIdTransformer();
    private Action[] rowActions;
    private Action[] headerActions;
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private Object[] ifts;
    private IncomingFinancialTransaction incomingFinancialTransaction;
    private Panel header;
    private Field systemItemNumber;
    private BookYearPeriodGrid iftYearPeriod;
    private Field iftTransactionValue;
    private FieldGroup fgAllocateTo;
    private Field unAllocatedValue;
    private ComboBox allocateTo;
    private static final String INVESTMENT = "INVESTMENT";
    private static final String DISINVESTMENT = "DISINVESTMENT";
    private static final String NEW_ASSET = "NEW_ASSET";
    private static final String LEDGERCORRECTION = "LEDGERCORRECTION";
    private static final String LOAN = "LOAN";
    private static final String PAYOFF = "PAYOFF";
    private static final String NEW_LOAN = "NEW_LOAN";
    private BookYearPeriodGrid facYearPeriod;
    private BookYearPeriodGrid finYearPeriod;
    private FloatBar fbAllocate;
    private FACDecimalField transactionValue = new FACDecimalField("Label.Amount", 15, 2);
    private Field description = new Field("Label.Description");
    private AssetReferenceField assetField;
    private AssetReferenceField assetFieldSave;
    private String companyOrDataSetId;
    private FieldGroup genericPanel = new FieldGroup();
    private FieldGroup disInvestmentPanel = new FieldGroup("Label.DisInvestment");
    private ComboBox disinvestmentReason;
    private CheckBox partialDisInvestment = new CheckBox("Label.PartialDisInvestment");
    private PartialDisInvestmentChangeAction partialDisInvestmentChangeAction = new PartialDisInvestmentChangeAction();
    private FACDecimalField disInvestmentPartialAmount = new FACDecimalField("Label.DisInvestmentPartialAmount", 15, 2);
    private FieldGroup correctionPanel = new FieldGroup("Label.GeneralLedgerCorrection");
    private FinancialReferenceField daybook;
    private FinancialReferenceField[] financialDimension = new FinancialReferenceField[9];
    private BigDecimal disInvestmentValue;
    private String[] finTexts = new String[5];
    private AssetPanels panels;
    private boolean returnedFromDimensionPanel;
    private Action details;
    private InvestmentBP investmentBP;
    private DisInvestmentBP disInvestmentBP;
    private LedgerCorrectionBP ledgerCorrectionBP;
    private LoanAndPayOffBP loanAndPayOffBP;
    private boolean autoConfirm = false;
    private boolean warnForMainAccountDifference = false;
    private boolean mainAccountDifferenceOK = false;
    private Window maWindow;
    private boolean table2Active = false;
    private Action changeView;
    private boolean isLoanOrPayOff = false;
    private Window editWindow;
    private ComboBox oldBBVCategory;
    private ComboBox newBBVCategory;
    private Window allocationWindow;
    private CreditReferenceField crf;
    private GenericGovernmentBP genericGovernmentBP;
    private FieldGroup maFieldGroup = null;

    public IncomingFinancialTransactionAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        ProcessParameters parameters;
        if (this.env.getShortName5().trim().length() > 0) {
            this.NAMES0 = new String[]{"bookYear", "period", "transactionValue", "id", "bBVCategory", "governmentCode", "description", "systemItemNumber", "voucherId", "internalInvoiceId", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "description2"};
            this.SIZES0 = new short[]{50, 30, 125, 20, 20, 20, 215, 100, 80, 120, 86, 85, 85, 85, 85, 85, 215};
            this.SEARCHNAMES0 = new String[]{"bookYear", "period", "transactionValue", "description", "systemItemNumber", "voucherId", "internalInvoiceId", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "description2"};
            this.NAMES2 = new String[]{"bookYear", "period", "transactionValue", "id", "bBVCategory", "governmentCode", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "description2"};
        } else {
            this.NAMES0 = new String[]{"bookYear", "period", "transactionValue", "id", "bBVCategory", "governmentCode", "description", "systemItemNumber", "voucherId", "internalInvoiceId", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.SIZES0 = new short[]{50, 30, 125, 20, 20, 20, 215, 100, 80, 120, 86, 85, 85, 85, 85};
            this.SEARCHNAMES0 = new String[]{"bookYear", "period", "transactionValue", "description", "systemItemNumber", "voucherId", "internalInvoiceId", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
            this.NAMES2 = new String[]{"bookYear", "period", "transactionValue", "id", "bBVCategory", "governmentCode", "mainAccount", "finDimId1", "finDimId2", "finDimId3", "finDimId4"};
        }
        this.shortLabels0 = new String[]{"Label.Year", "Label.Period.short", "Label.Amount", "Label.AlreadyAllocated", "Label.BBVCategory", "Label.Remark", "Label.Description", "Label.SystemItemNbr.Xshort", "Label.VoucherId.short", "Label.InvoiceNbr.Xshort", "Label.MainAccount", this.env.getShortName1(), this.env.getShortName2(), this.env.getShortName3(), this.env.getShortName4(), this.env.getShortName5(), "Label.Description2"};
        this.searchLabels0 = new String[]{"Label.Year", "Label.Period", "Label.Amount", "Label.Description", "Label.SystemItemNbr.short", "Label.VoucherId", "Label.InvoiceNbr.short", "Label.MainAccount", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5(), "Label.Description2"};
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        if (this.governmentActivated && this.company.getUseValuationMainAccount()) {
            this.genericGovernmentBP = new GenericGovernmentBP(this.company);
        }
        IncomingFinancialTransactionIdImageTransformer idTransformer = new IncomingFinancialTransactionIdImageTransformer(this.company);
        Transformer[] transformerArray = new Transformer[16];
        transformerArray[2] = DECIMALTRANSFORMER;
        transformerArray[3] = idTransformer;
        transformerArray[4] = BBVTRANSFORMER;
        transformerArray[5] = GOVCDETRANSFORMER;
        transformerArray[9] = ZLTBTRANSFORMER;
        this.transformers0 = transformerArray;
        if (this.env.getOperationArea().trim().length() == 0) {
            this.transformers0[8] = NUMERICIDTRANSFORMER;
            this.transformers0[10] = NUMERICIDTRANSFORMER;
            this.transformers0[11] = NUMERICIDTRANSFORMER;
            this.transformers0[12] = NUMERICIDTRANSFORMER;
            this.transformers0[13] = NUMERICIDTRANSFORMER;
            this.transformers0[14] = NUMERICIDTRANSFORMER;
            this.transformers0[15] = NUMERICIDTRANSFORMER;
        }
        this.investmentBP = new InvestmentBP(this.company, this.numberOfPeriods, "FIN");
        this.disInvestmentBP = new DisInvestmentBP(this.company, this.numberOfPeriods, "FIN");
        this.ledgerCorrectionBP = new LedgerCorrectionBP(this.company, this.numberOfPeriods);
        this.loanAndPayOffBP = new LoanAndPayOffBP(this.company, this.numberOfPeriods);
        this.companyOrDataSetId = this.companyId;
        if (this.dataSetId != null) {
            this.companyOrDataSetId = this.dataSetId;
        }
        if ((parameters = (ProcessParameters)ProcessParametersBO.get(this.dbData, this.companyOrDataSetId)[0]) != null) {
            this.autoConfirm = parameters.getAutoConfirmIFT();
            this.warnForMainAccountDifference = parameters.getWarningForDifferentType();
        }
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        this.fbShow.addAction(refresh);
        this.changeView = new Action("Button.ToView_2").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("changeView");
        this.fbShow.addAction(this.changeView);
        Action confirm = new Action("Button.Confirm").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRM);
        this.fbShow.addAction(confirm);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.fbShow.addAction(confirmDelete);
        Action confirmTest = new Action("Button.AllocateMultipleTransactions").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("testVerantwoordenMeerdere");
        this.fbShow.addAction(confirmTest);
        this.fbShow.addAction(this.finish);
        Action allocate = new Action("Button.Allocate").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(ALLOCATE_ENTRY);
        Action transactions = new Action("Button.Transactions").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionTransactionAdapter.PAGE)).setMethod("show");
        this.details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionDetailAdapter.PAGE)).setMethod("showDetails");
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        this.headerActions = new Action[]{refresh, this.changeView};
        this.rowActions = this.governmentActivated ? new Action[]{allocate, this.details, edit, transactions, confirm} : new Action[]{allocate, this.details, transactions, confirm};
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.header = new HeaderPanel();
        this.header.setWidth(611);
        FieldGroup fg = new FieldGroup();
        fg.forceBorder(false);
        this.systemItemNumber = new Field("Label.SystemItemNbr");
        this.systemItemNumber.setLength(15);
        this.systemItemNumber.setReadonly(true);
        fg.add(this.systemItemNumber);
        this.iftYearPeriod = new BookYearPeriodGrid("Label.GLPeriod", true);
        fg.add((ESPGridLayout)this.iftYearPeriod);
        this.iftTransactionValue = new Field("Label.TransactionValue", "decimal", null, "", 15);
        this.iftTransactionValue.setReadonly(true);
        fg.add(this.iftTransactionValue);
        this.header.addUIObject((UIObject)fg);
        this.fgAllocateTo = new FieldGroup("Label.UnAllocatedValue");
        ESPGridLayout grid = new ESPGridLayout();
        grid.setPaddingBottom(0);
        grid.setPaddingTop(0);
        short[] sArray = new short[2];
        sArray[0] = 198;
        grid.setColumnWidths(sArray);
        this.fgAllocateTo.add(grid);
        Label label = new Label("Label.Amount");
        label.setHelpId("Label.UnAllocatedAmount");
        grid.add((UIObject)label, 0, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.unAllocatedValue = new Field("", "decimal", null, "", 15);
        this.unAllocatedValue.setDiscardLabel(true);
        this.unAllocatedValue.setReadonly(true);
        grid.add((UIObject)this.unAllocatedValue, 0, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        label = new Label("Label.IFTType");
        grid.add((UIObject)label, 1, 0, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.allocateTo = new ComboBox("");
        this.allocateTo.setDiscardLabel(true);
        this.allocateTo.addOption("Label.AdditionalInvestment.short", INVESTMENT);
        this.allocateTo.addOption("Label.DisInvestment", DISINVESTMENT);
        this.allocateTo.addOption("Label.NewAsset", NEW_ASSET);
        this.allocateTo.addOption("Label.GeneralLedgerCorrection", LEDGERCORRECTION);
        this.allocateTo.add((Action)new AllocateToChangeAction(this.getProcessAdapterPageName(PAGE)));
        grid.add((UIObject)this.allocateTo, 1, 1, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_WEST);
        this.facYearPeriod = new BookYearPeriodGrid("Label.FACStartPeriod", "" + this.company.getCurrentBookYear(), this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.fgAllocateTo.add((ESPGridLayout)this.facYearPeriod);
        this.finYearPeriod = new BookYearPeriodGrid("Label.BookPeriod", false);
        this.fgAllocateTo.add((ESPGridLayout)this.finYearPeriod);
        this.transactionValue.setMandatory(true);
        this.transactionValue.requestFocus(true);
        this.genericPanel.add((Field)this.transactionValue);
        this.description.setLength(30);
        this.description.setMaxLength(30);
        this.genericPanel.add(this.description);
        this.assetField = new AssetReferenceField(this.company, null, new Boolean(true), true, false, new Boolean(false));
        this.assetField.setDescriptionLength(35);
        this.assetField.setMandatory(true);
        this.genericPanel.add((Field)this.assetField);
        this.disInvestmentPanel.add((Field)this.transactionValue);
        this.disInvestmentPanel.add(this.description);
        this.disinvestmentReason = EnumHelper.createComboBox("Label.DisinvestmentReason", DisinvestmentReasonCodeEnum.getCollection(this.env), false);
        if (!("".equals(this.env.getDIRCName1()) && "".equals(this.env.getDIRCName2()) && "".equals(this.env.getDIRCName3()) && "".equals(this.env.getDIRCName4()) && "".equals(this.env.getDIRCName5()))) {
            this.disInvestmentPanel.add(this.disinvestmentReason);
        }
        this.partialDisInvestment.setAction((Action)this.partialDisInvestmentChangeAction);
        this.disInvestmentPanel.add((Field)this.assetField);
        this.assetFieldSave = this.assetField;
        this.disInvestmentPanel.add(this.partialDisInvestment);
        this.disInvestmentPanel.add((Field)this.disInvestmentPartialAmount);
        this.correctionPanel.add((Field)this.transactionValue);
        this.transactionValue.requestFocus(true);
        this.correctionPanel.add(this.description);
        if (this.env.getOperationArea().length() == 0) {
            this.daybook = new FISReferenceField(this.loginHelper, "Label.Daybook", -1, this.company.getId(), "" + this.company.getCurrentBookYear(), true);
            this.financialDimension[0] = new FISReferenceField(this.loginHelper, "Label.MainAccount", 0, this.company.getId(), "" + this.company.getCurrentBookYear(), true);
            this.financialDimension[6] = new FISReferenceField(this.loginHelper, this.env.getNameDebtor(), 10, this.company.getId(), "" + this.company.getCurrentBookYear(), true);
            this.financialDimension[7] = new FISReferenceField(this.loginHelper, this.env.getNameCreditor(), 11, this.company.getId(), "" + this.company.getCurrentBookYear(), true);
        } else {
            this.daybook = new FMSReferenceField(this.loginHelper, "Label.Daybook", -1, true);
            this.financialDimension[0] = new FMSReferenceField(this.loginHelper, "Label.MainAccount", 0, true);
            this.financialDimension[6] = new FMSReferenceField(this.loginHelper, this.env.getNameDebtor(), 10, true);
            this.financialDimension[7] = new FMSReferenceField(this.loginHelper, this.env.getNameCreditor(), 11, true);
            this.financialDimension[8] = new FMSReferenceField(this.loginHelper, this.env.getNameCreditor(), 12, true);
        }
        this.daybook.setMandatory(true);
        this.correctionPanel.add((Field)this.daybook);
        this.financialDimension[0].setMandatory(true);
        this.correctionPanel.add((Field)this.financialDimension[0]);
        this.finTexts[0] = this.env.getName1();
        this.finTexts[1] = this.env.getName2();
        this.finTexts[2] = this.env.getName3();
        this.finTexts[3] = this.env.getName4();
        this.finTexts[4] = this.env.getName5();
        int i = 0;
        while (i < this.finTexts.length) {
            if (this.finTexts[i].length() != 0) {
                this.financialDimension[i + 1] = this.env.getOperationArea().length() == 0 ? new FISReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company) : new FMSReferenceField(this.loginHelper, this.finTexts[i], i + 1, this.company);
                this.correctionPanel.add((Field)this.financialDimension[i + 1]);
            }
            ++i;
        }
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.getProcess().removeAttribute(INCOMINGFINANCIALTRANSACTION);
        this.incomingFinancialTransaction = null;
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.IncomingFinancialTransactions", "screen_name"));
        if (this.table == null) {
            this.createTable();
        } else if (this.table.isSelectable()) {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject changeView(DataObject object) throws Exception {
        if (this.table2Active) {
            this.table2Active = false;
            this.changeView.setLabel("Button.ToView_2");
        } else {
            this.table2Active = true;
            this.changeView.setLabel("Button.ToView_1");
        }
        this.table = null;
        return this.show(object);
    }

    private void createTable() throws Exception {
        if (this.table2Active) {
            this.createTable2();
        } else {
            this.createTable1();
        }
    }

    private void createTable1() throws Exception {
        IncomingFinancialTransactionQuery query = new IncomingFinancialTransactionQuery(this.dbData, this.companyId, false, false);
        this.table = new ODBTable(IncomingFinancialTransaction.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(this.tableName1);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(this.NAMES0);
        this.table.setColumnsToDisplay(NAMES1);
        this.table.setColumnLabels(this.shortLabels0);
        this.table.setColumnSizes(this.SIZES0);
        this.table.setDisplayTransformers(this.transformers0);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(this.SEARCHNAMES0, this.searchLabels0);
        this.searchPanel.setCSSClass("headerPanel");
        this.searchPanel.setWidth(822);
        Action filterAction = this.table.createFilterAction(this.SEARCHNAMES0, this.searchLabels0, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    private void createTable2() throws Exception {
        IncomingFinancialTransactionQuery query = new IncomingFinancialTransactionQuery(this.dbData, this.companyId, false, false);
        this.table = new ODBTable(IncomingFinancialTransaction.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(this.tableName2);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(this.NAMES0);
        this.table.setColumnsToDisplay(this.NAMES2);
        this.table.setColumnLabels(this.shortLabels0);
        this.table.setColumnSizes(this.SIZES0);
        this.table.setDisplayTransformers(this.transformers0);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(this.SEARCHNAMES0, this.searchLabels0);
        this.searchPanel.setCSSClass("headerPanel");
        this.searchPanel.setWidth(822);
        Action filterAction = this.table.createFilterAction(this.SEARCHNAMES0, this.searchLabels0, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    public DataObject updateTable(DataObject object) throws Exception {
        this.incomingFinancialTransaction = (IncomingFinancialTransaction)this.getProcess().getAttribute(INCOMINGFINANCIALTRANSACTION);
        if (this.incomingFinancialTransaction != null) {
            String filterName = this.table.getODBCursor().getFilter();
            Map mapFilterParms = this.table.getODBCursor().getFilterParameters();
            boolean bDesc = this.table.getODBCursor().getDescending();
            String sSortedColumn = this.table.getODBCursor().getOrderColumn();
            this.table.getODBCursor().setFilter(filterName, mapFilterParms);
            this.table.getODBCursor().orderByColumn(sSortedColumn);
            this.table.getODBCursor().setDescending(bDesc);
            this.table.reload();
        }
        return this.show(object);
    }

    public DataObject updateTableMultipleTransactions(DataObject object) throws Exception {
        this.ifts = (Object[])this.getProcess().getAttribute(INCOMINGFINANCIALTRANSACTIONS);
        if (this.ifts != null) {
            String filterName = this.table.getODBCursor().getFilter();
            Map mapFilterParms = this.table.getODBCursor().getFilterParameters();
            boolean bDesc = this.table.getODBCursor().getDescending();
            String sSortedColumn = this.table.getODBCursor().getOrderColumn();
            this.table.getODBCursor().setFilter(filterName, mapFilterParms);
            this.table.getODBCursor().orderByColumn(sSortedColumn);
            this.table.getODBCursor().setDescending(bDesc);
            this.table.reload();
        }
        return this.show(object);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject refresh2(DataObject object) throws Exception {
        String filterName = this.table.getODBCursor().getFilter();
        Map mapFilterParms = this.table.getODBCursor().getFilterParameters();
        boolean bDesc = this.table.getODBCursor().getDescending();
        String sSortedColumn = this.table.getODBCursor().getOrderColumn();
        this.table.getODBCursor().setFilter(filterName, mapFilterParms);
        this.table.getODBCursor().orderByColumn(sSortedColumn);
        this.table.getODBCursor().setDescending(bDesc);
        this.table.reload();
        return this.show(object);
    }

    private void initializeCommonValues() throws Exception {
        String[] yps = this.investmentBP.retrieveYearsAndPeriods(null, this.incomingFinancialTransaction);
        this.facYearPeriod.setValues(yps[0], yps[1]);
        this.finYearPeriod.setValues(yps[2], yps[3]);
        this.unAllocatedValue.setValue((String)DECIMALTRANSFORMER.transform(this.incomingFinancialTransaction.getUnAllocatedValue()));
        this.description.setValue(this.incomingFinancialTransaction.getDescription());
    }

    private void initializeCommonValuesMultipleTransactions() throws Exception {
        String[] yps = this.investmentBP.retrieveYearsAndPeriods(null, this.incomingFinancialTransaction);
        this.facYearPeriod.setValues(yps[0], yps[1]);
        this.finYearPeriod.setValues(yps[2], yps[3]);
        this.description.setValue(this.incomingFinancialTransaction.getDescription());
    }

    public DataObject allocateEntry(DataObject object) throws Exception {
        this.allocateTo.setReadonly(false);
        this.transactionValue.setReadonly(false);
        this.incomingFinancialTransaction = (IncomingFinancialTransaction)this.getProcess().getAttribute(INCOMINGFINANCIALTRANSACTION);
        if (this.incomingFinancialTransaction == null) {
            this.incomingFinancialTransaction = (IncomingFinancialTransaction)TableHelper.getSelectedItem((DataObject)object);
            if (this.governmentActivated && this.incomingFinancialTransaction.getIFTType() == 2) {
                return this.allocateInitialProjectCostsWindow(object);
            }
            if (this.governmentActivated) {
                for (Option option : this.allocateTo.getOptions()) {
                    this.allocateTo.removeOption(option);
                }
                if (this.incomingFinancialTransaction.getIFTType() == 3) {
                    this.isLoanOrPayOff = true;
                    this.allocateTo.addOption("Label.AdditionalLoan.short", LOAN);
                    this.allocateTo.addOption("Label.PayOff", PAYOFF);
                    this.allocateTo.addOption("Label.NewLoan", NEW_LOAN);
                    this.allocateTo.addOption("Label.GeneralLedgerCorrection", LEDGERCORRECTION);
                } else {
                    this.isLoanOrPayOff = false;
                    this.allocateTo.addOption("Label.AdditionalInvestment.short", INVESTMENT);
                    this.allocateTo.addOption("Label.DisInvestment", DISINVESTMENT);
                    this.allocateTo.addOption("Label.NewAsset", NEW_ASSET);
                    this.allocateTo.addOption("Label.GeneralLedgerCorrection", LEDGERCORRECTION);
                }
            }
            this.getProcess().setAttribute(INCOMINGFINANCIALTRANSACTION, (Object)this.incomingFinancialTransaction);
        }
        this.setValues();
        if (this.incomingFinancialTransaction.getTransactionValue().doubleValue() < 0.0) {
            if (this.isLoanOrPayOff) {
                this.allocateTo.setSelectedOptionValue(PAYOFF);
            } else {
                this.allocateTo.setSelectedOptionValue(INVESTMENT);
            }
        } else if (this.isLoanOrPayOff) {
            this.allocateTo.setSelectedOptionValue(NEW_LOAN);
        } else {
            this.allocateTo.setSelectedOptionValue(NEW_ASSET);
        }
        return this.allocate(object);
    }

    public DataObject allocateEntryInvestmentMultipleTransactions(DataObject object, Object[] incomingFinancialTransactions) throws Exception {
        this.getProcess().setAttribute(INCOMINGFINANCIALTRANSACTIONS, (Object)this.ifts);
        this.setValuesMultipleTransactions();
        this.isLoanOrPayOff = false;
        this.allocateTo.addOption("Label.AdditionalInvestment.short", INVESTMENT);
        this.allocateTo.setSelectedOptionValue(INVESTMENT);
        this.allocateTo.setReadonly(true);
        this.transactionValue.setReadonly(true);
        return this.allocateMultipleTransactions(object);
    }

    private void setValues() throws Exception {
        this.systemItemNumber.setHidden(false);
        String sSystemItemNumber = this.incomingFinancialTransaction.getSystemItemSequencenumber() != 0 ? this.incomingFinancialTransaction.getSystemItemNumber() + "/" + this.incomingFinancialTransaction.getSystemItemSequencenumber() : "" + this.incomingFinancialTransaction.getSystemItemNumber();
        this.systemItemNumber.setValue(sSystemItemNumber);
        this.iftYearPeriod.setValues("" + this.incomingFinancialTransaction.getBookYear(), "" + this.incomingFinancialTransaction.getPeriod());
        this.iftTransactionValue.setValue((String)DECIMALTRANSFORMER.transform(this.incomingFinancialTransaction.getTransactionValue()));
        this.unAllocatedValue.setValue((String)DECIMALTRANSFORMER.transform(this.incomingFinancialTransaction.getUnAllocatedValue()));
    }

    private void setValuesMultipleTransactions() throws Exception {
        this.systemItemNumber.setHidden(true);
        BigDecimal unallocatedValue = new BigDecimal(0);
        BigDecimal transactionValue = new BigDecimal(0);
        IncomingFinancialTransaction incomingFinancialTransactionLaatste = null;
        int i = 0;
        while (i < this.ifts.length) {
            incomingFinancialTransactionLaatste = (IncomingFinancialTransaction)this.ifts[i];
            unallocatedValue = unallocatedValue.add(incomingFinancialTransactionLaatste.getUnAllocatedValue());
            transactionValue = transactionValue.add(incomingFinancialTransactionLaatste.getTransactionValue());
            ++i;
        }
        String sSystemItemNumber = incomingFinancialTransactionLaatste.getSystemItemSequencenumber() != 0 ? incomingFinancialTransactionLaatste.getSystemItemNumber() + "/" + incomingFinancialTransactionLaatste.getSystemItemSequencenumber() : "" + incomingFinancialTransactionLaatste.getSystemItemNumber();
        this.systemItemNumber.setValue(sSystemItemNumber);
        this.iftYearPeriod.setValues("" + incomingFinancialTransactionLaatste.getBookYear(), "" + incomingFinancialTransactionLaatste.getPeriod());
        this.iftTransactionValue.setValue((String)DECIMALTRANSFORMER.transform(transactionValue));
        this.unAllocatedValue.setValue((String)DECIMALTRANSFORMER.transform(unallocatedValue));
        this.unAllocatedValue.setReadonly(true);
    }

    public DataObject allocate(DataObject object) throws Exception {
        if (!this.returnedFromDimensionPanel) {
            this.mainAccountDifferenceOK = false;
        }
        if (this.incomingFinancialTransaction.getUnAllocatedValue().doubleValue() == 0.0) {
            if (this.autoConfirm) {
                String message = IncomingFinancialTransactionBP.confirm(this.incomingFinancialTransaction);
                if (message != null) {
                    object.addUIObject((UIObject)new Message(message, "error"));
                    return object;
                }
                return this.refresh(object);
            }
            object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(IncomingFinancialTransactionTransactionAdapter.PAGE), "show", this.getProcess().getProcessId()));
            return object;
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.AllocateIncomingFinancialTransaction", "screen_name"));
        object.addUIObject((UIObject)this.header);
        if (!this.returnedFromDimensionPanel) {
            this.initializeCommonValues();
        }
        object.addUIObject((UIObject)this.fgAllocateTo);
        this.fbAllocate = new FloatBar();
        String selected = this.allocateTo.getSelectedOptionValue();
        this.facYearPeriod.setHidden(false);
        this.facYearPeriod.setMandatory(true);
        this.facYearPeriod.getBookYear().setMinValue(new BigInteger(this.bookYearMin), true);
        this.finYearPeriod.setMandatory(false);
        if (selected.equals(INVESTMENT)) {
            this.createInvestmentPanel(object);
        } else if (selected.equals(LOAN)) {
            this.createLoanPanel(object);
        } else if (selected.equals(DISINVESTMENT)) {
            this.facYearPeriod.getBookYear().setMinValue(new BigInteger("1900"), true);
            this.createDisInvestmentPanel(object);
        } else if (selected.equals(PAYOFF)) {
            this.createPayOffPanel(object);
        } else if (selected.equals(NEW_ASSET) || selected.equals(NEW_LOAN)) {
            if (this.returnedFromDimensionPanel) {
                this.returnedFromDimensionPanel = false;
                this.createNewAssetPanelContinued(object);
            } else {
                this.createNewAssetPanel(object);
            }
        } else if (selected.equals(LEDGERCORRECTION)) {
            this.facYearPeriod.setHidden(true);
            this.facYearPeriod.setMandatory(false);
            this.finYearPeriod.setMandatory(true);
            this.createCorrectionPanel(object);
        }
        this.fbAllocate.addAction(this.details);
        this.fbAllocate.addAction(this.cancel);
        object.addUIObject((UIObject)this.fbAllocate);
        return object;
    }

    public DataObject allocateMultipleTransactions(DataObject object) throws Exception {
        if (!this.returnedFromDimensionPanel) {
            this.mainAccountDifferenceOK = false;
        }
        BigDecimal unallocatedValue = new BigDecimal(0);
        int i = 0;
        while (i < this.ifts.length) {
            this.incomingFinancialTransaction = (IncomingFinancialTransaction)this.ifts[i];
            unallocatedValue = unallocatedValue.add(this.incomingFinancialTransaction.getUnAllocatedValue());
            ++i;
        }
        if (unallocatedValue.doubleValue() == 0.0) {
            if (this.autoConfirm) {
                String message = IncomingFinancialTransactionBP.confirm(this.incomingFinancialTransaction);
                if (message != null) {
                    object.addUIObject((UIObject)new Message(message, "error"));
                    return object;
                }
                return this.refresh(object);
            }
            object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(IncomingFinancialTransactionMultipleTransactionsAdapter.PAGE), "show", this.getProcess().getProcessId()));
            return object;
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.AllocateIncomingFinancialTransaction", "screen_name"));
        object.addUIObject((UIObject)this.header);
        if (!this.returnedFromDimensionPanel) {
            this.initializeCommonValuesMultipleTransactions();
        }
        object.addUIObject((UIObject)this.fgAllocateTo);
        this.fbAllocate = new FloatBar();
        String selected = this.allocateTo.getSelectedOptionValue();
        this.facYearPeriod.setHidden(false);
        this.facYearPeriod.setMandatory(true);
        this.facYearPeriod.getBookYear().setMinValue(new BigInteger(this.bookYearMin), true);
        this.finYearPeriod.setMandatory(false);
        if (selected.equals(INVESTMENT)) {
            this.createInvestmentMultipleTransactionsPanel(object);
        } else if (selected.equals(LOAN)) {
            this.createLoanPanel(object);
        } else if (selected.equals(DISINVESTMENT)) {
            this.facYearPeriod.getBookYear().setMinValue(new BigInteger("1900"), true);
            this.createDisInvestmentPanel(object);
        } else if (selected.equals(PAYOFF)) {
            this.createPayOffPanel(object);
        } else if (selected.equals(NEW_ASSET) || selected.equals(NEW_LOAN)) {
            if (this.returnedFromDimensionPanel) {
                this.returnedFromDimensionPanel = false;
                this.createNewAssetPanelContinued(object);
            } else {
                this.createNewAssetPanel(object);
            }
        } else if (selected.equals(LEDGERCORRECTION)) {
            this.facYearPeriod.setHidden(true);
            this.facYearPeriod.setMandatory(false);
            this.finYearPeriod.setMandatory(true);
            this.createCorrectionPanel(object);
        }
        this.fbAllocate.addAction(this.details);
        this.fbAllocate.addAction(this.cancel);
        object.addUIObject((UIObject)this.fbAllocate);
        return object;
    }

    public void createInvestmentPanel(DataObject object) throws Exception {
        this.genericPanel.setLabel("Label.AdditionalInvestment.short");
        AssetReferenceField newAssetField = new AssetReferenceField(this.company, null, new Boolean(true), true, false, new Boolean(false));
        newAssetField.setLabel("Label.Asset");
        this.genericPanel.replaceUIObject((UIObject)this.assetField, (UIObject)newAssetField);
        this.assetField = newAssetField;
        this.assetField.setMandatory(true);
        this.genericPanel.removeUIObjects(CollectionTable.class, "IFTAdapter1_TRN", true);
        Action action = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createInvestment");
        this.createGenericPanel(object, action, false);
    }

    public void createInvestmentMultipleTransactionsPanel(DataObject object) throws Exception {
        this.genericPanel.setLabel("Label.AdditionalInvestment.short");
        AssetReferenceField newAssetField = new AssetReferenceField(this.company, null, new Boolean(true), true, false, new Boolean(false));
        newAssetField.setLabel("Label.Asset");
        this.genericPanel.replaceUIObject((UIObject)this.assetField, (UIObject)newAssetField);
        this.assetField = newAssetField;
        this.assetField.setMandatory(true);
        this.genericPanel.removeUIObjects(CollectionTable.class, "IFTAdapter1_TRN", true);
        this.genericPanel.add((Table)this.createExtraInvestmentTable());
        Action action = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createInvestmentMultipleTransactions");
        this.createGenericPanelMultipleTransactions(object, action, false);
    }

    public void createLoanPanel(DataObject object) throws Exception {
        this.genericPanel.setLabel("Label.AdditionalLoan.short");
        AssetReferenceField newAssetField = new AssetReferenceField(this.company, null, new Boolean(true), true, false, new Boolean(true));
        newAssetField.setLabel("Label.Loan");
        this.genericPanel.replaceUIObject((UIObject)this.assetField, (UIObject)newAssetField);
        this.assetField = newAssetField;
        this.assetField.setMandatory(true);
        Action action = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createLoan");
        this.createGenericPanel(object, action, false);
    }

    public void createPayOffPanel(DataObject object) throws Exception {
        this.genericPanel.setLabel("Label.PayOff");
        AssetReferenceField newAssetField = new AssetReferenceField(this.company, null, new Boolean(true), true, false, new Boolean(true));
        newAssetField.setLabel("Label.Loan");
        this.genericPanel.replaceUIObject((UIObject)this.assetField, (UIObject)newAssetField);
        this.assetField = newAssetField;
        this.assetField.setMandatory(true);
        Action action = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createPayOff");
        this.createGenericPanel(object, action, true);
    }

    private void createGenericPanel(DataObject object, Action action, boolean isPayOff) throws Exception {
        this.assetField.setValue();
        this.assetField.setDescription("");
        BigDecimal unAllocatedValue = isPayOff ? this.incomingFinancialTransaction.getUnAllocatedValue().negate() : this.incomingFinancialTransaction.getUnAllocatedValue();
        this.transactionValue.setValue(unAllocatedValue);
        if (unAllocatedValue.doubleValue() < 0.0) {
            this.transactionValue.setMaxValue(0.0, false);
            this.transactionValue.setMinValue(unAllocatedValue, true);
        } else {
            this.transactionValue.setMinValue(0.0, false);
            this.transactionValue.setMaxValue(unAllocatedValue, true);
        }
        object.addUIObject((UIObject)this.genericPanel);
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.fbAllocate.addAction(action);
    }

    private void createGenericPanelMultipleTransactions(DataObject object, Action action, boolean isPayOff) throws Exception {
        this.assetField.setValue();
        this.assetField.setDescription("");
        this.transactionValue.setValue(this.unAllocatedValue.getValue());
        object.addUIObject((UIObject)this.genericPanel);
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.fbAllocate.addAction(action);
    }

    public DataObject createInvestment(DataObject object) throws Exception {
        boolean warning;
        boolean error = this.validateGenericPanel(object, true, false);
        if (error) {
            return object;
        }
        Asset asset = this.assetField.getAsset();
        if (this.incomingFinancialTransaction.getGovernmentCode() == 1 && (asset.getStartUseYear() != this.facYearPeriod.getBookYear().getIntValue() || asset.getStartUsePeriod() != this.facYearPeriod.getPeriod().getIntValue())) {
            String s = " (" + asset.getStartUseYear() + "-" + asset.getStartUsePeriod() + ") ";
            object.addUIObject((UIObject)new Message("Ingangsperiode moet gelijk zijn aan de activeringsperiode van het activum" + s, "error"));
        }
        if (warning = this.validateMainAccount(object, asset, false)) {
            return object;
        }
        String message = this.investmentBP.createInvestment(asset, false, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.description.getValue(), this.transactionValue.getBigDecimal(), this.incomingFinancialTransaction, false, this.loginHelper.getUser(), false, null, 0, -1);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.incomingFinancialTransaction.getId(), true);
        this.table.reload();
        return this.allocate(object);
    }

    public DataObject createInvestmentMultipleTransactions(DataObject object) throws Exception {
        String pointerId = "";
        boolean error = this.validateGenericPanel(object, true, false);
        if (error) {
            return object;
        }
        Asset asset = this.assetField.getAsset();
        this.getProcess().setAttribute(ASSET, (Object)this.assetField.getValue());
        if (this.ifts != null) {
            int i = 0;
            while (i < this.ifts.length) {
                boolean warning;
                IncomingFinancialTransaction incomingFinancialTransactionMp = (IncomingFinancialTransaction)this.ifts[i];
                if (incomingFinancialTransactionMp.getGovernmentCode() == 1 && (asset.getStartUseYear() != this.facYearPeriod.getBookYear().getIntValue() || asset.getStartUsePeriod() != this.facYearPeriod.getPeriod().getIntValue())) {
                    String s = " (" + asset.getStartUseYear() + "-" + asset.getStartUsePeriod() + ") ";
                    object.addUIObject((UIObject)new Message("Ingangsperiode moet gelijk zijn aan de activeringsperiode van het activum" + s, "error"));
                }
                if (warning = this.validateMainAccount(object, asset, true)) {
                    return object;
                }
                String message = this.investmentBP.createInvestment(asset, false, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), incomingFinancialTransactionMp.getDescription(), incomingFinancialTransactionMp.getTransactionValue(), incomingFinancialTransactionMp, false, this.loginHelper.getUser(), false, null, 0, -1);
                if (message != null) {
                    object.addUIObject((UIObject)new Message(message, "error"));
                    return object;
                }
                if (pointerId.trim().equalsIgnoreCase("")) {
                    pointerId = incomingFinancialTransactionMp.getId();
                }
                ++i;
            }
        }
        this.table.setPointer("id", (Object)pointerId, true);
        this.table.reload();
        return this.allocateMultipleTransactions(object);
    }

    public DataObject createLoan(DataObject object) throws Exception {
        boolean error = this.validateGenericPanel(object, false, false);
        if (error) {
            return object;
        }
        Asset asset = this.assetField.getAsset();
        String message = this.loanAndPayOffBP.createLoan(asset, false, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.description.getValue(), this.transactionValue.getBigDecimal(), this.incomingFinancialTransaction, false, this.loginHelper.getUser());
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.incomingFinancialTransaction.getId(), true);
        this.table.reload();
        return this.allocate(object);
    }

    public DataObject createPayOff(DataObject object) throws Exception {
        boolean error = this.validateGenericPanel(object, false, true);
        if (error) {
            return object;
        }
        Asset asset = this.assetField.getAsset();
        String message = this.loanAndPayOffBP.createPayOff(asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.description.getValue(), this.transactionValue.getBigDecimal(), this.incomingFinancialTransaction, false, this.loginHelper.getUser());
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.incomingFinancialTransaction.getId(), true);
        this.table.reload();
        return this.allocate(object);
    }

    public boolean validateGenericPanel(DataObject object, boolean isInvestment, boolean isPayOff) throws Exception {
        String message;
        this.genericPanel.removeInvalidTags();
        Asset asset = this.assetField.getAsset();
        boolean error = false;
        if (this.governmentActivated) {
            if (this.isLoanOrPayOff && !asset.getLoan()) {
                this.assetField.setInvalidTag();
                object.addUIObject((UIObject)new Message("invalid_asset_no_3rd_party_loan", "error"));
                error = true;
            }
            if (!this.isLoanOrPayOff && asset.getLoan()) {
                this.assetField.setInvalidTag();
                object.addUIObject((UIObject)new Message("invalid_asset_is_3rd_party_loan", "error"));
                error = true;
            }
        }
        if ((message = this.investmentBP.hasNotPostedTransactions(asset)) != null) {
            error = true;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        String[] messages = null;
        messages = isInvestment ? this.investmentBP.validateFACYearAndPeriod(asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue()) : this.loanAndPayOffBP.validateFACYearAndPeriod(asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), isPayOff);
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.facYearPeriod.setInvalidTag();
        }
        if ((messages = this.investmentBP.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax))) != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.setInvalidTag();
        }
        if ((messages = isInvestment ? this.investmentBP.validateInvestmentValue(this.transactionValue.getBigDecimal()) : this.loanAndPayOffBP.validateTransactionValue(this.transactionValue.getBigDecimal(), isPayOff)) != null) {
            error = true;
            this.addErrors(object, messages);
            this.transactionValue.setInvalidTag();
        }
        return error;
    }

    public void createDisInvestmentPanel(DataObject object) throws Exception {
        AssetReferenceField newAssetField = new AssetReferenceField(this.company, null, new Boolean(true), true, false, new Boolean(false));
        this.genericPanel.replaceUIObject((UIObject)this.assetField, (UIObject)newAssetField);
        this.disInvestmentPanel.replaceUIObject((UIObject)this.assetFieldSave, (UIObject)newAssetField);
        this.assetFieldSave = this.assetField = newAssetField;
        this.assetField.setMandatory(true);
        BigDecimal unAllocatedValue = this.incomingFinancialTransaction.getUnAllocatedValue().negate();
        this.transactionValue.setValue(unAllocatedValue);
        if (unAllocatedValue.doubleValue() < 0.0) {
            this.transactionValue.setMaxValue(0.0, false);
            this.transactionValue.setMinValue(unAllocatedValue, true);
        } else {
            this.transactionValue.setMinValue(0.0, false);
            this.transactionValue.setMaxValue(unAllocatedValue, true);
        }
        this.partialDisInvestment.setValue(false);
        this.partialDisInvestmentChangeAction.execute(object);
        object.addUIObject((UIObject)this.disInvestmentPanel);
        Action action = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createDisInvestment");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.fbAllocate.addAction(action);
    }

    public DataObject createDisInvestment(DataObject object) throws Exception {
        this.disInvestmentPanel.removeInvalidTags();
        boolean error = false;
        String[] messages = null;
        Asset asset = this.assetField.getAsset();
        String message = this.disInvestmentBP.hasNotPostedTransactions(asset);
        if (message != null) {
            error = true;
            object.addUIObject((UIObject)new Message(message, "error"));
        }
        if ((messages = this.disInvestmentBP.validateFACYearAndPeriod(asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.partialDisInvestment.getValueAsBoolean())) != null) {
            error = true;
            this.addErrors(object, messages);
            this.facYearPeriod.getBookYear().setInvalidTag();
            this.facYearPeriod.getPeriod().setInvalidTag();
        }
        if ((messages = this.disInvestmentBP.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax))) != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.getBookYear().setInvalidTag();
            this.finYearPeriod.getPeriod().setInvalidTag();
        }
        if ((messages = this.disInvestmentBP.validateYieldValue(this.transactionValue.getBigDecimal())) != null) {
            error = true;
            this.addErrors(object, messages);
            this.transactionValue.setInvalidTag();
        }
        if (this.partialDisInvestment.getValueAsBoolean() && (messages = this.disInvestmentBP.validatePartialDisInvestmentValue(asset, this.disInvestmentPartialAmount.getBigDecimal(), this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue())) != null) {
            error = true;
            this.addErrors(object, messages);
            this.disInvestmentPartialAmount.setInvalidTag();
        }
        if (error) {
            return object;
        }
        this.disInvestmentValue = new BigDecimal("0");
        if (this.partialDisInvestment.getValueAsBoolean()) {
            this.disInvestmentValue = this.disInvestmentPartialAmount.getBigDecimal();
        }
        ProofDisInvestmentBP businesProcess = new ProofDisInvestmentBP(this.company, this.numberOfPeriods);
        businesProcess.calculateProofDisInvestmentValues(asset, this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.transactionValue.getBigDecimal(), this.disInvestmentValue);
        this.getProcess().setAttribute("assetToDisInvest", (Object)asset);
        this.getProcess().setAttribute("proofDisInvestmentProcess", (Object)businesProcess);
        this.getProcess().setAttribute("ProofDisinvestmentAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("ProofDisinvestmentAdapterReturnMethod", (Object)"createDisInvestmentContinued");
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(ProofDisInvestmentAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject createDisInvestmentContinued(DataObject object) throws Exception {
        String message = this.disInvestmentBP.createDisInvestment(this.assetField.getAsset(), this.facYearPeriod.getBookYear().getIntValue(), this.facYearPeriod.getPeriod().getIntValue(), this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.description.getValue(), this.transactionValue.getBigDecimal(), this.disInvestmentValue, this.incomingFinancialTransaction, false, this.loginHelper.getUser(), Integer.parseInt(this.disinvestmentReason.getValue()));
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.incomingFinancialTransaction.getId(), true);
        this.table.reload();
        return this.allocate(object);
    }

    public void createCorrectionPanel(DataObject object) throws Exception {
        BigDecimal unAllocatedValue = this.incomingFinancialTransaction.getUnAllocatedValue();
        this.transactionValue.setValue(unAllocatedValue);
        if (unAllocatedValue.doubleValue() < 0.0) {
            this.transactionValue.setMaxValue(0.0, false);
            this.transactionValue.setMinValue(unAllocatedValue, true);
        } else {
            this.transactionValue.setMinValue(0.0, false);
            this.transactionValue.setMaxValue(unAllocatedValue, true);
        }
        this.finYearPeriod.setValues("" + this.incomingFinancialTransaction.getBookYear(), "" + this.incomingFinancialTransaction.getPeriod());
        this.daybook.setValue(((CompanyAccountingPrincipleDefault)CompanyAccountingPrincipleDefaultBO.get(this.dbData, this.companyId, 1)[0]).getDaybookId1());
        this.daybook.setReadonly(false);
        this.financialDimension[0].setValue(this.incomingFinancialTransaction.getMainAccount());
        if (this.financialDimension[1] != null) {
            this.financialDimension[1].setValue(this.incomingFinancialTransaction.getFinDimId1());
        }
        if (this.financialDimension[2] != null) {
            this.financialDimension[2].setValue(this.incomingFinancialTransaction.getFinDimId2());
        }
        if (this.financialDimension[3] != null) {
            this.financialDimension[3].setValue(this.incomingFinancialTransaction.getFinDimId3());
        }
        if (this.financialDimension[4] != null) {
            this.financialDimension[4].setValue(this.incomingFinancialTransaction.getFinDimId4());
        }
        if (this.financialDimension[5] != null) {
            this.financialDimension[5].setValue(this.incomingFinancialTransaction.getFinDimId5());
        }
        int i = 0;
        while (i < this.financialDimension.length) {
            if (this.financialDimension[i] != null) {
                this.financialDimension[i].setReadonly(false);
            }
            ++i;
        }
        object.addUIObject((UIObject)this.correctionPanel);
        Action action = new Action("Button.OK", null, null, this.getProcessAdapterPageName(PAGE), "createCorrection");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.fbAllocate.addAction(action);
    }

    public DataObject createCorrection(DataObject object) throws Exception {
        String message;
        this.correctionPanel.removeInvalidTags();
        boolean error = false;
        String[] messages = null;
        messages = this.ledgerCorrectionBP.validateFINYearAndPeriod(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax));
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.finYearPeriod.setInvalidTag();
        }
        String mainAccount = this.financialDimension[0].getFormattedId();
        boolean isFMS = this.env.getOperationArea().trim().length() != 0;
        messages = this.ledgerCorrectionBP.validateFACMainAccount(this.loginHelper, isFMS, this.finYearPeriod.getBookYear().getIntValue(), mainAccount);
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.financialDimension[0].setInvalidTag();
        }
        if (error) {
            return object;
        }
        String sDaybook = this.daybook.getFormattedId();
        String finDimId1 = "";
        if (this.financialDimension[1] != null) {
            finDimId1 = this.financialDimension[1].getFormattedId();
        }
        String finDimId2 = "";
        if (this.financialDimension[2] != null) {
            finDimId2 = this.financialDimension[2].getFormattedId();
        }
        String finDimId3 = "";
        if (this.financialDimension[3] != null) {
            finDimId3 = this.financialDimension[3].getFormattedId();
        }
        String finDimId4 = "";
        if (this.financialDimension[4] != null) {
            finDimId4 = this.financialDimension[4].getFormattedId();
        }
        String finDimId5 = "";
        if (this.financialDimension[5] != null) {
            finDimId5 = this.financialDimension[5].getFormattedId();
        }
        if ((message = this.ledgerCorrectionBP.createCorrection(this.finYearPeriod.getBookYear().getIntValue(), this.finYearPeriod.getPeriod().getIntValue(), this.description.getValue(), this.transactionValue.getBigDecimal(), sDaybook, mainAccount, finDimId1, finDimId2, finDimId3, finDimId4, finDimId5, this.incomingFinancialTransaction, null, this.loginHelper.getUser())) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.incomingFinancialTransaction.getId(), true);
        this.table.reload();
        return this.allocate(object);
    }

    public DataObject createNewAssetPanel(DataObject object) throws Exception {
        if (this.returnedFromDimensionPanel) {
            this.createNewAssetPanelContinued(object);
            return object;
        }
        this.maFieldGroup = null;
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, null, false, false, false, this.incomingFinancialTransaction, false, null, null);
        this.getProcess().setAttribute("ParentAssetAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("ParentAssetAdapterReturnMethod", (Object)"handleNewParentAsset");
        this.panels.fbParent.addAction(this.panels.getCreateParentAssetAction().setAdapter(this.getProcessAdapterPageName(ParentAssetAdapter.PAGE)).setMethod("initCreateForm"));
        if (this.governmentActivated) {
            if (this.isLoanOrPayOff) {
                this.panels.firstPanel.setLabel("Label.NewLoan");
                this.panels.addAcquisitionDataToFirstPanel("Label.Amount", "Label.EntryDate", "Label.NegativeLoan", "Label.PayOffYearAmount");
                this.panels.updateAccountingPrincipleForms(true);
            } else {
                this.panels.firstPanel.setLabel("Label.NewAsset");
                this.panels.addAcquisitionDataToFirstPanel("Label.AcquisitionValue", "Label.AcquisitionDate", "Label.NegativeInvestment", null);
                this.panels.updateAccountingPrincipleForms(false);
            }
        } else {
            this.panels.firstPanel.setLabel("Label.NewAsset");
            this.panels.addAcquisitionDataToFirstPanel("Label.AcquisitionValue", "Label.AcquisitionDate", "Label.NegativeInvestment", null);
            this.panels.updateAccountingPrincipleForms(false);
        }
        if (this.incomingFinancialTransaction.getInvoiceDate() != null) {
            this.panels.acquisitionDate.setValue(this.incomingFinancialTransaction.getInvoiceDate());
        } else {
            this.panels.acquisitionDate.setValue(this.incomingFinancialTransaction.getBookDate());
        }
        BigDecimal unAllocatedValue = this.incomingFinancialTransaction.getUnAllocatedValue();
        this.panels.acquisitionValue.setValue(unAllocatedValue);
        if (unAllocatedValue.doubleValue() < 0.0) {
            this.panels.acquisitionValue.setMaxValue(0.0, false);
            this.panels.acquisitionValue.setMinValue(unAllocatedValue, true);
        } else {
            this.panels.acquisitionValue.setMinValue(0.0, false);
            this.panels.acquisitionValue.setMaxValue(unAllocatedValue, true);
        }
        this.panels.description.setValue(this.incomingFinancialTransaction.getDescription());
        this.createNewAssetPanelContinued(object);
        return object;
    }

    public DataObject createNewAssetPanelContinued(DataObject object) throws Exception {
        this.panels.id.setReadonly(this.panels.idReadOnly);
        this.panels.id.setLabel("");
        this.panels.description.setReadonly(false);
        this.panels.description.setLabel("");
        if (!this.panels.id.getReadonly()) {
            this.panels.id.requestFocus(true);
        } else {
            this.panels.description.requestFocus(true);
        }
        object.addUIObject((UIObject)this.panels.firstPanel);
        Action action = new Action("Button.Next", null, null, this.getProcessAdapterPageName(PAGE), "createDimensionsForm");
        action.setDefault(true);
        action.setValidationEnabled(true);
        this.fbAllocate.addAction(action);
        return object;
    }

    public DataObject handleNewParentAsset(DataObject object) throws Exception {
        Object newParentAssetId = this.getProcess().getAttribute("NewParentId");
        if (newParentAssetId != null) {
            this.panels.setNewParent(newParentAssetId.toString(), this.getProcess().getAttribute("NewParentDescription").toString());
            this.getProcess().removeAttribute("NewParentId");
            this.getProcess().removeAttribute("NewParentDescription");
        }
        return object;
    }

    public DataObject createDimensionsForm(DataObject object) throws Exception {
        boolean warning;
        if (!this.panels.id.isHidden()) {
            Object[] result;
            if ("number".equals(this.panels.id.getType())) {
                try {
                    if (Integer.parseInt(this.panels.id.getValue()) <= 0) {
                        this.panels.id.setInvalidTag();
                        object.addUIObject((UIObject)new Message("value_must_be_positive", "error"));
                        return object;
                    }
                }
                catch (NumberFormatException nfe) {
                    this.panels.id.setInvalidTag();
                    object.addUIObject((UIObject)new Message("not_a_number", "error"));
                    return object;
                }
            }
            if ((result = AssetBO.get(this.company, this.panels.id.getValue().trim(), false))[0] != null) {
                this.panels.id.setInvalidTag();
                object.addUIObject((UIObject)new Message("duplicate_key", "error"));
                return object;
            }
        }
        this.panels.investmentYP.setValues(this.facYearPeriod.getBookYear().getValue(), this.facYearPeriod.getPeriod().getValue());
        this.panels.bookYP.setValues(this.finYearPeriod.getBookYear().getValue(), this.finYearPeriod.getPeriod().getValue());
        String message = this.panels.validateCommonForm();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        if (this.governmentActivated) {
            if (this.isLoanOrPayOff && !this.panels.assetType.getIs3rdPartyLoan()) {
                this.panels.type.setInvalidTag();
                object.addUIObject((UIObject)new Message("invalid_assettype_no_3rd_party_loan", "error"));
                return object;
            }
            if (!this.isLoanOrPayOff && this.panels.assetType.getIs3rdPartyLoan()) {
                this.panels.type.setInvalidTag();
                object.addUIObject((UIObject)new Message("invalid_assettype_is_3rd_party_loan", "error"));
                return object;
            }
        }
        if (warning = this.validateMainAccount(object, null, false)) {
            return object;
        }
        this.panels.id.setReadonly(true);
        this.panels.id.setLabel("Label.Id");
        this.panels.id.setHelpId("Label.AssetId");
        this.panels.description.setReadonly(true);
        this.panels.description.setLabel("Label.Description");
        this.panels.initializeType();
        if (this.governmentActivated) {
            if (this.isLoanOrPayOff) {
                this.panels.updateAccountingPrincipleForms(true);
            } else {
                this.panels.updateAccountingPrincipleForms(false);
            }
        }
        this.panels.copyStartUsePeriod();
        return this.createDimensionsFormContinued(object);
    }

    public DataObject createDimensionsFormContinued(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateAssetDimensions", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.finDimensionPanel);
        object.addUIObject((UIObject)this.panels.facDimensionPanel);
        String suspense = this.incomingFinancialTransaction.getSuspenseAccount();
        String suspenseType = this.incomingFinancialTransaction.getSuspenseType();
        if (suspense.length() > 0) {
            Field[] freeDimension = this.panels.dimensionPanels.freeDimension;
            int i = 0;
            while (i < freeDimension.length) {
                if (freeDimension[i] instanceof FinancialReferenceField) {
                    String description;
                    if (freeDimension[i] instanceof FISReferenceField) {
                        freeDimension[i].setValue(suspense);
                    }
                    if (freeDimension[i] instanceof FMSReferenceField) {
                        int index = ((FMSReferenceField)freeDimension[i]).getIndex();
                        switch (index) {
                            case 10: {
                                if (!suspenseType.equals("D") && suspenseType.trim().length() != 0) break;
                                freeDimension[i].setValue(suspense);
                                break;
                            }
                            case 11: {
                                if (!suspenseType.equals("C") && suspenseType.trim().length() != 0) break;
                                freeDimension[i].setValue(suspense);
                                break;
                            }
                            case 12: {
                                if (!suspenseType.equals("R") && suspenseType.trim().length() != 0) break;
                                freeDimension[i].setValue(suspense);
                            }
                        }
                    }
                    if ((description = ((FinancialReferenceField)freeDimension[i]).getDescription()) == null || description.trim().length() == 0) {
                        freeDimension[i].setValue("");
                    }
                }
                ++i;
            }
        }
        FloatBar fb = new FloatBar();
        Action action = new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("resendNewAssetPanel");
        fb.addAction(action);
        if (!this.governmentActivated) {
            action = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAssetWithDefaults");
            action.setValidationEnabled(true);
            action.setDefault(true);
            fb.addAction(action);
        }
        action = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleForm");
        action.setValidationEnabled(true);
        action.setDefault(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        return object;
    }

    public DataObject resendNewAssetPanel(DataObject object) throws Exception {
        this.returnedFromDimensionPanel = true;
        return this.allocate(object);
    }

    private boolean validateMainAccount(DataObject object, Asset asset, boolean isMultipleTransactions) throws Exception {
        int thePeriod;
        int theYear;
        if (!this.warnForMainAccountDifference || this.mainAccountDifferenceOK) {
            return false;
        }
        String iftMainAccount = this.incomingFinancialTransaction.getMainAccount();
        int accountingPrinciple = 1;
        if (this.finYearPeriod.getBookYear().getIntValue() == 0) {
            theYear = this.facYearPeriod.getBookYear().getIntValue();
            thePeriod = this.facYearPeriod.getPeriod().getIntValue();
        } else {
            theYear = this.finYearPeriod.getBookYear().getIntValue();
            thePeriod = this.finYearPeriod.getPeriod().getIntValue();
        }
        AssetType assetType = null;
        assetType = asset == null ? this.panels.assetType : asset.getAssetType();
        MainAccountScheme mainAccountScheme = MainAccountSchemeBO.getMainAccountSchemeToUse(assetType, accountingPrinciple, theYear, thePeriod);
        if (mainAccountScheme == null) {
            return false;
        }
        String assetMainAccount = mainAccountScheme.getMainAccountId1();
        if (assetMainAccount == null || assetMainAccount.trim().length() == 0) {
            return false;
        }
        if (!iftMainAccount.equals(assetMainAccount)) {
            this.createMainAccountWarningWindow(object, iftMainAccount, assetMainAccount, asset, assetType, isMultipleTransactions);
            return true;
        }
        return false;
    }

    public void createMainAccountWarningWindow(DataObject object, String iftMA, String assetMA, Asset asset, AssetType assetType, boolean isMultipleTransactions) throws Exception {
        FinancialReferenceField assetMArf;
        FinancialReferenceField iftMArf;
        this.maWindow = new Window();
        this.maWindow.setTop("10%");
        this.maWindow.setRight("15%");
        this.maWindow.setLabel("Label.WarningForMADifference");
        if (this.env.getOperationArea().length() == 0) {
            iftMArf = new FISReferenceField(this.loginHelper, "Label.InvestmentMA", 0, this.companyId, "" + this.company.getCurrentBookYear(), true);
            assetMArf = new FISReferenceField(this.loginHelper, "Label.InvestmentMA", 0, this.companyId, "" + this.company.getCurrentBookYear(), true);
        } else {
            iftMArf = new FMSReferenceField(this.loginHelper, "Label.InvestmentMA", 0, true);
            assetMArf = new FMSReferenceField(this.loginHelper, "Label.InvestmentMA", 0, true);
        }
        FieldGroup fg = new FieldGroup("Label.InGL");
        iftMArf.setReadonly(true);
        iftMArf.setValue(iftMA);
        fg.add((Field)iftMArf);
        this.maWindow.add(fg);
        fg = new FieldGroup("Label.InFAC");
        if (asset != null) {
            AssetReferenceField arf = new AssetReferenceField(this.company, null, new Boolean(true), true, false, new Boolean(false));
            arf.setReadonly(true);
            arf.setLabel("Label.Asset");
            arf.setDescriptionLength(40);
            arf.setValue(asset.getId());
            fg.add((Field)arf);
        }
        AssetTypeReferenceField type = new AssetTypeReferenceField(this.dbData, this.companyOrDataSetId);
        type.setReadonly(true);
        type.setValue(assetType.getId());
        type.setDescription(assetType.getDescription());
        fg.add((Field)type);
        assetMArf.setReadonly(true);
        assetMArf.setValue(assetMA);
        fg.add((Field)assetMArf);
        this.maWindow.add(fg);
        FloatBar fb = new FloatBar();
        Action goOn = asset == null ? new Action("Button.GoOn").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("goOnWithNewAsset") : (isMultipleTransactions ? new Action("Button.GoOn").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("goOnWithAdditionalInvestmentMultipleTransactions") : new Action("Button.GoOn").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("goOnWithAdditionalInvestment"));
        goOn.setDefault(true);
        fb.addAction(goOn);
        Action back = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("closeMAWindow");
        fb.addAction(back);
        FieldGroup floatBar = new FieldGroup();
        floatBar.forceBorder(false);
        floatBar.add(fb);
        this.maWindow.add(floatBar);
        object.addUIObject((UIObject)this.maWindow);
    }

    public DataObject goOnWithNewAsset(DataObject object) throws Exception {
        this.maWindow.closeWindow(object);
        this.mainAccountDifferenceOK = true;
        return this.createDimensionsForm(object);
    }

    public DataObject goOnWithAdditionalInvestment(DataObject object) throws Exception {
        this.maWindow.closeWindow(object);
        this.mainAccountDifferenceOK = true;
        return this.createInvestment(object);
    }

    public DataObject goOnWithAdditionalInvestmentMultipleTransactions(DataObject object) throws Exception {
        this.maWindow.closeWindow(object);
        this.mainAccountDifferenceOK = true;
        return this.createInvestmentMultipleTransactions(object);
    }

    public DataObject closeMAWindow(DataObject object) throws Exception {
        this.maWindow.closeWindow(object);
        return object;
    }

    /*
     * Unable to fully structure code
     */
    public DataObject createAssetWithDefaults(DataObject object) throws Exception {
        message = null;
        this.panels.apTabCount = 0;
        while (this.panels.apTabCount <= this.panels.apTabCountMax) {
            block5: {
                try {
                    message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
                    break block5;
                }
                catch (UserMessageCollection umc) {
                    throwables = umc.getThrowables();
                    i = 0;
                    ** while (i < throwables.length)
                }
lbl-1000:
                // 1 sources

                {
                    object.addUIObject((UIObject)new Message(throwables[i].getMessage(), "error"));
                    ++i;
                    continue;
                }
lbl14:
                // 1 sources

                return this.createAccountingPrincipleForm(object);
            }
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return this.createAccountingPrincipleForm(object);
            }
            ++this.panels.apTabCount;
        }
        return this.createAsset(object);
    }

    public DataObject createAccountingPrincipleFormNext(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ++this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleFormPrevious(DataObject object) throws Exception {
        --this.panels.apTabCount;
        return this.createAccountingPrincipleForm(object);
    }

    public DataObject createAccountingPrincipleForm(DataObject object) throws Exception {
        this.panels.id.setReadonly(true);
        this.panels.description.setReadonly(true);
        this.clearScreen(true, false, true);
        String additionalText = "";
        if (!this.governmentActivated) {
            additionalText = this.panels.getAccountingPrincipleTabText();
        }
        Header headerr = new Header(String.valueOf(object.translate("Title.CreateAssetDepreciationInterest", object.getLocale())) + additionalText, "screen_name");
        headerr.setHelpId("Title.CreateAssetDepreciationInterest");
        object.addUIObject((UIObject)headerr);
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.panels.headerPanel);
        object.addUIObject((UIObject)this.panels.apPanels[this.panels.apTabCount]);
        this.panels.copyValues();
        FloatBar fbCreateAP = new FloatBar();
        Action action = this.panels.apTabCount == 0 ? new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionsFormContinued") : new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormPrevious");
        fbCreateAP.addAction(action);
        action = this.panels.apTabCount == this.panels.apTabCountMax ? (this.governmentActivated && this.company.getUseValuationMainAccount() ? new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createMainAccountForm") : new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEASSET)) : new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormNext");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fbCreateAP.addAction(action);
        fbCreateAP.addAction(this.cancel);
        object.addUIObject((UIObject)fbCreateAP);
        return object;
    }

    public DataObject createMainAccountForm(DataObject object) throws Exception {
        String message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ++this.panels.apTabCount;
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateAssetMainAccounts", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.panels.headerPanel);
        if (this.maFieldGroup == null) {
            int year = this.facYearPeriod.getBookYear().getIntValue();
            int period = this.facYearPeriod.getPeriod().getIntValue();
            if (this.finYearPeriod.getBookYear().getIntValue() > 0) {
                year = this.finYearPeriod.getBookYear().getIntValue();
                period = this.finYearPeriod.getPeriod().getIntValue();
            }
            this.maFieldGroup = this.genericGovernmentBP.getInitialMainAccountFieldGroup(this.loginHelper, this.panels.assetType, 1, year, period);
        }
        object.addUIObject((UIObject)this.maFieldGroup);
        FloatBar fb = new FloatBar();
        fb.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createAccountingPrincipleFormPrevious"));
        Action action = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEASSET);
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(this.cancel);
        object.addUIObject((UIObject)fb);
        return object;
    }

    /*
     * Unable to fully structure code
     */
    public DataObject createAsset(DataObject object) throws Exception {
        message = null;
        this.panels.apTabCount = 0;
        while (this.panels.apTabCount <= this.panels.apTabCountMax) {
            block7: {
                try {
                    message = this.panels.validateAccountingPrincipleForm(this.panels.apTabCount);
                    break block7;
                }
                catch (UserMessageCollection umc) {
                    throwables = umc.getThrowables();
                    i = 0;
                    ** while (i < throwables.length)
                }
lbl-1000:
                // 1 sources

                {
                    object.addUIObject((UIObject)new Message(throwables[i].getMessage(), "error"));
                    ++i;
                    continue;
                }
lbl14:
                // 1 sources

                return object;
            }
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return object;
            }
            ++this.panels.apTabCount;
        }
        if (this.company.getUseValuationMainAccount()) {
            this.panels.mainAccountIds = this.genericGovernmentBP.getFormattedMainAccountIds();
        }
        if ((message = (String)(result = new AssetBP(this.panels).create(this.incomingFinancialTransaction, null, false))[1]) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        filterName = this.table.getODBCursor().getFilter();
        mapFilterParms = this.table.getODBCursor().getFilterParameters();
        bDesc = this.table.getODBCursor().getDescending();
        sSortedColumn = this.table.getODBCursor().getOrderColumn();
        this.table.getODBCursor().setFilter(filterName, mapFilterParms);
        this.table.getODBCursor().orderByColumn(sSortedColumn);
        this.table.getODBCursor().setDescending(bDesc);
        this.table.reload();
        return this.allocate(object);
    }

    public DataObject confirmEntryMultipleTransactions(DataObject object) throws Exception {
        this.ifts = (Object[])this.getProcess().getAttribute(INCOMINGFINANCIALTRANSACTIONS);
        int i = 0;
        while (i < this.ifts.length) {
            this.incomingFinancialTransaction = (IncomingFinancialTransaction)this.ifts[i];
            String message = IncomingFinancialTransactionBP.confirm(this.incomingFinancialTransaction);
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return object;
            }
            ++i;
        }
        return this.refresh2(object);
    }

    public DataObject confirmEntry(DataObject object) throws Exception {
        this.incomingFinancialTransaction = (IncomingFinancialTransaction)this.getProcess().getAttribute(INCOMINGFINANCIALTRANSACTION);
        String message = IncomingFinancialTransactionBP.confirm(this.incomingFinancialTransaction);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        return this.refresh2(object);
    }

    public DataObject confirm(DataObject object) throws Exception {
        object.removeMessages();
        Object[] items = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (items.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        int i = 0;
        while (i < items.length) {
            IncomingFinancialTransaction incomingFinancialTransaction = (IncomingFinancialTransaction)items[i];
            String message = IncomingFinancialTransactionBP.confirm(incomingFinancialTransaction);
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return object;
            }
            ++i;
        }
        return this.refresh(object);
    }

    public DataObject editBBVCategoryWindow(DataObject object) throws Exception {
        this.incomingFinancialTransaction = (IncomingFinancialTransaction)TableHelper.getSelectedItem((DataObject)object);
        if (this.incomingFinancialTransaction.getIFTType() == 2) {
            this.incomingFinancialTransaction = null;
            return object;
        }
        this.editWindow = new Window(this.getProcess().getProcessAdapterName(PAGE), "cancelEdit");
        this.editWindow.setTop("10%");
        this.editWindow.setRight("15%");
        this.editWindow.setLabel("Title.ChangeBBVCategory");
        this.setValues();
        this.editWindow.add(this.header);
        FieldGroup fg = new FieldGroup("Label.BBVCategory");
        this.oldBBVCategory = EnumHelper.createComboBox("Label.Current", GovernmentEnumHelper.getCollection(5), false);
        this.oldBBVCategory.setSelectedOptionValue("" + this.incomingFinancialTransaction.getBBVCategory());
        this.oldBBVCategory.setReadonly(true);
        fg.add(this.oldBBVCategory);
        this.newBBVCategory = EnumHelper.createComboBox("Label.New", GovernmentEnumHelper.getCollection(5), false);
        fg.add(this.newBBVCategory);
        this.editWindow.add(fg);
        FloatBar fb = new FloatBar();
        Action action = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("editBBVCategory");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("cancelEdit"));
        this.editWindow.add(fb);
        object.addUIObject((UIObject)this.editWindow);
        return object;
    }

    public DataObject editBBVCategory(DataObject object) throws Exception {
        if (this.oldBBVCategory.getSelectedOptionValue().equals(this.newBBVCategory.getSelectedOptionValue())) {
            return this.cancelEdit(object);
        }
        String message = IncomingFinancialTransactionBP.changeBBVCategory(this.incomingFinancialTransaction, Integer.parseInt(this.newBBVCategory.getSelectedOptionValue()));
        if (message != null) {
            this.editWindow.add(new Message(message, "error"));
        } else {
            this.table.reloadPage();
            this.cancelEdit(object);
        }
        return object;
    }

    public DataObject cancelEdit(DataObject object) throws Exception {
        this.editWindow.closeWindow(object);
        this.incomingFinancialTransaction = null;
        return object;
    }

    public DataObject allocateInitialProjectCostsWindow(DataObject object) throws Exception {
        this.allocationWindow = new Window(this.getProcess().getProcessAdapterName(PAGE), "cancelAllocation");
        this.allocationWindow.setTop("10%");
        this.allocationWindow.setRight("15%");
        this.allocationWindow.setLabel("Title.AllocateInitialProjectCosts");
        this.setValues();
        this.allocationWindow.add(this.header);
        FieldGroup fg = new FieldGroup();
        this.crf = new CreditReferenceField(this.company, false);
        this.crf.setLabel("Label.Credit");
        fg.add((Field)this.crf);
        this.allocationWindow.add(fg);
        FloatBar fb = new FloatBar();
        Action action = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmIPCAllocation");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("cancelAllocation"));
        this.allocationWindow.add(fb);
        object.addUIObject((UIObject)this.allocationWindow);
        return object;
    }

    public DataObject confirmIPCAllocation(DataObject object) throws Exception {
        Credit credit = this.crf.getCredit();
        if (credit == null) {
            return this.cancelAllocation(object);
        }
        this.allocationWindow.closeWindow(object);
        this.allocationWindow = new Window(this.getProcess().getProcessAdapterName(PAGE), "cancelAllocation");
        this.allocationWindow.setTop("10%");
        this.allocationWindow.setRight("15%");
        this.allocationWindow.setLabel("Title.AllocateInitialProjectCosts");
        this.allocationWindow.add(this.header);
        FieldGroup fg = new FieldGroup("Label.Credit");
        this.crf.setReadonly(true);
        this.crf.setLabel("Label.Id");
        fg.add((Field)this.crf);
        FACDecimalField totalCreditValue = new FACDecimalField("Label.TotalCreditAmount", 15, 2);
        totalCreditValue.setReadonly(true);
        totalCreditValue.setValue(TotalEstimationTransactionBO.getTotalCreditAmount(credit));
        fg.add((Field)totalCreditValue);
        Field startYear = new Field("Label.StartYear");
        startYear.setReadonly(true);
        startYear.setLength(4);
        startYear.setValue("" + credit.getStartYear());
        fg.add(startYear);
        Field endYear = new Field("Label.EndYear");
        endYear.setReadonly(true);
        endYear.setLength(4);
        endYear.setValue("" + credit.getEndYear());
        fg.add(endYear);
        this.allocationWindow.add(fg);
        FloatBar fb = new FloatBar();
        Action action = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("allocateInitialProjectCosts");
        action.setDefault(true);
        action.setValidationEnabled(true);
        fb.addAction(action);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("cancelAllocation"));
        this.allocationWindow.add(fb);
        object.addUIObject((UIObject)this.allocationWindow);
        return object;
    }

    public DataObject allocateInitialProjectCosts(DataObject object) throws Exception {
        Credit credit = this.crf.getCredit();
        if (credit != null) {
            if (credit.getAllocatedValue().doubleValue() != 0.0) {
                this.allocationWindow.add(new Message("Credit_is_being_closed_at_the_moment", "error"));
                return object;
            }
            IncomingFinancialTransactionBP.allocateInitialProjectCosts(this.incomingFinancialTransaction, this.crf.getValue());
            credit.setInitialProjectCostsReferenceCounter(credit.getInitialProjectCostsReferenceCounter() + 1);
        }
        this.cancelAllocation(object);
        return this.refresh(object);
    }

    public DataObject cancelAllocation(DataObject object) throws Exception {
        this.allocationWindow.closeWindow(object);
        this.incomingFinancialTransaction = null;
        return object;
    }

    public DataObject testVerantwoordenMeerdere(DataObject object) throws Exception {
        object.removeMessages();
        this.ifts = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.ifts.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        BigDecimal totalTransactionAmount = new BigDecimal("0.00");
        int i = 0;
        while (i < this.ifts.length) {
            IncomingFinancialTransaction incomingFinancialTransaction = (IncomingFinancialTransaction)this.ifts[i];
            totalTransactionAmount = totalTransactionAmount.add(incomingFinancialTransaction.getTransactionValue());
            if (!IncomingFinancialTransactionBO.getTransactions(incomingFinancialTransaction).isEmpty()) {
                object.addUIObject((UIObject)new Message("ifts_to_delete_cannot_have_transactions", "error"));
                return object;
            }
            if (this.governmentActivated && incomingFinancialTransaction.getIFTType() == 2) {
                object.addUIObject((UIObject)new Message("ifts_to_verantoorden_cannot_governmentactivated", "error"));
                return object;
            }
            ++i;
        }
        if (totalTransactionAmount.doubleValue() == 0.0) {
            object.addUIObject((UIObject)new Message("total_transaction_amount_cannot_be_zero", "error"));
            return object;
        }
        if (this.ifts.length > 1) {
            IncomingFinancialTransaction firstIFT = (IncomingFinancialTransaction)this.ifts[0];
            String firstMainAccount = firstIFT.getMainAccount().trim();
            String firstFinDimId1 = firstIFT.getFinDimId1().trim();
            String firstFinDimId2 = firstIFT.getFinDimId2().trim();
            String firstFinDimId3 = firstIFT.getFinDimId3().trim();
            String firstFinDimId4 = firstIFT.getFinDimId4().trim();
            String firstFinDimId5 = firstIFT.getFinDimId5().trim();
            int i2 = 1;
            while (i2 < this.ifts.length) {
                IncomingFinancialTransaction secondIFT = (IncomingFinancialTransaction)this.ifts[i2];
                if (!(secondIFT.getMainAccount().trim().equals(firstMainAccount) && secondIFT.getFinDimId1().trim().equals(firstFinDimId1) && secondIFT.getFinDimId2().trim().equals(firstFinDimId2) && secondIFT.getFinDimId3().trim().equals(firstFinDimId3) && secondIFT.getFinDimId4().trim().equals(firstFinDimId4) && secondIFT.getFinDimId5().trim().equals(firstFinDimId5))) {
                    object.addUIObject((UIObject)new Message("ifts_to_allocate_should_have_equal_dimensions", "error"));
                    return object;
                }
                ++i2;
            }
        }
        this.clearScreen(true, false, true);
        return this.allocateEntryInvestmentMultipleTransactions(object, this.ifts);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        object.removeMessages();
        this.ifts = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.ifts.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        BigDecimal totalTransactionAmount = new BigDecimal("0.00");
        int i = 0;
        while (i < this.ifts.length) {
            IncomingFinancialTransaction incomingFinancialTransaction = (IncomingFinancialTransaction)this.ifts[i];
            totalTransactionAmount = totalTransactionAmount.add(incomingFinancialTransaction.getTransactionValue());
            if (!IncomingFinancialTransactionBO.getTransactions(incomingFinancialTransaction).isEmpty()) {
                object.addUIObject((UIObject)new Message("ifts_to_delete_cannot_have_transactions", "error"));
                return object;
            }
            ++i;
        }
        if (totalTransactionAmount.doubleValue() != 0.0) {
            object.addUIObject((UIObject)new Message("total_transaction_amount_must_be_zero", "error"));
            return object;
        }
        if (this.ifts.length > 1) {
            IncomingFinancialTransaction firstIFT = (IncomingFinancialTransaction)this.ifts[0];
            String firstMainAccount = firstIFT.getMainAccount().trim();
            String firstFinDimId1 = firstIFT.getFinDimId1().trim();
            String firstFinDimId2 = firstIFT.getFinDimId2().trim();
            String firstFinDimId3 = firstIFT.getFinDimId3().trim();
            String firstFinDimId4 = firstIFT.getFinDimId4().trim();
            String firstFinDimId5 = firstIFT.getFinDimId5().trim();
            int i2 = 1;
            while (i2 < this.ifts.length) {
                IncomingFinancialTransaction secondIFT = (IncomingFinancialTransaction)this.ifts[i2];
                if (!(secondIFT.getMainAccount().trim().equals(firstMainAccount) && secondIFT.getFinDimId1().trim().equals(firstFinDimId1) && secondIFT.getFinDimId2().trim().equals(firstFinDimId2) && secondIFT.getFinDimId3().trim().equals(firstFinDimId3) && secondIFT.getFinDimId4().trim().equals(firstFinDimId4) && secondIFT.getFinDimId5().trim().equals(firstFinDimId5))) {
                    object.addUIObject((UIObject)new Message("ifts_to_delete_should_have_equal_dimensions", "error"));
                    return object;
                }
                ++i2;
            }
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Label.DeleteIncomingFinancialTransactions", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createExtraInvestmentTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.ifts.length);
        int i = 0;
        while (i < this.ifts.length) {
            list.add(this.ifts[i]);
            ++i;
        }
        CollectionTable table = new CollectionTable(IncomingFinancialTransaction.class, list, 12);
        if (this.table2Active) {
            table.setName(String.valueOf(this.tableName2) + "_TRN");
            table.setColumnNames(this.NAMES0);
            table.setColumnsToDisplay(this.NAMES2);
            table.setColumnLabels(this.shortLabels0);
            table.setColumnSizes(this.SIZES0);
            table.setDisplayTransformers(this.transformers0);
        } else {
            table.setName(String.valueOf(this.tableName1) + "_TRN");
            table.setColumnNames(this.NAMES0);
            table.setColumnsToDisplay(NAMES1);
            table.setColumnLabels(this.shortLabels0);
            table.setColumnSizes(this.SIZES0);
            table.setDisplayTransformers(this.transformers0);
        }
        table.setSortable(true);
        table.reload();
        TableHelper.setHeaderTooltips((CommonTable)table, (String[])TOOLTIPS);
        return table;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.ifts.length);
        int i = 0;
        while (i < this.ifts.length) {
            list.add(this.ifts[i]);
            ++i;
        }
        CollectionTable table = new CollectionTable(IncomingFinancialTransaction.class, list, 12);
        if (this.table2Active) {
            table.setName(String.valueOf(this.tableName2) + "_DLT");
            table.setColumnNames(this.NAMES0);
            table.setColumnsToDisplay(this.NAMES2);
            table.setColumnLabels(this.shortLabels0);
            table.setColumnSizes(this.SIZES0);
            table.setDisplayTransformers(this.transformers0);
        } else {
            table.setName(String.valueOf(this.tableName1) + "_DLT");
            table.setColumnNames(this.NAMES0);
            table.setColumnsToDisplay(NAMES1);
            table.setColumnLabels(this.shortLabels0);
            table.setColumnSizes(this.SIZES0);
            table.setDisplayTransformers(this.transformers0);
        }
        table.setSortable(true);
        table.reload();
        TableHelper.setHeaderTooltips((CommonTable)table, (String[])TOOLTIPS);
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        int i = 0;
        while (i < this.ifts.length) {
            IncomingFinancialTransaction ift = (IncomingFinancialTransaction)this.ifts[i];
            if (ift != null) {
                ift.delete();
            }
            ++i;
        }
        return this.refresh(object);
    }

    private void addErrors(DataObject object, String[] errors) throws Exception {
        int i = 0;
        while (i < errors.length) {
            if (errors[i] != null && errors[i].trim().length() > 0) {
                object.addUIObject((UIObject)new Message(errors[i], "error"));
            }
            ++i;
        }
    }

    private class AllocateToChangeAction
    extends Action {
        private static final long serialVersionUID = -1095206906362369225L;

        AllocateToChangeAction(String page) {
            super(null, null, null, page, IncomingFinancialTransactionAdapter.ALLOCATE);
        }

        public boolean execute(DataObject dataObject) throws Exception {
            return false;
        }
    }

    private class PartialDisInvestmentChangeAction
    extends Action {
        private static final long serialVersionUID = 4787528047589997977L;

        public boolean execute(DataObject dataObject) throws Exception {
            if (IncomingFinancialTransactionAdapter.this.partialDisInvestment.isChecked()) {
                IncomingFinancialTransactionAdapter.this.disInvestmentPartialAmount.setHidden(false);
                IncomingFinancialTransactionAdapter.this.disInvestmentPartialAmount.setMandatory(true);
                return true;
            }
            IncomingFinancialTransactionAdapter.this.disInvestmentPartialAmount.setHidden(true);
            IncomingFinancialTransactionAdapter.this.disInvestmentPartialAmount.setMandatory(false);
            IncomingFinancialTransactionAdapter.this.disInvestmentPartialAmount.setValue();
            return true;
        }
    }
}

