/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.language.TranslationHelperImpl;
import nl.ibs.esp.uiobjects.Image;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.IncomingFinancialTransaction;

public class IncomingFinancialTransactionIdImageTransformer
implements Transformer {
    private static final long serialVersionUID = 1402202215969847330L;
    private Company company;

    public IncomingFinancialTransactionIdImageTransformer(Company company) {
        this.company = company;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object transform(Object object) {
        String id = (String)object;
        String text = "";
        String imageSource = "";
        try {
            IncomingFinancialTransaction ift = (IncomingFinancialTransaction)IncomingFinancialTransactionBO.get(this.company, id)[0];
            if (ift.getConfirmed()) {
                if (ift.getUnAllocatedValue().doubleValue() == 0.0) {
                    return "";
                }
                imageSource = ift.getTransactionValue().doubleValue() == ift.getUnAllocatedValue().doubleValue() ? "shape_square_go.png" : "shape_square_error.png";
                text = String.valueOf(TranslationHelperImpl.getInstance().translate("Label.AssetsRemoved")) + " : " + ift.getUnAllocatedValue();
                return new Image(text, imageSource).setHeight("16").setAlignment("center");
            }
            if (ift.getTransactionValue().doubleValue() == ift.getUnAllocatedValue().doubleValue()) {
                return "";
            }
            imageSource = ift.getUnAllocatedValue().doubleValue() == 0.0 ? "shape_square_go.png" : "shape_square_error.png";
            text = String.valueOf(TranslationHelperImpl.getInstance().translate("Label.AlreadyAllocated")) + " : " + ift.getTransactionValue().subtract(ift.getUnAllocatedValue());
            return new Image(text, imageSource).setHeight("16").setAlignment("center");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Image(text, imageSource).setHeight("16").setAlignment("center");
    }
}

