/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.OutputField;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.MainTransactionTypeEnum;
import nl.ibs.fac.adapters.AssetOriginatedImageTransformer;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.ExtendedTransactionAdapter;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionInfoAdapter;
import nl.ibs.fac.adapters.IncomingFinancialTransactionInfoProcess;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.TransactionTypeTransformer;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.adapters.ZeroIntegerToBlankTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.gov.adapters.BBVCategoryImageTransformer;
import nl.ibs.fac.queries.TransactionQuery;

public class IncomingFinancialTransactionTransactionAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 1314187117307114300L;
    public static final String PAGE = IncomingFinancialTransactionTransactionAdapter.class.getName();
    public static final String TABLENAME = "IFTTAdapter";
    public static final String SHOWINTERNAL = "showInternal";
    private Company company;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();
    private IncomingFinancialTransaction incomingFinancialTransaction;
    private Panel header;
    private Field systemItemNumber;
    private Field internalInvoiceId;
    private Field voucherId;
    private BookYearPeriodGrid iftYearPeriod;
    private Field iftDescription;
    private Field iftTransactionValue;
    private Field unAllocatedValue;
    private ODBTable table = null;
    private static final String[] NAMES = new String[]{"transactionType", "originalIFTAmount", "bookYear", "period", "assetId", "transactionOrAssetDescription", "assetOriginatedByFinancialTransaction", "bookingIndicator", "valueForAmount1", "amount2"};
    private String[] LABELS = new String[]{"Label.TransactionType.short", "Label.Amount", "Label.Year", "Label.Period.short", "Label.Asset", "Label.Description", "Label.NewAsset", "Label.BookingIndicator", "Label.Acquisition", "Label.Depreciation"};
    private static final String[] TOOLTIPS = new String[]{"Label.NewAsset", "Label.BookingIndicator"};
    private static final short[] SIZES = new short[]{120, 100, 50, 30, 80, 175, 20, 20, 100, 100};
    private static final String[] TYPES;
    private static final DecimalTransformer DECIMALTRANSFORMER;
    private static final ZeroIntegerToBlankTransformer BLANKTRANSFORMER;
    private static final ZeroBigDecimalToBlankTransformer BD_BLANKTRANSFORMER;
    private static final Transformer[] TRANSFORMERS;
    private static final boolean[] COLUMNNOWRAPS;
    private Map<String, ComboBox> inputComponents = new HashMap<String, ComboBox>();
    private TransactionTableRowMethod transactionTableRowMethod = new TransactionTableRowMethod();
    private static final String REFRESH = "refresh";
    private FloatBar fbShow1 = new FloatBar();
    private FloatBar fbShow2 = new FloatBar();
    private Action allocate;
    private Action confirm;
    private Action[] rowActions;
    private Action[] headerActions;
    private FloatBar fbDelete = new FloatBar();
    private ArrayList<Object> deleteList;
    private boolean info;

    static {
        String[] stringArray = new String[10];
        stringArray[0] = "text";
        TYPES = stringArray;
        DECIMALTRANSFORMER = new DecimalTransformer();
        BLANKTRANSFORMER = new ZeroIntegerToBlankTransformer();
        BD_BLANKTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
        Transformer[] transformerArray = new Transformer[10];
        transformerArray[0] = new TransactionTypeTransformer();
        transformerArray[1] = DECIMALTRANSFORMER;
        transformerArray[2] = BLANKTRANSFORMER;
        transformerArray[3] = BLANKTRANSFORMER;
        transformerArray[6] = new AssetOriginatedImageTransformer();
        transformerArray[7] = new BBVCategoryImageTransformer();
        transformerArray[8] = BD_BLANKTRANSFORMER;
        transformerArray[9] = BD_BLANKTRANSFORMER;
        TRANSFORMERS = transformerArray;
        COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true, true};
    }

    public IncomingFinancialTransactionTransactionAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.info = this.getProcess() instanceof IncomingFinancialTransactionInfoProcess;
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        Action back = !this.info ? new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionAdapter.PAGE)).setMethod("updateTable") : new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionInfoAdapter.PAGE)).setMethod("updateTable");
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        this.fbShow2.addAction(back);
        this.fbShow2.addAction(refresh);
        Action confirmDelete = null;
        if (!this.info) {
            this.allocate = new Action("Button.Allocate").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionAdapter.PAGE)).setMethod("allocateEntry");
            this.confirm = new Action("Button.Confirm").setAdapter(this.getProcessAdapterPageName(IncomingFinancialTransactionAdapter.PAGE)).setMethod("confirmEntry");
            confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("confirmDelete");
            this.fbShow1.addAction(this.allocate);
            this.fbShow1.addAction(this.confirm);
            this.fbShow2.addAction(confirmDelete);
        }
        this.fbShow2.addAction(this.finish);
        this.headerActions = new Action[]{refresh, this.allocate, this.confirm};
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(ExtendedTransactionAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{details, confirmDelete};
        ComboBox mtt = EnumHelper.createComboBox("Label.MainTransactionType", MainTransactionTypeEnum.getCollection(), true);
        mtt.setWidth("150");
        this.inputComponents.put("mainTransactionType", mtt);
        this.fbDelete.addAction(new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("delete"));
        this.fbDelete.addAction(new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SHOWINTERNAL));
        this.fbDelete.addAction(this.finish);
        this.header = new HeaderPanel();
        this.systemItemNumber = new Field("Label.SystemItemNbr");
        this.systemItemNumber.setLength(15);
        this.systemItemNumber.setReadonly(true);
        this.header.addUIObject((UIObject)this.systemItemNumber);
        this.internalInvoiceId = new Field("Label.InvoiceNbr", "text", null, "", 15);
        this.internalInvoiceId.setReadonly(true);
        this.header.addUIObject((UIObject)this.internalInvoiceId);
        this.voucherId = new Field("Label.VoucherId", "text", null, "", 15);
        this.voucherId.setReadonly(true);
        this.header.addUIObject((UIObject)this.voucherId);
        this.iftDescription = new Field("Label.Description", "text", null, "", 50);
        this.iftDescription.setReadonly(true);
        this.header.addUIObject((UIObject)this.iftDescription);
        this.iftYearPeriod = new BookYearPeriodGrid("Label.GLPeriod", true);
        this.header.addUIObject((UIObject)this.iftYearPeriod);
        this.iftTransactionValue = new Field("Label.TransactionValue", "decimal", null, "", 15);
        this.iftTransactionValue.setReadonly(true);
        this.header.addUIObject((UIObject)this.iftTransactionValue);
        this.unAllocatedValue = new Field("Label.StillAllocatable.short", "decimal", null, "", 15);
        this.unAllocatedValue.setReadonly(true);
        if (!this.info) {
            this.header.addUIObject((UIObject)this.unAllocatedValue);
        }
    }

    public DataObject show(DataObject object) throws Exception {
        this.incomingFinancialTransaction = (IncomingFinancialTransaction)this.getProcess().getAttribute("IncomingFinancialTransaction");
        if (this.incomingFinancialTransaction == null) {
            this.incomingFinancialTransaction = (IncomingFinancialTransaction)TableHelper.getSelectedItem((DataObject)object);
            this.getProcess().setAttribute("IncomingFinancialTransaction", (Object)this.incomingFinancialTransaction);
        }
        return this.refresh(object);
    }

    public DataObject showInternal(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        if (this.info) {
            object.addUIObject((UIObject)new Header("Title.InquiryIFT_Transactions", "screen_name"));
        } else {
            object.addUIObject((UIObject)new Header("Title.AllocateIFT_Transactions", "screen_name"));
        }
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.fbShow1);
        if (this.table == null) {
            this.createTable();
        } else if (this.table.isSelectable()) {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow2);
        return object;
    }

    private void createTable() throws Exception {
        if (this.governmentActivated) {
            if (this.incomingFinancialTransaction.getIFTType() == 3) {
                this.LABELS[8] = "Label.Loan";
                this.LABELS[9] = "Label.PayOff";
            } else {
                this.LABELS[8] = "Label.Acquisition";
                this.LABELS[9] = "Label.Depreciation";
            }
        }
        TransactionQuery query = new TransactionQuery(this.dbData, this.incomingFinancialTransaction);
        this.table = new ODBTable(Transaction.class, (ODBQuery)query, new String[]{"documentNr"}, 12);
        this.table.setName(TABLENAME);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(this.LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setColumnTypes(TYPES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setInputComponents(this.inputComponents);
        this.table.setSortable(true);
        if (!this.info) {
            this.table.setMultipleSelectable();
        }
        TableHelper.createMenu((CommonTable)this.table, (Action[])this.headerActions, (Action[])this.rowActions, (TableRowMethod)this.transactionTableRowMethod);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }

    public DataObject refresh(DataObject object) throws Exception {
        String sSystemItemNumber = this.incomingFinancialTransaction.getSystemItemSequencenumber() != 0 ? this.incomingFinancialTransaction.getSystemItemNumber() + "/" + this.incomingFinancialTransaction.getSystemItemSequencenumber() : "" + this.incomingFinancialTransaction.getSystemItemNumber();
        this.systemItemNumber.setValue(sSystemItemNumber);
        if (this.incomingFinancialTransaction.getInternalInvoiceId() != 0L) {
            this.internalInvoiceId.setValue("" + this.incomingFinancialTransaction.getInternalInvoiceId());
            this.internalInvoiceId.setHidden(false);
        } else {
            this.internalInvoiceId.setHidden(true);
        }
        if (this.incomingFinancialTransaction.getVoucherId().trim().length() != 0) {
            if (this.env.getOperationArea().trim().length() == 0) {
                this.voucherId.setValue((String)this.numericIdTransformer.transform(this.incomingFinancialTransaction.getVoucherId()));
            } else {
                this.voucherId.setValue(this.incomingFinancialTransaction.getVoucherId());
            }
        } else {
            this.voucherId.setHidden(true);
        }
        this.iftYearPeriod.setValues("" + this.incomingFinancialTransaction.getBookYear(), "" + this.incomingFinancialTransaction.getPeriod());
        this.iftDescription.setValue(this.incomingFinancialTransaction.getDescription());
        this.iftTransactionValue.setValue((String)DECIMALTRANSFORMER.transform(this.incomingFinancialTransaction.getTransactionValue()));
        this.unAllocatedValue.setValue((String)DECIMALTRANSFORMER.transform(this.incomingFinancialTransaction.getUnAllocatedValue()));
        if (!this.info) {
            if (this.incomingFinancialTransaction.getUnAllocatedValue().doubleValue() != 0.0) {
                this.allocate.setDefault(true);
                this.allocate.setEnabled(true);
                this.confirm.setDefault(false);
                this.confirm.setEnabled(false);
            } else {
                this.allocate.setDefault(false);
                this.allocate.setEnabled(false);
                this.confirm.setDefault(true);
                this.confirm.setEnabled(true);
            }
        }
        this.table = null;
        return this.showInternal(object);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteTransactions", "screen_name"));
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.createConfirmationTable(object));
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable(DataObject object) throws Exception {
        Object[] transactions = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.deleteList = new ArrayList(transactions.length);
        int i = 0;
        while (i < transactions.length) {
            this.deleteList.add(transactions[i]);
            ++i;
        }
        CollectionTable table = new CollectionTable(Transaction.class, this.deleteList, 12);
        table.setName(PAGE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(this.LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setColumnTypes(TYPES);
        table.setDisplayTransformers(TRANSFORMERS);
        table.setSortable(true);
        table.reload();
        TableHelper.setHeaderTooltips((CommonTable)table, (String[])TOOLTIPS);
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        Object[] transactions = this.deleteList.toArray();
        int i = 0;
        while (i < transactions.length) {
            Transaction transaction = (Transaction)transactions[i];
            message = TransactionBO.delete(transaction, this.incomingFinancialTransaction, null);
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
            }
            ++i;
        }
        if (message != null) {
            return object;
        }
        return this.refresh(object);
    }

    private class TransactionTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = 8351780433747830979L;

        private TransactionTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Transaction transaction = (Transaction)row.getObject();
            if (AssetBO.isIdNumeric(IncomingFinancialTransactionTransactionAdapter.this.company, "C".equals(transaction.getCora()))) {
                OutputField field = (OutputField)row.getUIOBjectByName(OutputField.class, "assetId");
                field.setValue((String)IncomingFinancialTransactionTransactionAdapter.this.numericIdTransformer.transform(transaction.getAssetId()));
                field.setType("number");
            }
            ContextMenu menu = new ContextMenu();
            int i = 0;
            while (i < rowActions.length) {
                if (rowActions[i] != null) {
                    ContextAction rowAction = new ContextAction(rowActions[i].getName());
                    rowAction.setAdapter(rowActions[i].getPageid());
                    rowAction.setMethod(rowActions[i].getMethod());
                    menu.addContextMenuItem(rowAction);
                }
                ++i;
            }
            row.setContextMenu(menu);
        }
    }
}

