/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.PeriodEnum;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.InterestTableDetailAdapter;
import nl.ibs.fac.adapters.InterestTableReportAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.InterestTableBO;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.queries.InterestTableQuery;

public class InterestTableAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 3325091191701275443L;
    public static final String PAGE = InterestTableAdapter.class.getName();
    public static final String REFRESH = "refresh";
    private static final String CREATEFORM = "createForm";
    private static final String CREATE = "create";
    private static final String EDITFORM = "editForm";
    private static final String EDIT = "edit";
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    private static final String PERCENTAGES = "showPercentages";
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"id", "description", "numberOfPeriods"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description", "Label.NumberOfPeriods"};
    private static final short[] SIZES = new short[]{80, 419, 120};
    protected Action[] rowActions;
    protected Action[] headerActions;
    private Panel header = new HeaderPanel();
    private Panel group = new Panel();
    private Field id = new Field("Label.Id", "upper");
    private Field desc = new Field("Label.Description");
    private ComboBox numberOfPeriods;
    private BookYearPeriodGrid firstYearPeriod;
    private FACDecimalField firstPercentage = new FACDecimalField("Label.Percentage", 6, 3);
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbCreate = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private InterestTable interestTable;
    private Object[] interestTables;

    public InterestTableAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.env == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Action percentages = new Action("Label.Percentages").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(PERCENTAGES);
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEFORM);
        Action report = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("report");
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDITFORM);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.rowActions = new Action[]{percentages, edit, confirmDelete, report};
        Action reportAll = new Action("Button.Report").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("reportAll");
        this.headerActions = new Action[]{refresh, create, reportAll};
        this.header.setWidth(622);
        this.group.setForceBorder(true);
        this.id.setMandatory(true);
        this.id.setLength(10);
        this.id.setMaxLength(10);
        this.id.setHelpId("Label.InterestTableId");
        this.header.addUIObject((UIObject)this.id);
        this.desc.setLength(50);
        this.desc.setMaxLength(50);
        this.group.addUIObject((UIObject)this.desc);
        this.numberOfPeriods = EnumHelper.createComboBox("Label.NumberOfPeriods", PeriodEnum.getCollection(), false);
        this.numberOfPeriods.setMandatory(true);
        this.numberOfPeriods.setWidth("120");
        this.group.addUIObject((UIObject)this.numberOfPeriods);
        this.firstYearPeriod = new BookYearPeriodGrid("Label.StartPeriod", "", "2000", "2999", 13);
        this.group.addUIObject((UIObject)this.firstYearPeriod);
        this.firstPercentage.setMinValue(new BigDecimal("0.000"), true);
        this.firstPercentage.setMaxValue(new BigDecimal("99.999"), true);
        this.group.addUIObject((UIObject)this.firstPercentage);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(this.finish);
        Action createOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE);
        createOK.setValidationEnabled(true);
        createOK.setDefault(true);
        this.fbCreate.addAction(createOK);
        this.fbCreate.addAction(this.cancel);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        editOK.setValidationEnabled(true);
        editOK.setDefault(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.env == null) {
            object.addUIObject((UIObject)new Message("NoActiveEnvironment", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.InterestTables", "screen_name"));
        this.id.setValue();
        this.desc.setValue();
        if (this.table == null) {
            this.createTable();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        InterestTableQuery query = new InterestTableQuery(this.dbData);
        this.table = new ODBTable(InterestTable.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setSelectable(false);
        this.table.setSortable(true);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        this.searchPanel.setCSSClass("headerpanel");
        Action filterAction = this.table.createFilterAction(NAMES, LABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateInterestTable", "screen_name"));
        this.id.setReadonly(false);
        object.addUIObject((UIObject)this.header);
        this.numberOfPeriods.setReadonly(false);
        this.firstYearPeriod.removeInvalidTags();
        this.firstYearPeriod.requestFocus(true);
        this.firstYearPeriod.setHidden(false);
        this.firstYearPeriod.setMandatory(true);
        this.firstYearPeriod.setValues("", "");
        this.firstPercentage.setHidden(false);
        this.firstPercentage.setMandatory(true);
        this.firstPercentage.setValue();
        object.addUIObject((UIObject)this.group);
        object.addUIObject((UIObject)this.fbCreate);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        int periods = Integer.parseInt(this.numberOfPeriods.getValue());
        int year = this.firstYearPeriod.getBookYear().getIntValue();
        int period = this.firstYearPeriod.getPeriod().getIntValue();
        if (period > periods) {
            this.firstYearPeriod.setInvalidTag();
            object.addUIObject((UIObject)new Message("period_cannot_be_greater_than_tablePeriod", "error"));
            return object;
        }
        Object[] result = InterestTableBO.create(this.dbData, this.id.getValue().trim(), this.desc.getValue().trim(), periods, year, period, this.firstPercentage.getBigDecimal());
        String message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.createForm(object);
        }
        return this.refresh(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditInterestTable", "screen_name"));
        this.interestTables = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.interestTables.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        if (this.interestTables.length > 1) {
            object.addUIObject((UIObject)new Message("OnlyOneSelectionAllowed", "error"));
            return object;
        }
        this.interestTable = (InterestTable)this.interestTables[0];
        this.id.setValue(this.interestTable.getId().trim());
        this.id.setReadonly(true);
        object.addUIObject((UIObject)this.header);
        this.desc.setValue(this.interestTable.getDescription().trim());
        this.numberOfPeriods.setValueAsString("" + this.interestTable.getNumberOfPeriods());
        this.numberOfPeriods.setReadonly(true);
        this.firstYearPeriod.removeInvalidTags();
        this.firstYearPeriod.setHidden(true);
        this.firstYearPeriod.setMandatory(false);
        this.firstPercentage.setHidden(true);
        this.firstPercentage.setMandatory(false);
        object.addUIObject((UIObject)this.group);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = InterestTableBO.update(this.interestTable, this.desc.getValue().trim(), Integer.parseInt(this.numberOfPeriods.getValue()));
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.id.getValue().trim(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.interestTables = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteInterestTables", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.interestTables.length);
        int i = 0;
        while (i < this.interestTables.length) {
            list.add(this.interestTables[i]);
            ++i;
        }
        CollectionTable table = new CollectionTable(InterestTable.class, list, 12);
        table.setName(PAGE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        int i = 0;
        while (i < this.interestTables.length) {
            InterestTable interestTable = (InterestTable)this.interestTables[i];
            if (interestTable != null && (message = InterestTableBO.delete(interestTable)) != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
            }
            ++i;
        }
        if (message != null) {
            return object;
        }
        this.table = null;
        return this.show(object);
    }

    public DataObject report(DataObject object) throws Exception {
        this.interestTables = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.interestTables.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        int i = 0;
        while (i < this.interestTables.length) {
            this.interestTable = (InterestTable)this.interestTables[i];
            String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"facLib", this.dbData.getSchema()}, {"Environment", this.env.getId()}, {"orderBy", "id"}, {"FromInterestTable", this.interestTable.getId()}, {"ToInterestTable", this.interestTable.getId()}};
            this.getProcess().setAttribute("selections", (Object)selections);
            this.getProcess().setAttribute("classNamePDF", (Object)InterestTableReportAdapter.CLASSNAMEPDF);
            this.getProcess().setAttribute("jobName", (Object)"Job.InterestTable");
            this.getProcess().setAttribute("returnPage", (Object)PAGE);
            object = ((SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE)).submit(object);
            ++i;
        }
        return object;
    }

    public DataObject reportAll(DataObject object) throws Exception {
        this.getProcess().setAttribute("returnPage", (Object)PAGE);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(InterestTableReportAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject showPercentages(DataObject object) throws Exception {
        this.interestTable = (InterestTable)TableHelper.getSelectedItem((DataObject)object);
        this.getProcess().setAttribute("interesttable", (Object)this.interestTable);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(InterestTableDetailAdapter.PAGE), REFRESH, this.getProcess().getProcessId()));
        return object;
    }
}

