/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.InterestTableAdapter;
import nl.ibs.fac.boadapters.InterestBookYearBO;
import nl.ibs.fac.boadapters.InterestPeriodBO;
import nl.ibs.fac.db.InterestPeriod;
import nl.ibs.fac.db.InterestTable;

public class InterestTableDetailAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -324840812617548431L;
    public static final String INTERESTTABLE = "interesttable";
    public static final String ADDWIZARD = "addwizard";
    public static final String PAGE = InterestTableDetailAdapter.class.getName();
    public static final String TITLE = "Title.InterestBookyears";
    private static final String REFRESH = "refresh";
    public static final String START_ACTION = "refresh";
    public static final String SHOW = "show";
    private static final String CREATEFORM = "createForm";
    private static final String CREATE = "create";
    private static final String EDITFORM = "editForm";
    private static final String EDIT = "edit";
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    private CollectionTable table = null;
    private InterestPeriod periodPercentage;
    private static final String[] NAMES = new String[]{"bookYear", "period", "percentage"};
    private static final String[] LABELS = new String[]{"Label.Year", "Label.Period.short", "Label.Percentage"};
    private static final short[] SIZES = new short[]{50, 30, 100};
    private static final Transformer[] TRANSFORMERS;
    protected Action[] rowActions;
    protected Action[] headerActions;
    private Panel header = new HeaderPanel();
    private ReferenceField refInterestTable = new ReferenceField("Label.InterestTable");
    private Field numOfPer = new Field("Label.NumberOfPeriods", "number");
    private Panel group = new Panel();
    private BookYearPeriodGrid theYearPeriod;
    private FACDecimalField thePercentage = new FACDecimalField("Label.Percentage", 6, 3);
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbCreate = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private InterestTable interestTable;
    private Window window;

    static {
        Transformer[] transformerArray = new Transformer[4];
        transformerArray[2] = new DecimalTransformer(3);
        transformerArray[3] = new DecimalTransformer(3);
        TRANSFORMERS = transformerArray;
    }

    public InterestTableDetailAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.env == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Action previous = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(InterestTableAdapter.PAGE)).setMethod("refresh");
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh");
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEFORM);
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDITFORM);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.rowActions = new Action[]{edit, confirmDelete};
        this.headerActions = new Action[]{refresh, create};
        this.fbShow.addAction(previous);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        Action createOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE);
        createOK.setDefault(true);
        createOK.setValidationEnabled(true);
        this.fbCreate.addAction(createOK);
        this.fbCreate.addAction(this.cancel);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        editOK.setDefault(true);
        editOK.setValidationEnabled(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.refInterestTable.setReadonly(true);
        this.refInterestTable.setLength(10);
        this.refInterestTable.setDescriptionLength(50);
        this.group.addUIObject((UIObject)this.refInterestTable);
        this.header.addUIObject((UIObject)this.refInterestTable);
        this.numOfPer.setReadonly(true);
        this.numOfPer.setLength(2);
        this.group.addUIObject((UIObject)this.numOfPer);
        this.header.addUIObject((UIObject)this.numOfPer);
        this.theYearPeriod = new BookYearPeriodGrid("Label.StartPeriod", "", "2000", "2999", 13);
        this.group.addUIObject((UIObject)this.theYearPeriod);
        this.thePercentage.setMinValue(new BigDecimal("0.000"), true);
        this.thePercentage.setMaxValue(new BigDecimal("99.999"), true);
        this.group.addUIObject((UIObject)this.thePercentage);
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        object.addUIObject((UIObject)this.header);
        if (this.table == null) {
            this.createTable();
        }
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        this.table = new CollectionTable(InterestPeriod.class, InterestPeriodBO.getPercentages(this.dbData, this.interestTable.getId()), 12);
        this.table.setName(PAGE);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.interestTable = (InterestTable)this.getProcess().getAttribute(INTERESTTABLE);
        this.refInterestTable.setValue(this.interestTable.getId());
        this.refInterestTable.setDescription(this.interestTable.getDescription());
        this.numOfPer.setValue("" + this.interestTable.getNumberOfPeriods());
        this.table = null;
        return this.show(object);
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.window = new Window();
        this.window.setLabel("Label.AddPercentage");
        this.theYearPeriod.removeInvalidTags();
        this.theYearPeriod.requestFocus(true);
        this.theYearPeriod.setValues("", "");
        this.theYearPeriod.setReadonly(false);
        this.theYearPeriod.setMandatory(true);
        this.thePercentage.setValue();
        this.thePercentage.setReadonly(false);
        this.thePercentage.setMandatory(true);
        this.window.add(this.group);
        this.window.add(this.fbCreate);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        String id = this.interestTable.getId();
        int year = this.theYearPeriod.getBookYear().getIntValue();
        int period = this.theYearPeriod.getPeriod().getIntValue();
        if (period > Integer.parseInt(this.numOfPer.getValue())) {
            this.window.add(new Message("period_cannot_be_greater_than_tablePeriod", "error"));
            return object;
        }
        BigDecimal percentage = this.thePercentage.getBigDecimal();
        if (!InterestBookYearBO.checkExistence(this.interestTable, year)) {
            InterestBookYearBO.create(this.dbData, id, year);
            InterestPeriodBO.create(this.dbData, id, year, period, percentage);
        } else if (!InterestPeriodBO.checkExistence(this.interestTable, year, period)) {
            InterestPeriodBO.create(this.dbData, id, year, period, percentage);
        } else {
            this.theYearPeriod.setInvalidTag();
            this.window.add(new Message("periodPercentage_already_exists", "error"));
            return object;
        }
        this.table = null;
        return this.show(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.periodPercentage = (InterestPeriod)TableHelper.getSelectedItem((DataObject)object);
        this.window = new Window();
        this.window.setLabel("Label.EditPercentage");
        this.theYearPeriod.removeInvalidTags();
        this.theYearPeriod.requestFocus(true);
        this.theYearPeriod.setValues("" + this.periodPercentage.getBookYear(), "" + this.periodPercentage.getPeriod());
        this.theYearPeriod.setReadonly(true);
        this.theYearPeriod.setMandatory(false);
        this.thePercentage.setValue(this.periodPercentage.getPercentage());
        this.thePercentage.setReadonly(false);
        this.thePercentage.setMandatory(true);
        this.window.add(this.group);
        this.window.add(this.fbEdit);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        this.periodPercentage.setPercentage(this.thePercentage.getBigDecimal());
        this.table = null;
        return this.show(object);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.periodPercentage = (InterestPeriod)TableHelper.getSelectedItem((DataObject)object);
        this.window = new Window();
        this.window.setLabel("Label.DeletePercentage");
        this.theYearPeriod.removeInvalidTags();
        this.theYearPeriod.requestFocus(true);
        this.theYearPeriod.setValues("" + this.periodPercentage.getBookYear(), "" + this.periodPercentage.getPeriod());
        this.theYearPeriod.setReadonly(true);
        this.theYearPeriod.setMandatory(false);
        this.thePercentage.setValue(this.periodPercentage.getPercentage());
        this.thePercentage.setReadonly(true);
        this.thePercentage.setMandatory(false);
        this.window.add(this.group);
        this.window.add(this.fbDelete);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject delete(DataObject object) throws Exception {
        InterestPeriodBO.delete(this.periodPercentage);
        this.table = null;
        return this.show(object);
    }
}

