/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import com.ibm.as400.access.AS400;
import java.util.Collection;
import java.util.Vector;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.ComparisonValue;
import nl.ibs.fac.adapters.AssetStateImageTransformer;
import nl.ibs.fac.adapters.AssetTransactionAdapter;
import nl.ibs.fac.adapters.ComparisonDifferenceImageTransformer;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.ComparisonBP;
import nl.ibs.fac.db.Company;

public class InternalComparisonAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 1377415662613175700L;
    public static final String PAGE = InternalComparisonAdapter.class.getName();
    private Company company;
    private ComparisonBP businessProcess;
    private Vector comparisonValues;
    private FloatBar fb1;
    private TabbedPanel tabbedPanel;
    private Action[] rowActions;
    private boolean[] internalDifferences = new boolean[3];
    private boolean internalDifference;
    private static final DecimalTransformer DECIMALTRANSFORMER = new DecimalTransformer();
    private static final ComparisonDifferenceImageTransformer DIFFERENCETRANSFORMER = new ComparisonDifferenceImageTransformer();
    private static final AssetStateImageTransformer ASSETSTATETRANSFORMER = new AssetStateImageTransformer();
    private CollectionTable mainTable = null;
    private static final String[] NAMES = new String[]{"acquisitionAccountDescription", "gLAcquisitionTotal", "fACAcquisitionTotal", "acquisitionTotalDifference", "gLDepreciationTotal", "fACDepreciationTotal", "depreciationTotalDifference"};
    private static final String[] LABELS = new String[]{"Label.AccountingPrinciple", "Label.Assets", "Label.Transactions", "Label.AcquisitionTotalDifference", "Label.Assets", "Label.Transactions", "Label.DepreciationTotalDifference"};
    private static final String[] TOOLTIPS = new String[]{"Label.AcquisitionTotalDifference", "Label.DepreciationTotalDifference"};
    private static final short[] SIZES = new short[]{144, 120, 120, 20, 120, 120, 20};
    private Transformer[] transformers;
    private CollectionTable subTable;
    private static final String[] SUB_NAMES = new String[]{"acquisitionAccount", "assetState", "gLAcquisitionTotal", "fACAcquisitionTotal", "acquisitionTotalDifference", "gLDepreciationTotal", "fACDepreciationTotal", "depreciationTotalDifference"};
    private static final String[] SUB_LABELS = new String[]{"Label.AssetId", "Label.State", "Label.Asset", "Label.Transactions", "Label.AcquisitionTotalDifference", "Label.Asset", "Label.Transactions", "Label.DepreciationTotalDifference"};
    private static final String[] SUB_TOOLTIPS = new String[]{"Label.State", "Label.AcquisitionTotalDifference", "Label.DepreciationTotalDifference"};
    private static final short[] SUB_SIZES = new short[]{100, 20, 120, 120, 20, 120, 120, 20};
    private Transformer[] sub_transformers;

    public InternalComparisonAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        Transformer[] transformerArray = new Transformer[7];
        transformerArray[1] = DECIMALTRANSFORMER;
        transformerArray[2] = DECIMALTRANSFORMER;
        transformerArray[3] = DIFFERENCETRANSFORMER;
        transformerArray[4] = DECIMALTRANSFORMER;
        transformerArray[5] = DECIMALTRANSFORMER;
        transformerArray[6] = DIFFERENCETRANSFORMER;
        this.transformers = transformerArray;
        this.subTable = null;
        Transformer[] transformerArray2 = new Transformer[8];
        transformerArray2[1] = ASSETSTATETRANSFORMER;
        transformerArray2[2] = DECIMALTRANSFORMER;
        transformerArray2[3] = DECIMALTRANSFORMER;
        transformerArray2[4] = DIFFERENCETRANSFORMER;
        transformerArray2[5] = DECIMALTRANSFORMER;
        transformerArray2[6] = DECIMALTRANSFORMER;
        transformerArray2[7] = DIFFERENCETRANSFORMER;
        this.sub_transformers = transformerArray2;
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.businessProcess = new ComparisonBP(this.dbData, (AS400)this.loginHelper.getAs400(), this.env, this.company, this.numberOfPeriods, false);
        this.fb1 = new FloatBar();
        this.fb1.addAction(this.finish);
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(AssetTransactionAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{details};
        this.getProcess().setAttribute("AssetTransactionAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("AssetTransactionAdapterReturnMethod", (Object)"internalShow");
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.comparisonValues = this.businessProcess.retrieveInternalCompanyComparisonValues();
        this.createMainTable();
        for (ComparisonValue comparisonValue : this.comparisonValues) {
            if (comparisonValue.getAcquisitionTotalDifference().doubleValue() == 0.0 && comparisonValue.getDepreciationTotalDifference().doubleValue() == 0.0) continue;
            this.internalDifferences[comparisonValue.getAccountingPrinciple()] = true;
            this.internalDifference = true;
        }
        if (this.internalDifference) {
            this.tabbedPanel = new TabbedPanel();
            Vector[] vectorArray = this.businessProcess.retrieveInternalAssetComparisonValues();
            if (this.internalDifferences[1]) {
                Tab tab1 = new Tab(this.env.getAPShortName1());
                this.comparisonValues = vectorArray[0];
                this.createSubTable();
                tab1.add((Table)this.subTable);
                this.tabbedPanel.add(tab1);
            }
            if (this.internalDifferences[2]) {
                Tab tab2 = new Tab(this.env.getAPShortName2());
                this.comparisonValues = vectorArray[1];
                this.createSubTable();
                tab2.add((Table)this.subTable);
                this.tabbedPanel.add(tab2);
            }
        }
        return this.internalShow(object);
    }

    public DataObject internalShow(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.InternalComparison", "screen_name"));
        object.addUIObject((UIObject)this.mainTable);
        if (this.internalDifference) {
            object.addUIObject((UIObject)new Header("Label.Deviations", "sub_screen_name"));
            object.addUIObject((UIObject)this.tabbedPanel);
        }
        object.addUIObject((UIObject)this.fb1);
        return object;
    }

    private void createMainTable() throws Exception {
        this.mainTable = new CollectionTable(ComparisonValue.class, (Collection)this.comparisonValues, this.numberOfPeriods);
        this.mainTable.setName(String.valueOf(PAGE) + "_MAIN");
        this.mainTable.setColumnNames(NAMES);
        this.mainTable.setColumnLabels(LABELS);
        this.mainTable.setColumnSizes(SIZES);
        this.mainTable.setDisplayTransformers(this.transformers);
        this.mainTable.setSortable(false);
        this.mainTable.setSelectable(false);
        this.mainTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.mainTable, (String[])TOOLTIPS);
    }

    private void createSubTable() throws Exception {
        this.subTable = new CollectionTable(ComparisonValue.class, (Collection)this.comparisonValues, this.numberOfPeriods);
        this.subTable.setName(String.valueOf(PAGE) + "_SUB");
        this.subTable.setColumnNames(SUB_NAMES);
        this.subTable.setColumnLabels(SUB_LABELS);
        this.subTable.setColumnSizes(SUB_SIZES);
        this.subTable.setDisplayTransformers(this.sub_transformers);
        this.subTable.setSortable(false);
        this.subTable.setSelectable(false);
        TableHelper.createMenu((CommonTable)this.subTable, null, (Action[])this.rowActions, null);
        this.subTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.subTable, (String[])SUB_TOOLTIPS);
    }
}

