/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.List;
import nl.ibs.esp.adapter.AbstractLoginAdapter;
import nl.ibs.esp.adapter.Adapter;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.dataobject.HttpDataObject;
import nl.ibs.esp.servlet.ESPSessionContext;
import nl.ibs.esp.servlet.ESPUserContext;
import nl.ibs.esp.session.ActiveUsers;
import nl.ibs.esp.session.SessionInfo;
import nl.ibs.esp.uiobjects.LoginPanel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.FacConstants;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.UserBO;
import nl.ibs.fac.db.BookYearManager;
import nl.ibs.fac.db.BookYearManagerFactory;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.User;
import nl.ibs.fac.language.UserContext;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.fac.ui.ApplicationIdentifierHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.UserSettings;
import nl.ibs.vegas.SettingsStore;

public class LoginAdapter
extends AbstractLoginAdapter {
    private static final long serialVersionUID = 6000071577883529747L;
    public static final String NEW_LOGIN = "newLogin";

    public LoginAdapter(DataObject object) throws Exception {
        super(object);
        UserContext.setLocale(ESPUserContext.getLocale());
        object.setApplicationIdentifyingString("");
        this.showTaskBar(false);
    }

    public DataObject main(DataObject object) throws Exception {
        StartStopServlet.setContextName(((HttpDataObject)this.dataObject).getRequest());
        if (!StartStopServlet.settingsValid(false)) {
            this.logonCompleted();
            return object;
        }
        if (!StartStopServlet.isValidObjectLibrary()) {
            this.getLoginPanel().setMessage("wrong_version_of_objectLibrary");
        }
        this.removeSessionAttributes(object);
        return super.main(object);
    }

    public void removeSessionAttributes(DataObject object) throws Exception {
        object.removeSessionAttribute(LoginHelper.LOGINHELPER);
        object.removeSessionAttribute("Administrator");
        object.removeSessionAttribute("AdministratorMenu");
        object.removeSessionAttribute("userGroupId");
        object.removeSessionAttribute("selectCompany");
        object.removeSessionAttribute("ActiveEnvironment");
        object.removeSessionAttribute("ActiveDBData");
        object.removeSessionAttribute("ActiveCompany");
        object.removeSessionAttribute("ActiveBookYear");
        object.removeSessionAttribute("MinBookYear");
        object.removeSessionAttribute("MaxBookYear");
        object.removeSessionAttribute("NumberOfPeriods");
        object.removeSessionAttribute("ActiveDataSet");
        object.removeSessionAttribute("GOV");
    }

    protected boolean isValidUser(String user) throws Exception {
        FacConstants.setClassPath(((HttpDataObject)this.dataObject).getRequest());
        String sessionId = ((HttpDataObject)this.dataObject).getRequest().getSession().getId();
        LoginHelper loginHelper = new LoginHelper(sessionId, StartStopServlet.getSystem(), user, this.getPasswordField().getValue().trim(), StartStopServlet.getLibrary());
        this.dataObject.setSessionAttribute(LoginHelper.LOGINHELPER, (Object)loginHelper);
        String message = loginHelper.login();
        if (message != null) {
            this.getLoginPanel().setMessage(message);
            return false;
        }
        message = loginHelper.checkIFS();
        if (message != null) {
            loginHelper.logout();
            this.getLoginPanel().setMessage(message);
            return false;
        }
        String description = "";
        User tmpUser = null;
        if ("FACSYSBEH".equals(user) || "APPSYSBEH".equals(user)) {
            description = loginHelper.getUserDescription();
        } else {
            tmpUser = (User)UserBO.get(user)[0];
            if (tmpUser == null) {
                loginHelper.logout();
                message = "no_menu_options";
                this.getLoginPanel().setMessage(message);
                return false;
            }
        }
        if (tmpUser != null) {
            description = tmpUser.getDescription();
            if (tmpUser.getAdmin()) {
                this.dataObject.setSessionAttribute("Administrator", (Object)"");
            }
            this.dataObject.setSessionAttribute("userGroupId", (Object)tmpUser.getUserGroupId());
            this.dataObject.setSessionAttribute("selectCompany", (Object)Boolean.toString(true));
            Environment env = (Environment)EnvironmentBO.get(tmpUser.getFacLib())[0];
            if (env == null) {
                ESPSessionContext.setSettingStore((SettingsStore)new UserSettings("fac", user, ""));
            } else {
                Object[] result;
                ESPSessionContext.setSettingStore((SettingsStore)new UserSettings("fac", user, env.getFacLib()));
                String companyId = null;
                String bookYear = null;
                DBData dbData = EnvironmentBO.getDBData(env.getFacLib());
                Company company = (Company)CompanyBO.get(dbData, tmpUser.getCompanyId())[0];
                if (company == null) {
                    message = loginHelper.login(env, companyId, bookYear);
                    if (message == null || message.trim().length() == 0) {
                        this.dataObject.setSessionAttribute("ActiveEnvironment", (Object)env);
                        this.dataObject.setSessionAttribute("ActiveDBData", (Object)dbData);
                    }
                } else {
                    companyId = company.getId();
                    message = loginHelper.login(env, companyId, bookYear = "" + company.getCurrentBookYear());
                    if (message == null || message.trim().length() == 0) {
                        this.dataObject.setSessionAttribute("selectCompany", (Object)("" + tmpUser.getSelectCompany()));
                        this.dataObject.setSessionAttribute("ActiveEnvironment", (Object)env);
                        this.dataObject.setSessionAttribute("ActiveDBData", (Object)dbData);
                        this.dataObject.setSessionAttribute("ActiveCompany", (Object)companyId);
                        BookYearManager manager = BookYearManagerFactory.getInstance(dbData);
                        this.dataObject.setSessionAttribute("MaxBookYear", (Object)("" + (manager.getMax(companyId) + 1)));
                        this.dataObject.setSessionAttribute("MinBookYear", (Object)("" + company.getInitialBookYear()));
                        this.dataObject.setSessionAttribute("ActiveBookYear", (Object)bookYear);
                        this.dataObject.setSessionAttribute("NumberOfPeriods", (Object)("" + company.retrieveNumberOfPeriods()));
                        if (company.getDataSet() != null) {
                            this.dataObject.setSessionAttribute("ActiveDataSet", (Object)company.getDataSetId());
                        }
                        ESPSessionContext.setSettingStore((SettingsStore)new UserSettings("fac", user, String.valueOf(env.getFacLib()) + " " + companyId));
                    }
                }
                if ((message = (String)(result = EnvironmentBO.checkActivated(loginHelper, env.getOperationArea(), false))[0]) != null) {
                    if (result[1] == null) {
                        loginHelper.logout(env, companyId, bookYear);
                        this.getLoginPanel().setMessage(message);
                        return false;
                    }
                    this.dataObject.setSessionAttribute("MESSAGE", (Object)message);
                }
                int maxUsers = Integer.parseInt((String)result[2]);
                List sessions = ActiveUsers.getSessions((DataObject)this.dataObject);
                if (Log.debug()) {
                    for (SessionInfo sessionInfo : sessions) {
                        if (!sessionInfo.getUserId().equals(user)) continue;
                        Log.debug((String)("user_already_logged_in: " + user));
                    }
                }
                if (maxUsers != 0 && sessions.size() > maxUsers - 1) {
                    message = String.valueOf(this.translate("max_users_exceeded")) + ": " + maxUsers;
                    loginHelper.logout(env, companyId, bookYear);
                    this.getLoginPanel().setMessage(message);
                    return false;
                }
                if (env.getGovernmentActivated()) {
                    result = EnvironmentBO.checkActivated(loginHelper, env.getOperationArea(), true);
                    message = (String)result[0];
                    if (result[0] == null || result[1] != null) {
                        this.dataObject.setSessionAttribute("GOV", (Object)"");
                    }
                }
            }
        }
        ApplicationIdentifierHelper.update(this.dataObject);
        ActiveUsers.addUser((String)user, (String)description, (DataObject)this.dataObject);
        this.logonCompleted();
        return true;
    }

    public DataObject newLogin(DataObject object) throws Exception {
        object.killAllProcesses();
        ActiveUsers.removeUser((DataObject)object);
        LoginHelper loginHelper = (LoginHelper)object.getSessionAttribute(LoginHelper.LOGINHELPER);
        if (loginHelper != null) {
            Environment env = (Environment)object.getSessionAttribute("ActiveEnvironment");
            if (env != null) {
                String companyId = (String)object.getSessionAttribute("ActiveCompany");
                String bookYear = (String)object.getSessionAttribute("ActiveBookYear");
                try {
                    loginHelper.logout(env, companyId, bookYear);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                loginHelper.logout();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object.addUIObject((UIObject)new RedirectAction((Adapter)this, "main"));
        return object;
    }

    protected void completeLogin(String user) throws Exception {
    }

    protected boolean isValidUserPasswordCombination(String user, String password) throws Exception {
        return true;
    }

    protected void customize(LoginPanel loginPanel) throws Exception {
        loginPanel.setHeader("Title.Loginpage");
        loginPanel.setVersionInfo("2025.01.000");
        this.getUserField().setMandatory(true);
        this.getUserField().setType("upper");
        this.getPasswordField().setMandatory(true);
    }
}

