/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.renderer.JavaScriptInstructionSet;
import nl.ibs.esp.session.ActiveUsers;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.LoginPanel;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.adapters.FACAdapter;
import nl.ibs.fac.db.Environment;

public class LogoutAdapter
extends FACAdapter {
    private static final long serialVersionUID = 8435711834661900827L;
    public static String PAGE = LogoutAdapter.class.getName();
    public static final String LOGOUT = "logout";

    public LogoutAdapter(DataObject object) throws Exception {
        super(object);
        this.showTaskBar(false);
        this.setHidden(true);
        object.setApplicationIdentifyingString("");
    }

    public DataObject logout(DataObject object) throws Exception {
        this.killOtherProcesses();
        ActiveUsers.removeUser((DataObject)object);
        LoginHelper loginHelper = (LoginHelper)object.getSessionAttribute(LoginHelper.LOGINHELPER);
        if (loginHelper != null) {
            Environment env = (Environment)object.getSessionAttribute("ActiveEnvironment");
            if (env != null) {
                String companyId = (String)object.getSessionAttribute("ActiveCompany");
                String bookYear = (String)object.getSessionAttribute("ActiveBookYear");
                try {
                    loginHelper.logout(env, companyId, bookYear);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                loginHelper.logout();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.clearScreen(false, false);
        LoginPanel panel = new LoginPanel();
        panel.setHeader(new Header("Label.SignedOff", "screen_name"));
        object.addUIObject((UIObject)panel);
        ActiveUsers.removeUser((DataObject)object);
        this.logoffCompleted();
        JavaScriptInstructionSet.addInstruction((String)"setTimeout(closeTop, 1000);");
        return object;
    }

    @Override
    public String getDefaultAction() {
        return LOGOUT;
    }
}

