/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.List;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.event.EventListener;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.MassTransactionProcessTypeEnum;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.MassCorrectionPanel;
import nl.ibs.fac.adapters.MassMovementPanel;
import nl.ibs.fac.adapters.MassRemovePanel;
import nl.ibs.fac.adapters.MassTransactionPanel;
import nl.ibs.fac.adapters.MassWriteOffPanel;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.commands.MassTransactionCreateCommand;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Scrambler;

public class MassTransactionCreateAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 5612476681795231565L;
    public static final String PAGE = MassTransactionCreateAdapter.class.getName();
    private static final String SUBMIT = "submit";
    private static final String TITLE = "Title.MassTransactionsCreate";
    private static final String CLASSNAME = MassTransactionCreateCommand.CLASSNAME;
    private static final String JOBNAME = "Job.CreateMassTransactionProposal";
    private MassTransactionPanel[] panel;
    private FloatBar fbShow = new FloatBar();
    private FieldGroup fgProcType;
    private ComboBox cbProcType;
    private int procType = 1;
    private Company company = null;
    private Company dataSet;

    public MassTransactionCreateAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.dataSet = this.company.getDataSet();
        if (this.dataSet == null) {
            this.dataSet = this.company;
        }
        this.panel = new MassTransactionPanel[4];
        this.panel[0] = new MassWriteOffPanel(this.company, this.bookYearMin, this.bookYearMax);
        this.panel[1] = new MassMovementPanel(this.company, this.loginHelper, this.env, this.bookYearMin, this.bookYearMax);
        this.panel[2] = new MassCorrectionPanel(this.company, this.env, this.bookYearMin, this.bookYearMax);
        this.panel[3] = new MassRemovePanel(this.company, this.bookYearMin, this.bookYearMax);
        this.cbProcType = EnumHelper.createComboBox("Label.MTTType", MassTransactionProcessTypeEnum.getCollection(), false);
        this.cbProcType.removeOption(this.cbProcType.getOptionByValue("4"));
        this.cbProcType.removeOption(this.cbProcType.getOptionByValue("5"));
        this.cbProcType.removeOption(this.cbProcType.getOptionByValue("6"));
        this.cbProcType.setMandatory(true);
        this.cbProcType.addOnChangeListener((EventListener)new cbTypeListener());
        this.cbProcType.setSelectedOptionValue("" + this.procType);
        this.fgProcType = new FieldGroup();
        this.fgProcType.add(this.cbProcType);
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true).setDefault(true);
        this.fbShow.addAction(ok);
        this.fbShow.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        TransactionBatch transactionBatch = MassTransactionBP.getCurrentMassTransactionBatch(this.dbData, this.companyId);
        if (transactionBatch != null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "mass_transaction_proposal_already_exists");
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.finish(object);
        }
        transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(this.dbData, this.companyId);
        if (transactionBatch != null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "depreciation_proposal_already_exists");
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        object.addUIObject((UIObject)this.fgProcType);
        int p = 0;
        while (p < this.panel.length) {
            this.panel[p].setHidden(p != this.procType);
            object.addUIObject((UIObject)this.panel[p]);
            ++p;
        }
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        boolean error = this.panel[this.procType].validate(object);
        if (error) {
            return object;
        }
        List<Object> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("User", this.loginHelper.getUser()));
        list.add(new NameValuePair("System", this.loginHelper.getSystem()));
        list.add(new NameValuePair("Password", Scrambler.scramble((String)this.loginHelper.getPassword())));
        list.add(new NameValuePair("facLib", this.dbData.getSchema()));
        list.add(new NameValuePair("Environment", this.env.getId()));
        list.add(new NameValuePair("Company", this.companyId));
        list.add(new NameValuePair("BookYear", this.bookYear));
        list.add(new NameValuePair("governmentActivated", "" + this.governmentActivated));
        list.add(new NameValuePair("PROCTYPE", this.cbProcType.getSelectedOptionValue()));
        list = this.panel[this.procType].addSubmitParms(list);
        this.getProcess().setAttribute("selections", (Object)NameValuePair.getStringArray(list));
        this.getProcess().setAttribute("title", (Object)TITLE);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        this.getProcess().setAttribute("backMethod", (Object)"show");
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "showInWindow", this.getProcess().getProcessId()));
        return object;
    }

    private class cbTypeListener
    implements EventListener {
        private static final long serialVersionUID = -8267692719616032811L;

        private cbTypeListener() {
        }

        public void event(UIObject object, String type) throws Exception {
            MassTransactionCreateAdapter.this.panel[MassTransactionCreateAdapter.this.procType].setHidden(true);
            MassTransactionCreateAdapter.this.procType = Integer.parseInt(MassTransactionCreateAdapter.this.cbProcType.getSelectedOptionValue().trim());
            MassTransactionCreateAdapter.this.panel[MassTransactionCreateAdapter.this.procType].setHidden(false);
        }
    }
}

