/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFileOutputStream;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FileSelectionField;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.UserMessageException;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.MassTransactionProcessTypeEnum;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.inport.ImportCSVHelper;
import nl.ibs.fac.inport.MassTransactionCSV;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.util.Scrambler;

public class MassTransactionImportAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 7518276287459037831L;
    public static final String PAGE = MassTransactionImportAdapter.class.getName();
    private static final String TITLE = "Title.MassTransactionImport";
    private static final String CLASSNAME = MassTransactionCSV.CLASSNAME;
    private static final String JOBNAME = "Job.MassTransactionImport";
    private FieldGroup group = new FieldGroup();
    private FileSelectionField file = new FileSelectionField("Label.File", 40);
    private ComboBox cbProcType;
    private FloatBar fbShow = new FloatBar();
    private static final String SUBMIT = "submit";
    private static final int CCSID = 819;

    public MassTransactionImportAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.file.setMandatory(true);
        this.group.add((Field)this.file);
        this.cbProcType = EnumHelper.createComboBox("Label.MTTType", MassTransactionProcessTypeEnum.getCollection(), false);
        this.cbProcType.removeOption(this.cbProcType.getOptionByValue("2"));
        this.cbProcType.removeOption(this.cbProcType.getOptionByValue("1"));
        this.cbProcType.removeOption(this.cbProcType.getOptionByValue("3"));
        this.cbProcType.removeOption(this.cbProcType.getOptionByValue("0"));
        this.cbProcType.setMandatory(true);
        this.cbProcType.setSelectedOptionValue("4");
        this.group.add(this.cbProcType);
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        this.fbShow.addAction(ok);
        this.fbShow.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        TransactionBatch transactionBatch = MassTransactionBP.getCurrentMassTransactionBatch(this.dbData, this.companyId);
        if (transactionBatch != null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "mass_transaction_proposal_already_exists");
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.finish(object);
        }
        transactionBatch = DepreciationProposalBP.getCurrentDepreciationBatch(this.dbData, this.companyId);
        if (transactionBatch != null) {
            String message = LanguageHelper.getString("nl.ibs.fac.language", "depreciation_proposal_already_exists");
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        object.addUIObject((UIObject)this.group);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        this.file.validateSize(object);
        byte[] bytes = this.file.getFileContent(object);
        if (bytes.length == 0) {
            this.file.setInvalidTag();
            throw new UserMessageException("importfile_not_found");
        }
        LoginHelper loginHelper = (LoginHelper)object.getSessionAttribute(LoginHelper.LOGINHELPER);
        String pathToFile = String.valueOf(ImportCSVHelper.getDefaultPath()) + '/' + this.file.getValue();
        IFSFileOutputStream fos = new IFSFileOutputStream((AS400)loginHelper.getAs400(), pathToFile, 819);
        fos.write(bytes);
        fos.close();
        String[][] selections = new String[][]{{"pathToFile", pathToFile}, {"System", loginHelper.getSystem()}, {"User", loginHelper.getUser()}, {"Password", Scrambler.scramble((String)loginHelper.getPassword())}, {"facLib", this.dbData.getSchema()}, {"Environment", this.env.getId()}, {"Company", this.companyId}, {"PROCTYPE", this.cbProcType.getSelectedOptionValue()}};
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("title", (Object)object.translate(TITLE, object.getLocale()));
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }
}

