/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.List;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.MassTransactionPanel;
import nl.ibs.fac.bp.MassWriteOffBP;
import nl.ibs.fac.db.Company;
import nl.ibs.util.NameValuePair;

public class MassWriteOffPanel
extends MassTransactionPanel {
    private static final long serialVersionUID = -5312482754300476938L;
    private AssetTypeReferenceField rfTypeFrom = null;
    private AssetTypeReferenceField rfTypeTo = null;
    private BookYearPeriodGrid periodWOF;
    private BookYearPeriodGrid periodFAC;
    private BookYearPeriodGrid periodFIN;
    private int wofYear;
    private int wofPeriod;
    private int facYear;
    private int facPeriod;
    private int finYear;
    private int finPeriod;
    private MassWriteOffBP businessProcess;

    public MassWriteOffPanel(Company company, String bookYearMin, String bookYearMax) throws Exception {
        super(company, null, bookYearMin, bookYearMax);
        this.initialize();
    }

    private void initialize() throws Exception {
        this.businessProcess = new MassWriteOffBP(this.company, this.company.getNumberOfPeriods());
        this.rfTypeFrom = new AssetTypeReferenceField(this.company.getDBData(), this.company.getId());
        this.rfTypeFrom.setLabel("Label.AssetTypeFrom");
        this.rfTypeTo = new AssetTypeReferenceField(this.company.getDBData(), this.company.getId());
        this.rfTypeTo.setLabel("Label.AssetTypeTo");
        String[] pyp = this.businessProcess.retrieveWriteOffYearAndPeriod();
        this.periodWOF = new BookYearPeriodGrid("Label.WriteOffPeriod", pyp[0], pyp[1], false);
        this.periodWOF.setMandatory(true);
        String[] yps = this.businessProcess.retrieveYearsAndPeriods();
        this.periodFAC = new BookYearPeriodGrid("Label.FACStartPeriod", yps[0], yps[1], false);
        this.periodFAC.setMandatory(true);
        this.periodFIN = new BookYearPeriodGrid("Label.FinancialPeriod", yps[2], yps[3], false);
        this.addUIObject((UIObject)this.rfTypeFrom);
        this.addUIObject((UIObject)this.rfTypeTo);
        this.addUIObject((UIObject)this.periodWOF);
        this.addUIObject((UIObject)this.periodFAC);
        this.addUIObject((UIObject)this.periodFIN);
    }

    public void setHidden(boolean isHidden) {
        try {
            this.periodWOF.setMandatory(!isHidden);
            this.periodFAC.setMandatory(!isHidden);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.setHidden(isHidden);
    }

    @Override
    public boolean validate(DataObject object) throws Exception {
        boolean error = false;
        String[] errors = null;
        String val1 = this.rfTypeFrom.getValue().trim();
        String val2 = this.rfTypeTo.getValue().trim();
        if (val1.length() > 0 && val2.length() > 0 && val1.compareTo(val2) > 0) {
            error = true;
            this.addErrors(object, new String[]{"from_is_greater_than_to"});
            this.rfTypeFrom.setInvalidTag();
            this.rfTypeTo.setInvalidTag();
        }
        this.wofYear = this.periodWOF.getBookYear().getIntValue();
        this.wofPeriod = this.periodWOF.getPeriod().getIntValue();
        this.facYear = this.periodFAC.getBookYear().getIntValue();
        this.facPeriod = this.periodFAC.getPeriod().getIntValue();
        errors = this.businessProcess.validateWriteOffYearAndPeriod(this.wofYear, this.wofPeriod, this.facYear, this.facPeriod);
        if (errors != null) {
            error = true;
            this.addErrors(object, errors);
            this.periodWOF.setInvalidTag();
        }
        if ((errors = this.businessProcess.validateFACYearAndPeriod(this.facYear, this.facPeriod)) != null) {
            error = true;
            this.addErrors(object, errors);
            this.periodFAC.setInvalidTag();
        }
        this.finYear = this.periodFIN.getBookYear().getIntValue();
        this.finPeriod = this.periodFIN.getPeriod().getIntValue();
        errors = this.businessProcess.validateFINYearAndPeriod(this.finYear, this.finPeriod, Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax));
        if (errors != null) {
            error = true;
            this.addErrors(object, errors);
            this.periodFIN.setInvalidTag();
        }
        return error;
    }

    @Override
    public List addSubmitParms(List list) throws Exception {
        list.add(new NameValuePair("TYPEFROM", this.rfTypeFrom.getValue()));
        list.add(new NameValuePair("TYPETO", this.rfTypeTo.getValue()));
        list.add(new NameValuePair("WOFPERYEAR", "" + this.wofYear));
        list.add(new NameValuePair("WOFPERPER", "" + this.wofPeriod));
        list.add(new NameValuePair("FACPERYEAR", "" + this.facYear));
        list.add(new NameValuePair("FACPERPER", "" + this.facPeriod));
        list.add(new NameValuePair("FINPERYEAR", "" + this.finYear));
        list.add(new NameValuePair("FINPERPER", "" + this.finPeriod));
        return list;
    }
}

