/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CloseWindowAction;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.ObjectDataReader;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.AssetStateEnum;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.adapters.AnalysisGroupHelper;
import nl.ibs.fac.adapters.AssetDimensionPanels;
import nl.ibs.fac.adapters.AssetField;
import nl.ibs.fac.adapters.AssetPanels;
import nl.ibs.fac.adapters.AssetStateImageTransformer;
import nl.ibs.fac.adapters.AssetTransactionAdapter;
import nl.ibs.fac.adapters.AssetTypeReferenceField;
import nl.ibs.fac.adapters.DecimalTransformer;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.FinancialReferenceField;
import nl.ibs.fac.adapters.MemoAdapter;
import nl.ibs.fac.adapters.MemoImageTransformer;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.ParentAssetInfoProcess;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.AssetDataReader;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.AssetBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.queries.AssetQuery;

public class ParentAssetAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 5311257405246856984L;
    public static final String PAGE = ParentAssetAdapter.class.getName();
    public static final String RETURNPAGE = "ParentAssetAdapterReturnPage";
    public static final String RETURNMETHOD = "ParentAssetAdapterReturnMethod";
    protected Company company;
    private String cId;
    private AssetPanels panels;
    private boolean isWindow = false;
    private CloseWindowAction closeWindow;
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private String[] names2;
    private String[] labels2;
    private String[] searchNames;
    private String[] searchLabels2;
    private String[] shortLabels2;
    private short[] sizes2;
    private String[] types2;
    private Transformer[] transformers2;
    private static final String[] NAMES = new String[]{"id", "description", "typeId", "finDimId1", "finDimId2", "finDimId3", "finDimId4", "finDimId5", "hasMemo"};
    private static final String[] TOOLTIPS = new String[]{"Label.Memo"};
    private String[] labels;
    private String[] shortLabels;
    private static final int LEADING_LABELS = 3;
    private static final int FIN_DIM_LABELS = 5;
    private static final short[] SIZES = new short[]{100, 300, 80, 80, 80, 80, 80, 80, 20};
    private String[] types = new String[9];
    private Transformer[] transformers;
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private NumericIdTransformer numericIdTransformer;
    private Map inputComponents;
    protected TableRowMethod tableRowMethod;
    private static final String REFRESH = "refresh";
    private static final String CREATEFORM = "initCreateForm";
    private static final String EDITFORM = "initEditForm";
    private static final String EDIT = "edit";
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    protected static final String SHOWSUBASSETS = "showSubAssets";
    protected FloatBar fbShow;
    private FloatBar fbShowSubAssets;
    private FloatBar fbCreate;
    private FieldGroup fgCreate;
    private FloatBar fbEdit;
    private FloatBar fbDelete;
    protected Action[] rowActions;
    protected Action[] headerActions;
    protected String title;
    protected boolean selectable;
    protected Asset asset;
    private Object[] assets;
    private ArrayList<Asset> deleteList;
    private Boolean parents;
    private Boolean subs;
    private Window window;
    private Panel headerPanel;
    private ReferenceField idDesc;
    private AssetTypeReferenceField refType;
    private FACDecimalField totalBookValue;
    private Action next;
    private Action close;
    private Action previous;
    private Action createOK;
    private String createHeader;
    private ODBTable subTable;
    private CommonTable.SearchPanel subSearchPanel;
    private static final String[] SUBNAMES = new String[]{"id", "description", "typeId", "bookValue", "state"};
    private static final String[] SUBLABELS = new String[]{"Label.Id", "Label.Description", "Label.Type", "Label.BookValue", "Label.State"};
    private static final String[] SUBTOOLTIPS = new String[]{"Label.State"};
    private static final String[] SUBSEARCHNAMES = new String[]{"id", "description", "typeId", "state"};
    private static final String[] SUBSEARCHLABELS = new String[]{"Label.Id", "Label.Description", "Label.Type", "Label.State"};
    private static final short[] SUBSIZES = new short[]{100, 300, 80, 100, 25};
    private static final String[] SUBTYPES = new String[5];
    private static final Transformer[] SUBTRANSFORMERS;
    private static final boolean[] SUBSORTABLE;

    static {
        Transformer[] transformerArray = new Transformer[5];
        transformerArray[3] = new DecimalTransformer();
        transformerArray[4] = new AssetStateImageTransformer();
        SUBTRANSFORMERS = transformerArray;
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[4] = true;
        SUBSORTABLE = blArray;
    }

    public ParentAssetAdapter(ESPProcess process, DataObject object, boolean isWindow) throws Exception {
        super(process, object);
        Transformer[] transformerArray = new Transformer[9];
        transformerArray[8] = new MemoImageTransformer();
        this.transformers = transformerArray;
        this.numericIdTransformer = new NumericIdTransformer();
        this.inputComponents = new HashMap();
        this.tableRowMethod = null;
        this.fbShow = new FloatBar();
        this.fbShowSubAssets = new FloatBar();
        this.fbCreate = new FloatBar();
        this.fbEdit = new FloatBar();
        this.fbDelete = new FloatBar();
        this.parents = new Boolean(true);
        this.subs = new Boolean(false);
        this.idDesc = new ReferenceField("Label.Asset");
        this.totalBookValue = new FACDecimalField("Label.BookValue", 15, 2);
        this.subTable = null;
        if (this.companyId == null) {
            return;
        }
        this.isWindow = isWindow;
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.labels = new String[]{"Label.Id", "Label.Description", "Label.Type", this.env.getName1(), this.env.getName2(), this.env.getName3(), this.env.getName4(), this.env.getName5(), "Label.Memo"};
        this.shortLabels = new String[]{"Label.Id", "Label.Description", "Label.Type", this.env.getShortName1(), this.env.getShortName2(), this.env.getShortName3(), this.env.getShortName4(), this.env.getShortName5(), "Label.Memo"};
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.cId = this.companyId;
        if (this.dataSetId != null) {
            this.cId = this.dataSetId;
        }
        if (this.env.getOperationArea().trim().length() == 0) {
            this.transformers[3] = this.numericIdTransformer;
            this.transformers[4] = this.numericIdTransformer;
            this.transformers[5] = this.numericIdTransformer;
            this.transformers[6] = this.numericIdTransformer;
            this.transformers[7] = this.numericIdTransformer;
            this.types[3] = "number";
            this.types[4] = "number";
            this.types[5] = "number";
            this.types[6] = "number";
            this.types[7] = "number";
        }
        this.modifyTableArrays();
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEFORM);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(this.finish);
        this.inputComponents.put("id", new AssetField(this.company, false));
        this.inputComponents.put("typeId", new AssetTypeReferenceField(this.dbData, this.cId));
        ComboBox state = EnumHelper.createComboBox("Label.State", AssetStateEnum.getCollection(), true);
        state.setWidth("180");
        this.inputComponents.put("state", state);
        Company dataSet = this.company;
        if (this.dataSetId != null) {
            dataSet = this.company.getDataSet();
        }
        AssetDimensionPanels dimensionPanels = new AssetDimensionPanels(this.loginHelper, this.dbData, this.env, dataSet, false);
        FinancialReferenceField[] financialDimension = dimensionPanels.getFINDimensions();
        int i = 0;
        while (i < 5) {
            if (financialDimension[i] != null) {
                this.inputComponents.put(NAMES[i + 3], financialDimension[i]);
            }
            ++i;
        }
        this.searchNames = NAMES;
        this.searchLabels2 = this.labels;
        Object[] result = AnalysisGroupHelper.addAnalysisGroups(this.loginHelper, this.env, dataSet, this.inputComponents, this.searchNames, this.searchLabels2);
        this.searchNames = (String[])result[0];
        this.searchLabels2 = (String[])result[1];
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDITFORM);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        editOK.setValidationEnabled(true);
        editOK.setDefault(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(this.cancel);
        this.fbEdit.addAction(this.finish);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
        this.createHeader = "Title.CreateParentAsset";
        this.next = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createDimensionsForm");
        this.previous = new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createForm");
        this.createOK = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("create");
        Action subAssets = new Action("Button.SubAssets").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initSubAssets");
        Action refresh2 = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(((Object)((Object)this)).getClass().getName())).setMethod("refreshSubAssets");
        this.fbShowSubAssets.addAction(this.back);
        this.fbShowSubAssets.addAction(refresh2);
        this.fbShowSubAssets.addAction(this.finish);
        Action memo = new Action("Label.Memo").setAdapter(this.getProcessAdapterPageName(MemoAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{edit, memo, subAssets, confirmDelete};
        this.headerActions = new Action[]{refresh, create};
        if (this.isWindow) {
            this.window = new Window();
            this.window.setTop("10%");
            this.window.setRight("15%");
            this.window.setLabel(this.createHeader);
            this.closeWindow = new CloseWindowAction(this.window, this.getProcessAdapterPageName(PAGE), "close");
            this.window.add((Action)this.closeWindow);
            this.close = new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close");
            this.fgCreate = new FieldGroup();
            this.fgCreate.forceBorder(false);
            this.fgCreate.add(this.fbCreate);
        } else {
            this.close = this.cancel;
            this.getProcess().setAttribute("MemoAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        }
        this.headerPanel = new HeaderPanel();
        this.idDesc.setReadonly(true);
        this.idDesc.setLength(10);
        this.idDesc.setDescriptionLength(50);
        this.headerPanel.addUIObject((UIObject)this.idDesc);
        this.refType = new AssetTypeReferenceField(this.dbData, this.cId);
        this.refType.setReadonly(true);
        this.headerPanel.addUIObject((UIObject)this.refType);
        this.totalBookValue.setReadonly(true);
        this.headerPanel.addUIObject((UIObject)this.totalBookValue);
        this.title = "Title.ParentAssets";
        this.selectable = true;
    }

    public DataObject initCreateForm(DataObject object) throws Exception {
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, null, false, true, false, null, false, null, null);
        if (this.isWindow) {
            object.addUIObject((UIObject)this.window);
        }
        return this.createForm(object);
    }

    public DataObject createForm(DataObject object) throws Exception {
        if (this.isWindow) {
            this.window.removeAllChildUIObjects();
            this.window.add((Action)this.closeWindow);
            this.window.add(this.panels.firstPanel);
            this.window.add(this.fgCreate);
        } else {
            this.clearScreen(true, false, true);
            object.addUIObject((UIObject)new Header(this.createHeader, "screen_name"));
            object.addUIObject((UIObject)this.panels.firstPanel);
            object.addUIObject((UIObject)this.fbCreate);
        }
        this.panels.id.setReadonly(this.panels.idReadOnly);
        this.panels.description.setReadonly(false);
        this.panels.type.setReadonly(false);
        this.removeActions();
        this.next.setDefault(true);
        this.next.setValidationEnabled(true);
        this.fbCreate.addAction(this.next);
        this.fbCreate.addAction(this.close);
        return object;
    }

    public DataObject createDimensionsForm(DataObject object) throws Exception {
        if (!this.panels.id.isHidden()) {
            Object[] result;
            if ("number".equals(this.panels.id.getType())) {
                try {
                    if (Integer.parseInt(this.panels.id.getValue()) <= 0) {
                        this.panels.id.setInvalidTag();
                        object.addUIObject((UIObject)new Message("value_must_be_positive", "error"));
                        return object;
                    }
                }
                catch (NumberFormatException nfe) {
                    this.panels.id.setInvalidTag();
                    object.addUIObject((UIObject)new Message("not_a_number", "error"));
                    return object;
                }
            }
            if ((result = AssetBO.get(this.company, this.panels.id.getValue().trim(), false))[0] != null) {
                this.panels.id.setInvalidTag();
                object.addUIObject((UIObject)new Message("duplicate_key", "error"));
                return object;
            }
        }
        this.panels.initializeType();
        if (this.isWindow) {
            this.window.removeAllChildUIObjects();
            this.window.add((Action)this.closeWindow);
            this.window.add(this.panels.firstPanel);
            this.window.add(this.panels.finDimensionPanel);
            this.window.add(this.panels.facDimensionPanel);
            this.window.add(this.fgCreate);
        } else {
            this.clearScreen(true, false, true);
            object.addUIObject((UIObject)new Header(this.createHeader, "screen_name"));
            object.addUIObject((UIObject)this.panels.firstPanel);
            object.addUIObject((UIObject)this.panels.finDimensionPanel);
            object.addUIObject((UIObject)this.panels.facDimensionPanel);
            object.addUIObject((UIObject)this.fbCreate);
        }
        this.panels.id.setReadonly(true);
        this.panels.description.setReadonly(true);
        this.panels.type.setReadonly(true);
        this.removeActions();
        this.createOK.setDefault(true);
        this.createOK.setValidationEnabled(true);
        this.fbCreate.addAction(this.previous);
        this.fbCreate.addAction(this.createOK);
        this.fbCreate.addAction(this.close);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        Object[] result = new AssetBP(this.panels).create(null, null, false);
        String message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.asset = (Asset)result[0];
        String id = this.asset.getId();
        if (AssetBO.isIdNumeric(this.company, false)) {
            id = (String)this.numericIdTransformer.transform(id);
        }
        if (this.isWindow) {
            this.getProcess().setAttribute("NewParentId", (Object)id);
            this.getProcess().setAttribute("NewParentDescription", (Object)this.panels.description.getValue());
            object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(PAGE), "close", this.getProcess().getProcessId()));
        } else {
            this.table.setPointer("id", (Object)id, true);
            this.table.reload();
            object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(PAGE), "show", this.getProcess().getProcessId()));
        }
        return object;
    }

    public DataObject initEditForm(DataObject object) throws Exception {
        this.asset = this.getAsset(TableHelper.getSelectedItem((DataObject)object));
        this.panels = new AssetPanels(this.loginHelper, this.dbData, this.env, this.company, this.bookYearMin, this.bookYearMax, this.numberOfPeriods, this.governmentActivated, this.asset, false, true, false, null, false, null, null);
        this.panels.setValues();
        return this.editForm(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        String header = "Title.EditParentAsset";
        object.addUIObject((UIObject)new Header(header, "screen_name"));
        object.addUIObject((UIObject)this.panels.firstPanel);
        object.addUIObject((UIObject)this.panels.finDimensionPanel);
        object.addUIObject((UIObject)this.panels.facDimensionPanel);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = this.panels.update();
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.table.setPointer("id", (Object)this.asset.getId(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(this.title, "screen_name"));
        if (this.table == null) {
            this.createTable();
        } else if (this.table.isSelectable()) {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        AssetQuery query = new AssetQuery(this.dbData, this.companyId, this.parents, this.subs, false, null, false, false);
        this.table = new ODBTable((ObjectDataReader)new AssetDataReader(), (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName(PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setTextCodeSingleObject("Label.Asset");
        this.table.setTextCodeMultipleObjects("Label.Assets");
        this.table.setColumnNames(this.names2);
        this.table.setColumnLabels(this.shortLabels2);
        this.table.setColumnSizes(this.sizes2);
        this.table.setColumnTypes(this.types2);
        this.table.setDisplayTransformers(this.transformers2);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setInputComponents(this.inputComponents);
        this.table.setSortable(true);
        if (this.selectable) {
            this.table.setMultipleSelectable();
        }
        this.table.orderByColumn("id");
        this.searchPanel = this.table.createSearch(this.searchNames, this.searchLabels2);
        this.searchPanel.setCSSClass("headerPanel");
        Action filterAction = this.table.createFilterAction(this.searchNames, this.searchLabels2, 3);
        if (this.tableRowMethod != null) {
            TableHelper.createMenu((CommonTable)this.table, (Action[])this.headerActions, (Action[])this.rowActions, (TableRowMethod)this.tableRowMethod);
        } else {
            TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        }
        this.searchPanel.addAction(filterAction);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
        this.getProcess().setAttribute("Table", (Object)this.table);
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject initSubAssets(DataObject object) throws Exception {
        this.asset = this.getAsset(TableHelper.getSelectedItem((DataObject)object));
        this.refType.setValue(this.asset.getTypeId());
        this.refType.validate();
        return this.refreshSubAssets(object);
    }

    public DataObject refreshSubAssets(DataObject object) throws Exception {
        this.subTable = null;
        return this.showSubAssets(object);
    }

    public DataObject showSubAssets(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.SubAssets", "screen_name"));
        this.totalBookValue.setValue(this.asset.getTotalBookValue());
        object.addUIObject((UIObject)this.headerPanel);
        if (this.subTable == null) {
            this.createSubAssetTable(object);
        }
        object.addUIObject((UIObject)this.subSearchPanel);
        object.addUIObject((UIObject)this.subTable);
        object.addUIObject((UIObject)this.fbShowSubAssets);
        return object;
    }

    private void createSubAssetTable(DataObject object) throws Exception {
        AssetQuery assetQuery = new AssetQuery(this.dbData, this.companyId);
        assetQuery.setQueryForSubAssets(this.asset.getId(), this.asset.getCredit());
        this.subTable = new ODBTable(Asset.class, (ODBQuery)assetQuery, new String[]{"id"}, 12);
        this.subTable.setName(String.valueOf(PAGE) + "sub");
        this.subTable.setColumnNames(SUBNAMES);
        this.subTable.setColumnLabels(SUBLABELS);
        this.subTable.setColumnSizes(SUBSIZES);
        this.subTable.setColumnTypes(SUBTYPES);
        this.subTable.setDisplayTransformers(SUBTRANSFORMERS);
        if (AssetBO.isIdNumeric(this.company, false)) {
            ParentAssetAdapter.SUBTYPES[0] = "number";
            ParentAssetAdapter.SUBTRANSFORMERS[0] = this.numericIdTransformer;
        }
        this.subTable.setInputComponents(this.inputComponents);
        this.subTable.setColumnSortable(SUBSORTABLE);
        this.subTable.setSortable(true);
        this.subTable.setSelectable(false);
        this.subTable.orderByColumn("id");
        this.subSearchPanel = this.subTable.createSearch(SUBSEARCHNAMES, SUBSEARCHLABELS);
        Action filterAction = this.subTable.createFilterAction(SUBSEARCHNAMES, SUBSEARCHLABELS, 3);
        this.subSearchPanel.addAction(filterAction);
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refreshSubAssets");
        Action[] headerActions = new Action[]{refresh};
        Action[] rowActions = null;
        if (this.getProcess() instanceof ParentAssetInfoProcess) {
            Action transactions = new Action("Button.Transactions").setAdapter(this.getProcessAdapterPageName(AssetTransactionAdapter.PAGE)).setMethod("show");
            rowActions = new Action[]{transactions};
        }
        TableHelper.createMenu((Table)this.subTable, (Action[])headerActions, rowActions);
        this.subTable.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.subTable, (String[])SUBTOOLTIPS);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.assets = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        AssetQuery assetQuery = new AssetQuery(this.dbData, this.companyId);
        int i = 0;
        while (i < this.assets.length) {
            Asset asset = (Asset)this.assets[i];
            if (asset != null) {
                assetQuery.setQueryForSubAssets(asset.getId(), asset.getCredit());
                Collection subAssets = assetQuery.fetchData(null, null, null, 999);
                if (subAssets != null && !subAssets.isEmpty()) {
                    object.addUIObject((UIObject)new Message("parent_asset_to_delete_has_sub_assets", "error"));
                    return object;
                }
            }
            ++i;
        }
        this.clearScreen(true, false, true);
        String header = "Title.DeleteParentAssets";
        object.addUIObject((UIObject)new Header(header, "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable(object));
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable(DataObject object) throws Exception {
        this.deleteList = new ArrayList(this.assets.length);
        int i = 0;
        while (i < this.assets.length) {
            this.deleteList.add(this.getAsset(this.assets[i]));
            ++i;
        }
        CollectionTable table = new CollectionTable(Asset.class, this.deleteList, 12);
        table.setName(PAGE);
        table.setColumnNames(this.names2);
        table.setColumnLabels(this.shortLabels2);
        table.orderByColumn(this.names2[0]);
        table.setColumnSizes(this.sizes2);
        table.setColumnTypes(this.types2);
        table.setDisplayTransformers(this.transformers2);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        Object[] assets = this.deleteList.toArray();
        int i = 0;
        while (i < assets.length) {
            Asset asset = (Asset)assets[i];
            if (asset != null && (message = AssetBO.delete(asset)) != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
            }
            ++i;
        }
        if (message != null) {
            return object;
        }
        this.table = null;
        return this.show(object);
    }

    private void modifyTableArrays() throws Exception {
        if (AssetBO.isIdNumeric(this.company, false)) {
            this.types[0] = "number";
            this.transformers[0] = this.numericIdTransformer;
        }
        int[] finDimUsage = new int[]{this.company.retrieveFinancialDimension1Usage(), this.company.retrieveFinancialDimension2Usage(), this.company.retrieveFinancialDimension3Usage(), this.company.retrieveFinancialDimension4Usage(), this.company.retrieveFinancialDimension5Usage()};
        int oldArrayLength = NAMES.length;
        int newArrayLength = NAMES.length;
        int i = 0;
        while (i < 5) {
            if (finDimUsage[i] == 0) {
                --newArrayLength;
            }
            ++i;
        }
        if (newArrayLength == oldArrayLength) {
            this.names2 = NAMES;
            this.labels2 = this.labels;
            this.shortLabels2 = this.shortLabels;
            this.sizes2 = SIZES;
            this.types2 = this.types;
            this.transformers2 = this.transformers;
            return;
        }
        this.names2 = new String[newArrayLength];
        this.labels2 = new String[newArrayLength];
        this.shortLabels2 = new String[newArrayLength];
        this.sizes2 = new short[newArrayLength];
        this.types2 = new String[newArrayLength];
        this.transformers2 = new Transformer[newArrayLength];
        int j = 0;
        int i2 = 0;
        while (i2 < oldArrayLength) {
            if (i2 < 3 || i2 >= 8 || finDimUsage[i2 - 3] != 0) {
                this.names2[j] = NAMES[i2];
                this.labels2[j] = this.labels[i2];
                this.shortLabels2[j] = this.shortLabels[i2];
                this.sizes2[j] = SIZES[i2];
                this.types2[j] = this.types[i2];
                this.transformers2[j] = this.transformers[i2];
                ++j;
            }
            ++i2;
        }
    }

    protected Asset getAsset(Object object) throws Exception {
        Asset asset = (Asset)object;
        if (asset != null) {
            this.idDesc.setValue(AssetBO.unFormatId(this.company, asset.getId(), false));
            this.idDesc.setDescription(asset.getDescription());
        }
        return asset;
    }

    private void removeActions() throws Exception {
        this.fbCreate.removeAction("Button.Previous");
        this.fbCreate.removeAction("Button.Next");
        this.fbCreate.removeAction("Button.Complete");
        this.fbCreate.removeAction("Button.Cancel");
    }

    public DataObject close(DataObject object) throws Exception {
        this.window.closeWindow(object);
        object.addUIObject((UIObject)new RedirectAction(this.getProcess().getAttribute(RETURNPAGE).toString(), this.getProcess().getAttribute(RETURNMETHOD).toString(), this.getProcess().getProcessId()));
        return object;
    }
}

