/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.ContextAction;
import nl.ibs.esp.uiobjects.ContextMenu;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.TableRowMethod;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.adapters.AssetDimensionPanels;
import nl.ibs.fac.adapters.MemoAdapter;
import nl.ibs.fac.adapters.ParentAssetAdapter;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.boadapters.WozValueBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.WozValue;
import nl.ibs.fac.queries.AssetQuery;

public class ParentAssetInfoAdapter
extends ParentAssetAdapter {
    private static final long serialVersionUID = -2744757228895968078L;
    public static final String PAGE = ParentAssetInfoAdapter.class.getName();
    private static final ZeroBigDecimalToBlankTransformer DECIMALTRANSFORMER = new ZeroBigDecimalToBlankTransformer();

    public ParentAssetInfoAdapter(ESPProcess process, DataObject object, boolean isWindow) throws Exception {
        super(process, object, false);
    }

    @Override
    protected void initialize(DataObject object) throws Exception {
        super.initialize(object);
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("refresh");
        Action showAssetDetails = new Action("Button.BasicData").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showAssetDetails");
        this.fbShow = new FloatBar();
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(this.finish);
        this.headerActions = new Action[]{refresh};
        Action memo = new Action("Label.Memo").setAdapter(this.getProcessAdapterPageName(MemoAdapter.PAGE)).setMethod("show");
        Action subAssets = new Action("Button.SubAssets").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("initSubAssets");
        this.rowActions = new Action[]{subAssets, showAssetDetails, memo};
        this.getProcess().setAttribute("AssetTransactionAdapterReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("AssetTransactionAdapterReturnMethod", (Object)"showSubAssets");
        this.title = "Title.ParentAssetInfo";
        this.selectable = false;
        this.tableRowMethod = new AssetTableRowMethod();
    }

    public DataObject showAssetDetails(DataObject object) throws Exception {
        Field field;
        this.asset = this.getAsset(TableHelper.getSelectedItem((DataObject)object));
        AssetType type = this.asset.getAssetType();
        WozValue wozValue = WozValueBO.getLastWozValue(this.dbData, this.companyId, "A", this.asset.getId());
        Window window = new Window();
        window.setTop("10%");
        window.setRight("15%");
        window.setLabel("Activum " + this.asset.getId() + " - " + object.translate("Button.BasicData", object.getLocale()));
        TabbedPanel tabbedPanel = new TabbedPanel();
        Tab commonTab = new Tab("Label.Common");
        tabbedPanel.add(commonTab);
        Tab dimensionTab = new Tab("Label.Dimensions");
        tabbedPanel.add(dimensionTab);
        FieldGroup fg = new FieldGroup("");
        ReferenceField rf = new ReferenceField("Label.Asset");
        rf.setLength(10);
        rf.setDescriptionLength(40);
        rf.setReadonly(true);
        rf.setValue(this.asset.getId());
        rf.setDescription(this.asset.getDescription());
        fg.add((Field)rf);
        rf = new ReferenceField("Label.Type");
        rf.setLength(10);
        rf.setDescriptionLength(40);
        rf.setReadonly(true);
        rf.setValue(type.getId());
        rf.setDescription(type.getDescription());
        fg.add((Field)rf);
        commonTab.add(fg);
        dimensionTab.add(fg);
        if (wozValue != null) {
            fg = new FieldGroup("");
            Field field2 = new Field("Label.FACStartPeriod", "text", null, PeriodHelper.toString(this.asset.getStartUseYear(), this.asset.getStartUsePeriod()), 10);
            field2.setReadonly(true);
            fg.add(field2);
            field2 = new Field("Label.CurrentWOZValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(wozValue.getWOZAmount()), 15);
            field2.setType("decimal");
            field2.setReadonly(true);
            fg.add(field2);
            commonTab.add(fg);
        }
        AssetQuery assetQuery = new AssetQuery(this.dbData, this.companyId);
        assetQuery.setQueryForSubAssets(this.asset.getId(), this.asset.getCredit());
        Collection subAssets = assetQuery.fetchData(null, null, null, 999);
        Iterator sai = subAssets.iterator();
        BigDecimal[] acquisitionValues = new BigDecimal[]{new BigDecimal("0.00"), new BigDecimal("0.00"), new BigDecimal("0.00")};
        BigDecimal[] depreciatedValues = new BigDecimal[]{new BigDecimal("0.00"), new BigDecimal("0.00"), new BigDecimal("0.00")};
        boolean[] accPrins = new boolean[3];
        while (sai.hasNext()) {
            Asset subAsset = (Asset)sai.next();
            Collection valuations = subAsset.getValuationsCollection(null);
            for (Valuation valuation : valuations) {
                acquisitionValues[valuation.getAccountingPrinciple()] = acquisitionValues[valuation.getAccountingPrinciple()].add(valuation.getPostedAcquisitionBalance());
                depreciatedValues[valuation.getAccountingPrinciple()] = depreciatedValues[valuation.getAccountingPrinciple()].add(valuation.getPostedDepreciationBalance());
                accPrins[valuation.getAccountingPrinciple()] = true;
            }
        }
        if (accPrins[1]) {
            fg = new FieldGroup(this.env.getAPName1());
            field = new Field("Label.AcquisitionValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(acquisitionValues[1]), 15);
            field.setType("decimal");
            field.setReadonly(true);
            fg.add(field);
            field = new Field("Label.BookValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(acquisitionValues[1].subtract(depreciatedValues[1])), 15);
            field.setType("decimal");
            field.setReadonly(true);
            fg.add(field);
            if (wozValue != null) {
                field = new Field("Label.LimitValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(wozValue.getLimitAmount1()), 15);
                field.setType("decimal");
                field.setReadonly(true);
                fg.add(field);
            }
            commonTab.add(fg);
        }
        if (accPrins[2]) {
            fg = new FieldGroup(this.env.getAPName2());
            field = new Field("Label.AcquisitionValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(acquisitionValues[2]), 15);
            field.setType("decimal");
            field.setReadonly(true);
            fg.add(field);
            field = new Field("Label.BookValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(acquisitionValues[2].subtract(depreciatedValues[2])), 15);
            field.setType("decimal");
            field.setReadonly(true);
            fg.add(field);
            if (wozValue != null) {
                field = new Field("Label.LimitValue", "decimal", null, (String)DECIMALTRANSFORMER.transform(wozValue.getLimitAmount2()), 15);
                field.setType("decimal");
                field.setReadonly(true);
                fg.add(field);
            }
            commonTab.add(fg);
        }
        AssetDimensionPanels dimensionPanels = new AssetDimensionPanels(this.loginHelper, this.dbData, this.env, this.company, true);
        dimensionTab.add(dimensionPanels.initializeFINDimensionPanel(this.asset, this.asset.getAssetType(), null, null));
        dimensionTab.add(dimensionPanels.initializeFACDimensionPanel(this.asset, this.asset.getAssetType(), true, null));
        Panel panel = new Panel();
        panel.addUIObject((UIObject)tabbedPanel);
        window.add(panel);
        object.addUIObject((UIObject)window);
        return object;
    }

    private class AssetTableRowMethod
    implements TableRowMethod,
    Serializable {
        private static final long serialVersionUID = -8908212449829197540L;

        private AssetTableRowMethod() {
        }

        public void postprocesCreatedRow(TableRow row, ContextAction[] rowActions) throws Exception {
            Asset asset = (Asset)row.getObject();
            ContextMenu menu = new ContextMenu();
            int i = 0;
            while (i < rowActions.length) {
                if (!rowActions[i].getLanguageCode().equals("Label.Memo") || asset.getHasMemo()) {
                    ContextAction rowAction = new ContextAction(rowActions[i].getName());
                    rowAction.setAdapter(rowActions[i].getPageid());
                    rowAction.setMethod(rowActions[i].getMethod());
                    menu.addContextMenuItem(rowAction);
                }
                ++i;
            }
            row.setContextMenu(menu);
        }
    }
}

