/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.InputComponent;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.ReasonCodeImageTransformer;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.adapters.ZeroIntegerToBlankTransformer;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.ProofDepreciationBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Valuation;

public class ProofDepreciationAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 8474246806197628171L;
    public static final String PAGE = ProofDepreciationAdapter.class.getName();
    public static final String ASSET = "asset";
    public static final String VALUATION = "valuation";
    private Company company;
    private Asset asset;
    private Valuation valuation;
    private ProofDepreciationBP proofDepreciationBP;
    private Window window = new Window();
    private ReferenceField field;
    private BookYearPeriodGrid yearPeriodTo;
    private Action ok;
    private static final String[] SEARCHNAMES = new String[]{"year"};
    private static final String[] SEARCHLABELS = new String[]{"Label.Year"};
    private static final String[] NAMES = new String[]{"year", "period", "bookValue", "depreciationAmount", "bookValueAfterDepreciation", "totalDepreciationAmount", "totalDepreciationAmountBeyondEconomicLife", "interestAmount", "reasonCode"};
    private static final String[] LABELS = new String[]{"Label.Year", "Label.Period.short", "Label.BookValueBeforeDepreciation.short", "Label.DepreciationAmount.short", "Label.BookValueAfterDepreciation.short", "Label.TotalDepreciationAmount.short", "Label.TotalDepreciationAmountBeyondEconomicLife.short", "Label.InterestAmount", "Label.ReasonCode"};
    private static final String[] TOOLTIPS = new String[]{"Label.ReasonCode"};
    private static final short[] SIZES = new short[]{50, 30, 120, 120, 120, 120, 120, 120, 20};
    private static final ZeroIntegerToBlankTransformer INTEGERTRANSFORMER = new ZeroIntegerToBlankTransformer();
    private static final ZeroBigDecimalToBlankTransformer DECIMALTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    private Transformer[] transformers = new Transformer[]{INTEGERTRANSFORMER, INTEGERTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, DECIMALTRANSFORMER, new ReasonCodeImageTransformer()};
    private static final boolean[] COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true, true};
    private CollectionTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private FieldGroup tableFG;

    public ProofDepreciationAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.proofDepreciationBP = new ProofDepreciationBP(this.company, this.numberOfPeriods);
        FieldGroup fieldGroup = new FieldGroup("", 0, 525);
        fieldGroup.forceBorder(true);
        this.field = new ReferenceField("Label.Asset");
        this.field.setLength(10);
        this.field.setDescriptionLength(50);
        this.field.setReadonly(true);
        fieldGroup.add((Field)this.field);
        this.yearPeriodTo = new BookYearPeriodGrid("Label.PeriodUntilIncluding", this.bookYearMax, this.bookYearMin, null, this.numberOfPeriods);
        this.yearPeriodTo.getPeriod().setValue((long)this.numberOfPeriods);
        fieldGroup.add((ESPGridLayout)this.yearPeriodTo);
        this.ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("calculate");
        this.ok.setValidationEnabled(true);
        fieldGroup.add((InputComponent)this.ok);
        FieldGroup tableFG = new FieldGroup("");
        tableFG.forceBorder(true);
        this.window.setTop("8%");
        this.window.setRight("15%");
        this.window.add(fieldGroup);
    }

    public DataObject show(DataObject object) throws Exception {
        this.asset = (Asset)this.getProcess().getAttribute(ASSET);
        this.valuation = (Valuation)this.getProcess().getAttribute(VALUATION);
        if (this.valuation != null) {
            String sAP = this.valuation.getAccountingPrinciple() == 1 ? this.env.getAPName1() : this.env.getAPName2();
            this.window.setLabel(String.valueOf(object.translate("Title.ProofDepreciate", object.getLocale())) + " - " + sAP);
            this.field.setValue(this.asset.getId());
            this.field.setDescription(this.asset.getDescription());
        }
        if (this.table != null) {
            this.window.removeUIObject((UIObject)this.searchPanel, false);
            this.window.removeUIObject((UIObject)this.tableFG, false);
            this.table = null;
        }
        this.ok.setDefault(true);
        object.addUIObject((UIObject)this.window);
        this.window.removeUIObjects(Message.class, false);
        return object;
    }

    public DataObject calculate(DataObject object) throws Exception {
        if (this.table != null) {
            this.window.removeUIObject((UIObject)this.searchPanel, false);
            this.window.removeUIObject((UIObject)this.tableFG, false);
        }
        this.createTable();
        if (this.table == null) {
            return object;
        }
        this.ok.setDefault(false);
        this.window.add((Panel)this.searchPanel);
        this.tableFG = new FieldGroup("");
        this.tableFG.add((Table)this.table);
        this.window.add(this.tableFG);
        return object;
    }

    private void createTable() throws Exception {
        ArrayList collection = (ArrayList)this.proofDepreciationBP.calculate(this.asset, this.valuation.getAccountingPrinciple(), this.yearPeriodTo.getBookYear().getIntValue(), this.yearPeriodTo.getPeriod().getIntValue());
        String message = this.proofDepreciationBP.getMessage();
        if (message != null) {
            this.window.add(new Message(message, "error"));
            return;
        }
        int numberOfTableRows = this.numberOfPeriods;
        if (collection != null && !collection.isEmpty()) {
            BigDecimal diffAmount;
            CalculationValue value2 = (CalculationValue)collection.get(0);
            BigDecimal acquAmount = value2.getAcquisitionValue();
            BigDecimal bookAmount = value2.getBookValue();
            if (acquAmount != null && bookAmount != null && (diffAmount = acquAmount.subtract(bookAmount)).doubleValue() != 0.0) {
                for (CalculationValue value2 : collection) {
                    value2.addToTotalDepreciationAmount(diffAmount);
                }
                CalculationValue firstBlood = new CalculationValue(99, 0, 0, new BigDecimal("0"), new BigDecimal("0"), this.asset, this.valuation, bookAmount, acquAmount, diffAmount, new BigDecimal("0"), new BigDecimal("0"), null, null, false, new BigDecimal("0"));
                collection.add(0, firstBlood);
                ++numberOfTableRows;
            }
        }
        Iterator iterator = collection.iterator();
        BigDecimal totalDepreciationAmount = new BigDecimal("0");
        while (iterator.hasNext()) {
            CalculationValue value = (CalculationValue)iterator.next();
            totalDepreciationAmount = totalDepreciationAmount.add(value.getDepreciationAmount());
            value.setTotalDepreciationAmount(totalDepreciationAmount);
        }
        this.table = new CollectionTable(CalculationValue.class, (Collection)collection, numberOfTableRows);
        this.table.setName(PAGE);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.setColumnSizes(SIZES);
        this.table.setDisplayTransformers(this.transformers);
        this.table.setColumnNoWraps(COLUMNNOWRAPS);
        this.table.setSortable(false);
        this.table.setSelectable(false);
        this.searchPanel = this.table.createSearch(SEARCHNAMES, SEARCHLABELS, true, false, true);
        this.table.reload();
        TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
    }
}

