/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Label;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.ReportAdapterHelper;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.reports.ReconciliationToCSV;
import nl.ibs.fac.reports.ReconciliationToPDF;
import nl.ibs.fac.ui.AssetSelection;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Scrambler;

public class ReconciliationReportAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 8839330235311659501L;
    public static final String PAGE = ReconciliationReportAdapter.class.getName();
    private static final String SUBMIT = "submit";
    private String title = "Title.ReconciliationReport";
    private String classNameCSV = ReconciliationToCSV.CLASSNAME;
    private String classNamePDF = ReconciliationToPDF.CLASSNAME;
    private String jobName = "Job.Reconciliation";
    private Panel panel = new HeaderPanel();
    private FieldGroup subPanel = new FieldGroup("Label.Common");
    private CheckBox justTotals;
    private CheckBox generalTotal;
    private Panel selectionPanel = null;
    private BookYearPeriodGrid periodFrom;
    private BookYearPeriodGrid periodTo;
    private ComboBox accountingPrinciple = new ComboBox();
    private AssetSelection assetSelection = null;
    private boolean[] asda;
    private FloatBar fbShow;
    private FloatBar fbShowSelectionPanel;
    private static final String GRID_FILL_NONE = ESPGridLayoutConstraints.GRID_FILL_NONE;
    private static final String GRID_ANCHOR_WEST = ESPGridLayoutConstraints.GRID_ANCHOR_WEST;
    private ComboBox reportType;
    private ReportTypeChangeAction reportTypeChangeAction;

    public ReconciliationReportAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        boolean[] blArray = new boolean[13];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[9] = true;
        blArray[10] = true;
        this.asda = blArray;
        this.fbShow = new FloatBar();
        this.fbShowSelectionPanel = new FloatBar();
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Company company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        ESPGridLayout grid = new ESPGridLayout();
        short[] sArray = new short[2];
        sArray[0] = 200;
        grid.setColumnWidths(sArray);
        this.periodFrom = new BookYearPeriodGrid(null, "", this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.periodFrom.setMandatory(false);
        this.periodTo = new BookYearPeriodGrid(null, "", this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
        this.periodTo.setMandatory(false);
        grid.add((UIObject)new Label("Label.Period"), 0, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)this.periodFrom, 0, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)new Label("up-to-and-including"), 1, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        grid.add((UIObject)this.periodTo, 1, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        if (company.getLastDepreciationRunYear() != 0) {
            this.periodFrom.setValues("" + company.getLastDepreciationRunYear(), "1");
            this.periodTo.setValues("" + company.getLastDepreciationRunYear(), "" + company.getLastDepreciationRunPeriod());
        }
        this.accountingPrinciple.addOption(this.env.getAPName1(), "1");
        this.accountingPrinciple.setSelectedOptionValue("1");
        int ap2Usage = company.getAccountingPrinciple2Usage();
        if (ap2Usage < 0) {
            Company dataSet = (Company)CompanyBO.get(this.dbData, company.getDataSetId())[0];
            ap2Usage = dataSet.getAccountingPrinciple2Usage();
        }
        if (ap2Usage != 0) {
            this.accountingPrinciple.addOption(this.env.getAPName2(), "2");
            grid.add((UIObject)new Label("Label.AccountingPrinciple"), 2, 0, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
            grid.add((UIObject)this.accountingPrinciple, 2, 1, 1, 1, GRID_FILL_NONE, GRID_ANCHOR_WEST);
        }
        this.panel.addUIObject((UIObject)grid);
        this.reportType = ReportAdapterHelper.retrieveReportTypeComboBox(false);
        this.reportTypeChangeAction = new ReportTypeChangeAction();
        this.reportType.add((Action)this.reportTypeChangeAction);
        this.subPanel.add(this.reportType);
        this.justTotals = new CheckBox(LanguageHelper.getString("nl.ibs.fac.language", "JustTotals"));
        this.subPanel.add(this.justTotals);
        this.generalTotal = new CheckBox("Label.PrintGeneralTotal", false);
        this.subPanel.add(this.generalTotal);
        Action next = new Action("Button.Next").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("showSelectionPanel");
        next.setValidationEnabled(true);
        next.setDefault(true);
        this.fbShow.addAction(next);
        this.fbShow.addAction(this.finish);
        this.fbShowSelectionPanel.addAction(new Action("Button.Previous").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("show"));
        Action ok = new Action("Button.Complete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        this.fbShowSelectionPanel.addAction(ok);
        this.fbShowSelectionPanel.addAction(this.finish);
        this.reportTypeChangeAction.execute(object);
        this.assetSelection = new AssetSelection(object, false);
        this.assetSelection.hideFieldGroup = true;
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(this.title, "screen_name"));
        this.panel.setReadonly(false);
        object.addUIObject((UIObject)this.panel);
        this.subPanel.setReadonly(false);
        object.addUIObject((UIObject)this.subPanel);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject showSelectionPanel(DataObject object) throws Exception {
        this.assetSelection.setDisplayAttributes(this.asda[0], this.asda[1], this.asda[2], this.asda[3], this.asda[4], this.asda[5], this.asda[6], this.asda[7], this.asda[8], this.asda[9], this.asda[10], this.asda[11], this.asda[12]);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(this.title, "screen_name"));
        this.panel.setReadonly(true);
        object.addUIObject((UIObject)this.panel);
        this.subPanel.setReadonly(true);
        object.addUIObject((UIObject)this.subPanel);
        this.selectionPanel = this.assetSelection.getSelectionPanel(this.loginHelper);
        object.addUIObject((UIObject)this.selectionPanel);
        object.addUIObject((UIObject)this.fbShowSelectionPanel);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("User", this.loginHelper.getUser()));
        list.add(new NameValuePair("System", this.loginHelper.getSystem()));
        list.add(new NameValuePair("Password", Scrambler.scramble((String)this.loginHelper.getPassword())));
        list.add(new NameValuePair("facLib", this.dbData.getSchema()));
        list.add(new NameValuePair("Environment", this.env.getId()));
        list.add(new NameValuePair("Company", this.companyId));
        list.add(new NameValuePair("BookYear", this.bookYear));
        list.add(new NameValuePair("governmentActivated", "" + this.governmentActivated));
        list.add(new NameValuePair("BookYearFrom", "" + this.periodFrom.getBookYear().getIntValue()));
        list.add(new NameValuePair("PeriodFrom", "" + this.periodFrom.getPeriod().getIntValue()));
        list.add(new NameValuePair("BookYearTo", "" + this.periodTo.getBookYear().getIntValue()));
        list.add(new NameValuePair("PeriodTo", "" + this.periodTo.getPeriod().getIntValue()));
        list.add(new NameValuePair("AccountingPrinciple", this.accountingPrinciple.getSelectedOptionValue()));
        this.assetSelection.fldJustTotals.setValue(this.justTotals.getValueAsBoolean());
        this.assetSelection.fldGrandTotal.setValue(this.generalTotal.getValueAsBoolean());
        list.add(new NameValuePair(AssetSelection.ASSETSELECTION, this.assetSelection.getStringRepresentation()[0]));
        list.add(new NameValuePair(String.valueOf(AssetSelection.ASSETSELECTION) + "2", this.assetSelection.getStringRepresentation()[1]));
        this.assetSelection.save();
        this.getProcess().setAttribute("selections", (Object)NameValuePair.getStringArray(list));
        this.getProcess().setAttribute("title", (Object)this.title);
        this.getProcess().removeAttribute("classNameCSV");
        this.getProcess().removeAttribute("classNamePDF");
        if ("CSV".equals(this.reportType.getValue())) {
            this.getProcess().setAttribute("classNameCSV", (Object)this.classNameCSV);
        } else {
            this.getProcess().setAttribute("classNamePDF", (Object)this.classNamePDF);
        }
        this.getProcess().setAttribute("jobName", (Object)this.jobName);
        this.getProcess().setAttribute("backPage", (Object)PAGE);
        this.getProcess().setAttribute("backMethod", (Object)"show");
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "showInWindow", this.getProcess().getProcessId()));
        return object;
    }

    private class ReportTypeChangeAction
    extends Action {
        private static final long serialVersionUID = 1L;

        public boolean execute(DataObject dataObject) throws Exception {
            if ("CSV".equals(ReconciliationReportAdapter.this.reportType.getValue())) {
                ReconciliationReportAdapter.this.justTotals.setValue(false);
                ReconciliationReportAdapter.this.justTotals.setHidden(true);
                ReconciliationReportAdapter.this.generalTotal.setValue(false);
                ReconciliationReportAdapter.this.generalTotal.setHidden(true);
                ((ReconciliationReportAdapter)ReconciliationReportAdapter.this).asda[9] = false;
                ((ReconciliationReportAdapter)ReconciliationReportAdapter.this).asda[10] = false;
                ((ReconciliationReportAdapter)ReconciliationReportAdapter.this).asda[11] = true;
            } else if ("1".equals(ReconciliationReportAdapter.this.accountingPrinciple.getValue()) || "2".equals(ReconciliationReportAdapter.this.accountingPrinciple.getValue())) {
                ReconciliationReportAdapter.this.justTotals.setHidden(false);
                ReconciliationReportAdapter.this.generalTotal.setHidden(false);
                ((ReconciliationReportAdapter)ReconciliationReportAdapter.this).asda[9] = true;
                ((ReconciliationReportAdapter)ReconciliationReportAdapter.this).asda[10] = true;
                ((ReconciliationReportAdapter)ReconciliationReportAdapter.this).asda[11] = false;
            }
            return true;
        }
    }
}

