/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.Collection;
import java.util.Iterator;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.ReportDefinitionTypeEnum;
import nl.ibs.fac.ReportDefinitionUsageEnum;
import nl.ibs.fac.TransactionTypeEnum;
import nl.ibs.fac.adapters.BookYearField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.ReportDefinitionAdapter;
import nl.ibs.fac.adapters.ReportDefinitionTypeTransformer;
import nl.ibs.fac.adapters.ReportDefinitionUsageTransformer;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.reports.ReportDefinitionToCSV;
import nl.ibs.jsql.UserSetting;
import nl.ibs.jsql.UserSettings;
import nl.ibs.util.Scrambler;

public class ReportDefinitionReportAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -1339423283746262149L;
    public static final String PAGE = ReportDefinitionReportAdapter.class.getName();
    private static final String[] NAMES = new String[]{"key1", "value", "key2", "key3"};
    private static final String[] LABELS = new String[]{"Label.Id", "Label.Description", "Label.Type", "Label.Usage"};
    private static final short[] SIZES = new short[]{120, 250, 150, 150};
    private static final String[] TYPES = new String[4];
    private static final Transformer[] TRANSFORMERS;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] SEARCH_NAMES;
    private static final String[] SEARCH_LABELS;
    private static final String REFRESH = "refresh";
    private static final String CREATEFORM = "createForm";
    private static final String CREATE = "create";
    private static final String SHOW_ONTHEFLY_WINDOW = "showOnTheFlyWindow";
    private ComboBox cobType;
    private ComboBox cobUsage;
    private HeaderPanel headerPanel;
    private Field hpId;
    private Field hpName;
    private Field hpType;
    private Field hpUsage;
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbCreate = new FloatBar();
    private FloatBar fbOnTheFly = new FloatBar();
    private Action[] rowActions;
    private Action[] headerActions;
    private Window createWindow;
    private FieldGroup fg;
    private BookYearField bookYearForReport;
    private BookYearField toBookYearForReport;
    private NumberField fromPeriodForReport;
    private NumberField toPeriodForReport;
    private ComboBox accountingPrinciple = new ComboBox("Label.AccountingPrinciple");
    private boolean cbapInitialized = false;
    private ComboBox transactionType = TransactionTypeEnum.createComboBox("Label.TransactionType", TransactionTypeEnum.getCollection(), true);
    private Company company;
    private UserSettings userSettings;
    private CollectionTable definitionTable = null;
    private UserSetting reportDefinition;
    private int usage;
    private static final String CLASSNAMECSV;
    private static final String JOBNAME = "Job.ReportDefinitionToCSV";

    static {
        Transformer[] transformerArray = new Transformer[4];
        transformerArray[2] = new ReportDefinitionTypeTransformer();
        transformerArray[3] = new ReportDefinitionUsageTransformer();
        TRANSFORMERS = transformerArray;
        SEARCH_NAMES = new String[]{"key1", "value"};
        SEARCH_LABELS = new String[]{"Label.Id", "Label.Description"};
        CLASSNAMECSV = ReportDefinitionToCSV.CLASSNAME;
    }

    public ReportDefinitionReportAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.userSettings = new UserSettings("fac", "FACSYSBEH", this.env.getFacLib());
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        Action once = new Action("Button.Once").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SHOW_ONTHEFLY_WINDOW);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(once);
        this.fbShow.addAction(this.finish);
        Action createForm = new Action("Button.CreateCSVFile").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEFORM);
        this.rowActions = new Action[]{createForm};
        this.headerActions = new Action[]{refresh};
        Action createOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE);
        createOK.setValidationEnabled(true);
        createOK.setDefault(true);
        this.fbCreate.addAction(createOK);
        this.fbCreate.addAction(this.cancel);
        Action onTheFlyOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("performFieldSelection");
        onTheFlyOK.setValidationEnabled(true);
        onTheFlyOK.setDefault(true);
        this.fbOnTheFly.addAction(onTheFlyOK);
        this.fbOnTheFly.addAction(this.cancel);
        this.headerPanel = new HeaderPanel("");
        this.headerPanel.setForceBorder(true);
        this.headerPanel.setWidth(550);
        this.hpId = new Field("Label.Id");
        this.hpId.setLength(10);
        this.hpId.setReadonly(true);
        this.headerPanel.addUIObject((UIObject)this.hpId);
        this.hpName = new Field("Label.Description");
        this.hpName.setLength(40);
        this.headerPanel.addUIObject((UIObject)this.hpName);
        this.hpType = new Field("Label.Type");
        this.hpType.setLength(40);
        this.hpType.setReadonly(true);
        this.headerPanel.addUIObject((UIObject)this.hpType);
        this.hpUsage = new Field("Label.Usage");
        this.hpUsage.setLength(40);
        this.hpUsage.setReadonly(true);
        this.headerPanel.addUIObject((UIObject)this.hpUsage);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateCSVFiles", "screen_name"));
        if (this.definitionTable == null) {
            this.createTable();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.definitionTable);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        Collection reportDefinitions = this.userSettings.getSettings("FACReportDefinition", "RT");
        Iterator rdi = reportDefinitions.iterator();
        while (rdi.hasNext()) {
            UserSetting reportDefinition = (UserSetting)rdi.next();
            if (reportDefinition.getKey3() == null || reportDefinition.getKey3().length() <= 0 || reportDefinition.getKey3().equals(this.companyId)) continue;
            rdi.remove();
        }
        this.definitionTable = new CollectionTable(UserSetting.class, reportDefinitions, 12);
        this.definitionTable.setName(PAGE);
        this.definitionTable.setColumnNames(NAMES);
        this.definitionTable.setColumnLabels(LABELS);
        this.definitionTable.setColumnSizes(SIZES);
        this.definitionTable.setColumnTypes(TYPES);
        this.definitionTable.setDisplayTransformers(TRANSFORMERS);
        this.definitionTable.setSortable(true);
        this.definitionTable.setSelectable(false);
        TableHelper.createMenu((Table)this.definitionTable, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.definitionTable.createSearch(SEARCH_NAMES, SEARCH_LABELS);
        this.definitionTable.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.definitionTable = null;
        return this.show(object);
    }

    public DataObject showOnTheFlyWindow(DataObject object) throws Exception {
        Window window = new Window();
        window.setLabel("Title.CreateCSVFile");
        FieldGroup fg1 = new FieldGroup("");
        this.cobType = EnumHelper.createComboBox("Label.Type", ReportDefinitionTypeEnum.getCollection(this.governmentActivated), false);
        fg1.add(this.cobType);
        this.cobUsage = EnumHelper.createComboBox("Label.Usage", ReportDefinitionUsageEnum.getCollection(), false);
        fg1.add(this.cobUsage);
        window.add(fg1);
        this.initializeSelectionPanel();
        window.add(this.fg);
        FieldGroup fg3 = new FieldGroup();
        fg3.add(this.fbOnTheFly);
        window.add(fg3);
        object.addUIObject((UIObject)window);
        return object;
    }

    public DataObject performFieldSelection(DataObject object) throws Exception {
        this.getProcess().setAttribute("OnTheFlyReturnPage", (Object)this.getProcessAdapterPageName(PAGE));
        this.getProcess().setAttribute("OnTheFlyReturnMethod", (Object)"createOnTheFly");
        this.getProcess().setAttribute("OnTheFlyUser", (Object)this.loginHelper.getUser());
        this.getProcess().setAttribute("OnTheFlyId", (Object)object.translate("Label.NotApplicable.short", object.getLocale()));
        this.getProcess().setAttribute("OnTheFlyDescription", (Object)object.translate("Button.Once", object.getLocale()));
        this.getProcess().setAttribute("OnTheFlyType", (Object)this.cobType.getSelectedOptionValue());
        if (this.cobUsage.getSelectedOptionValue().equals("0")) {
            this.getProcess().setAttribute("OnTheFlyUsage", (Object)this.companyId);
        } else {
            this.getProcess().setAttribute("OnTheFlyUsage", (Object)" ");
        }
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(ReportDefinitionAdapter.PAGE), "createOnTheFly", this.getProcess().getProcessId()));
        return object;
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.reportDefinition = (UserSetting)TableHelper.getSelectedItem((DataObject)object);
        this.hpId.setValue(this.reportDefinition.getKey1());
        this.hpName.setValue(this.reportDefinition.getValue());
        this.hpType.setValue(ReportDefinitionTypeEnum.getValue(Integer.parseInt(this.reportDefinition.getKey2())));
        this.usage = this.companyId.equals(this.reportDefinition.getKey3()) ? 0 : 1;
        this.hpUsage.setValue(ReportDefinitionUsageEnum.getValue(this.usage));
        this.createWindow = new Window();
        this.createWindow.setLabel("Title.CreateCSVFile");
        this.createWindow.add(this.headerPanel);
        this.hpName.setReadonly(true);
        this.initializeSelectionPanel();
        this.createWindow.add(this.fg);
        FieldGroup dummy = new FieldGroup();
        dummy.add(this.fbCreate);
        this.createWindow.add(dummy);
        object.addUIObject((UIObject)this.createWindow);
        return object;
    }

    private void initializeSelectionPanel() throws Exception {
        this.fg = new FieldGroup();
        this.fg.forceBorder(true);
        this.bookYearForReport = new BookYearField("Label.BookYearFrom", this.bookYear, this.bookYearMin, this.bookYearMax);
        this.fg.add((Field)this.bookYearForReport);
        this.toBookYearForReport = new BookYearField("Label.BookYearTo", this.bookYear, this.bookYearMin, this.bookYearMax);
        this.fg.add((Field)this.toBookYearForReport);
        this.fromPeriodForReport = new BookYearField("Label.StartPeriod", "1", "1", "" + (this.numberOfPeriods + this.company.getNumberOfCorrectionPeriods()));
        this.fromPeriodForReport.setLength(2);
        this.fromPeriodForReport.setMaxLength(2);
        this.fg.add((Field)this.fromPeriodForReport);
        int toPeriod = this.company.getLastDepreciationRunPeriod();
        if (toPeriod == 0) {
            ++toPeriod;
        }
        this.toPeriodForReport = new BookYearField("Label.PeriodUntilIncluding", "" + toPeriod, "1", "" + (this.numberOfPeriods + this.company.getNumberOfCorrectionPeriods()));
        this.toPeriodForReport.setLength(2);
        this.toPeriodForReport.setMaxLength(2);
        this.fg.add((Field)this.toPeriodForReport);
        if (this.hpType.getValue().equals(ReportDefinitionTypeEnum.getValue(2)) || this.hpType.getValue().equals(ReportDefinitionTypeEnum.getValue(3))) {
            this.fg.add(this.transactionType);
        }
        int ap2Usage = this.company.getAccountingPrinciple2Usage();
        if (this.cbapInitialized) {
            this.accountingPrinciple.setSelectedOptionValue("1");
            if (ap2Usage != 0) {
                this.fg.add(this.accountingPrinciple);
            }
            return;
        }
        this.accountingPrinciple.addOption(this.env.getAPName1(), "1");
        this.accountingPrinciple.setSelectedOptionValue("1");
        if (ap2Usage < 0) {
            Company dataSet = (Company)CompanyBO.get(this.dbData, this.company.getDataSetId())[0];
            ap2Usage = dataSet.getAccountingPrinciple2Usage();
        }
        if (ap2Usage != 0) {
            this.accountingPrinciple.addOption(this.env.getAPName2(), "2");
            this.fg.add(this.accountingPrinciple);
        }
        this.cbapInitialized = true;
    }

    public DataObject create(DataObject object) throws Exception {
        String reportDefinitionKey = String.valueOf(this.reportDefinition.getUser()) + ";" + this.reportDefinition.getContext() + ";" + this.reportDefinition.getKey1() + ";" + this.reportDefinition.getKey2() + ";" + this.reportDefinition.getKey3();
        String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"System", this.loginHelper.getSystem()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"facLib", this.dbData.getSchema()}, {"Environment", this.env.getFacLib()}, {"Company", this.companyId}, {"reportDefinitionKey", reportDefinitionKey}, {"reportName", this.hpName.getValue()}, {"yearFrom", this.bookYearForReport.getValue()}, {"periodFrom", this.fromPeriodForReport.getValue()}, {"yearTo", this.toBookYearForReport.getValue()}, {"periodTo", this.toPeriodForReport.getValue()}, {"transactionType", this.transactionType.getValue()}, {"accountingPrinciple", this.accountingPrinciple.getSelectedOptionValue()}};
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("classNameCSV", (Object)CLASSNAMECSV);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("returnPage", (Object)PAGE);
        object = ((SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE)).submit(object);
        return object;
    }

    public DataObject createOnTheFly(DataObject object) throws Exception {
        String key3 = " ";
        if (this.cobUsage.getSelectedOptionValue().equals("0")) {
            key3 = this.companyId;
        }
        String reportDefinitionKey = String.valueOf(this.loginHelper.getUser()) + ";" + this.env.getFacLib() + ";" + object.translate("Label.NotApplicable.short", object.getLocale()) + ";" + this.cobType.getSelectedOptionValue() + ";" + key3;
        String[][] selections = new String[][]{{"User", this.loginHelper.getUser()}, {"System", this.loginHelper.getSystem()}, {"Password", Scrambler.scramble((String)this.loginHelper.getPassword())}, {"facLib", this.dbData.getSchema()}, {"Environment", this.env.getFacLib()}, {"Company", this.companyId}, {"reportDefinitionKey", reportDefinitionKey}, {"reportName", object.translate("Button.Once", object.getLocale())}, {"yearFrom", this.bookYearForReport.getValue()}, {"periodFrom", this.fromPeriodForReport.getValue()}, {"yearTo", this.toBookYearForReport.getValue()}, {"periodTo", this.toPeriodForReport.getValue()}, {"accountingPrinciple", this.accountingPrinciple.getSelectedOptionValue()}};
        this.getProcess().setAttribute("selections", (Object)selections);
        this.getProcess().setAttribute("classNameCSV", (Object)CLASSNAMECSV);
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("returnPage", (Object)PAGE);
        object = ((SubmitAdapter)this.getProcess().getAdapterByName(SubmitAdapter.PAGE)).submit(object);
        return object;
    }
}

