/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.Collection;
import nl.ibs.esp.adapter.Adapter;
import nl.ibs.esp.dataobject.BinaryObject;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.DateTransformer;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.LoginHelper;
import nl.ibs.fac.ReportFile;
import nl.ibs.fac.ReportFileHelper;
import nl.ibs.fac.adapters.FACAdapter;

public class ReportFileAdapter
extends FACAdapter {
    private static final long serialVersionUID = -1789043148175773369L;
    public static final String PAGE = ReportFileAdapter.class.getName();
    private Action[] rowActions;
    private Action[] headerActions;
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private CollectionTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] NAMES = new String[]{"shortName", "company", "user", "date", "time", "size"};
    private static final String[] LABELS = new String[]{"Label.Name", "Label.Company", "Label.User", "Label.Date", "Label.Time", "Label.Size"};
    private static final short[] SIZES = new short[]{350, 120, 90, 80, 70, 70};
    private static final Transformer[] TRANSFORMERS;
    private Object[] files;
    private LoginHelper loginHelper;

    static {
        Transformer[] transformerArray = new Transformer[6];
        transformerArray[3] = new DateTransformer();
        TRANSFORMERS = transformerArray;
    }

    public ReportFileAdapter(DataObject object) throws Exception {
        super(object);
        this.loginHelper = (LoginHelper)object.getSessionAttribute(LoginHelper.LOGINHELPER);
        Action download = new Action("Button.Download", (Adapter)this, "download");
        download.setIsDownloadAction(true);
        Action confirmDelete = new Action("Button.Delete", (Adapter)this, "confirmDelete");
        this.rowActions = new Action[]{download, confirmDelete};
        Action refresh = new Action("Button.Refresh", (Adapter)this, "refresh");
        this.headerActions = new Action[]{refresh};
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(download);
        this.fbShow.addAction(new Action("Button.SelectAll", (Adapter)this, "selectAll"));
        this.fbShow.addAction(confirmDelete);
        this.fbShow.addAction(this.finish);
        Action deleteOK = new Action("Button.OK", (Adapter)this, "delete");
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.ReportFiles", "screen_name"));
        if (this.table == null) {
            this.createTable();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        this.table = new CollectionTable(ReportFile.class, (Collection)ReportFileHelper.getFiles(this.loginHelper), 12);
        this.table.setName(PAGE);
        this.table.setIgnoreContext(Boolean.TRUE);
        this.table.setColumnNames(NAMES);
        this.table.setColumnLabels(LABELS);
        this.table.orderByColumn(NAMES[3]);
        this.table.setDescending(true);
        this.table.setColumnSizes(SIZES);
        this.table.setDisplayTransformers(TRANSFORMERS);
        this.table.setSortable(true);
        this.table.setMultipleSelectable();
        this.table.setAddSelectAllRowsContextMenuItem(true);
        this.table.setAddUnSelectAllRowsContextMenuItem(true);
        TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
        this.searchPanel = this.table.createSearch(NAMES, LABELS);
        this.searchPanel.setCSSClass("headerpanel");
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject download(DataObject object) throws Exception {
        Object[] files = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (files.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        if (files.length > 1) {
            object.addUIObject((UIObject)new Message("OnlyOneSelectionAllowed", "error"));
            return object;
        }
        String fileName = ((ReportFile)files[0]).getName();
        String type = "";
        if (fileName.indexOf("csv") > 0) {
            type = "application/vnd.ms-excel";
        } else if (fileName.indexOf("pdf") > 0) {
            type = "application/pdf";
        }
        BinaryObject bobj = new BinaryObject(ReportFileHelper.getBytes(this.loginHelper, fileName), type, object);
        bobj.openSaveAsDialog(((ReportFile)files[0]).getShortName());
        return bobj;
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.files = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteReportFiles", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.files.length);
        int i = 0;
        while (i < this.files.length) {
            list.add(this.files[i]);
            ++i;
        }
        CollectionTable table = new CollectionTable(ReportFile.class, list, 12);
        table.setName(PAGE);
        table.setIgnoreContext(Boolean.TRUE);
        table.setColumnNames(NAMES);
        table.setColumnLabels(LABELS);
        table.orderByColumn(NAMES[0]);
        table.setColumnSizes(SIZES);
        table.setDisplayTransformers(TRANSFORMERS);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        int i = 0;
        while (i < this.files.length) {
            ReportFile file = (ReportFile)this.files[i];
            if (file != null && !ReportFileHelper.delete(this.loginHelper, file.getName())) {
                object.addUIObject((UIObject)new Message(String.valueOf(file.getName()) + " " + object.translate("deletion_failed", object.getLocale()), "error"));
            }
            ++i;
        }
        this.table = null;
        return this.show(object);
    }

    public DataObject selectAll(DataObject object) throws Exception {
        TableHelper.selectAllRows((AbstractTable)this.table, (DataObject)object);
        return object;
    }

    public String getDescription() {
        return this.translate("Process.ReportFiles");
    }

    public String getShortDescription() {
        return "Process.ReportFiles.short";
    }
}

