/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.layout.ESPGridLayoutConstraints;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CheckBox;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.DateSelectionField;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.BatchJobHelper;
import nl.ibs.fac.CommandHelper;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.session.StartStopServlet;
import nl.ibs.jeelog.Log;

public class SubmitAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 4846439398578233410L;
    public static final String PAGE = SubmitAdapter.class.getName();
    public static final String START_ACTION_WINDOW = "showInWindow";
    public static final String BACK_PAGE = "backPage";
    public static final String BACK_METHOD = "backMethod";
    public static final String RETURN_PAGE = "returnPage";
    public static final String RETURN_METHOD = "returnMethod";
    public static final String HEADER = "header";
    public static final String WINDOWWIDTH = "windowWidth";
    public static final String TITLE = "title";
    public static final String SELECTIONS = "selections";
    public static final String RPGNAME = "RPGName";
    public static final String PREPROCESSOR = "preprocessor";
    public static final String CLASSNAME = "className";
    public static final String CLASSNAMECSV = "classNameCSV";
    public static final String CLASSNAMEPDF = "classNamePDF";
    public static final String JOBNAME = "jobName";
    public static final String CONFIRMATION_MSG = "confirmationMessage";
    public static final String SUBMIT = "submit";
    private Calendar cal = Calendar.getInstance();
    private DateSelectionField delayedUntilDate = new DateSelectionField("Label.NotSoonerThan");
    private CheckBox delayed = new CheckBox("Label.Delayed");
    private FieldGroup delayedGroup = new FieldGroup();
    private ComboBox delayedHours = new ComboBox("Label.Hours");
    private ComboBox delayedMinutes = new ComboBox("");
    public ComboBox fileType = new ComboBox("Label.FileType");

    public SubmitAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.fileType.addOption("", "");
        this.fileType.addOption("CSV", "CSV");
        this.fileType.addOption("PDF", "PDF");
        this.fileType.setWidth("60");
        this.fileType.setMandatory(true);
        int i = 0;
        while (i < 24) {
            if (String.valueOf(i).length() == 1) {
                this.delayedHours.addOption("0" + String.valueOf(i), String.valueOf(i));
            } else {
                this.delayedHours.addOption(String.valueOf(i), String.valueOf(i));
            }
            ++i;
        }
        i = 0;
        while (i < 60) {
            if (String.valueOf(i).length() == 1) {
                this.delayedMinutes.addOption("0" + String.valueOf(i), String.valueOf(i));
            } else {
                this.delayedMinutes.addOption(String.valueOf(i), String.valueOf(i));
            }
            ++i;
        }
        this.delayedHours.setWidth("44");
        this.delayedMinutes.setWidth("44");
        ESPGridLayout grid = new ESPGridLayout();
        grid.add((UIObject)this.delayedUntilDate, 1, 1, 1, 2, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_CENTER);
        grid.add((UIObject)this.delayedHours, 1, 3, 1, 2, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_CENTER);
        grid.add((UIObject)this.delayedMinutes, 1, 5, 1, 1, ESPGridLayoutConstraints.GRID_FILL_NONE, ESPGridLayoutConstraints.GRID_ANCHOR_CENTER);
        this.delayedGroup.add(grid);
        this.delayed.setAction((Action)new ChangeAction());
        this.delayedGroup.setHidden(true);
    }

    public DataObject showInWindow(DataObject object) throws Exception {
        Window window = new Window();
        int windowWidth = 350;
        if (this.getProcess().getAttribute(WINDOWWIDTH) != null) {
            windowWidth = Integer.parseInt((String)this.getProcess().getAttribute(WINDOWWIDTH));
        }
        window.setWidth(windowWidth);
        window.setLabel((String)this.getProcess().getAttribute(TITLE));
        FieldGroup fgHeader = (FieldGroup)this.getProcess().getAttribute(HEADER);
        if (fgHeader != null) {
            window.add(fgHeader);
        }
        FieldGroup fg = this.prepareFieldGroup();
        window.add(fg);
        window.add(this.delayedGroup);
        FieldGroup fb = new FieldGroup();
        FloatBar fbShow = this.prepareFloatBar(false);
        fb.add(fbShow);
        window.add(fb);
        object.addUIObject((UIObject)window);
        return object;
    }

    public DataObject show(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        String title = (String)this.getProcess().getAttribute(TITLE);
        object.addUIObject((UIObject)new Header(title, "screen_name"));
        UIObject fgHeader = (UIObject)this.getProcess().getAttribute(HEADER);
        if (fgHeader != null) {
            object.addUIObject(fgHeader);
        }
        FieldGroup fg = this.prepareFieldGroup();
        object.addUIObject((UIObject)fg);
        object.addUIObject((UIObject)this.delayedGroup);
        FloatBar fbShow = this.prepareFloatBar(true);
        object.addUIObject((UIObject)fbShow);
        return object;
    }

    private FieldGroup prepareFieldGroup() throws Exception {
        FieldGroup fg = new FieldGroup();
        this.fileType.setHidden(false);
        if (this.getProcess().getAttribute(CLASSNAMECSV) == null && this.getProcess().getAttribute(CLASSNAMEPDF) == null) {
            this.fileType.setHidden(true);
        } else if (this.getProcess().getAttribute(CLASSNAMECSV) != null && this.getProcess().getAttribute(CLASSNAMEPDF) != null) {
            fg.add(this.fileType);
        } else {
            if (this.getProcess().getAttribute(CLASSNAMECSV) != null) {
                this.fileType.setSelectedOptionValue("CSV");
            }
            if (this.getProcess().getAttribute(CLASSNAMEPDF) != null) {
                this.fileType.setSelectedOptionValue("PDF");
            }
        }
        this.delayedUntilDate.setValue(this.cal.getTime());
        this.delayedHours.setValueAsString(String.valueOf(this.cal.get(11)));
        this.delayedMinutes.setValueAsString(String.valueOf(this.cal.get(12)));
        fg.add(this.delayed);
        return fg;
    }

    private FloatBar prepareFloatBar(boolean addFinishAction) throws Exception {
        String page;
        FloatBar fbShow = new FloatBar();
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        fbShow.addAction(ok);
        if (this.getProcess().getAttribute(CONFIRMATION_MSG) != null) {
            String msg = (String)this.getProcess().getAttribute(CONFIRMATION_MSG);
            ok.setConfirmationMessage(msg);
        }
        if ((page = (String)this.getProcess().getAttribute(BACK_PAGE)) != null) {
            String method = (String)this.getProcess().getAttribute(BACK_METHOD);
            if (method == null) {
                method = "show";
            }
            fbShow.addAction(new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(page)).setMethod(method));
        }
        if (addFinishAction) {
            fbShow.addAction(this.finish);
        }
        return fbShow;
    }

    public DataObject submit(DataObject object) throws Exception {
        Date date = null;
        if (this.delayed.getValueAsBoolean()) {
            Date postponedDate = null;
            postponedDate = this.delayedUntilDate == null || this.delayedUntilDate.getValueAsDate() == null ? Calendar.getInstance().getTime() : this.delayedUntilDate.getValueAsDate();
            this.cal.setTime(postponedDate);
            if (this.delayedHours != null && this.delayedMinutes != null) {
                this.cal.set(11, Integer.parseInt(this.delayedHours.getValue()));
                this.cal.set(12, Integer.parseInt(this.delayedMinutes.getValue()));
            }
            date = this.cal.getTime();
        }
        String rpgName = (String)this.getProcess().getAttribute(RPGNAME);
        String className = (String)this.getProcess().getAttribute(CLASSNAME);
        String classNamePDF = (String)this.getProcess().getAttribute(CLASSNAMEPDF);
        String classNameCSV = (String)this.getProcess().getAttribute(CLASSNAMECSV);
        String jobName = (String)this.getProcess().getAttribute(JOBNAME);
        String[][] selections = (String[][])this.getProcess().getAttribute(SELECTIONS);
        Map map = BatchJobHelper.getSelections(selections);
        String companyId = (String)map.get("Company");
        String[] companyIds = companyId != null && companyId.indexOf(",") > 0 ? companyId.split(",") : new String[]{companyId};
        int i = 0;
        while (i < companyIds.length) {
            if (companyIds.length > 1) {
                BatchJobHelper.setCompanyId(selections, companyIds[i]);
            }
            String message = null;
            String preprocessor = (String)this.getProcess().getAttribute(PREPROCESSOR);
            if (preprocessor != null && (message = (String)CommandHelper.execute(preprocessor, selections)) != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return object;
            }
            String[] result = null;
            if (rpgName != null) {
                result = BatchJobHelper.submitRPG(this.loginHelper, jobName, rpgName, StartStopServlet.getObjectLibrary(), selections, date);
            } else if (Log.debug()) {
                message = this.fileType.isHidden() ? (String)CommandHelper.execute(className, selections) : (classNameCSV == null || this.fileType.getSelectedOptionValue().equals("PDF") ? (String)CommandHelper.execute(classNamePDF, selections) : (String)CommandHelper.execute(classNameCSV, selections));
            } else {
                result = this.fileType.isHidden() ? BatchJobHelper.submitJava(this.loginHelper, jobName, className, selections, date) : (classNameCSV == null || this.fileType.getSelectedOptionValue().equals("PDF") ? BatchJobHelper.submitJava(this.loginHelper, jobName, classNamePDF, selections, date) : BatchJobHelper.submitJava(this.loginHelper, jobName, classNameCSV, selections, date));
            }
            if (result != null && result[0] != null) {
                if ("CPC1221".equals(result[1])) {
                    object.addUIObject((UIObject)new Message(result[0]));
                } else {
                    object.addUIObject((UIObject)new Message(result[0], "error"));
                    return object;
                }
            }
            if (message != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
                return object;
            }
            ++i;
        }
        String page = (String)this.getProcess().getAttribute(RETURN_PAGE);
        if (page == null) {
            return this.finish(object);
        }
        String method = (String)this.getProcess().getAttribute(RETURN_METHOD);
        if (method == null) {
            method = "show";
        }
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(page), method, this.getProcess().getProcessId()));
        return object;
    }

    public Action getReturnAction() {
        String page = (String)this.getProcess().getAttribute(RETURN_PAGE);
        if (page != null) {
            String method = (String)this.getProcess().getAttribute(RETURN_METHOD);
            if (method == null) {
                method = "show";
            }
            return new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(page)).setMethod(method);
        }
        return null;
    }

    private class ChangeAction
    extends Action {
        private static final long serialVersionUID = -95011077132350820L;

        private ChangeAction() {
        }

        public boolean execute(DataObject object) throws Exception {
            SubmitAdapter.this.delayedGroup.setHidden(!SubmitAdapter.this.delayed.getValueAsBoolean());
            return true;
        }
    }
}

