/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.SubmitAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.bp.TransactionAggregationBP;
import nl.ibs.fac.commands.TransactionAggregationCommand;
import nl.ibs.fac.db.Company;
import nl.ibs.util.NameValuePair;
import nl.ibs.util.Scrambler;

public class TransactionAggregationAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -6563212465613474330L;
    public static final String PAGE = TransactionAggregationAdapter.class.getName();
    private HeaderPanel group1 = new HeaderPanel();
    private FieldGroup group2 = new FieldGroup();
    private static final String TITLE = "Title.TransactionAggregation";
    private static final String CLASSNAME = TransactionAggregationCommand.CLASSNAME;
    private static final String JOBNAME = "Job.TransactionAggregation";
    private Field initialBookYear = new Field("Label.StartYear");
    private Field lastDepreciationRunYear = new Field("Label.LastDepreciated");
    private Field lastAggregatedYear = new Field("Label.LastAggregatedYear");
    private Field aggregatingYear = new Field("Label.AggregatingYear");
    private FloatBar fbShow = new FloatBar();
    private static final String SUBMIT = "submit";
    private TransactionAggregationBP businessProcess;
    private Company company;

    public TransactionAggregationAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    protected void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.businessProcess = new TransactionAggregationBP(this.company, this.company.getNumberOfPeriods());
        String[] years = this.businessProcess.retrieveYears();
        this.group1.setWidth(600);
        this.initialBookYear.setValue(years[0]);
        this.initialBookYear.setReadonly(true);
        this.initialBookYear.setLength(5);
        this.initialBookYear.setType("number");
        this.group1.addUIObject((UIObject)this.initialBookYear);
        this.lastDepreciationRunYear.setValue(years[1]);
        this.lastDepreciationRunYear.setReadonly(true);
        this.lastDepreciationRunYear.setLength(5);
        this.lastDepreciationRunYear.setType("number");
        this.group1.addUIObject((UIObject)this.lastDepreciationRunYear);
        this.lastAggregatedYear.setValue(years[2]);
        this.lastAggregatedYear.setReadonly(true);
        this.lastAggregatedYear.setLength(5);
        this.lastAggregatedYear.setType("number");
        this.group2.add(this.lastAggregatedYear);
        this.aggregatingYear.setValue(years[3]);
        this.aggregatingYear.setReadonly(true);
        this.aggregatingYear.setLength(5);
        this.aggregatingYear.setType("number");
        this.group2.add(this.aggregatingYear);
        Action ok = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(SUBMIT);
        ok.setValidationEnabled(true);
        ok.setDefault(true);
        this.fbShow.addAction(ok);
        this.fbShow.addAction(this.finish);
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.companyId == null) {
            object.addUIObject((UIObject)new Message("NoActiveCompany", "error"));
            return this.finish(object);
        }
        if (this.company.getAggregationInProgress()) {
            object.addUIObject((UIObject)new Message("ProcessAlreadyInProgressOrEndedAbnormally", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(TITLE, "screen_name"));
        object.addUIObject((UIObject)this.group1);
        object.addUIObject((UIObject)this.group2);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    public DataObject submit(DataObject object) throws Exception {
        boolean error = this.validate(object);
        if (error) {
            return object;
        }
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add(new NameValuePair("User", this.loginHelper.getUser()));
        list.add(new NameValuePair("System", this.loginHelper.getSystem()));
        list.add(new NameValuePair("Password", Scrambler.scramble((String)this.loginHelper.getPassword())));
        list.add(new NameValuePair("facLib", this.dbData.getSchema()));
        list.add(new NameValuePair("Environment", this.env.getId()));
        list.add(new NameValuePair("Company", this.companyId));
        list.add(new NameValuePair("BookYear", this.bookYear));
        list.add(new NameValuePair("governmentActivated", "" + this.governmentActivated));
        list.add(new NameValuePair(TransactionAggregationBP.BOOKYEAR, this.aggregatingYear.getValue()));
        this.getProcess().setAttribute("selections", (Object)NameValuePair.getStringArray(list));
        this.getProcess().setAttribute("className", (Object)CLASSNAME);
        this.getProcess().setAttribute("title", (Object)object.translate(TITLE, object.getLocale()));
        this.getProcess().setAttribute("jobName", (Object)JOBNAME);
        this.getProcess().setAttribute("header", (Object)this.group2);
        object.addUIObject((UIObject)new RedirectAction(this.getProcessAdapterPageName(SubmitAdapter.PAGE), "show", this.getProcess().getProcessId()));
        return object;
    }

    private boolean validate(DataObject object) throws Exception {
        boolean error = false;
        String[] errors = null;
        String s = this.aggregatingYear.getValue().trim();
        int yearToAggregate = s.length() == 0 ? 0 : Integer.valueOf(s);
        errors = this.businessProcess.validate(this.company, yearToAggregate);
        if (errors != null) {
            error = true;
            this.addErrors(object, errors);
            this.aggregatingYear.setInvalidTag();
        }
        return error;
    }

    private void addErrors(DataObject object, String[] errors) throws Exception {
        int i = 0;
        while (i < errors.length) {
            if (errors[i] != null && errors[i].trim().length() > 0) {
                object.addUIObject((UIObject)new Message(errors[i], "error"));
            }
            ++i;
        }
    }
}

