/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.ComboBox;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.InputComponent;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.ReferenceField;
import nl.ibs.esp.uiobjects.Tab;
import nl.ibs.esp.uiobjects.TabbedPanel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.esp.util.Transformer;
import nl.ibs.fac.EnumHelper;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ReasonCodeEnum;
import nl.ibs.fac.TransactionBatchCodeEnum;
import nl.ibs.fac.TransactionBatchStateEnum;
import nl.ibs.fac.TransactionTypeEnum;
import nl.ibs.fac.adapters.AssetReferenceField;
import nl.ibs.fac.adapters.CurrentTransactionBatchInfoProcess;
import nl.ibs.fac.adapters.DepreciationProposalInfoProcess;
import nl.ibs.fac.adapters.DepreciationProposalsPostAdapter;
import nl.ibs.fac.adapters.DepreciationProposalsPostProcess;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.adapters.ReasonCodeImageTransformer;
import nl.ibs.fac.adapters.TransactionAdapter;
import nl.ibs.fac.adapters.TransactionBatchAdapter;
import nl.ibs.fac.adapters.TransactionBatchProcess;
import nl.ibs.fac.adapters.TransactionTypeTransformer;
import nl.ibs.fac.adapters.ZeroBigDecimalToBlankTransformer;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.gov.adapters.CreditReferenceField;
import nl.ibs.fac.gov.boadapters.CreditBO;
import nl.ibs.fac.queries.TransactionQuery;

public class TransactionBatchTransactionAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = -2568366251375341593L;
    private static final Class CLASS = TransactionBatchTransactionAdapter.class;
    public static final String PAGE = CLASS.getName();
    public static final String SHOWINTERNAL = "showInternal";
    private TransactionBatch transactionBatch;
    private String theTitle;
    private Panel headerPanel;
    private TabbedPanel tabbedPanel;
    private Tab[] tabs = new Tab[4];
    private String[] tabTexts = new String[4];
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private int tableSize;
    private static final ZeroBigDecimalToBlankTransformer DECIMALTRANSFORMER = new ZeroBigDecimalToBlankTransformer();
    private static final String[] TOOLTIPS = new String[]{"Label.ReasonCode"};
    private static final String[] CB_NAMES = new String[]{"documentAndSequenceNumber", "transactionType", "amount1", "amount2", "valueForAmount3", "assetId", "FACYearAndPeriod"};
    private static final String[] CB_LABELS = new String[]{"Label.TransNbrShort", "Label.TransactionType", "Label.Acquisition", "Label.Depreciation", "Label.Interest", "Label.Asset", "Label.Period"};
    private static final short[] CB_SIZES = new short[]{100, 150, 120, 120, 120, 120, 80};
    private static String[] CB_TYPES;
    private static Transformer[] CB_TRANSFORMERS;
    private static final boolean[] CB_COLUMNNOWRAPS;
    private static final boolean[] CB_SORTABLE;
    private static final String[] CB_SEARCH_NAMES;
    private static final String[] CB_SEARCH_LABELS;
    private static final String[] CBC_NAMES;
    private static final String[] CBC_LABELS;
    private static final short[] CBC_SIZES;
    private static String[] CBC_TYPES;
    private static Transformer[] CBC_TRANSFORMERS;
    private static final boolean[] CBC_COLUMNNOWRAPS;
    private static final boolean[] CBC_SORTABLE;
    private static final String[] CBC_SEARCH_NAMES;
    private static final String[] CBC_SEARCH_LABELS;
    private static final String[] DP_NAMES;
    private static final String[] DP_LABELS;
    private static final short[] DP_SIZES;
    private static final String[] DP_TYPES;
    private static final Transformer[] DP_TRANSFORMERS;
    private static final boolean[] DP_COLUMNNOWRAPS;
    private static final boolean[] DP_SORTABLE;
    private static final String[] DP_SEARCH_NAMES;
    private static final String[] DP_SEARCH_LABELS;
    private static final String[] DPC_NAMES;
    private static final String[] DPC_LABELS;
    private static final short[] DPC_SIZES;
    private static final String[] DPC_TYPES;
    private static final Transformer[] DPC_TRANSFORMERS;
    private static final boolean[] DPC_COLUMNNOWRAPS;
    private static final boolean[] DPC_SORTABLE;
    private static final String[] DPC_SEARCH_NAMES;
    private static final String[] DPC_SEARCH_LABELS;
    private Map<String, InputComponent> cb_inputComponents = new HashMap<String, InputComponent>();
    private Map<String, InputComponent> cbc_inputComponents = new HashMap<String, InputComponent>();
    private Map<String, InputComponent> dp_inputComponents = new HashMap<String, InputComponent>();
    private Map<String, InputComponent> dpc_inputComponents = new HashMap<String, InputComponent>();
    private static final String REFRESH = "refresh";
    private FloatBar fbShow = new FloatBar();
    private Action[] rowActions;
    private Action[] headerActions;
    private Company company;
    private NumericIdTransformer numericIdTransformer = new NumericIdTransformer();

    static {
        String[] stringArray = new String[7];
        stringArray[1] = "text";
        CB_TYPES = stringArray;
        Transformer[] transformerArray = new Transformer[7];
        transformerArray[1] = new TransactionTypeTransformer();
        transformerArray[2] = DECIMALTRANSFORMER;
        transformerArray[3] = DECIMALTRANSFORMER;
        transformerArray[4] = DECIMALTRANSFORMER;
        CB_TRANSFORMERS = transformerArray;
        CB_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true};
        boolean[] blArray = new boolean[7];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        CB_SORTABLE = blArray;
        CB_SEARCH_NAMES = new String[]{"documentNr", "transactionType", "assetId", "bookYear"};
        CB_SEARCH_LABELS = new String[]{"Label.Transaction", "Label.TransactionType", "Label.Asset", "Label.Year"};
        CBC_NAMES = new String[]{"documentAndSequenceNumber", "transactionType", "amount1", "amount2", "valueForAmount3", "creditId", "FACYearAndPeriod"};
        CBC_LABELS = new String[]{"Label.TransNbrShort", "Label.TransactionType", "Label.Acquisition", "Label.Depreciation", "Label.Interest", "Label.Credit", "Label.Period"};
        CBC_SIZES = new short[]{100, 150, 120, 120, 120, 120, 80};
        String[] stringArray2 = new String[7];
        stringArray2[1] = "text";
        CBC_TYPES = stringArray2;
        Transformer[] transformerArray2 = new Transformer[7];
        transformerArray2[1] = new TransactionTypeTransformer();
        transformerArray2[2] = DECIMALTRANSFORMER;
        transformerArray2[3] = DECIMALTRANSFORMER;
        transformerArray2[4] = DECIMALTRANSFORMER;
        CBC_TRANSFORMERS = transformerArray2;
        CBC_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true};
        boolean[] blArray2 = new boolean[7];
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        CBC_SORTABLE = blArray2;
        CBC_SEARCH_NAMES = new String[]{"documentNr", "transactionType", "creditId", "bookYear"};
        CBC_SEARCH_LABELS = new String[]{"Label.Transaction", "Label.TransactionType", "Label.Credit", "Label.Year"};
        DP_NAMES = new String[]{"documentAndSequenceNumber", "amount2", "amount3", "assetId", "FACYearAndPeriod", "reasonCode", "amount1"};
        DP_LABELS = new String[]{"Label.TransNbrShort", "Label.Depreciation", "Label.Interest", "Label.Asset", "Label.Period", "Label.ReasonCode", ""};
        DP_SIZES = new short[]{100, 120, 120, 120, 80, 20, 120};
        String[] stringArray3 = new String[7];
        stringArray3[5] = "text";
        DP_TYPES = stringArray3;
        Transformer[] transformerArray3 = new Transformer[7];
        transformerArray3[1] = DECIMALTRANSFORMER;
        transformerArray3[2] = DECIMALTRANSFORMER;
        transformerArray3[5] = new ReasonCodeImageTransformer();
        transformerArray3[6] = DECIMALTRANSFORMER;
        DP_TRANSFORMERS = transformerArray3;
        DP_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true};
        boolean[] blArray3 = new boolean[7];
        blArray3[1] = true;
        blArray3[2] = true;
        blArray3[3] = true;
        blArray3[5] = true;
        blArray3[6] = true;
        DP_SORTABLE = blArray3;
        DP_SEARCH_NAMES = new String[]{"documentNr", "assetId", "bookYear", "reasonCode"};
        DP_SEARCH_LABELS = new String[]{"Label.Transaction", "Label.Asset", "Label.Year", "Label.ReasonCode"};
        DPC_NAMES = new String[]{"documentAndSequenceNumber", "amount2", "amount3", "creditId", "FACYearAndPeriod", "reasonCode", "amount1"};
        DPC_LABELS = new String[]{"Label.TransNbrShort", "Label.Depreciation", "Label.Interest", "Label.Credit", "Label.Period", "Label.ReasonCode", ""};
        DPC_SIZES = new short[]{100, 120, 120, 120, 80, 20, 120};
        String[] stringArray4 = new String[7];
        stringArray4[5] = "text";
        DPC_TYPES = stringArray4;
        Transformer[] transformerArray4 = new Transformer[7];
        transformerArray4[1] = DECIMALTRANSFORMER;
        transformerArray4[2] = DECIMALTRANSFORMER;
        transformerArray4[5] = new ReasonCodeImageTransformer();
        transformerArray4[6] = DECIMALTRANSFORMER;
        DPC_TRANSFORMERS = transformerArray4;
        DPC_COLUMNNOWRAPS = new boolean[]{true, true, true, true, true, true, true};
        boolean[] blArray4 = new boolean[7];
        blArray4[1] = true;
        blArray4[2] = true;
        blArray4[3] = true;
        blArray4[5] = true;
        blArray4[6] = true;
        DPC_SORTABLE = blArray4;
        DPC_SEARCH_NAMES = new String[]{"documentNr", "creditId", "bookYear", "reasonCode"};
        DPC_SEARCH_LABELS = new String[]{"Label.Transaction", "Label.Credit", "Label.Year", "Label.ReasonCode"};
    }

    public TransactionBatchTransactionAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Action back;
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.tabTexts[0] = this.env.getAPShortName1();
        this.tabTexts[1] = this.env.getAPShortName2();
        this.tabTexts[2] = this.env.getAPShortName3();
        this.tabTexts[3] = this.env.getAPShortName4();
        if (this.getProcess() instanceof TransactionBatchProcess) {
            this.theTitle = "Title.MaintainTransactionBatches_Transactions";
            back = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(TransactionBatchAdapter.PAGE)).setMethod("show");
            this.fbShow.addAction(back);
        } else if (this.getProcess() instanceof DepreciationProposalsPostProcess) {
            this.theTitle = "Title.InquiryDepreciationProposal_Transactions";
            back = new Action("Button.Back").setAdapter(this.getProcessAdapterPageName(DepreciationProposalsPostAdapter.PAGE)).setMethod("show");
            this.fbShow.addAction(back);
        } else if (this.getProcess() instanceof CurrentTransactionBatchInfoProcess) {
            this.theTitle = "Title.InquiryCurrentTransactionBatch_Transactions";
        } else if (this.getProcess() instanceof DepreciationProposalInfoProcess) {
            this.theTitle = "Title.InquiryDepreciationProposal_Transactions";
        }
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(this.finish);
        this.headerActions = new Action[]{refresh};
        Action details = new Action("Button.Details").setAdapter(this.getProcessAdapterPageName(TransactionAdapter.PAGE)).setMethod("show");
        this.rowActions = new Action[]{details};
    }

    public DataObject show(DataObject object) throws Exception {
        ComboBox comboBox;
        this.transactionBatch = (TransactionBatch)this.getProcess().getAttribute("TransactionBatch");
        if (this.transactionBatch == null) {
            this.transactionBatch = (TransactionBatch)TableHelper.getSelectedItem((DataObject)object);
            if (this.transactionBatch.getBatchCode() == 3 && this.transactionBatch.getState() == 0) {
                object.addUIObject((UIObject)new Message("InquiryNotPossible_UseAppropriateMenuOption", "error"));
                return object;
            }
            this.getProcess().setAttribute("TransactionBatch", (Object)this.transactionBatch);
        }
        this.tableSize = 12;
        if (this.transactionBatch.getBatchCode() == 0 || this.transactionBatch.getBatchCode() == 3) {
            if (AssetBO.isIdNumeric(this.company, false)) {
                TransactionBatchTransactionAdapter.CB_TYPES[5] = "number";
                TransactionBatchTransactionAdapter.CB_TRANSFORMERS[5] = this.numericIdTransformer;
            }
            comboBox = EnumHelper.createComboBox("Label.TransactionType", TransactionTypeEnum.getCollection(), true);
            comboBox.setWidth("170");
            this.cb_inputComponents.put("transactionType", (InputComponent)comboBox);
            this.cb_inputComponents.put("assetId", (InputComponent)new AssetReferenceField(this.company, null, null, true, false));
            if (this.governmentActivated) {
                if (CreditBO.isIdNumeric(this.company)) {
                    TransactionBatchTransactionAdapter.CBC_TYPES[5] = "number";
                    TransactionBatchTransactionAdapter.CBC_TRANSFORMERS[5] = this.numericIdTransformer;
                }
                this.cbc_inputComponents.put("transactionType", (InputComponent)comboBox);
                this.cbc_inputComponents.put("creditId", (InputComponent)new CreditReferenceField(this.company, true));
            }
        } else if (this.transactionBatch.getBatchCode() == 1) {
            if (AssetBO.isIdNumeric(this.company, false)) {
                TransactionBatchTransactionAdapter.DP_TYPES[3] = "number";
                TransactionBatchTransactionAdapter.DP_TRANSFORMERS[3] = this.numericIdTransformer;
            }
            comboBox = EnumHelper.createComboBox("Label.ReasonCode", ReasonCodeEnum.getCollection(), true);
            comboBox.removeOption(comboBox.getOptionByValue("52"));
            comboBox.setWidth("170");
            this.dp_inputComponents.put("reasonCode", (InputComponent)comboBox);
            this.dp_inputComponents.put("assetId", (InputComponent)new AssetReferenceField(this.company, null, null, true, false));
            if (this.governmentActivated) {
                if (CreditBO.isIdNumeric(this.company)) {
                    TransactionBatchTransactionAdapter.DPC_TYPES[3] = "number";
                    TransactionBatchTransactionAdapter.DPC_TRANSFORMERS[3] = this.numericIdTransformer;
                }
                this.dpc_inputComponents.put("reasonCode", (InputComponent)comboBox);
                this.dpc_inputComponents.put("creditId", (InputComponent)new CreditReferenceField(this.company, true));
            }
        }
        if (this.transactionBatch.getCompanyId().equals(this.companyId)) {
            this.headerPanel = TransactionBatchTransactionAdapter.getHeaderPanel(this.transactionBatch, null);
        } else {
            HeaderPanel thePanel = new HeaderPanel();
            thePanel.setWidth(550);
            ReferenceField crf = new ReferenceField("Label.Company");
            crf.setReadonly(true);
            crf.setDescriptionLength("40");
            Company theCompany = (Company)CompanyBO.get(this.dbData, this.transactionBatch.getCompanyId())[0];
            crf.setValue(theCompany.getId());
            crf.setDescription(theCompany.getDescription());
            thePanel.addUIObject((UIObject)crf);
            this.headerPanel = TransactionBatchTransactionAdapter.getHeaderPanel(this.transactionBatch, (Panel)thePanel);
        }
        return this.refresh(object);
    }

    public static Panel getHeaderPanel(TransactionBatch transactionBatch) throws Exception {
        return TransactionBatchTransactionAdapter.getHeaderPanel(transactionBatch, null);
    }

    public static Panel getHeaderPanel(TransactionBatch transactionBatch, Panel thePanel) throws Exception {
        Panel panel;
        if (thePanel == null) {
            panel = new HeaderPanel();
            panel.setWidth(550);
        } else {
            panel = thePanel;
        }
        String batchType = TransactionBatchCodeEnum.getValue(transactionBatch.getBatchCode());
        Field field = new Field(batchType, "text", null, "" + transactionBatch.getBatchId(), 10);
        field.setHelpId("batchType");
        field.setReadonly(true);
        panel.addUIObject((UIObject)field);
        String periodDescription = "";
        if (transactionBatch.getEndYear() != 0) {
            periodDescription = transactionBatch.getBatchCode() == 0 || transactionBatch.getBatchCode() == 3 ? "Label.ProcessingPeriod" : "Label.PeriodUntilIncluding";
        }
        if (periodDescription != "") {
            field = new Field(periodDescription, "text", null, PeriodHelper.toString(transactionBatch.getEndYear(), transactionBatch.getEndPeriod()), 10);
            field.setReadonly(true);
            panel.addUIObject((UIObject)field);
        }
        field = new Field("Label.State", "text", null, TransactionBatchStateEnum.getValue(transactionBatch.getState()), 20);
        field.setReadonly(true);
        panel.addUIObject((UIObject)field);
        return panel;
    }

    public DataObject showInternal(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header(this.theTitle, "screen_name"));
        object.addUIObject((UIObject)this.headerPanel);
        if (this.table == null) {
            this.tabbedPanel = new TabbedPanel();
            boolean setActiveTab = false;
            boolean activeTabSet = false;
            Tab activeTab = null;
            int i = 0;
            while (i < 4) {
                this.tabs[i] = new Tab(this.tabTexts[i]);
                TransactionQuery query = new TransactionQuery(this.dbData, this.transactionBatch, i + 1);
                Collection fetchedData = query.fetchData(null, null, null, 1);
                if (fetchedData != null && !fetchedData.isEmpty()) {
                    this.createTable(i + 1);
                    this.tabs[i].add((Panel)this.searchPanel);
                    this.tabs[i].add((Table)this.table);
                    setActiveTab = true;
                } else {
                    this.tabs[i].setHidden(true);
                }
                this.tabbedPanel.add(this.tabs[i]);
                if (!activeTabSet && setActiveTab) {
                    activeTab = this.tabs[i];
                    activeTabSet = true;
                }
                ++i;
            }
            if (activeTab != null) {
                this.tabbedPanel.setActiveTab(activeTab);
            }
        }
        object.addUIObject((UIObject)this.tabbedPanel);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable(int accountingPrinciple) throws Exception {
        TransactionQuery query = new TransactionQuery(this.dbData, this.transactionBatch, accountingPrinciple);
        this.table = new ODBTable(Transaction.class, (ODBQuery)query, new String[]{"documentNr", "seqNr"}, this.tableSize);
        this.table.setCounter((ODBCounter)query);
        if (this.transactionBatch.getBatchCode() == 0 || this.transactionBatch.getBatchCode() == 3) {
            if (this.governmentActivated && accountingPrinciple == 3) {
                this.table.setName("CBC_Table" + accountingPrinciple);
                this.table.setColumnNames(CBC_NAMES);
                this.table.setColumnLabels(CBC_LABELS);
                this.table.setColumnSizes(CBC_SIZES);
                this.table.setColumnTypes(CBC_TYPES);
                this.table.setDisplayTransformers(CBC_TRANSFORMERS);
                this.table.setColumnNoWraps(CBC_COLUMNNOWRAPS);
                this.table.setColumnSortable(CBC_SORTABLE);
                this.table.setInputComponents(this.cbc_inputComponents);
                this.table.setSortable(true);
                this.table.setSelectable(false);
                TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
                this.searchPanel = this.table.createSearch(CBC_SEARCH_NAMES, CBC_SEARCH_LABELS);
                Action filterAction = this.table.createFilterAction(CBC_SEARCH_NAMES, CBC_SEARCH_LABELS, 3);
                this.searchPanel.addAction(filterAction);
                this.table.reload();
            } else {
                this.table.setName("CB_Table" + accountingPrinciple);
                this.table.setColumnNames(CB_NAMES);
                this.table.setColumnLabels(CB_LABELS);
                this.table.setColumnSizes(CB_SIZES);
                this.table.setColumnTypes(CB_TYPES);
                this.table.setDisplayTransformers(CB_TRANSFORMERS);
                this.table.setColumnNoWraps(CB_COLUMNNOWRAPS);
                this.table.setColumnSortable(CB_SORTABLE);
                this.table.setInputComponents(this.cb_inputComponents);
                this.table.setSortable(true);
                this.table.setSelectable(false);
                TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
                this.searchPanel = this.table.createSearch(CB_SEARCH_NAMES, CB_SEARCH_LABELS);
                Action filterAction = this.table.createFilterAction(CB_SEARCH_NAMES, CB_SEARCH_LABELS, 3);
                this.searchPanel.addAction(filterAction);
                this.table.reload();
            }
        } else if (this.transactionBatch.getBatchCode() == 1) {
            if (this.governmentActivated && accountingPrinciple == 3) {
                this.table.setName("DP_Table" + accountingPrinciple);
                this.table.setColumnNames(DPC_NAMES);
                this.table.setColumnLabels(DPC_LABELS);
                this.table.setColumnSizes(DPC_SIZES);
                this.table.setColumnTypes(DPC_TYPES);
                this.table.setDisplayTransformers(DPC_TRANSFORMERS);
                this.table.setColumnNoWraps(DPC_COLUMNNOWRAPS);
                this.table.setColumnSortable(DPC_SORTABLE);
                this.table.setInputComponents(this.dpc_inputComponents);
                this.table.setSortable(true);
                this.table.setSelectable(false);
                TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
                this.searchPanel = this.table.createSearch(DPC_SEARCH_NAMES, DPC_SEARCH_LABELS);
                Action filterAction = this.table.createFilterAction(DPC_SEARCH_NAMES, DPC_SEARCH_LABELS, 3);
                this.searchPanel.addAction(filterAction);
                this.table.reload();
                TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
            } else {
                this.table.setName("DP_Table" + accountingPrinciple);
                this.table.setColumnNames(DP_NAMES);
                this.table.setColumnLabels(DP_LABELS);
                this.table.setColumnSizes(DP_SIZES);
                this.table.setColumnTypes(DP_TYPES);
                this.table.setDisplayTransformers(DP_TRANSFORMERS);
                this.table.setColumnNoWraps(DP_COLUMNNOWRAPS);
                this.table.setColumnSortable(DP_SORTABLE);
                this.table.setInputComponents(this.dp_inputComponents);
                this.table.setSortable(true);
                this.table.setSelectable(false);
                TableHelper.createMenu((Table)this.table, (Action[])this.headerActions, (Action[])this.rowActions);
                this.searchPanel = this.table.createSearch(DP_SEARCH_NAMES, DP_SEARCH_LABELS);
                Action filterAction = this.table.createFilterAction(DP_SEARCH_NAMES, DP_SEARCH_LABELS, 3);
                this.searchPanel.addAction(filterAction);
                this.table.reload();
                TableHelper.setHeaderTooltips((CommonTable)this.table, (String[])TOOLTIPS);
            }
        }
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.showInternal(object);
    }
}

