/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.helpers.TableHelper;
import nl.ibs.esp.uiobjects.AbstractTable;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.CollectionTable;
import nl.ibs.esp.uiobjects.CommonTable;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Header;
import nl.ibs.esp.uiobjects.HeaderPanel;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.ODBQuery;
import nl.ibs.esp.uiobjects.ODBTable;
import nl.ibs.esp.uiobjects.Panel;
import nl.ibs.esp.uiobjects.Table;
import nl.ibs.esp.uiobjects.TableRow;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.esp.util.ODBCounter;
import nl.ibs.fac.MenuOptionValue;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.MenuOptionBO;
import nl.ibs.fac.boadapters.UserGroupBO;
import nl.ibs.fac.db.UserGroup;
import nl.ibs.fac.queries.UserGroupQuery;
import nl.ibs.fac.ui.FACMenuBarHelper;

public class UserGroupMenuAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 2462585062809029808L;
    public static final String PAGE = UserGroupMenuAdapter.class.getName();
    public static final String REFRESH = "refresh";
    private static final String CREATEFORM = "createForm";
    private static final String CREATE = "create";
    private static final String COPYFORM = "copyForm";
    private static final String EDITFORM = "editForm";
    private static final String EDIT = "edit";
    private static final String CONFIRMDELETE = "confirmDelete";
    private static final String DELETE = "delete";
    private ODBTable table = null;
    private CommonTable.SearchPanel searchPanel;
    private static final String[] UGNAMES = new String[]{"id", "description"};
    private static final String[] UGLABELS = new String[]{"Label.Id", "Label.Description"};
    private static final short[] UGSIZES = new short[]{120, 450};
    protected Action[] ugRowActions;
    protected Action[] ugHeaderActions;
    private Panel header = new HeaderPanel();
    private Field id = new Field("Label.Id", "upper");
    private Field desc = new Field("Label.Description");
    private FloatBar fbShow = new FloatBar();
    private FloatBar fbCreate = new FloatBar();
    private FloatBar fbEdit = new FloatBar();
    private FloatBar fbDelete = new FloatBar();
    private UserGroup userGroup;
    private Object[] userGroups;
    private Window window;
    private Field toId = new Field("Label.Id", "upper");
    private Field toDesc = new Field("Label.Description");
    private Action[] optionsHeaderActions;
    private List<Object> options;
    private CollectionTable optionsTable = null;
    private static final String[] OPTIONSNAMES = new String[]{"name"};
    private static final String[] OPTIONSLABELS = new String[]{"Menu's en menu opties"};
    private static final short[] OPTIONSSIZES = new short[]{570};

    public UserGroupMenuAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        Action refresh = new Action("Button.Refresh").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(REFRESH);
        Action create = new Action("Button.Create").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATEFORM);
        Action copy = new Action("Button.Copy").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(COPYFORM);
        Action edit = new Action("Button.Edit").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDITFORM);
        Action confirmDelete = new Action("Button.Delete").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CONFIRMDELETE);
        this.ugRowActions = new Action[]{edit, copy, confirmDelete};
        this.ugHeaderActions = new Action[]{refresh, create};
        this.id.setMandatory(true);
        this.id.setLength(10);
        this.id.setMaxLength(10);
        this.id.setHelpId("Label.UserGroupId");
        this.header.addUIObject((UIObject)this.id);
        this.desc.setLength(50);
        this.desc.setMaxLength(50);
        this.header.addUIObject((UIObject)this.desc);
        this.fbShow.addAction(refresh);
        this.fbShow.addAction(create);
        this.fbShow.addAction(copy);
        this.fbShow.addAction(confirmDelete);
        this.fbShow.addAction(this.finish);
        Action createOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(CREATE);
        createOK.setValidationEnabled(true);
        createOK.setDefault(true);
        this.fbCreate.addAction(createOK);
        this.fbCreate.addAction(this.cancel);
        this.fbCreate.addAction(this.finish);
        Action editOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(EDIT);
        Action addAll = new Action("Button.AddAll").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("addAll");
        Action removeAll = new Action("Button.RemoveAll").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("removeAll");
        editOK.setValidationEnabled(true);
        editOK.setDefault(true);
        this.fbEdit.addAction(editOK);
        this.fbEdit.addAction(addAll);
        this.fbEdit.addAction(removeAll);
        this.fbEdit.addAction(this.cancel);
        this.fbEdit.addAction(this.finish);
        Action deleteOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod(DELETE);
        this.fbDelete.addAction(deleteOK);
        this.fbDelete.addAction(this.back);
        this.fbDelete.addAction(this.finish);
        this.optionsHeaderActions = new Action[]{addAll, removeAll};
    }

    public DataObject show(DataObject object) throws Exception {
        if (this.env == null) {
            object.addUIObject((UIObject)new Message("NoActiveEnvironment", "error"));
            return this.finish(object);
        }
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.UserGroups", "screen_name"));
        this.id.setValue();
        this.desc.setValue();
        if (this.table == null) {
            this.createTable();
        } else {
            this.table.undoSelections();
        }
        object.addUIObject((UIObject)this.searchPanel);
        object.addUIObject((UIObject)this.table);
        object.addUIObject((UIObject)this.fbShow);
        return object;
    }

    private void createTable() throws Exception {
        UserGroupQuery query = new UserGroupQuery();
        this.table = new ODBTable(UserGroup.class, (ODBQuery)query, new String[]{"id"}, 12);
        this.table.setName("UG_" + PAGE);
        this.table.setCounter((ODBCounter)query);
        this.table.setIgnoreContext(Boolean.TRUE);
        this.table.setColumnNames(UGNAMES);
        this.table.setColumnLabels(UGLABELS);
        this.table.setColumnSizes(UGSIZES);
        this.table.setSortable(true);
        this.table.setMultipleSelect(true);
        TableHelper.createMenu((Table)this.table, (Action[])this.ugHeaderActions, (Action[])this.ugRowActions);
        this.searchPanel = this.table.createSearch(UGNAMES, UGLABELS);
        this.searchPanel.setCSSClass("headerpanel");
        Action filterAction = this.table.createFilterAction(UGNAMES, UGLABELS, 3);
        this.searchPanel.addAction(filterAction);
        this.table.reload();
    }

    public DataObject refresh(DataObject object) throws Exception {
        this.table = null;
        return this.show(object);
    }

    public DataObject createForm(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.CreateUserGroup", "screen_name"));
        this.id.setReadonly(false);
        object.addUIObject((UIObject)this.header);
        object.addUIObject((UIObject)this.fbCreate);
        return object;
    }

    public DataObject create(DataObject object) throws Exception {
        Object[] result = UserGroupBO.create(this.id.getValue().trim(), this.desc.getValue().trim());
        String message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return this.createForm(object);
        }
        this.userGroup = (UserGroup)result[0];
        this.table.setPointer("id", (Object)this.id.getValue().trim(), true);
        this.table.reload();
        return this.editFormContinued(object);
    }

    public DataObject editForm(DataObject object) throws Exception {
        this.userGroup = (UserGroup)TableHelper.getSelectedItem((DataObject)object);
        return this.editFormContinued(object);
    }

    private DataObject editFormContinued(DataObject object) throws Exception {
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.EditUserGroup", "screen_name"));
        this.id.setValue(this.userGroup.getId());
        this.desc.setValue(this.userGroup.getDescription());
        this.id.setReadonly(true);
        object.addUIObject((UIObject)this.header);
        this.createOptionsTable(object);
        object.addUIObject((UIObject)this.optionsTable);
        object.addUIObject((UIObject)this.fbEdit);
        return object;
    }

    public DataObject edit(DataObject object) throws Exception {
        String message = UserGroupBO.update(this.userGroup, this.desc.getValue().trim());
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        ArrayList selected = this.optionsTable.getSelectedObjects();
        boolean removeItems = false;
        for (MenuOptionValue menuOptionValue : this.options) {
            if (menuOptionValue.getValue().startsWith("Menu.")) {
                removeItems = !selected.contains((Object)menuOptionValue);
                continue;
            }
            if (!removeItems) continue;
            selected.remove((Object)menuOptionValue);
        }
        MenuOptionBO.revokeAll(this.id.getValue());
        MenuOptionBO.addOptions(this.id.getValue(), selected);
        this.table.setPointer("id", (Object)this.id.getValue().trim(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject copyForm(DataObject object) throws Exception {
        this.userGroups = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        if (this.userGroups.length == 0) {
            object.addUIObject((UIObject)new Message("NothingSelected", "error"));
            return object;
        }
        if (this.userGroups.length > 1) {
            object.addUIObject((UIObject)new Message("OnlyOneSelectionAllowed", "error"));
            return object;
        }
        this.userGroup = (UserGroup)this.userGroups[0];
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "show");
        this.window.setLabel("Title.CopyUserGroup");
        object.addUIObject((UIObject)this.window);
        FieldGroup windowGroup = new FieldGroup();
        this.toId.setValue();
        this.toId.setMandatory(true);
        this.toId.setLength(10);
        this.toId.setMaxLength(10);
        windowGroup.add(this.toId);
        this.toDesc.setValue();
        this.toDesc.setLength(50);
        this.toDesc.setMaxLength(50);
        windowGroup.add(this.toDesc);
        this.window.add(windowGroup);
        Action copyOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("copy");
        copyOK.setValidationEnabled(true);
        copyOK.setDefault(true);
        this.window.add(copyOK);
        return object;
    }

    public DataObject copy(DataObject object) throws Exception {
        Object[] result = UserGroupBO.create(this.toId.getValue().trim(), this.toDesc.getValue().trim());
        String message = (String)result[1];
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        MenuOptionBO.copyAll(this.userGroup.getId(), this.toId.getValue());
        this.table.unSelect((Object)this.userGroup);
        this.table.setPointer("id", (Object)this.toId.getValue().trim(), true);
        this.table.reload();
        return this.show(object);
    }

    public DataObject confirmDelete(DataObject object) throws Exception {
        this.userGroups = TableHelper.getSelectedItems((AbstractTable)this.table, (DataObject)object);
        this.clearScreen(true, false, true);
        object.addUIObject((UIObject)new Header("Title.DeleteUserGroups", "screen_name"));
        object.addUIObject((UIObject)this.createConfirmationTable());
        object.addUIObject((UIObject)this.fbDelete);
        return object;
    }

    private CollectionTable createConfirmationTable() throws Exception {
        ArrayList<Object> list = new ArrayList<Object>(this.userGroups.length);
        int i = 0;
        while (i < this.userGroups.length) {
            list.add(this.userGroups[i]);
            ++i;
        }
        CollectionTable table = new CollectionTable(UserGroup.class, list, 12);
        table.setName(PAGE);
        table.setIgnoreContext(Boolean.TRUE);
        table.setColumnNames(UGNAMES);
        table.setColumnLabels(UGLABELS);
        table.orderByColumn(UGNAMES[0]);
        table.setColumnSizes(UGSIZES);
        table.setSortable(true);
        table.reload();
        return table;
    }

    public DataObject delete(DataObject object) throws Exception {
        String message = null;
        int i = 0;
        while (i < this.userGroups.length) {
            UserGroup userGroup = (UserGroup)this.userGroups[i];
            if (userGroup != null && (message = UserGroupBO.delete(userGroup)) != null) {
                object.addUIObject((UIObject)new Message(message, "error"));
            }
            ++i;
        }
        if (message != null) {
            return object;
        }
        this.table = null;
        return this.show(object);
    }

    public DataObject addAll(DataObject object) throws Exception {
        TableHelper.selectAllRows((AbstractTable)this.optionsTable, (DataObject)object, (boolean)true);
        return object;
    }

    public DataObject removeAll(DataObject object) throws Exception {
        TableHelper.selectAllRows((AbstractTable)this.optionsTable, (DataObject)object, (boolean)false);
        return object;
    }

    private void createOptionsTable(DataObject object) throws Exception {
        this.options = new ArrayList<Object>();
        Iterator iterator = FACMenuBarHelper.getUSERMenuOptions(this.governmentActivated).iterator();
        List list = MenuOptionBO.getOptions(this.id.getValue().trim());
        while (iterator.hasNext()) {
            String option = (String)iterator.next();
            String name = object.translate(option, object.getLocale());
            name = option.startsWith("Menu.") ? name.toUpperCase() : "&nbsp;&nbsp;" + name;
            this.options.add((Object)new MenuOptionValue(name, option, list.contains(option)));
        }
        this.optionsTable = new CollectionTable(MenuOptionValue.class, this.options, 12);
        this.optionsTable.setName("MO_" + PAGE);
        this.optionsTable.setIgnoreContext(Boolean.TRUE);
        this.optionsTable.setColumnNames(OPTIONSNAMES);
        this.optionsTable.setColumnLabels(OPTIONSLABELS);
        this.optionsTable.setColumnSizes(OPTIONSSIZES);
        this.optionsTable.setMultipleSelectable();
        TableHelper.createMenu((Table)this.optionsTable, (Action[])this.optionsHeaderActions, null);
        this.optionsTable.reload();
        this.optionsTable.setLastPage();
        for (TableRow row : this.optionsTable.getRows()) {
            MenuOptionValue menuOptionValue = (MenuOptionValue)((Object)row.getObject());
            if (!menuOptionValue.getEnabled()) continue;
            row.setSelected(true);
        }
        this.optionsTable.setFirstPage();
    }
}

