/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.adapters;

import java.math.BigDecimal;
import java.math.BigInteger;
import nl.ibs.esp.adapter.ESPProcess;
import nl.ibs.esp.dataobject.DataObject;
import nl.ibs.esp.layout.ESPGridLayout;
import nl.ibs.esp.uiobjects.Action;
import nl.ibs.esp.uiobjects.Field;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.esp.uiobjects.FloatBar;
import nl.ibs.esp.uiobjects.Message;
import nl.ibs.esp.uiobjects.NumberField;
import nl.ibs.esp.uiobjects.RedirectAction;
import nl.ibs.esp.uiobjects.UIObject;
import nl.ibs.esp.uiobjects.Window;
import nl.ibs.fac.adapters.BookYearPeriodGrid;
import nl.ibs.fac.adapters.FACDecimalField;
import nl.ibs.fac.adapters.FACProcessAwareAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.ValuationCorrectionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Valuation;

public class ValuationCorrectionAdapter
extends FACProcessAwareAdapter {
    private static final long serialVersionUID = 6209443191944130465L;
    public static final String PAGE = ValuationCorrectionAdapter.class.getName();
    public static final String RETURNPAGE = "ValuationCorrectionAdapterReturnPage";
    public static final String RETURNMETHOD = "ValuationCorrectionAdapterReturnMethod";
    private Company company;
    private String[] fgTexts = new String[2];
    private FieldGroup[] fg1 = new FieldGroup[2];
    private FieldGroup[] fg2 = new FieldGroup[2];
    private FACDecimalField[] residualValue = new FACDecimalField[2];
    private FACDecimalField[] residualPercentage = new FACDecimalField[2];
    private NumberField[] depreciatableLife = new NumberField[3];
    private BookYearPeriodGrid[] activationPeriods = new BookYearPeriodGrid[2];
    private BookYearPeriodGrid[] financialBookPeriods = new BookYearPeriodGrid[2];
    private Field description = new Field();
    private FieldGroup fg3 = new FieldGroup("Label.Description");
    private FieldGroup fgCorrection;
    private Asset asset;
    private Window window;
    private ValuationCorrectionBP businessProcess;
    private Valuation[] valuations = new Valuation[2];
    private int[] facYears = new int[2];
    private int[] facPeriods = new int[2];
    private int[] finYears = new int[2];
    private int[] finPeriods = new int[2];
    private int[] depreciatableLifes = new int[2];
    private BigDecimal[] residualPercentages = new BigDecimal[2];
    private BigDecimal[] residualValues = new BigDecimal[2];
    private boolean[] changeValuations;
    private int[] descriptionHelpers;

    public ValuationCorrectionAdapter(ESPProcess process, DataObject object) throws Exception {
        super(process, object);
        if (this.companyId == null) {
            return;
        }
        this.initialize(object);
    }

    private void initialize(DataObject object) throws Exception {
        this.company = (Company)CompanyBO.get(this.dbData, this.companyId)[0];
        this.businessProcess = new ValuationCorrectionBP(this.company, this.numberOfPeriods);
        this.fgTexts[0] = this.governmentActivated ? "" : this.env.getAPName1();
        this.fgTexts[1] = this.env.getAPName2();
        int i = 0;
        while (i < 2) {
            this.fg1[i] = new FieldGroup(this.fgTexts[i]);
            this.depreciatableLife[i] = new NumberField("Label.DepreciationLife", 4, false);
            this.fg1[i].add((Field)this.depreciatableLife[i]);
            this.residualPercentage[i] = new FACDecimalField("Label.ResidualValuePercentage", 5, 2);
            this.residualPercentage[i].setMinValue(new BigDecimal(0), true);
            this.residualPercentage[i].setMaxValue(new BigDecimal(100), true);
            this.fg1[i].add((Field)this.residualPercentage[i]);
            this.residualValue[i] = new FACDecimalField("Label.ResidualValueAmount", 15, 2);
            this.fg1[i].add((Field)this.residualValue[i]);
            this.fg2[i] = new FieldGroup();
            this.activationPeriods[i] = new BookYearPeriodGrid("Label.FACStartPeriod", this.bookYear, this.bookYearMin, this.bookYearMax, this.numberOfPeriods);
            this.fg2[i].add((ESPGridLayout)this.activationPeriods[i]);
            this.financialBookPeriods[i] = new BookYearPeriodGrid("Label.BookPeriod", false);
            this.fg2[i].add((ESPGridLayout)this.financialBookPeriods[i]);
            this.fg1[i].add(this.fg2[i]);
            ++i;
        }
        this.fg3.add(this.description);
        this.description.setDiscardLabel(true);
        this.description.setLength(50);
        this.description.setMaxLength(30);
        Action correctionOK = new Action("Button.OK").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("createCorrections");
        correctionOK.setDefault(true);
        correctionOK.setValidationEnabled(true);
        FloatBar fb = new FloatBar();
        fb.addAction(correctionOK);
        fb.addAction(new Action("Button.Cancel").setAdapter(this.getProcessAdapterPageName(PAGE)).setMethod("close"));
        this.fgCorrection = new FieldGroup();
        this.fgCorrection.forceBorder(false);
        this.fgCorrection.add(fb);
    }

    public DataObject correctionForm(DataObject object) throws Exception {
        this.asset = (Asset)this.getProcess().getAttribute("correctionAsset");
        String message = this.businessProcess.hasNotPostedTransactions(this.asset);
        if (message != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        this.retrieveYearsAndPeriods();
        int i = 0;
        while (i < 2 && this.valuations[i] != null) {
            this.residualPercentage[i].setValue(this.valuations[i].getResidualPercentage());
            this.residualValue[i].setValue(this.valuations[i].getResidualValue());
            this.depreciatableLife[i].setValue((long)this.valuations[i].getDepreciatableLife());
            this.depreciatableLife[i].setMinValue(new BigInteger("" + this.valuations[i].getNumberOfDepreciatedPeriods()), true);
            if (this.valuations[i].getDepreciationMethod() == 99) {
                this.depreciatableLife[i].setReadonly(true);
                this.residualPercentage[i].setReadonly(true);
                this.residualValue[i].setReadonly(true);
                this.activationPeriods[i].setMandatory(false);
                this.activationPeriods[i].setReadonly(true);
            }
            ++i;
        }
        this.window = new Window(this.getProcess().getProcessAdapterName(PAGE), "close");
        this.window.setLabel("Title.EditValuationData");
        if (this.valuations[0].getLastDepreciationBookYear() > 0) {
            this.window.add(this.fg1[0]);
        }
        if (this.valuations[1] != null && this.valuations[1].getLastDepreciationBookYear() > 0) {
            this.window.add(this.fg1[1]);
        }
        this.description.setValue();
        this.window.add(this.fg3);
        this.window.add(this.fgCorrection);
        object.addUIObject((UIObject)this.window);
        return object;
    }

    public DataObject createCorrections(DataObject object) throws Exception {
        String message;
        boolean error0 = false;
        boolean error1 = false;
        this.changeValuations = new boolean[2];
        this.descriptionHelpers = new int[2];
        this.fg1[0].removeInvalidTags();
        error0 = this.validateForCorrection(object, 0);
        if (this.valuations[1] != null) {
            this.fg1[1].removeInvalidTags();
            error1 = this.validateForCorrection(object, 1);
        }
        if (error0 || error1) {
            return object;
        }
        if (!this.changeValuations[0] && !this.changeValuations[1]) {
            this.addErrors(object, new String[]{"no_changes"});
            return object;
        }
        this.fillUpArrays(0);
        if (this.valuations[1] != null) {
            this.fillUpArrays(1);
        }
        if ((message = this.businessProcess.updateValuations(this.asset, this.valuations, this.facYears, this.facPeriods, this.finYears, this.finPeriods, this.changeValuations, this.depreciatableLifes, this.residualPercentages, this.residualValues, this.description.getValue().trim(), this.descriptionHelpers, this.loginHelper.getUser(), -1, 0)) != null) {
            object.addUIObject((UIObject)new Message(message, "error"));
            return object;
        }
        return this.close(object);
    }

    public boolean validateForCorrection(DataObject object, int index) throws Exception {
        String[] messages = null;
        boolean error = false;
        this.changeValuations[index] = false;
        if (this.depreciatableLife[index].getIntValue() == this.valuations[index].getDepreciatableLife() && this.residualPercentage[index].getBigDecimal().doubleValue() == this.valuations[index].getResidualPercentage().doubleValue() && this.residualValue[index].getBigDecimal().doubleValue() == this.valuations[index].getResidualValue().doubleValue()) {
            return error;
        }
        this.changeValuations[index] = true;
        if (this.valuations[index].getDepreciationMethod() == 11) {
            error = true;
            this.addErrors(object, new String[]{"action_not_allowed_for_depreciationmethod_annuity"});
        }
        this.descriptionHelpers[index] = 0;
        if (this.depreciatableLife[index].getIntValue() != this.valuations[index].getDepreciatableLife()) {
            this.descriptionHelpers[index] = this.descriptionHelpers[index] + 1;
        }
        if (this.residualPercentage[index].getBigDecimal().doubleValue() != this.valuations[index].getResidualPercentage().doubleValue() || this.residualValue[index].getBigDecimal().doubleValue() != this.valuations[index].getResidualValue().doubleValue()) {
            this.descriptionHelpers[index] = this.descriptionHelpers[index] + 2;
        }
        if (this.residualValue[index].getDoubleValue() != 0.0 && this.residualPercentage[index].getDoubleValue() > 0.0) {
            error = true;
            this.addErrors(object, new String[]{"provide_only_one_value"});
            this.residualValue[index].setInvalidTag();
            this.residualPercentage[index].setInvalidTag();
            return error;
        }
        messages = this.businessProcess.validateFACYearAndPeriod(this.valuations[index], this.activationPeriods[index].getBookYear().getIntValue(), this.activationPeriods[index].getPeriod().getIntValue());
        if (messages != null) {
            error = true;
            this.addErrors(object, messages);
            this.activationPeriods[index].setInvalidTag();
        }
        if ((messages = this.businessProcess.validateFINYearAndPeriod(this.financialBookPeriods[index].getBookYear().getIntValue(), this.financialBookPeriods[index].getPeriod().getIntValue(), Integer.parseInt(this.bookYearMin), Integer.parseInt(this.bookYearMax))) != null) {
            error = true;
            this.addErrors(object, messages);
            this.financialBookPeriods[index].setInvalidTag();
        }
        if (this.residualPercentage[index].getBigDecimal().doubleValue() != this.valuations[index].getResidualPercentage().doubleValue() && (messages = this.businessProcess.validateResidualValue(this.asset, this.valuations[index], null, this.activationPeriods[index].getBookYear().getIntValue(), this.activationPeriods[index].getPeriod().getIntValue(), this.residualPercentage[index].getBigDecimal())) != null) {
            error = true;
            this.addErrors(object, messages);
            this.residualPercentage[index].setInvalidTag();
        }
        if (this.residualValue[index].getBigDecimal().doubleValue() != this.valuations[index].getResidualValue().doubleValue() && (messages = this.businessProcess.validateResidualValue(this.asset, this.valuations[index], this.residualValue[index].getBigDecimal(), this.activationPeriods[index].getBookYear().getIntValue(), this.activationPeriods[index].getPeriod().getIntValue(), null)) != null) {
            error = true;
            this.addErrors(object, messages);
            this.residualValue[index].setInvalidTag();
        }
        return error;
    }

    private void addErrors(DataObject object, String[] errors) throws Exception {
        int i = 0;
        while (i < errors.length) {
            if (errors[i] != null && errors[i].trim().length() > 0) {
                object.addUIObject((UIObject)new Message(errors[i], "error"));
            }
            ++i;
        }
    }

    public DataObject close(DataObject object) throws Exception {
        this.window.closeWindow(object);
        object.addUIObject((UIObject)new RedirectAction(this.getProcess().getAttribute(RETURNPAGE).toString(), this.getProcess().getAttribute(RETURNMETHOD).toString(), this.getProcess().getProcessId()));
        return object;
    }

    private void retrieveYearsAndPeriods() throws Exception {
        this.valuations[0] = (Valuation)ValuationBO.get(this.company.getDBData(), this.company.getId(), this.asset.getCora(), this.asset.getId(), 1)[0];
        String[] yps = this.businessProcess.retrieveYearsAndPeriods(this.valuations[0]);
        this.activationPeriods[0].setValues(yps[0], yps[1]);
        this.financialBookPeriods[0].setValues(yps[2], yps[3]);
        this.valuations[1] = (Valuation)ValuationBO.get(this.company.getDBData(), this.company.getId(), this.asset.getCora(), this.asset.getId(), 2)[0];
        if (this.valuations[1] != null) {
            yps = this.businessProcess.retrieveYearsAndPeriods(this.valuations[1]);
            this.activationPeriods[1].setValues(yps[0], yps[1]);
            this.financialBookPeriods[1].setValues(yps[2], yps[3]);
        }
    }

    private void fillUpArrays(int index) throws Exception {
        this.facYears[index] = this.activationPeriods[index].getBookYear().getIntValue();
        this.facPeriods[index] = this.activationPeriods[index].getPeriod().getIntValue();
        this.finYears[index] = this.financialBookPeriods[index].getBookYear().getIntValue();
        this.finPeriods[index] = this.financialBookPeriods[index].getPeriod().getIntValue();
        this.depreciatableLifes[index] = this.depreciatableLife[index].getIntValue();
        this.residualPercentages[index] = this.residualPercentage[index].getBigDecimal();
        this.residualValues[index] = this.residualValue[index].getBigDecimal();
    }
}

