/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.AnalysisCode;
import nl.ibs.fac.db.AnalysisCodeDataBean;
import nl.ibs.fac.db.AnalysisCodeManager;
import nl.ibs.fac.db.AnalysisCodeManagerFactory;
import nl.ibs.fac.db.AnalysisCodePK;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.exception.FinderException;

public abstract class AnalysisCodeBO
extends BOAdapter {
    public static Object[] get(DBData dbData, AnalysisGroup analysisGroup, String code) throws Exception {
        Object[] result = new Object[2];
        AnalysisCodePK key = new AnalysisCodePK();
        key.setCompanyId(analysisGroup.getCompanyId());
        key.setSeqNr(analysisGroup.getSeqNr());
        key.setCode(AnalysisGroupBO.formatCode(analysisGroup, code));
        try {
            result[0] = AnalysisCodeManagerFactory.getInstance(dbData).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Object[] create(DBData dbData, AnalysisGroup analysisGroup, String code, String description) throws Exception {
        if (code.length() == 0) {
            AnalysisCodeManager manager = AnalysisCodeManagerFactory.getInstance(dbData);
            code = manager.getCodeMax(analysisGroup.getCompanyId(), analysisGroup.getSeqNr());
            int startValue = 0;
            if (code != null) {
                try {
                    startValue = Integer.parseInt(code);
                }
                catch (RuntimeException e) {
                    Object[] result = new Object[2];
                    result[1] = "autoNumber_value_not_numeric";
                    return result;
                }
            }
            code = code == null || startValue < analysisGroup.getStartValue() ? "" + analysisGroup.getStartValue() : "" + (Integer.parseInt(code) + 1);
        } else if (analysisGroup.getType().equals("N")) {
            try {
                if (Integer.parseInt(code) <= 0) {
                    Object[] result = new Object[2];
                    result[1] = "value_must_be_positive";
                    return result;
                }
            }
            catch (NumberFormatException e) {
                Object[] result = new Object[2];
                result[1] = "not_a_number";
                return result;
            }
        }
        return AnalysisCodeBO.create(dbData, analysisGroup.getCompanyId(), analysisGroup.getSeqNr(), code, description);
    }

    public static Object[] create(DBData dbData, String companyId, int seqNr, String code, String description) throws Exception {
        Object[] result = AnalysisGroupBO.get(dbData, companyId, seqNr);
        if (result[1] != null) {
            return result;
        }
        AnalysisGroup analysisGroup = (AnalysisGroup)result[0];
        AnalysisCodeManager manager = AnalysisCodeManagerFactory.getInstance(dbData);
        AnalysisCodeDataBean bean = new AnalysisCodeDataBean();
        bean.setCompanyId(companyId);
        bean.setSeqNr(seqNr);
        bean.setCode(AnalysisGroupBO.formatCode(analysisGroup, code));
        bean.setDescription(description);
        result = new Object[2];
        try {
            result[0] = manager.create(bean);
        }
        catch (Exception e) {
            result[1] = AnalysisCodeBO.investigate(e, null);
        }
        return result;
    }

    public static String update(AnalysisCode analysisCode, String description) throws Exception {
        try {
            analysisCode.setDescription(description);
        }
        catch (Exception e) {
            return AnalysisCodeBO.investigate(e, null);
        }
        return null;
    }

    public static String delete(AnalysisCode analysisCode) throws Exception {
        try {
            analysisCode.delete();
        }
        catch (Exception e) {
            return AnalysisCodeBO.investigate(e, null);
        }
        return null;
    }
}

