/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.AnalysisGroupDataBean;
import nl.ibs.fac.db.AnalysisGroupManager;
import nl.ibs.fac.db.AnalysisGroupManagerFactory;
import nl.ibs.fac.db.AnalysisGroupPK;
import nl.ibs.fac.db.Environment;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class AnalysisGroupBO
extends BOAdapter {
    public static Object[] get(DBData dbData, String companyId, int seqNr) throws Exception {
        Object[] result = new Object[2];
        AnalysisGroupPK key = new AnalysisGroupPK();
        key.setCompanyId(companyId);
        key.setSeqNr(seqNr);
        try {
            result[0] = AnalysisGroupManagerFactory.getInstance(dbData).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Collection getAnalysisGroups(Map map) throws Exception {
        ExecutableQuery query = QueryFactory.create(AnalysisGroup.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String companyId = (String)map.get("Company");
        String filter = AnalysisGroupBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        query.setFilter(filter);
        query.setParameters(parameters);
        AnalysisGroupManager manager = AnalysisGroupManagerFactory.getInstance(BOAdapter.getDBData(map));
        return manager.getCollection(query);
    }

    public static void disableAnalysisGroup(DBData dbData, String companyId, int seqNr) throws Exception {
        AnalysisGroup group = (AnalysisGroup)AnalysisGroupBO.get(dbData, companyId, seqNr)[0];
        if (group == null) {
            return;
        }
        group.setNotUsed(true);
        AssetTypeBO.disableExternalAnalysisGroup(dbData, companyId, seqNr);
    }

    public static void enableAnalysisGroup(DBData dbData, String companyId, int seqNr) throws Exception {
        AnalysisGroup group = (AnalysisGroup)AnalysisGroupBO.get(dbData, companyId, seqNr)[0];
        group.setNotUsed(false);
    }

    public static String formatCode(AnalysisGroup analysisGroup, String code) throws Exception {
        if (analysisGroup.getType().equals("N")) {
            DecimalFormat formatter = new DecimalFormat("0000000000");
            try {
                code = formatter.format(Integer.parseInt(code));
                code = code.substring(10 - analysisGroup.getLength());
            }
            catch (RuntimeException e) {
                return code;
            }
        }
        return code;
    }

    public static String unFormatCode(AnalysisGroup analysisGroup, String code) throws Exception {
        if (analysisGroup.getType().equals("N")) {
            return (String)new NumericIdTransformer().transform(code);
        }
        return code;
    }

    public static Object[] create(DBData dbData, String companyId, int seqNr, int usage, String name, String shortName, String type, int length, int decimals, boolean autoNumber, int startValue) throws Exception {
        Object[] result = new Object[2];
        String message = AnalysisGroupBO.validateName(dbData, companyId, name);
        if (message != null) {
            result[1] = message;
            return result;
        }
        AnalysisGroupManager manager = AnalysisGroupManagerFactory.getInstance(dbData);
        AnalysisGroupDataBean bean = new AnalysisGroupDataBean();
        bean.setCompanyId(companyId);
        if (seqNr == 0) {
            seqNr = manager.getSeqNrMax(companyId) + 1;
        }
        bean.setSeqNr(seqNr);
        bean.setUsage(usage);
        bean.setName(name);
        bean.setShortName(shortName);
        bean.setType(type);
        if (type.equals("N") && length > 9) {
            length = 9;
        }
        bean.setLength(length);
        bean.setDecimals(decimals);
        bean.setAutoNumber(autoNumber);
        if (autoNumber) {
            if (startValue < 0) {
                result[1] = "value_must_be_positive";
                return result;
            }
            bean.setStartValue(startValue);
        } else {
            bean.setStartValue(0);
        }
        boolean alreadyActive = AnalysisGroupBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            AnalysisGroupBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = AnalysisGroupBO.investigate(e, dbTransaction);
        }
        return result;
    }

    private static String validateName(DBData dbData, String companyId, String name) throws Exception {
        AnalysisGroupManager manager = AnalysisGroupManagerFactory.getInstance(dbData);
        ExecutableQuery qry = QueryFactory.create(AnalysisGroup.class, null, "seqNr");
        qry.setFilter("companyId = ?_companyId AND name = ?_name");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", companyId);
        parameters.put("_name", name);
        qry.setParameters(parameters);
        if (manager.getFirstObject(qry) != null) {
            return "duplicate_key";
        }
        return null;
    }

    public static String update(AnalysisGroup analysisGroup, int usage, String name, String shortName, String type, int length, int decimals, boolean autoNumber, int startValue) throws Exception {
        String message;
        if (!name.equals(analysisGroup.getName()) && (message = AnalysisGroupBO.validateName(analysisGroup.getDBData(), analysisGroup.getCompanyId(), name)) != null) {
            return message;
        }
        if (autoNumber && startValue < 0) {
            return "value_must_be_positive";
        }
        boolean alreadyActive = AnalysisGroupBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            analysisGroup.setUsage(usage);
            analysisGroup.setName(name);
            analysisGroup.setShortName(shortName);
            analysisGroup.setType(type);
            analysisGroup.setLength(length);
            analysisGroup.setDecimals(decimals);
            analysisGroup.setAutoNumber(autoNumber);
            if (autoNumber) {
                analysisGroup.setStartValue(startValue);
            } else {
                analysisGroup.setStartValue(0);
            }
            AnalysisGroupBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return AnalysisGroupBO.investigate(e, dbTransaction);
        }
        return null;
    }

    static void updateExternalAnalysisGroup(Environment environment, int sequenceNumber, String name, String shortName) throws Exception {
        AnalysisGroupManager manager = AnalysisGroupManagerFactory.getInstance(AnalysisGroupBO.getDBData(environment.getFacLib()));
        manager.generalUpdate("name = " + AnalysisGroupBO.escapeSingleQuotes(name) + "," + "shortName" + " = " + AnalysisGroupBO.escapeSingleQuotes(shortName), "seqNr = " + sequenceNumber);
    }

    public static String delete(AnalysisGroup analysisGroup) throws Exception {
        boolean alreadyActive = AnalysisGroupBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            analysisGroup.delete();
            AnalysisGroupBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return AnalysisGroupBO.investigate(e, dbTransaction);
        }
        return null;
    }
}

