/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.util.Collection;
import java.util.HashMap;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.AnalysisCode;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.AssetAnalysisCode;
import nl.ibs.fac.db.AssetAnalysisCodeDataBean;
import nl.ibs.fac.db.AssetAnalysisCodeManager;
import nl.ibs.fac.db.AssetAnalysisCodeManagerFactory;
import nl.ibs.fac.db.AssetAnalysisCodePK;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class AssetAnalysisCodeBO
extends BOAdapter {
    public static Object[] get(DBData dbData, String companyId, int seqNr, String cora, String assetId) throws Exception {
        Object[] result = new Object[2];
        AssetAnalysisCodePK key = new AssetAnalysisCodePK();
        key.setCompanyId(companyId);
        key.setSeqNr(seqNr);
        key.setAssetId(assetId);
        key.setCora(cora);
        try {
            result[0] = AssetAnalysisCodeManagerFactory.getInstance(dbData).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Collection getCollection(DBData dbData, String companyId, String assetId) throws Exception {
        ExecutableQuery query = QueryFactory.create(AssetAnalysisCode.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = AssetAnalysisCodeBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        filter = AssetAnalysisCodeBO.addFilterTerm(filter, "assetId = ?_assetId");
        parameters.put("_assetId", assetId);
        filter = AssetAnalysisCodeBO.addFilterTerm(filter, "cora = 'A'");
        query.setFilter(filter);
        query.setParameters(parameters);
        AssetAnalysisCodeManager manager = AssetAnalysisCodeManagerFactory.getInstance(dbData);
        return manager.getCollection(query);
    }

    public static Object[] create(DBData dbData, String companyId, String cora, String assetId, String analysisGroupCompanyId, int seqNr, String code) throws Exception {
        Object[] result;
        if (analysisGroupCompanyId == null || analysisGroupCompanyId.length() == 0) {
            analysisGroupCompanyId = companyId;
        }
        if ((result = AnalysisGroupBO.get(dbData, analysisGroupCompanyId, seqNr))[1] != null) {
            return result;
        }
        return AssetAnalysisCodeBO.create(dbData, companyId, cora, assetId, (AnalysisGroup)result[0], code);
    }

    public static Object[] create(DBData dbData, String companyId, String cora, String assetId, AnalysisGroup analysisGroup, String code) throws Exception {
        Object[] result = new Object[2];
        AssetAnalysisCodeManager manager = AssetAnalysisCodeManagerFactory.getInstance(dbData);
        AssetAnalysisCodeDataBean bean = new AssetAnalysisCodeDataBean();
        bean.setCompanyId(companyId);
        bean.setCora(cora);
        bean.setAssetId(assetId);
        bean.setAnalysisGroupCompanyId(analysisGroup.getCompanyId());
        bean.setSeqNr(analysisGroup.getSeqNr());
        bean.setCode(AnalysisGroupBO.formatCode(analysisGroup, code));
        boolean alreadyActive = AssetAnalysisCodeBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            AssetAnalysisCodeBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = AssetAnalysisCodeBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String update(AssetAnalysisCode assetAnalysisCode, AnalysisGroup analysisGroup, String code) throws Exception {
        AssetAnalysisCodeDataBean bean = new AssetAnalysisCodeDataBean();
        bean.setCompanyId(assetAnalysisCode.getCompanyId());
        bean.setCora(assetAnalysisCode.getCora());
        bean.setAssetId(assetAnalysisCode.getAssetId());
        bean.setAnalysisGroupCompanyId(assetAnalysisCode.getAnalysisGroupCompanyId());
        bean.setSeqNr(assetAnalysisCode.getSeqNr());
        bean.setCode(AnalysisGroupBO.formatCode(analysisGroup, code));
        boolean alreadyActive = AssetAnalysisCodeBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            assetAnalysisCode.update(bean);
            AssetAnalysisCodeBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return AssetAnalysisCodeBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(AssetAnalysisCode assetAnalysisCode) throws Exception {
        boolean alreadyActive = AssetAnalysisCodeBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            assetAnalysisCode.delete();
            AssetAnalysisCodeBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return AssetAnalysisCodeBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static boolean hasAssetsForAnalysisCode(AnalysisCode analysiscode) throws Exception {
        ExecutableQuery query = QueryFactory.create(AssetAnalysisCode.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = AssetAnalysisCodeBO.addFilterTerm(null, "seqNr = ?_seqNr");
        parameters.put("_seqNr", analysiscode.getSeqNr());
        filter = AssetAnalysisCodeBO.addFilterTerm(filter, "analysisGroupCompanyId = ?_analysisGroupCompanyId");
        parameters.put("_analysisGroupCompanyId", analysiscode.getCompanyId());
        filter = AssetAnalysisCodeBO.addFilterTerm(filter, "code = ?_code");
        parameters.put("_code", analysiscode.getCode());
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        AssetAnalysisCodeManager manager = AssetAnalysisCodeManagerFactory.getInstance(analysiscode.getDBData());
        return manager.getFirstObject(query) != null;
    }

    public static boolean hasAssetsForAnalysisGroup(AnalysisGroup analysisgroup) throws Exception {
        ExecutableQuery query = QueryFactory.create(AssetAnalysisCode.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = AssetAnalysisCodeBO.addFilterTerm(null, "seqNr = ?_seqNr");
        parameters.put("_seqNr", analysisgroup.getSeqNr());
        filter = AssetAnalysisCodeBO.addFilterTerm(filter, "analysisGroupCompanyId = ?_analysisGroupCompanyId");
        parameters.put("_analysisGroupCompanyId", analysisgroup.getCompanyId());
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        AssetAnalysisCodeManager manager = AssetAnalysisCodeManagerFactory.getInstance(analysisgroup.getDBData());
        return manager.getFirstObject(query) != null;
    }
}

