/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.fac.adapters.NumericIdTransformer;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.MemoBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.boadapters.ValuationMainAccountBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetDataBean;
import nl.ibs.fac.db.AssetManager;
import nl.ibs.fac.db.AssetManagerFactory;
import nl.ibs.fac.db.AssetPK;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Memo;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.ValuationMainAccount;
import nl.ibs.fac.queries.ValuationMainAccountQuery;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class AssetBO
extends BOAdapter {
    public static final String FROMASSETID = "FromAsset";
    public static final String TOASSETID = "ToAsset";
    public static final String FROMCREDITID = "FromCredit";
    public static final String TOCREDITID = "ToCredit";
    public static final String FROMTYPE = "FromType";
    public static final String TOTYPE = "ToType";
    public static final String FROMFINDIMID1 = "FromFinDimId1";
    public static final String TOFINDIMID1 = "ToFinDimId1";
    public static final String FROMFINDIMID2 = "FromFinDimId2";
    public static final String TOFINDIMID2 = "ToFinDimId2";
    public static final String FROMFINDIMID3 = "FromFinDimId3";
    public static final String TOFINDIMID3 = "ToFinDimId3";
    public static final String FROMFINDIMID4 = "FromFinDimId4";
    public static final String TOFINDIMID4 = "ToFinDimId4";
    public static final String FROMFINDIMID5 = "FromFinDimId5";
    public static final String TOFINDIMID5 = "ToFinDimId5";
    public static final String PARENT_ASSET = "parentAsset";
    public static final String IS_PARENT_OR_STANDALONE = "IsParentOrStandAlone";
    public static final String IS_PARENT = "isParent";
    public static final String IS_SUBASSET = "isSubsset";
    public static final String INCLUDE_DISINVESTED = "includeDisinvested";

    public static Object[] get(Company company, String id, boolean credit) throws Exception {
        Object[] result = new Object[2];
        AssetPK key = new AssetPK();
        key.setCompanyId(company.getId());
        if (credit) {
            key.setCora("C");
        } else {
            key.setCora("A");
        }
        key.setId(AssetBO.formatId(company, id, credit));
        try {
            result[0] = AssetManagerFactory.getInstance(company.getDBData()).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Collection<?> getParentAssets(Company company, boolean credit) throws Exception {
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = AssetBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", company.getId());
        filter = AssetBO.addFilterTerm(filter, "credit = ?_credit");
        parameters.put("_credit", Boolean.toString(credit));
        filter = AssetBO.addFilterTerm(filter, "parentAsset = ?_parentAsset");
        parameters.put("_parentAsset", Boolean.toString(true));
        filter = AssetBO.addFilterTerm(filter, "(subAsset = ?_subAsset OR state = ?_activated )");
        parameters.put("_subAsset", Boolean.toString(false));
        parameters.put("_activated", "2");
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        query.setOrdering("id");
        AssetManager manager = AssetManagerFactory.getInstance(company.getDBData());
        return manager.getCollection(query);
    }

    public static Collection<?> getSubAssets(DBData dbData, String companyId, String parentId, boolean credit) throws Exception {
        if (Log.debug()) {
            Log.debug((String)("getSubAssets for: " + parentId));
        }
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = AssetBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        filter = AssetBO.addFilterTerm(filter, "parentId = ?_parentId");
        parameters.put("_parentId", parentId);
        filter = AssetBO.addFilterTerm(filter, "credit = ?_credit");
        parameters.put("_credit", Boolean.toString(credit));
        filter = AssetBO.addFilterTerm(filter, "state <> ?_preliminary");
        parameters.put("_preliminary", "0");
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        query.setOrdering("id");
        AssetManager manager = AssetManagerFactory.getInstance(dbData);
        return manager.getCollection(query);
    }

    public static Collection<?> getAssets(Map<?, ?> map, boolean credit) throws Exception {
        String isSubAsset;
        String parentAsset;
        String isParentOrStandAlone;
        String to;
        if (Log.debug()) {
            Log.debug((String)"getCollection");
        }
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String companyId = (String)map.get("Company");
        String filter = AssetBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        Company company = (Company)CompanyBO.get(BOAdapter.getDBData(map), companyId)[0];
        String from = (String)map.get(FROMASSETID);
        if (from == null) {
            from = (String)map.get(FROMCREDITID);
        }
        if (from != null && from.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "id >= ?_fromId");
            parameters.put("_fromId", AssetBO.formatId(company, from, false));
        }
        if ((to = (String)map.get(TOASSETID)) == null) {
            to = (String)map.get(TOCREDITID);
        }
        if (to != null && to.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "id <= ?_toId");
            parameters.put("_toId", AssetBO.formatId(company, to, false));
        }
        if ((from = (String)map.get(FROMTYPE)) != null && from.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "typeId >= ?_fromType");
            parameters.put("_fromType", from);
        }
        if ((to = (String)map.get(TOTYPE)) != null && to.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "typeId <= ?_toType");
            parameters.put("_toType", to);
        }
        if ((from = (String)map.get(FROMFINDIMID1)) != null && from.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "finDimId1 >= ?_fromFinDimId1");
            parameters.put("_fromFinDimId1", from);
        }
        if ((to = (String)map.get(TOFINDIMID1)) != null && to.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "finDimId1 <= ?_toFinDimId1");
            parameters.put("_toFinDimId1", to);
        }
        if ((from = (String)map.get(FROMFINDIMID2)) != null && from.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "finDimId2 >= ?_fromFinDimId2");
            parameters.put("_fromFinDimId2", from);
        }
        if ((to = (String)map.get(TOFINDIMID2)) != null && to.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "finDimId2 <= ?_toFinDimId2");
            parameters.put("_toFinDimId2", to);
        }
        if ((from = (String)map.get(FROMFINDIMID3)) != null && from.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "finDimId3 >= ?_fromFinDimId3");
            parameters.put("_fromFinDimId3", from);
        }
        if ((to = (String)map.get(TOFINDIMID3)) != null && to.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "finDimId3 <= ?_toFinDimId3");
            parameters.put("_toFinDimId3", to);
        }
        if ((from = (String)map.get(FROMFINDIMID4)) != null && from.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "finDimId4 >= ?_fromFinDimId4");
            parameters.put("_fromFinDimId4", from);
        }
        if ((to = (String)map.get(TOFINDIMID4)) != null && to.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "finDimId4 <= ?_toFinDimId4");
            parameters.put("_toFinDimId4", to);
        }
        if ((from = (String)map.get(FROMFINDIMID5)) != null && from.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "finDimId5 >= ?_fromFinDimId5");
            parameters.put("_fromFinDimId5", from);
        }
        if ((to = (String)map.get(TOFINDIMID5)) != null && to.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "finDimId5 <= ?_toFinDimId5");
            parameters.put("_toFinDimId5", to);
        }
        if ((isParentOrStandAlone = (String)map.get(IS_PARENT_OR_STANDALONE)) != null && Boolean.valueOf(isParentOrStandAlone).booleanValue()) {
            filter = AssetBO.addFilterTerm(filter, "parentAsset = ?_parentAsset");
            parameters.put("_parentAsset", Boolean.toString(true));
            filter = AssetBO.addFilterTerm(filter, "(subAsset = ?_subAsset OR state <> ?_preliminary )");
            parameters.put("_subAsset", Boolean.toString(false));
            parameters.put("_preliminary", "0");
        }
        if ((parentAsset = (String)map.get(PARENT_ASSET)) != null && parentAsset.length() > 0) {
            filter = AssetBO.addFilterTerm(filter, "parentAsset = ?_parentAsset");
            parameters.put("_parentAsset", parentAsset);
        }
        if ((isSubAsset = (String)map.get(IS_SUBASSET)) != null && Boolean.valueOf(isSubAsset).booleanValue()) {
            filter = AssetBO.addFilterTerm(filter, "subAsset = ?_subAsset");
            parameters.put("_subAsset", Boolean.toString(true));
        }
        filter = AssetBO.addFilterTerm(filter, "credit = ?_credit");
        parameters.put("_credit", Boolean.toString(credit));
        if (map.get("currentCapitalization") != null) {
            filter = AssetBO.addFilterTerm(filter, "currentCapitalization = ?_currentCapitalization");
            parameters.put("_currentCapitalization", new Boolean(true));
        } else if (map.get(IS_PARENT) != null) {
            filter = AssetBO.addFilterTerm(filter, "parentAsset = ?_parentAsset");
            parameters.put("_parentAsset", new Boolean(true));
            filter = AssetBO.addFilterTerm(filter, "subAsset = ?_subAsset");
            parameters.put("_subAsset", new Boolean(false));
        } else if (map.get(IS_PARENT_OR_STANDALONE) == null) {
            filter = AssetBO.addFilterTerm(filter, "state <> ?_preliminary");
            parameters.put("_preliminary", "0");
        }
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        AssetBO.addOrdering(query, map, "id");
        AssetManager manager = AssetManagerFactory.getInstance(BOAdapter.getDBData(map));
        return manager.getCollection(query);
    }

    public static boolean hasAssets(Company company) throws Exception {
        if (company == null) {
            return false;
        }
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = AssetBO.addFilterTerm(null, "typeCompanyId = ?_companyId");
        parameters.put("_companyId", company.getId());
        query.setFilter(filter);
        query.setParameters(parameters);
        AssetManager manager = AssetManagerFactory.getInstance(company.getDBData());
        return manager.getFirstObject(query) != null;
    }

    public static boolean hasAssets(AssetType assetType) throws Exception {
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = AssetBO.addFilterTerm(null, "typeId = ?_typeId");
        parameters.put("_typeId", assetType.getId());
        filter = AssetBO.addFilterTerm(filter, "typeCompanyId = ?_companyId");
        parameters.put("_companyId", assetType.getCompanyId());
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        AssetManager manager = AssetManagerFactory.getInstance(assetType.getDBData());
        return manager.getFirstObject(query) != null;
    }

    public static Object[] create(DBData dbData, String companyId, String id, String description, int state, String typeCompanyId, String typeId, String parentId, boolean parentAsset, boolean subAsset, boolean credit, boolean loan, boolean currentCapitalization, boolean negativeInvestment, boolean hasMemo, Date acquisitionDate, int startUsePeriod, int startUseYear, int historicalPeriod, int historicalYear, String incomingFinancialTransactionId, String finDimId1, String finDimId2, String finDimId3, String finDimId4, String finDimId5, int creditState, String councilDecision, Date councilDecisionDate, String originId) throws Exception {
        Object[] result = new Object[2];
        AssetManager manager = AssetManagerFactory.getInstance(dbData);
        AssetDataBean bean = new AssetDataBean();
        bean.setCompanyId(companyId);
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        Object[] idResult = AssetBO.getId(company, id, credit);
        if (idResult[1] != null) {
            result[1] = idResult[1];
            return result;
        }
        bean.setId(AssetBO.formatId(company, (String)idResult[0], credit));
        if (credit) {
            bean.setCora("C");
            bean.setParentCora("C");
        } else {
            bean.setCora("A");
            bean.setParentCora("A");
        }
        bean.setDescription(description);
        bean.setState(state);
        if (typeCompanyId == null || typeCompanyId.length() == 0) {
            typeCompanyId = companyId;
        }
        bean.setTypeCompanyId(typeCompanyId);
        bean.setTypeId(typeId);
        if (parentId != null && parentId.length() == 0) {
            parentId = null;
        }
        bean.setParentId(AssetBO.formatId(company, parentId, credit));
        bean.setParentAsset(parentAsset);
        bean.setSubAsset(subAsset);
        bean.setCredit(credit);
        bean.setLoan(loan);
        bean.setCurrentCapitalization(currentCapitalization);
        bean.setNegativeInvestment(negativeInvestment);
        bean.setHasMemo(hasMemo);
        bean.setAcquisitionDate(acquisitionDate);
        bean.setStartUsePeriod(startUsePeriod);
        bean.setStartUseYear(startUseYear);
        bean.setHistoricalPeriod(historicalPeriod);
        bean.setHistoricalYear(historicalYear);
        if (incomingFinancialTransactionId != null && incomingFinancialTransactionId.length() == 0) {
            incomingFinancialTransactionId = null;
        }
        bean.setIncomingFinancialTransactionId(incomingFinancialTransactionId);
        bean.setFinDimId1(finDimId1);
        bean.setFinDimId2(finDimId2);
        bean.setFinDimId3(finDimId3);
        bean.setFinDimId4(finDimId4);
        bean.setFinDimId5(finDimId5);
        bean.setCreditState(creditState);
        bean.setCouncilDecision(councilDecision);
        bean.setCouncilDecisionDate(councilDecisionDate);
        if (originId != null && originId.length() == 0) {
            originId = null;
        }
        bean.setOriginId(originId);
        boolean alreadyActive = AssetBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        boolean created = false;
        while (!created) {
            try {
                result[0] = manager.create(bean);
                AssetBO.commitTransaction(alreadyActive);
                created = true;
            }
            catch (Exception e) {
                if (id.trim().length() == 0 && e.getMessage().startsWith("[SQL0803]")) {
                    idResult = AssetBO.getId(company, id, credit);
                    if (idResult[1] != null) {
                        result[1] = idResult[1];
                        AssetBO.investigate(null, dbTransaction);
                        return result;
                    }
                    bean.setId(AssetBO.formatId(company, (String)idResult[0], credit));
                    continue;
                }
                result[1] = AssetBO.investigate(e, dbTransaction);
                return result;
            }
        }
        return result;
    }

    private static Object[] getId(Company company, String id, boolean credit) throws Exception {
        Object[] result = new Object[2];
        AssetManager manager = AssetManagerFactory.getInstance(company.getDBData());
        if (id.trim().length() == 0) {
            if (credit) {
                id = manager.getCreditIdMax(company.getId());
                int startValue = 0;
                if (id != null) {
                    try {
                        startValue = Integer.parseInt(id);
                    }
                    catch (NumberFormatException e) {
                        result[1] = "autoNumber_value_not_numeric";
                        return result;
                    }
                }
                id = id == null || startValue < company.getCreditIdStartValue() ? "" + company.getCreditIdStartValue() : "" + (Integer.parseInt(id) + 1);
            } else {
                id = manager.getAssetIdMax(company.getId());
                int startValue = 0;
                if (id != null) {
                    try {
                        startValue = Integer.parseInt(id);
                    }
                    catch (NumberFormatException e) {
                        result[1] = "autoNumber_value_not_numeric";
                        return result;
                    }
                }
                id = id == null || startValue < company.getAssetIdStartValue() ? "" + company.getAssetIdStartValue() : "" + (Integer.parseInt(id) + 1);
            }
        }
        result[0] = id;
        return result;
    }

    public static String formatId(Company company, String id, boolean credit) throws Exception {
        if (id == null) {
            return id;
        }
        if (AssetBO.isIdNumeric(company, credit)) {
            DecimalFormat formatter = new DecimalFormat("0000000000");
            try {
                id = formatter.format(Integer.parseInt(id.trim()));
                id = credit ? id.substring(10 - company.getCreditIdLength()) : id.substring(10 - company.getAssetIdLength());
            }
            catch (RuntimeException e) {
                return id;
            }
        }
        return id;
    }

    public static String unFormatId(Company company, String id, boolean credit) throws Exception {
        if (AssetBO.isIdNumeric(company, credit)) {
            return (String)new NumericIdTransformer().transform(id);
        }
        return id;
    }

    public static boolean isIdNumeric(Company company, boolean credit) throws Exception {
        return !credit && company.getAssetIdType().equals("N") || credit && company.getCreditIdType().equals("N");
    }

    public static Object[] createParent(DBData dbData, String companyId, String id, String description, String typeCompanyId, String typeId, boolean credit) throws Exception {
        Object[] result = new Object[2];
        AssetManager manager = AssetManagerFactory.getInstance(dbData);
        AssetDataBean bean = new AssetDataBean();
        bean.setCompanyId(companyId);
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        Object[] idResult = AssetBO.getId(company, id, credit);
        if (idResult[1] != null) {
            result[1] = idResult[1];
            return result;
        }
        bean.setId(AssetBO.formatId(company, (String)idResult[0], credit));
        if (credit) {
            bean.setCora("C");
            bean.setParentCora("C");
        } else {
            bean.setCora("A");
            bean.setParentCora("A");
        }
        bean.setDescription(description);
        if (typeCompanyId == null || typeCompanyId.length() == 0) {
            typeCompanyId = companyId;
        }
        bean.setTypeCompanyId(typeCompanyId);
        bean.setTypeId(typeId);
        bean.setCredit(credit);
        bean.setParentAsset(true);
        bean.setSubAsset(false);
        boolean alreadyActive = AssetBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        boolean created = false;
        while (!created) {
            try {
                result[0] = manager.create(bean);
                AssetBO.commitTransaction(alreadyActive);
                created = true;
            }
            catch (Exception e) {
                if (id.trim().length() == 0 && e.getMessage().startsWith("[SQL0803]")) {
                    idResult = AssetBO.getId(company, id, credit);
                    if (idResult[1] != null) {
                        result[1] = idResult[1];
                        AssetBO.investigate(null, dbTransaction);
                        return result;
                    }
                    bean.setId(AssetBO.formatId(company, (String)idResult[0], credit));
                    continue;
                }
                result[1] = AssetBO.investigate(e, dbTransaction);
                return result;
            }
        }
        return result;
    }

    public static String update(Asset asset, String description, AssetType assetType, Asset parent, boolean parentAsset, boolean subAsset, Date acquisitionDate, int startUsePeriod, int startUseYear, int historicalPeriod, int historicalYear, String finDimId1, String finDimId2, String finDimId3, String finDimId4, String finDimId5, BigDecimal payOffYearAmount) throws Exception {
        boolean alreadyActive = AssetBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            asset.setDescription(description);
            if (asset.getState() == 0) {
                asset.setAssetType(assetType);
            }
            asset.setParent(parent);
            asset.setParentAsset(parentAsset);
            asset.setSubAsset(subAsset);
            asset.setAcquisitionDate(acquisitionDate);
            asset.setStartUseYear(startUseYear);
            asset.setStartUsePeriod(startUsePeriod);
            asset.setHistoricalPeriod(historicalPeriod);
            asset.setHistoricalYear(historicalYear);
            asset.setPayOffYearAmount(payOffYearAmount);
            if (asset.getState() == 0) {
                asset.setFinDimId1(finDimId1);
                asset.setFinDimId2(finDimId2);
                asset.setFinDimId3(finDimId3);
                asset.setFinDimId4(finDimId4);
                asset.setFinDimId5(finDimId5);
            }
            AssetBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return AssetBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String update(Asset asset, String finDimId1, String finDimId2, String finDimId3, String finDimId4, String finDimId5) throws Exception {
        boolean alreadyActive = AssetBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            asset.setFinDimId1(finDimId1);
            asset.setFinDimId2(finDimId2);
            asset.setFinDimId3(finDimId3);
            asset.setFinDimId4(finDimId4);
            asset.setFinDimId5(finDimId5);
            AssetBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return AssetBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String updateParent(Asset asset, String description, AssetType assetType) throws Exception {
        boolean alreadyActive = AssetBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            asset.setDescription(description);
            asset.setAssetType(assetType);
            AssetBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return AssetBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(Asset asset) throws Exception {
        return AssetBO.delete(asset, null, null, true);
    }

    public static void deleteAllAssets(Company company) throws Exception {
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = AssetBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", company.getId());
        query.setFilter(filter);
        query.setParameters(parameters);
        AssetManager manager = AssetManagerFactory.getInstance(company.getDBData());
        for (Asset asset : manager.getCollection(query)) {
            AssetBO.delete(asset, null, null, false);
        }
    }

    public static String delete(Asset asset, IncomingFinancialTransaction incomingFinancialTransaction, Credit credit, boolean checkState) throws Exception {
        if (checkState && asset.getState() != 0) {
            return "invalid_state";
        }
        boolean alreadyActive = AssetBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            String message = null;
            ValuationMainAccountQuery query = new ValuationMainAccountQuery(asset.getDBData(), asset.getCompanyId(), "A", asset.getId(), "1");
            Collection maSchemes = query.fetchData(null, null, null, 0);
            for (ValuationMainAccount maScheme : maSchemes) {
                message = ValuationMainAccountBO.delete(maScheme);
                if (message == null) continue;
                return message;
            }
            if (asset.getHasMemo()) {
                Object[] oa = MemoBO.get(asset);
                message = oa[0] == null ? (String)oa[1] : MemoBO.delete(asset, (Memo)oa[0]);
            }
            if (message != null) {
                return message;
            }
            for (Transaction transaction : TransactionBO.getTransactions(asset)) {
                IncomingFinancialTransaction ift;
                if (asset.getIncomingFinancialTransactionId() != null && transaction.getSeqNr() == 1 && (ift = transaction.getIncomingFinancialTransaction()) != null) {
                    BigDecimal amount = transaction.getMainTransactionType() == 2 ? transaction.getAmount3().negate() : transaction.getAmount1();
                    if (incomingFinancialTransaction != null && ift.getId().equals(incomingFinancialTransaction.getId())) {
                        incomingFinancialTransaction.setUnAllocatedValue(incomingFinancialTransaction.getUnAllocatedValue().add(amount));
                    } else {
                        ift.setUnAllocatedValue(ift.getUnAllocatedValue().add(amount));
                    }
                }
                if (transaction.getCreditId() != null && credit != null && transaction.getCreditId().equals(credit.getId()) && transaction.getSeqNr() == 1) {
                    credit.setAllocatedValue(credit.getAllocatedValue().subtract(transaction.getAmount1()));
                    credit.setAllocatedDepreciationValue(credit.getAllocatedDepreciationValue().subtract(transaction.getAmount2()));
                }
                transaction.delete();
            }
            asset.delete();
            AssetBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return AssetBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static BigDecimal getBookValue(Asset asset) throws Exception {
        if (asset.getState() != 2) {
            return new BigDecimal("0");
        }
        return ValuationBO.getBookValue(asset);
    }

    public static BigDecimal getTotalBookValue(Asset asset) throws Exception {
        if (asset.getSubAsset()) {
            return asset.getBookValue();
        }
        BigDecimal result = new BigDecimal(0);
        for (Asset subAsset : AssetBO.getSubAssets(asset.getDBData(), asset.getCompanyId(), asset.getId(), asset.getCredit())) {
            result = result.add(subAsset.getBookValue());
        }
        return result;
    }

    public static int[] getLastDepreciatedPeriod(Asset asset) throws Exception {
        return ValuationBO.getLastDepreciatedPeriod(asset);
    }

    public static BigDecimal getAcquisitionValue(Asset asset) throws Exception {
        return ValuationBO.getAcquisitionValue(asset);
    }

    public static int[] getLastAcquisitionPeriod(Asset asset) throws Exception {
        return ValuationBO.getLastAcquisitionPeriod(asset);
    }

    public static boolean hasNotPostedTransactions(Asset asset) throws Exception {
        return TransactionBO.getFirstTransaction(asset, new Boolean(false)) != null;
    }
}

