/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.AssetTypeDataBean;
import nl.ibs.fac.db.AssetTypeManager;
import nl.ibs.fac.db.AssetTypeManagerFactory;
import nl.ibs.fac.db.AssetTypePK;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.queries.AssetTypeQuery;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class AssetTypeBO
extends BOAdapter {
    public static final String FROMTYPE = "FromType";
    public static final String TOTYPE = "ToType";

    public static Object[] get(DBData dbData, String companyId, String id) throws Exception {
        Object[] result = new Object[2];
        AssetTypePK key = new AssetTypePK();
        key.setCompanyId(companyId);
        key.setId(id);
        try {
            result[0] = AssetTypeManagerFactory.getInstance(dbData).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Collection getAssetTypes(Map map) throws Exception {
        String toId;
        if (Log.debug()) {
            Log.debug((String)"getCollection");
        }
        ExecutableQuery query = QueryFactory.create(AssetType.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String companyId = (String)map.get("Company");
        String filter = AssetTypeBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        String fromId = (String)map.get(FROMTYPE);
        if (fromId != null && fromId.length() > 0) {
            filter = AssetTypeBO.addFilterTerm(filter, "id >= ?_fromId");
            parameters.put("_fromId", fromId);
        }
        if ((toId = (String)map.get(TOTYPE)) != null && toId.length() > 0) {
            filter = AssetTypeBO.addFilterTerm(filter, "id <= ?_toId");
            parameters.put("_toId", toId);
        }
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        AssetTypeBO.addOrdering(query, map, "id");
        AssetTypeManager manager = AssetTypeManagerFactory.getInstance(BOAdapter.getDBData(map));
        return manager.getCollection(query);
    }

    public static boolean hasAssetTypes(Company company) throws Exception {
        ExecutableQuery query = QueryFactory.create(AssetType.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = AssetTypeBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", company.getId());
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        AssetTypeManager manager = AssetTypeManagerFactory.getInstance(company.getDBData());
        return manager.getFirstObject(query) != null;
    }

    public static boolean hasAssetTypesForAnalysisGroup(AnalysisGroup analysisGroup) throws Exception {
        ExecutableQuery query = QueryFactory.create(AssetType.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = AssetTypeBO.addFilterTerm(null, "(companyId = ?_companyId)");
        parameters.put("_companyId", analysisGroup.getCompanyId());
        filter = AssetTypeBO.addFilterTerm(filter, "(seqNr1 = ?_code");
        parameters.put("_code", Integer.toString(analysisGroup.getSeqNr()));
        filter = AssetTypeBO.addOrFilterTerm(filter, "seqNr2 = ?_code");
        parameters.put("_code", Integer.toString(analysisGroup.getSeqNr()));
        filter = AssetTypeBO.addOrFilterTerm(filter, "seqNr3 = ?_code");
        parameters.put("_code", Integer.toString(analysisGroup.getSeqNr()));
        filter = AssetTypeBO.addOrFilterTerm(filter, "seqNr4 = ?_code");
        parameters.put("_code", Integer.toString(analysisGroup.getSeqNr()));
        filter = AssetTypeBO.addOrFilterTerm(filter, "seqNr5 = ?_code");
        parameters.put("_code", Integer.toString(analysisGroup.getSeqNr()));
        filter = AssetTypeBO.addOrFilterTerm(filter, "seqNr6 = ?_code");
        parameters.put("_code", Integer.toString(analysisGroup.getSeqNr()));
        filter = AssetTypeBO.addOrFilterTerm(filter, "seqNr7 = ?_code");
        parameters.put("_code", Integer.toString(analysisGroup.getSeqNr()));
        filter = AssetTypeBO.addOrFilterTerm(filter, "seqNr8 = ?_code");
        parameters.put("_code", Integer.toString(analysisGroup.getSeqNr()));
        filter = AssetTypeBO.addOrFilterTerm(filter, "seqNr9 = ?_code");
        parameters.put("_code", Integer.toString(analysisGroup.getSeqNr()));
        filter = AssetTypeBO.addOrFilterTerm(filter, "seqNr10 = ?_code)");
        parameters.put("_code", Integer.toString(analysisGroup.getSeqNr()));
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        AssetTypeManager manager = AssetTypeManagerFactory.getInstance(analysisGroup.getDBData());
        return manager.getFirstObject(query) != null;
    }

    public static Object[] create(DBData dbData, String companyId, String id, String description, int category, boolean thirdPartyLoan, boolean limitedDepreciation, boolean exclWriteOff, boolean differentAcquisitionValueForAP2, boolean accountingPrinciple2IsUsed, int[] usageFinDims, int[] seqNr, boolean[] seqNrMandatory, String[] defaults, boolean depreciateBeyondEconomicLife) throws Exception {
        Object[] result = new Object[2];
        AssetTypeManager manager = AssetTypeManagerFactory.getInstance(dbData);
        AssetTypeDataBean bean = AssetTypeBO.createBean(companyId, id, description, category, thirdPartyLoan, false, limitedDepreciation, exclWriteOff, differentAcquisitionValueForAP2, accountingPrinciple2IsUsed, usageFinDims, seqNr, seqNrMandatory, defaults, depreciateBeyondEconomicLife);
        try {
            result[0] = manager.create(bean);
        }
        catch (Exception e) {
            result[1] = AssetTypeBO.investigate(e, null);
        }
        return result;
    }

    private static AssetTypeDataBean createBean(String companyId, String id, String description, int category, boolean thirdPartyLoan, boolean notUsed, boolean limitedDepreciation, boolean exclWriteOff, boolean differentAcquisitionValueForAP2, boolean accountingPrinciple2IsUsed, int[] usageFinDims, int[] seqNr, boolean[] seqNrMandatory, String[] defaults, boolean depreciateBeyondEconomicLife) throws Exception {
        AssetTypeDataBean bean = new AssetTypeDataBean();
        bean.setCompanyId(companyId);
        bean.setId(id);
        bean.setDescription(description);
        bean.setCategory(category);
        bean.setIs3rdPartyLoan(thirdPartyLoan);
        bean.setNotUsed(notUsed);
        bean.setLimitedDepreciation(limitedDepreciation);
        bean.setDepreciateBeyondEconomicLife(depreciateBeyondEconomicLife);
        bean.setExclWriteOff(exclWriteOff);
        bean.setUseDifferentAcquisitionValues(differentAcquisitionValueForAP2);
        bean.setAccountingPrinciple2IsUsed(accountingPrinciple2IsUsed);
        bean.setFinancialDimension1Usage(usageFinDims[0]);
        bean.setFinancialDimension2Usage(usageFinDims[1]);
        bean.setFinancialDimension3Usage(usageFinDims[2]);
        bean.setFinancialDimension4Usage(usageFinDims[3]);
        bean.setFinancialDimension5Usage(usageFinDims[4]);
        bean.setSeqNr1(seqNr[0] == 0 ? null : new Integer(seqNr[0]));
        bean.setSeqNr2(seqNr[1] == 0 ? null : new Integer(seqNr[1]));
        bean.setSeqNr3(seqNr[2] == 0 ? null : new Integer(seqNr[2]));
        bean.setSeqNr4(seqNr[3] == 0 ? null : new Integer(seqNr[3]));
        bean.setSeqNr5(seqNr[4] == 0 ? null : new Integer(seqNr[4]));
        bean.setSeqNr6(seqNr[5] == 0 ? null : new Integer(seqNr[5]));
        bean.setSeqNr7(seqNr[6] == 0 ? null : new Integer(seqNr[6]));
        bean.setSeqNr8(seqNr[7] == 0 ? null : new Integer(seqNr[7]));
        bean.setSeqNr9(seqNr[8] == 0 ? null : new Integer(seqNr[8]));
        bean.setSeqNr10(seqNr[9] == 0 ? null : new Integer(seqNr[9]));
        bean.setSeqNr1Mandatory(seqNrMandatory[0]);
        bean.setSeqNr2Mandatory(seqNrMandatory[1]);
        bean.setSeqNr3Mandatory(seqNrMandatory[2]);
        bean.setSeqNr4Mandatory(seqNrMandatory[3]);
        bean.setSeqNr5Mandatory(seqNrMandatory[4]);
        bean.setSeqNr6Mandatory(seqNrMandatory[5]);
        bean.setSeqNr7Mandatory(seqNrMandatory[6]);
        bean.setSeqNr8Mandatory(seqNrMandatory[7]);
        bean.setSeqNr9Mandatory(seqNrMandatory[8]);
        bean.setSeqNr10Mandatory(seqNrMandatory[9]);
        bean.setDefaultAnalysisCode1(defaults[0]);
        bean.setDefaultAnalysisCode2(defaults[1]);
        bean.setDefaultAnalysisCode3(defaults[2]);
        bean.setDefaultAnalysisCode4(defaults[3]);
        bean.setDefaultAnalysisCode5(defaults[4]);
        bean.setDefaultAnalysisCode6(defaults[5]);
        bean.setDefaultAnalysisCode7(defaults[6]);
        bean.setDefaultAnalysisCode8(defaults[7]);
        bean.setDefaultAnalysisCode9(defaults[8]);
        bean.setDefaultAnalysisCode10(defaults[9]);
        return bean;
    }

    public static String update(AssetType assetType, String description, int category, boolean thirdPartyLoan, boolean notUsed, boolean limitedDepreciation, boolean exclWriteOff, boolean differentAcquisitionValueForAP2, boolean accountingPrinciple2IsUsed, int[] usageFinDims, int[] seqNr, boolean[] seqNrMandatory, String[] defaults, boolean depreciateBeyondEconomicLife) throws Exception {
        AssetTypeDataBean bean = AssetTypeBO.createBean(assetType.getCompanyId(), assetType.getId(), description, category, thirdPartyLoan, notUsed, limitedDepreciation, exclWriteOff, differentAcquisitionValueForAP2, accountingPrinciple2IsUsed, usageFinDims, seqNr, seqNrMandatory, defaults, depreciateBeyondEconomicLife);
        try {
            assetType.update(bean);
        }
        catch (Exception e) {
            return AssetTypeBO.investigate(e, null);
        }
        return null;
    }

    static void disableExternalAnalysisGroup(DBData dbData, String companyId, int seqNr) throws Exception {
        Collection assetTypes = new AssetTypeQuery(dbData, companyId, false).fetchData(null, null, null, 999);
        for (AssetType assetType : assetTypes) {
            if (assetType.getAnalysisGroup1() != null && assetType.getAnalysisGroup1().getSeqNr() == seqNr) {
                assetType.setAnalysisGroup1(null);
                assetType.setSeqNr1Mandatory(false);
            }
            if (assetType.getAnalysisGroup2() != null && assetType.getAnalysisGroup2().getSeqNr() == seqNr) {
                assetType.setAnalysisGroup2(null);
                assetType.setSeqNr2Mandatory(false);
            }
            if (assetType.getAnalysisGroup3() != null && assetType.getAnalysisGroup3().getSeqNr() == seqNr) {
                assetType.setAnalysisGroup3(null);
                assetType.setSeqNr3Mandatory(false);
            }
            if (assetType.getAnalysisGroup4() != null && assetType.getAnalysisGroup4().getSeqNr() == seqNr) {
                assetType.setAnalysisGroup4(null);
                assetType.setSeqNr4Mandatory(false);
            }
            if (assetType.getAnalysisGroup5() != null && assetType.getAnalysisGroup5().getSeqNr() == seqNr) {
                assetType.setAnalysisGroup5(null);
                assetType.setSeqNr5Mandatory(false);
            }
            if (assetType.getAnalysisGroup6() != null && assetType.getAnalysisGroup6().getSeqNr() == seqNr) {
                assetType.setAnalysisGroup6(null);
                assetType.setSeqNr6Mandatory(false);
            }
            if (assetType.getAnalysisGroup7() != null && assetType.getAnalysisGroup7().getSeqNr() == seqNr) {
                assetType.setAnalysisGroup7(null);
                assetType.setSeqNr7Mandatory(false);
            }
            if (assetType.getAnalysisGroup8() != null && assetType.getAnalysisGroup8().getSeqNr() == seqNr) {
                assetType.setAnalysisGroup8(null);
                assetType.setSeqNr8Mandatory(false);
            }
            if (assetType.getAnalysisGroup9() != null && assetType.getAnalysisGroup9().getSeqNr() == seqNr) {
                assetType.setAnalysisGroup9(null);
                assetType.setSeqNr9Mandatory(false);
            }
            if (assetType.getAnalysisGroup10() == null || assetType.getAnalysisGroup10().getSeqNr() != seqNr) continue;
            assetType.setAnalysisGroup10(null);
            assetType.setSeqNr10Mandatory(false);
        }
    }

    public static String delete(AssetType assetType) throws Exception {
        try {
            assetType.delete();
        }
        catch (Exception e) {
            return AssetTypeBO.investigate(e, null);
        }
        return null;
    }
}

