/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nl.ibs.fac.boadapters.AnalysisGroupBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.EnvironmentBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.db.AnalysisGroup;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyDataBean;
import nl.ibs.fac.db.CompanyManager;
import nl.ibs.fac.db.CompanyManagerFactory;
import nl.ibs.fac.db.Environment;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionBatchManager;
import nl.ibs.fac.db.TransactionBatchManagerFactory;
import nl.ibs.fac.db.TransactionBatchPK;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class CompanyBO
extends BOAdapter {
    public static final String FROMID = "FromCompany";
    public static final String TOID = "ToCompany";

    public static Collection getCompanies(Map map) throws Exception {
        if (Log.debug()) {
            Log.debug((String)"getCollection");
        }
        ExecutableQuery query = QueryFactory.create(Company.class);
        query.setCacheable(true);
        if (map != null) {
            String toId;
            HashMap<String, String> parameters = new HashMap<String, String>();
            String filter = null;
            String fromId = (String)map.get(FROMID);
            if (fromId != null && fromId.length() > 0) {
                filter = CompanyBO.addFilterTerm(filter, "id >= ?_fromId");
                parameters.put("_fromId", fromId);
            }
            if ((toId = (String)map.get(TOID)) != null && toId.length() > 0) {
                filter = CompanyBO.addFilterTerm(filter, "id <= ?_toId");
                parameters.put("_toId", toId);
            }
            if (Log.debug()) {
                Log.debug((String)("Filter: " + filter));
                Log.debug((String)("Parameters: " + parameters));
            }
            query.setFilter(filter);
            query.setParameters(parameters);
        }
        CompanyBO.addOrdering(query, map, "id");
        CompanyManager manager = CompanyManagerFactory.getInstance(BOAdapter.getDBData(map));
        return manager.getCollection(query);
    }

    public static boolean hasCompanies(DBData dbData) throws Exception {
        ExecutableQuery query = QueryFactory.create(Company.class);
        query.setCacheable(true);
        CompanyManager manager = CompanyManagerFactory.getInstance(dbData);
        return manager.getFirstObject(query) != null;
    }

    public static Object[] get(DBData dbData, String companyId) throws Exception {
        Object[] result = new Object[2];
        try {
            result[0] = CompanyManagerFactory.getInstance(dbData).findByPrimaryKey(companyId);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Object[] create(DBData dbData, String id, String description, int initialBookYear, int currentBookYear, String dataSetId, int numberOfPeriods, int numberOfCorrectionPeriods, String famMemberPrefix, String assetIdType, int assetIdLength, boolean assetIdAuto, int assetIdStartValue, String creditIdType, int creditIdLength, boolean creditIdAuto, int creditIdStartValue, int[] usageFinDims, String[] finDimFrom, String[] finDimTo, int accountingPrinciple2Usage, String userId) throws Exception {
        Object[] result = new Object[2];
        CompanyManager manager = CompanyManagerFactory.getInstance(dbData);
        CompanyDataBean bean = new CompanyDataBean();
        bean.setId(id);
        bean.setDescription(description);
        bean.setInitialBookYear(initialBookYear);
        bean.setCurrentBookYear(currentBookYear);
        if (dataSetId != null && dataSetId.length() == 0) {
            dataSetId = null;
        }
        bean.setDataSetId(dataSetId);
        if (dataSetId == null) {
            bean.setNumberOfPeriods(numberOfPeriods);
            bean.setAccountingPrinciple2Usage(accountingPrinciple2Usage);
            bean.setNumberOfCorrectionPeriods(numberOfCorrectionPeriods);
        } else {
            bean.setNumberOfPeriods(-1);
            bean.setAccountingPrinciple2Usage(-1);
            bean.setNumberOfCorrectionPeriods(-1);
        }
        bean.setFamMemberPrefix(famMemberPrefix);
        bean.setAssetIdType(assetIdType);
        bean.setAssetIdLength(assetIdLength);
        bean.setAssetIdAuto(assetIdAuto);
        if (assetIdAuto) {
            if (assetIdStartValue < 0) {
                result[1] = "value_must_be_positive";
                return result;
            }
            bean.setAssetIdStartValue(assetIdStartValue);
        } else {
            bean.setAssetIdStartValue(0);
        }
        if (creditIdType == null) {
            creditIdType = "";
        }
        bean.setCreditIdType(creditIdType);
        bean.setCreditIdLength(creditIdLength);
        bean.setCreditIdAuto(creditIdAuto);
        if (creditIdAuto) {
            if (creditIdStartValue < 0) {
                result[1] = "value_must_be_positive";
                return result;
            }
            bean.setCreditIdStartValue(creditIdStartValue);
        } else {
            bean.setCreditIdStartValue(0);
        }
        int i = 0;
        while (i < 5) {
            if (dataSetId != null) {
                usageFinDims[i] = 0;
            }
            if (usageFinDims[i] == 0) {
                finDimFrom[i] = "";
                finDimTo[i] = "";
            }
            ++i;
        }
        bean.setFinancialDimension1Usage(usageFinDims[0]);
        bean.setFinancialDimension2Usage(usageFinDims[1]);
        bean.setFinancialDimension3Usage(usageFinDims[2]);
        bean.setFinancialDimension4Usage(usageFinDims[3]);
        bean.setFinancialDimension5Usage(usageFinDims[4]);
        bean.setFD1From(finDimFrom[0]);
        bean.setFD2From(finDimFrom[1]);
        bean.setFD3From(finDimFrom[2]);
        bean.setFD4From(finDimFrom[3]);
        bean.setFD5From(finDimFrom[4]);
        bean.setFD1To(finDimTo[0]);
        bean.setFD2To(finDimTo[1]);
        bean.setFD3To(finDimTo[2]);
        bean.setFD4To(finDimTo[3]);
        bean.setFD5To(finDimTo[4]);
        Environment env = (Environment)EnvironmentBO.get(dbData.getName())[0];
        int i2 = 5;
        while (i2 < 11) {
            if (usageFinDims[i2] != 0) {
                switch (i2 - 4) {
                    case 1: {
                        AnalysisGroup group = (AnalysisGroup)AnalysisGroupBO.create(dbData, id, 0, 3, env.getNameDebtor(), env.getShortNameDebtor(), "", 0, 0, false, 0)[0];
                        bean.setAGDebtorUsed(true);
                        bean.setAGDebtorSequenceNbr(group.getSeqNr());
                        break;
                    }
                    case 2: {
                        AnalysisGroup group = (AnalysisGroup)AnalysisGroupBO.create(dbData, id, 0, 3, env.getNameCreditor(), env.getShortNameCreditor(), "", 0, 0, false, 0)[0];
                        bean.setAGCreditorUsed(true);
                        bean.setAGCreditorSequenceNbr(group.getSeqNr());
                        break;
                    }
                    case 3: {
                        AnalysisGroup group = (AnalysisGroup)AnalysisGroupBO.create(dbData, id, 0, 3, env.getNameRelation(), env.getShortNameRelation(), "", 0, 0, false, 0)[0];
                        bean.setAGRelationUsed(true);
                        bean.setAGRelationSequenceNbr(group.getSeqNr());
                        break;
                    }
                    case 4: {
                        AnalysisGroup group = (AnalysisGroup)AnalysisGroupBO.create(dbData, id, 0, 4, env.getCMSName1(), env.getCMSShortName1(), "", 0, 0, false, 0)[0];
                        bean.setCMSDimension1Used(true);
                        bean.getAGCMSDimension1SequenceNbr();
                        break;
                    }
                    case 5: {
                        AnalysisGroup group = (AnalysisGroup)AnalysisGroupBO.create(dbData, id, 0, 4, env.getCMSName2(), env.getCMSShortName2(), "", 0, 0, false, 0)[0];
                        bean.setCMSDimension2Used(true);
                        bean.getAGCMSDimension2SequenceNbr();
                        break;
                    }
                    case 6: {
                        AnalysisGroup group = (AnalysisGroup)AnalysisGroupBO.create(dbData, id, 0, 4, env.getCMSName3(), env.getCMSShortName3(), "", 0, 0, false, 0)[0];
                        bean.setCMSDimension3Used(true);
                        bean.getAGCMSDimension3SequenceNbr();
                    }
                }
            }
            ++i2;
        }
        boolean alreadyActive = CompanyBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            Company company = manager.create(bean);
            result[0] = company;
            String message = CompanyBO.createCurrentBatch(company, userId);
            if (message != null) {
                CompanyBO.investigate(null, dbTransaction);
                result[1] = message;
                return result;
            }
            CompanyBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = CompanyBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String update(Company company, String description, int initialBookYear, int currentBookYear, Company dataSet, int numberOfPeriods, int numberOfCorrectionPeriods, String famMemberPrefix, String assetIdType, int assetIdLength, boolean assetIdAuto, int assetIdStartValue, String creditIdType, int creditIdLength, boolean creditIdAuto, int creditIdStartValue, int[] usageFinDims, String[] finDimFrom, String[] finDimTo, int accountingPrinciple2Usage, String userId, int[] seqNr, boolean[] seqNrMandatory, String[] defaults) throws Exception {
        if (assetIdAuto && assetIdStartValue < 0) {
            return "value_must_be_positive";
        }
        if (creditIdAuto && creditIdStartValue < 0) {
            return "value_must_be_positive";
        }
        boolean alreadyActive = CompanyBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            String message;
            company.setDescription(description);
            company.setInitialBookYear(initialBookYear);
            company.setCurrentBookYear(currentBookYear);
            company.setDataSet(dataSet);
            if (dataSet == null) {
                company.setNumberOfPeriods(numberOfPeriods);
                company.setAccountingPrinciple2Usage(accountingPrinciple2Usage);
                company.setNumberOfCorrectionPeriods(numberOfCorrectionPeriods);
            } else {
                company.setNumberOfPeriods(-1);
                company.setAccountingPrinciple2Usage(-1);
                company.setNumberOfCorrectionPeriods(-1);
            }
            company.setFamMemberPrefix(famMemberPrefix);
            company.setAssetIdType(assetIdType);
            company.setAssetIdLength(assetIdLength);
            company.setAssetIdAuto(assetIdAuto);
            if (assetIdAuto) {
                company.setAssetIdStartValue(assetIdStartValue);
            } else {
                company.setAssetIdStartValue(0);
            }
            company.setCreditIdType(creditIdType);
            company.setCreditIdLength(creditIdLength);
            company.setCreditIdAuto(creditIdAuto);
            if (creditIdAuto) {
                company.setCreditIdStartValue(creditIdStartValue);
            } else {
                company.setCreditIdStartValue(0);
            }
            int i = 0;
            while (i < 5) {
                if (dataSet != null) {
                    usageFinDims[i] = 0;
                }
                if (usageFinDims[i] == 0) {
                    finDimFrom[i] = "";
                    finDimTo[i] = "";
                }
                ++i;
            }
            company.setFinancialDimension1Usage(usageFinDims[0]);
            company.setFinancialDimension2Usage(usageFinDims[1]);
            company.setFinancialDimension3Usage(usageFinDims[2]);
            company.setFinancialDimension4Usage(usageFinDims[3]);
            company.setFinancialDimension5Usage(usageFinDims[4]);
            company.setFD1From(finDimFrom[0]);
            company.setFD2From(finDimFrom[1]);
            company.setFD3From(finDimFrom[2]);
            company.setFD4From(finDimFrom[3]);
            company.setFD5From(finDimFrom[4]);
            company.setFD1To(finDimTo[0]);
            company.setFD2To(finDimTo[1]);
            company.setFD3To(finDimTo[2]);
            company.setFD4To(finDimTo[3]);
            company.setFD5To(finDimTo[4]);
            company.setSeqNr1Mandatory(seqNrMandatory[0]);
            company.setSeqNr2Mandatory(seqNrMandatory[1]);
            company.setSeqNr3Mandatory(seqNrMandatory[2]);
            company.setSeqNr4Mandatory(seqNrMandatory[3]);
            company.setSeqNr5Mandatory(seqNrMandatory[4]);
            company.setSeqNr6Mandatory(seqNrMandatory[5]);
            company.setDefaultAnalysisCode1(defaults[0]);
            company.setDefaultAnalysisCode2(defaults[1]);
            company.setDefaultAnalysisCode3(defaults[2]);
            company.setDefaultAnalysisCode4(defaults[3]);
            company.setDefaultAnalysisCode5(defaults[4]);
            company.setDefaultAnalysisCode6(defaults[5]);
            Environment env = (Environment)EnvironmentBO.get(company.getDBData().getName())[0];
            int i2 = 5;
            while (i2 < 11) {
                block52: {
                    block51: {
                        if (usageFinDims[i2] != 0) break block51;
                        switch (i2 - 4) {
                            case 1: {
                                if (company.getAGDebtorUsed()) {
                                    AnalysisGroupBO.disableAnalysisGroup(company.getDBData(), company.getId(), company.getAGDebtorSequenceNbr());
                                    company.setAGDebtorUsed(false);
                                    break;
                                }
                                break block52;
                            }
                            case 2: {
                                if (company.getAGCreditorUsed()) {
                                    AnalysisGroupBO.disableAnalysisGroup(company.getDBData(), company.getId(), company.getAGCreditorSequenceNbr());
                                    company.setAGCreditorUsed(false);
                                    break;
                                }
                                break block52;
                            }
                            case 3: {
                                if (company.getAGRelationUsed()) {
                                    AnalysisGroupBO.disableAnalysisGroup(company.getDBData(), company.getId(), company.getAGRelationSequenceNbr());
                                    company.setAGRelationUsed(false);
                                    break;
                                }
                                break block52;
                            }
                            case 4: {
                                if (company.getCMSDimension1Used()) {
                                    AnalysisGroupBO.disableAnalysisGroup(company.getDBData(), company.getId(), company.getAGCMSDimension1SequenceNbr());
                                    company.setCMSDimension1Used(false);
                                    break;
                                }
                                break block52;
                            }
                            case 5: {
                                if (company.getCMSDimension2Used()) {
                                    AnalysisGroupBO.disableAnalysisGroup(company.getDBData(), company.getId(), company.getAGCMSDimension2SequenceNbr());
                                    company.setCMSDimension2Used(false);
                                    break;
                                }
                                break block52;
                            }
                            case 6: {
                                if (!company.getCMSDimension3Used()) break block52;
                                AnalysisGroupBO.disableAnalysisGroup(company.getDBData(), company.getId(), company.getAGCMSDimension3SequenceNbr());
                                company.setCMSDimension3Used(false);
                            }
                            default: {
                                break;
                            }
                            {
                            }
                        }
                        break block52;
                    }
                    switch (i2 - 4) {
                        case 1: {
                            AnalysisGroup group;
                            if (company.getAGDebtorUsed()) break;
                            if (company.getAGDebtorSequenceNbr() > 0) {
                                AnalysisGroupBO.enableAnalysisGroup(company.getDBData(), company.getId(), company.getAGDebtorSequenceNbr());
                            } else {
                                group = (AnalysisGroup)AnalysisGroupBO.create(company.getDBData(), company.getId(), 0, 3, env.getNameDebtor(), env.getShortNameDebtor(), "", 0, 0, false, 0)[0];
                                company.setAGDebtorSequenceNbr(group.getSeqNr());
                            }
                            company.setAGDebtorUsed(true);
                            break;
                        }
                        case 2: {
                            AnalysisGroup group;
                            if (company.getAGCreditorUsed()) break;
                            if (company.getAGCreditorSequenceNbr() > 0) {
                                AnalysisGroupBO.enableAnalysisGroup(company.getDBData(), company.getId(), company.getAGCreditorSequenceNbr());
                            } else {
                                group = (AnalysisGroup)AnalysisGroupBO.create(company.getDBData(), company.getId(), 0, 3, env.getNameCreditor(), env.getShortNameCreditor(), "", 0, 0, false, 0)[0];
                                company.setAGCreditorSequenceNbr(group.getSeqNr());
                            }
                            company.setAGCreditorUsed(true);
                            break;
                        }
                        case 3: {
                            AnalysisGroup group;
                            if (company.getAGRelationUsed()) break;
                            if (company.getAGRelationSequenceNbr() > 0) {
                                AnalysisGroupBO.enableAnalysisGroup(company.getDBData(), company.getId(), company.getAGRelationSequenceNbr());
                            } else {
                                group = (AnalysisGroup)AnalysisGroupBO.create(company.getDBData(), company.getId(), 0, 3, env.getNameRelation(), env.getShortNameRelation(), "", 0, 0, false, 0)[0];
                                company.setAGRelationSequenceNbr(group.getSeqNr());
                            }
                            company.setAGRelationUsed(true);
                            break;
                        }
                        case 4: {
                            AnalysisGroup group;
                            if (company.getCMSDimension1Used()) break;
                            if (company.getAGCMSDimension1SequenceNbr() > 0) {
                                AnalysisGroupBO.enableAnalysisGroup(company.getDBData(), company.getId(), company.getAGCMSDimension1SequenceNbr());
                            } else {
                                group = (AnalysisGroup)AnalysisGroupBO.create(company.getDBData(), company.getId(), 0, 4, env.getCMSName1(), env.getCMSShortName1(), "", 0, 0, false, 0)[0];
                                company.setAGCMSDimension1SequenceNbr(group.getSeqNr());
                            }
                            company.setCMSDimension1Used(true);
                            break;
                        }
                        case 5: {
                            AnalysisGroup group;
                            if (company.getCMSDimension2Used()) break;
                            if (company.getAGCMSDimension2SequenceNbr() > 0) {
                                AnalysisGroupBO.enableAnalysisGroup(company.getDBData(), company.getId(), company.getAGCMSDimension2SequenceNbr());
                            } else {
                                group = (AnalysisGroup)AnalysisGroupBO.create(company.getDBData(), company.getId(), 0, 4, env.getCMSName2(), env.getCMSShortName2(), "", 0, 0, false, 0)[0];
                                company.setAGCMSDimension2SequenceNbr(group.getSeqNr());
                            }
                            company.setCMSDimension2Used(true);
                            break;
                        }
                        case 6: {
                            AnalysisGroup group;
                            if (company.getCMSDimension3Used()) break;
                            if (company.getAGCMSDimension3SequenceNbr() > 0) {
                                AnalysisGroupBO.enableAnalysisGroup(company.getDBData(), company.getId(), company.getAGCMSDimension3SequenceNbr());
                            } else {
                                group = (AnalysisGroup)AnalysisGroupBO.create(company.getDBData(), company.getId(), 0, 4, env.getCMSName3(), env.getCMSShortName3(), "", 0, 0, false, 0)[0];
                                company.setAGCMSDimension3SequenceNbr(group.getSeqNr());
                            }
                            company.setCMSDimension3Used(true);
                        }
                    }
                }
                ++i2;
            }
            if (company.getCurrentBatchId() == null && (message = CompanyBO.createCurrentBatch(company, userId)) != null) {
                CompanyBO.investigate(null, dbTransaction);
                return message;
            }
            CompanyDataBean bean = company.getCompanyDataBean();
            bean.setSeqNr1(seqNr[0] == 0 ? null : new Integer(seqNr[0]));
            bean.setSeqNr2(seqNr[1] == 0 ? null : new Integer(seqNr[1]));
            bean.setSeqNr3(seqNr[2] == 0 ? null : new Integer(seqNr[2]));
            bean.setSeqNr4(seqNr[3] == 0 ? null : new Integer(seqNr[3]));
            bean.setSeqNr5(seqNr[4] == 0 ? null : new Integer(seqNr[4]));
            bean.setSeqNr6(seqNr[5] == 0 ? null : new Integer(seqNr[5]));
            company.update(bean);
            CompanyBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return CompanyBO.investigate(e, dbTransaction);
        }
        return null;
    }

    static void updateExternalAnalysisGroups(Environment environment, int externalAnalysisGroup, String name, String shortName) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", environment.getFacLib());
        Collection companies = CompanyBO.getCompanies(map);
        Iterator ci = companies.iterator();
        int[] sequenceNumbers = new int[7];
        while (ci.hasNext()) {
            Company company = (Company)ci.next();
            sequenceNumbers[1] = company.getAGDebtorSequenceNbr();
            sequenceNumbers[2] = company.getAGCreditorSequenceNbr();
            sequenceNumbers[3] = company.getAGRelationSequenceNbr();
            sequenceNumbers[4] = company.getAGCMSDimension1SequenceNbr();
            sequenceNumbers[5] = company.getAGCMSDimension2SequenceNbr();
            sequenceNumbers[6] = company.getAGCMSDimension3SequenceNbr();
            if (sequenceNumbers[externalAnalysisGroup] <= 0) continue;
            AnalysisGroupBO.updateExternalAnalysisGroup(environment, sequenceNumbers[externalAnalysisGroup], name, shortName);
        }
    }

    public static Object[] getCurrentBatch(DBData dbData, String companyId) throws Exception {
        Object[] result = new Object[2];
        Company company = (Company)CompanyBO.get(dbData, companyId)[0];
        TransactionBatchManager manager = TransactionBatchManagerFactory.getInstance(dbData);
        TransactionBatchPK key = new TransactionBatchPK();
        key.setCompanyId(companyId);
        key.setBatchId(company.getCurrentBatchId());
        try {
            result[0] = manager.findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static String createCurrentBatch(Company company, String userId) throws Exception {
        boolean alreadyActive = CompanyBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            Object[] result = TransactionBatchBO.create(company.getDBData(), company.getId(), userId, 0);
            if (result[1] != null) {
                CompanyBO.investigate(null, dbTransaction);
                return (String)result[1];
            }
            TransactionBatch transactionBatch = (TransactionBatch)result[0];
            company.setCurrentBatchId(new Integer(transactionBatch.getBatchId()));
            CompanyBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return CompanyBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(Company company) throws Exception {
        block3: {
            try {
                if (!CompanyBO.isUsedAsDataSet(company)) break block3;
                return "company_is_used_as_dataset";
            }
            catch (Exception e) {
                return CompanyBO.investigate(e, null);
            }
        }
        company.delete();
        return null;
    }

    public static boolean isUsedAsDataSet(Company company) throws Exception {
        ExecutableQuery query = QueryFactory.create(Company.class);
        query.setFilter("dataSetId = '" + company.getId() + "'");
        CompanyManager manager = CompanyManagerFactory.getInstance(company.getDBData());
        return manager.getFirstObject(query) != null;
    }
}

