/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.util.Collection;
import java.util.HashMap;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.FinancialDimensionHistory;
import nl.ibs.fac.db.FinancialDimensionHistoryDataBean;
import nl.ibs.fac.db.FinancialDimensionHistoryManager;
import nl.ibs.fac.db.FinancialDimensionHistoryManagerFactory;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public abstract class FinancialDimensionHistoryBO
extends BOAdapter {
    public static FinancialDimensionHistory getLast(Asset asset, int bookYear, int period) throws Exception {
        FinancialDimensionHistoryManager manager = FinancialDimensionHistoryManagerFactory.getInstance(asset.getDBData());
        String sql = "companyId = ?_companyId AND assetId = ?_assetId AND cora = ?_cora AND ((bookYear = ?_bookYear AND period <= ?_period) OR (bookYear < ?_bookYear))";
        ExecutableQuery query = QueryFactory.create(FinancialDimensionHistory.class, sql, "bookYear descending, period descending");
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", asset.getCompanyId());
        parameters.put("_assetId", asset.getId());
        parameters.put("_cora", asset.getCora());
        parameters.put("_bookYear", "" + bookYear);
        parameters.put("_period", "" + period);
        query.setParameters(parameters);
        return manager.getFirstObject(query);
    }

    public static Collection getAfter(Asset asset, int bookYear, int period) throws Exception {
        FinancialDimensionHistoryManager manager = FinancialDimensionHistoryManagerFactory.getInstance(asset.getDBData());
        String sql = "companyId = ?_companyId AND assetId = ?_assetId AND cora = ?_cora AND ((bookYear = ?_bookYear AND period > ?_period) OR (bookYear > ?_bookYear))";
        ExecutableQuery query = QueryFactory.create(FinancialDimensionHistory.class, sql, "bookYear, period");
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", asset.getCompanyId());
        parameters.put("_assetId", asset.getId());
        parameters.put("_cora", asset.getCora());
        parameters.put("_bookYear", "" + bookYear);
        parameters.put("_period", "" + period);
        query.setParameters(parameters);
        return manager.getCollection(query);
    }

    public static Object[] create(Asset asset, int bookYear, int period, String finDimId1, String finDimId2, String finDimId3, String finDimId4, String finDimId5) throws Exception {
        Object[] result = new Object[2];
        FinancialDimensionHistoryManager manager = FinancialDimensionHistoryManagerFactory.getInstance(asset.getDBData());
        boolean alreadyActive = FinancialDimensionHistoryBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            String message;
            boolean create = false;
            if (PeriodHelper.equals(bookYear, period, asset.getStartUseYear(), asset.getStartUsePeriod())) {
                Log.debug((String)"1");
                message = FinancialDimensionHistoryBO.deleteAll(asset);
                if (message != null) {
                    FinancialDimensionHistoryBO.investigate(null, dbTransaction);
                    result[1] = message;
                    return result;
                }
            } else if (PeriodHelper.isAfter(bookYear, period, asset.getFinDimYearFrom(), asset.getFinDimPeriodFrom())) {
                Log.debug((String)"2");
                create = true;
            } else if (PeriodHelper.isBefore(bookYear, period, asset.getFinDimYearFrom(), asset.getFinDimPeriodFrom())) {
                Log.debug((String)"3");
                message = FinancialDimensionHistoryBO.deleteAfterOrEquals(asset, bookYear, period);
                if (message != null) {
                    FinancialDimensionHistoryBO.investigate(null, dbTransaction);
                    result[1] = message;
                    return result;
                }
            }
            if (create) {
                FinancialDimensionHistoryDataBean bean = new FinancialDimensionHistoryDataBean();
                bean.setCompanyId(asset.getCompanyId());
                bean.setAssetId(asset.getId());
                bean.setCora(asset.getCora());
                bean.setBookYear(asset.getFinDimYearFrom());
                bean.setPeriod(asset.getFinDimPeriodFrom());
                bean.setFinDimId1(asset.getFinDimId1());
                bean.setFinDimId2(asset.getFinDimId2());
                bean.setFinDimId3(asset.getFinDimId3());
                bean.setFinDimId4(asset.getFinDimId4());
                bean.setFinDimId5(asset.getFinDimId5());
                result[0] = manager.create(bean);
            }
            if (PeriodHelper.equals(bookYear, period, asset.getStartUseYear(), asset.getStartUsePeriod())) {
                asset.setFinDimYearFrom(0);
                asset.setFinDimPeriodFrom(0);
            } else {
                asset.setFinDimYearFrom(bookYear);
                asset.setFinDimPeriodFrom(period);
            }
            asset.setFinDimId1(finDimId1);
            asset.setFinDimId2(finDimId2);
            asset.setFinDimId3(finDimId3);
            asset.setFinDimId4(finDimId4);
            asset.setFinDimId5(finDimId5);
            FinancialDimensionHistoryBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = FinancialDimensionHistoryBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String deleteAll(Asset asset) throws Exception {
        for (FinancialDimensionHistory financialDimensionHistory : FinancialDimensionHistoryBO.getAll(asset)) {
            String message = FinancialDimensionHistoryBO.delete(financialDimensionHistory);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    private static Collection getAll(Asset asset) throws Exception {
        FinancialDimensionHistoryManager manager = FinancialDimensionHistoryManagerFactory.getInstance(asset.getDBData());
        String sql = "companyId = ?_companyId AND assetId = ?_assetId AND cora = ?_cora";
        ExecutableQuery query = QueryFactory.create(FinancialDimensionHistory.class, sql);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", asset.getCompanyId());
        parameters.put("_assetId", asset.getId());
        parameters.put("_cora", asset.getCora());
        query.setParameters(parameters);
        return manager.getCollection(query);
    }

    private static String deleteAfterOrEquals(Asset asset, int bookYear, int period) throws Exception {
        for (FinancialDimensionHistory financialDimensionHistory : FinancialDimensionHistoryBO.getAfterOrEquals(asset, bookYear, period)) {
            String message = FinancialDimensionHistoryBO.delete(financialDimensionHistory);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    private static Collection getAfterOrEquals(Asset asset, int bookYear, int period) throws Exception {
        FinancialDimensionHistoryManager manager = FinancialDimensionHistoryManagerFactory.getInstance(asset.getDBData());
        String sql = "companyId = ?_companyId AND assetId = ?_assetId AND cora = ?_cora AND ((bookYear = ?_bookYear AND period >= ?_period) OR (bookYear > ?_bookYear))";
        ExecutableQuery query = QueryFactory.create(FinancialDimensionHistory.class, sql);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", asset.getCompanyId());
        parameters.put("_assetId", asset.getId());
        parameters.put("_cora", asset.getCora());
        parameters.put("_bookYear", "" + bookYear);
        parameters.put("_period", "" + period);
        query.setParameters(parameters);
        return manager.getCollection(query);
    }

    private static String delete(FinancialDimensionHistory financialDimensionHistory) throws Exception {
        try {
            financialDimensionHistory.delete();
        }
        catch (Exception e) {
            return FinancialDimensionHistoryBO.investigate(e, null);
        }
        return null;
    }
}

