/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.InterestPeriod;
import nl.ibs.fac.db.InterestPeriodDataBean;
import nl.ibs.fac.db.InterestPeriodManager;
import nl.ibs.fac.db.InterestPeriodManagerFactory;
import nl.ibs.fac.db.InterestPeriodPK;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class InterestPeriodBO
extends BOAdapter {
    public static BigDecimal getPercentage(DBData dbData, String interestTableId, int bookYear, int period) throws Exception {
        InterestPeriodManager manager = InterestPeriodManagerFactory.getInstance(dbData);
        String sql = "interestTableId = ?_interestTableId AND ((bookYear = ?_bookYear AND period <= ?_period) OR (bookYear < ?_bookYear))";
        ExecutableQuery query = QueryFactory.create(InterestPeriod.class, sql, "bookYear descending, period descending");
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_interestTableId", interestTableId);
        parameters.put("_bookYear", "" + bookYear);
        parameters.put("_period", "" + period);
        query.setParameters(parameters);
        InterestPeriod interestPeriod = manager.getFirstObject(query);
        if (interestPeriod == null) {
            return new BigDecimal(0);
        }
        return interestPeriod.getPercentage();
    }

    public static Collection getPercentages(DBData dbData, String interestTableId) throws Exception {
        InterestPeriodManager manager = InterestPeriodManagerFactory.getInstance(dbData);
        String sql = "interestTableId = ?_interestTableId";
        ExecutableQuery query = QueryFactory.create(InterestPeriod.class, sql, "bookYear, period");
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_interestTableId", interestTableId);
        query.setParameters(parameters);
        return manager.getCollection(query);
    }

    public static Object[] create(DBData dbData, String interestTableId, int bookYear, int period, BigDecimal percentage) throws Exception {
        Object[] result = new Object[2];
        InterestPeriodManager manager = InterestPeriodManagerFactory.getInstance(dbData);
        InterestPeriodDataBean bean = new InterestPeriodDataBean();
        bean.setInterestTableId(interestTableId);
        bean.setBookYear(bookYear);
        bean.setPeriod(period);
        bean.setPercentage(percentage);
        try {
            result[0] = manager.create(bean);
        }
        catch (Exception e) {
            result[1] = InterestPeriodBO.investigate(e, null);
        }
        return result;
    }

    public static void createFirstPercentage(DBData dbData, String interestTableId, int bookYear, int period, BigDecimal percentage) throws Exception {
        InterestPeriodManager manager = InterestPeriodManagerFactory.getInstance(dbData);
        InterestPeriodDataBean bean = new InterestPeriodDataBean();
        bean.setInterestTableId(interestTableId);
        bean.setBookYear(bookYear);
        bean.setPeriod(period);
        bean.setPercentage(percentage);
        manager.create(bean);
    }

    public static String delete(InterestPeriod interestPeriod) throws Exception {
        try {
            interestPeriod.delete();
        }
        catch (Exception e) {
            return InterestPeriodBO.investigate(e, null);
        }
        return null;
    }

    public static boolean checkExistence(InterestTable table, int year, int period) throws Exception {
        InterestPeriodPK pk = new InterestPeriodPK();
        pk.setInterestTableId(table.getId());
        pk.setBookYear(year);
        pk.setPeriod(period);
        try {
            InterestPeriodManagerFactory.getInstance(table.getDBData()).findByPrimaryKey(pk);
        }
        catch (FinderException e) {
            return false;
        }
        return true;
    }
}

