/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionDataBean;
import nl.ibs.fac.db.TransactionManager;
import nl.ibs.fac.db.TransactionManagerFactory;
import nl.ibs.fac.db.TransactionPK;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.queries.TransactionQuery;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class TransactionBO
extends BOAdapter {
    public static final String ACCOUNTINGPRINCIPLE2 = "AccountingPrinciple2";
    public static final String REASONCODEFROM = "ReasonCodeFrom";
    public static final String REASONCODETO = "ReasonCodeTo";
    public static final String FROMFINDIMID1 = "FromFinDimId1";
    public static final String TOFINDIMID1 = "ToFinDimId1";
    public static final String FROMFINDIMID2 = "FromFinDimId2";
    public static final String TOFINDIMID2 = "ToFinDimId2";
    public static final String FROMFINDIMID3 = "FromFinDimId3";
    public static final String TOFINDIMID3 = "ToFinDimId3";
    public static final String FROMFINDIMID4 = "FromFinDimId4";
    public static final String TOFINDIMID4 = "ToFinDimId4";
    public static final String FROMFINDIMID5 = "FromFinDimId5";
    public static final String TOFINDIMID5 = "ToFinDimId5";

    public static Object[] get(DBData dbData, String companyId, int documentNr, int seqNr) throws Exception {
        Object[] result = new Object[2];
        TransactionPK key = new TransactionPK();
        key.setCompanyId(companyId);
        key.setDocumentNr(documentNr);
        key.setSeqNr(seqNr);
        try {
            result[0] = TransactionManagerFactory.getInstance(dbData).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Object[] create(DBData dbData, String companyId, int documentNr, int seqNr, String description, String cora, String assetId, int accountingPrinciple, int mainTransactionType, int transactionType, int bookYear, int period, int bookYearForJournalization, int periodForJournalization, BigDecimal amount1, BigDecimal amount2, BigDecimal amount3, String incomingFinancialTransactionId, String finDimId1, String finDimId2, String finDimId3, String finDimId4, String finDimId5, int journalingState, int reasonCode, int batchId, String createdByUser, String pfTypeId) throws Exception {
        Object[] result = new Object[2];
        TransactionManager manager = TransactionManagerFactory.getInstance(dbData);
        TransactionDataBean bean = new TransactionDataBean();
        bean.setCompanyId(companyId);
        if (documentNr == 0) {
            documentNr = manager.getDocumentNrMax(companyId) + 1;
        }
        bean.setDocumentNr(documentNr);
        bean.setSeqNr(seqNr);
        if (description == null) {
            description = "";
        }
        if (description.length() > 30) {
            bean.setDescription(description.substring(0, 30));
        } else {
            bean.setDescription(description);
        }
        bean.setCora(cora);
        bean.setAssetId(assetId);
        bean.setAccountingPrinciple(accountingPrinciple);
        bean.setMainTransactionType(mainTransactionType);
        bean.setTransactionType(transactionType);
        bean.setBookYear(bookYear);
        bean.setPeriod(period);
        bean.setBookYearForJournalization(bookYearForJournalization);
        bean.setPeriodForJournalization(periodForJournalization);
        bean.setAmount1(amount1);
        bean.setAmount2(amount2);
        bean.setAmount3(amount3);
        bean.setIncomingFinancialTransactionId(incomingFinancialTransactionId);
        bean.setProFormaTypeId(pfTypeId);
        bean.setFinDimId1(finDimId1);
        bean.setFinDimId2(finDimId2);
        bean.setFinDimId3(finDimId3);
        bean.setFinDimId4(finDimId4);
        bean.setFinDimId5(finDimId5);
        bean.setJournalingState(journalingState);
        bean.setReasonCode(reasonCode);
        if (batchId == -1) {
            Company company = (Company)CompanyBO.get(dbData, companyId)[0];
            batchId = company.getCurrentBatchId();
        }
        bean.setBatchId(batchId);
        bean.setCreatedByUser(createdByUser);
        bean.setCreationDate(new Date());
        boolean alreadyActive = TransactionBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        boolean created = false;
        while (!created) {
            try {
                result[0] = manager.create(bean);
                TransactionBO.commitTransaction(alreadyActive);
                created = true;
            }
            catch (Exception e) {
                if (e.getMessage().startsWith("[SQL0803]")) {
                    bean.setDocumentNr(++documentNr);
                    continue;
                }
                result[1] = TransactionBO.investigate(e, dbTransaction);
                return result;
            }
        }
        return result;
    }

    public static BigDecimal[] getManualCapitalCosts(Credit credit) throws Exception {
        BigDecimal[] amounts = new BigDecimal[]{new BigDecimal("0.00"), new BigDecimal("0.00")};
        TransactionQuery query = new TransactionQuery(credit.getDBData(), credit, false);
        Collection transactions = query.fetchData(null, null, null, 0);
        for (Transaction transaction : transactions) {
            if (transaction.getTransactionType() != 90) continue;
            amounts[0] = amounts[0].add(transaction.getAmount2());
            amounts[1] = amounts[1].add(transaction.getAmount3());
        }
        return amounts;
    }

    public static boolean hasTransactions(Credit credit) throws Exception {
        TransactionQuery query = new TransactionQuery(credit.getDBData(), credit, false);
        return query.fetchData(null, null, null, 0).size() > 0;
    }

    public static BigDecimal[] calculateAcquisitionValue(Asset asset, int accountingPrinciple, int yearTo, int periodTo) throws Exception {
        BigDecimal[] amounts = new BigDecimal[]{new BigDecimal(0), new BigDecimal(0)};
        TransactionManager manager = TransactionManagerFactory.getInstance(asset.getDBData());
        ExecutableQuery query = QueryFactory.create(Transaction.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = TransactionBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", asset.getCompanyId());
        filter = TransactionBO.addFilterTerm(filter, "cora = ?_cora");
        parameters.put("_cora", asset.getCora());
        filter = TransactionBO.addFilterTerm(filter, "assetId = ?_assetId");
        parameters.put("_assetId", asset.getId());
        filter = TransactionBO.addFilterTerm(filter, "accountingPrinciple = ?_accountingPrinciple");
        parameters.put("_accountingPrinciple", new Integer(accountingPrinciple));
        String filterTerm = "(mainTransactionType = 1 OR mainTransactionType = 2)";
        filter = TransactionBO.addFilterTerm(filter, filterTerm);
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        for (Transaction transaction : manager.getCollection(query)) {
            if (yearTo != 0 && PeriodHelper.isAfter(transaction.getBookYear(), transaction.getPeriod(), yearTo, periodTo)) continue;
            amounts[0] = amounts[0].add(transaction.getAmount1());
            amounts[1] = amounts[1].add(transaction.getAmount2());
        }
        return amounts;
    }

    public static BigDecimal[] calculateDepreciatedTotal(Asset asset, int accountingPrinciple, int yearTo, int periodTo) throws Exception {
        BigDecimal[] amounts = new BigDecimal[]{new BigDecimal(0), new BigDecimal(0)};
        TransactionManager manager = TransactionManagerFactory.getInstance(asset.getDBData());
        ExecutableQuery query = QueryFactory.create(Transaction.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = TransactionBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", asset.getCompanyId());
        filter = TransactionBO.addFilterTerm(filter, "cora = ?_cora");
        parameters.put("_cora", asset.getCora());
        filter = TransactionBO.addFilterTerm(filter, "assetId = ?_assetId");
        parameters.put("_assetId", asset.getId());
        filter = TransactionBO.addFilterTerm(filter, "accountingPrinciple = ?_accountingPrinciple");
        parameters.put("_accountingPrinciple", new Integer(accountingPrinciple));
        String filterTerm = "mainTransactionType = 3";
        filter = TransactionBO.addFilterTerm(filter, filterTerm);
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        for (Transaction transaction : manager.getCollection(query)) {
            if (yearTo != 0 && PeriodHelper.isAfter(transaction.getBookYear(), transaction.getPeriod(), yearTo, periodTo)) continue;
            amounts[0] = amounts[0].add(transaction.getAmount2());
            amounts[1] = amounts[1].add(transaction.getAmount3());
        }
        return amounts;
    }

    public static Collection getAfterOrEquals(Asset asset, int bookYear, int period, int accountingPrinciple) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(asset.getDBData());
        String sql = "companyId = ?_companyId AND assetId = ?_assetId AND cora = ?_cora AND accountingPrinciple = ?_accountingPrinciple AND ((bookYear = ?_bookYear AND period >= ?_period) OR (bookYear > ?_bookYear))";
        ExecutableQuery query = QueryFactory.create(Transaction.class, sql);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", asset.getCompanyId());
        parameters.put("_assetId", asset.getId());
        parameters.put("_cora", asset.getCora());
        parameters.put("_accountingPrinciple", "" + accountingPrinciple);
        parameters.put("_bookYear", "" + bookYear);
        parameters.put("_period", "" + period);
        query.setParameters(parameters);
        return manager.getCollection(query);
    }

    public static Collection getBeforeOrEquals(Asset asset, int bookYear, int period, int accountingPrinciple, boolean onlyPosted, boolean skipAnonymous) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(asset.getDBData());
        String sql = "companyId = ?_companyId AND assetId = ?_assetId AND cora = ?_cora AND accountingPrinciple = ?_accountingPrinciple AND ((bookYear = ?_bookYear AND period <= ?_period) OR (bookYear < ?_bookYear))";
        if (onlyPosted) {
            sql = String.valueOf(sql) + " AND " + "state" + " = ?_state";
        }
        if (skipAnonymous) {
            sql = String.valueOf(sql) + " AND " + "mainTransactionType" + " != ?_anonymous";
        }
        ExecutableQuery query = QueryFactory.create(Transaction.class, sql);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", asset.getCompanyId());
        parameters.put("_assetId", asset.getId());
        parameters.put("_cora", asset.getCora());
        parameters.put("_accountingPrinciple", "" + accountingPrinciple);
        parameters.put("_bookYear", "" + bookYear);
        parameters.put("_period", "" + period);
        if (onlyPosted) {
            parameters.put("_state", "1");
        }
        if (skipAnonymous) {
            parameters.put("_anonymous", "9");
        }
        query.setParameters(parameters);
        query.setOrdering("bookYearForJournalization ascending, periodForJournalization ascending, transactionType ascending");
        return manager.getCollection(query);
    }

    public static Collection getBeforeOrEquals(Credit credit, int bookYear, int period, int accountingPrinciple, boolean onlyPosted, boolean skipAnonymous) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(credit.getDBData());
        String sql = "companyId = ?_companyId AND creditId = ?_creditId AND cora = ?_cora AND accountingPrinciple = ?_accountingPrinciple AND ((bookYear = ?_bookYear AND period <= ?_period) OR (bookYear < ?_bookYear))";
        if (onlyPosted) {
            sql = String.valueOf(sql) + " AND " + "state" + " = ?_state";
        }
        if (skipAnonymous) {
            sql = String.valueOf(sql) + " AND " + "mainTransactionType" + " != ?_anonymous";
        }
        ExecutableQuery query = QueryFactory.create(Transaction.class, sql);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", credit.getCompanyId());
        parameters.put("_creditId", credit.getId());
        parameters.put("_cora", "C");
        parameters.put("_accountingPrinciple", "" + accountingPrinciple);
        parameters.put("_bookYear", "" + bookYear);
        parameters.put("_period", "" + period);
        if (onlyPosted) {
            parameters.put("_state", "1");
        }
        if (skipAnonymous) {
            parameters.put("_anonymous", "9");
        }
        query.setParameters(parameters);
        query.setOrdering("bookYearForJournalization ascending, periodForJournalization ascending, transactionType ascending");
        return manager.getCollection(query);
    }

    public static Collection get(Asset asset, int bookYear, int accountingPrinciple, boolean onlyPosted, boolean skipAnonymous) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(asset.getDBData());
        String sql = "companyId = ?_companyId AND assetId = ?_assetId AND cora = ?_cora AND accountingPrinciple = ?_accountingPrinciple AND bookYear = ?_bookYear";
        if (onlyPosted) {
            sql = String.valueOf(sql) + " AND " + "state" + " = ?_state";
        }
        if (skipAnonymous) {
            sql = String.valueOf(sql) + " AND " + "mainTransactionType" + " != ?_anonymous";
        }
        ExecutableQuery query = QueryFactory.create(Transaction.class, sql);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", asset.getCompanyId());
        parameters.put("_assetId", asset.getId());
        parameters.put("_cora", asset.getCora());
        parameters.put("_accountingPrinciple", "" + accountingPrinciple);
        parameters.put("_bookYear", "" + bookYear);
        if (onlyPosted) {
            parameters.put("_state", "1");
        }
        if (skipAnonymous) {
            parameters.put("_anonymous", "9");
        }
        query.setParameters(parameters);
        query.setOrdering("bookYearForJournalization ascending, periodForJournalization ascending, transactionType ascending");
        return manager.getCollection(query);
    }

    public static Transaction getFirstTransaction(Asset asset, Boolean posted) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(asset.getDBData());
        return manager.getFirstObject(TransactionBO.createQuery(asset, posted));
    }

    public static Collection getTransactions(Asset asset) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(asset.getDBData());
        return manager.getCollection(TransactionBO.createQuery(asset, null));
    }

    private static ExecutableQuery createQuery(Asset asset, Boolean posted) throws Exception {
        ExecutableQuery query = QueryFactory.create(Transaction.class, null, "documentNr, seqNr");
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = TransactionBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", asset.getCompanyId());
        filter = TransactionBO.addFilterTerm(filter, "cora = ?_cora");
        parameters.put("_cora", asset.getCora());
        filter = TransactionBO.addFilterTerm(filter, "assetId = ?_id");
        parameters.put("_id", asset.getId());
        if (posted != null) {
            filter = TransactionBO.addFilterTerm(filter, "state = ?_state");
            if (posted.booleanValue()) {
                parameters.put("_state", new Integer(1));
            } else {
                parameters.put("_state", new Integer(0));
            }
        }
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        return query;
    }

    public static Collection getTransactions(Valuation valuation, boolean posted) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(valuation.getDBData());
        return manager.getCollection(TransactionBO.createQuery(valuation, posted));
    }

    private static ExecutableQuery createQuery(Valuation valuation, boolean posted) throws Exception {
        ExecutableQuery query = QueryFactory.create(Transaction.class, null, "assetId, documentNr, seqNr");
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = TransactionBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", valuation.getCompanyId());
        filter = TransactionBO.addFilterTerm(filter, "cora = ?_cora");
        parameters.put("_cora", valuation.getCora());
        filter = TransactionBO.addFilterTerm(filter, "assetId = ?_id");
        parameters.put("_id", valuation.getAssetId());
        filter = TransactionBO.addFilterTerm(filter, "accountingPrinciple = ?_ap");
        parameters.put("_ap", new Integer(valuation.getAccountingPrinciple()));
        filter = TransactionBO.addFilterTerm(filter, "state = ?_state");
        if (posted) {
            parameters.put("_state", new Integer(1));
        } else {
            parameters.put("_state", new Integer(0));
        }
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        return query;
    }

    public static Collection getTransactions(Company company, boolean posted) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(company.getDBData());
        return manager.getCollection(TransactionBO.createQuery(company, posted));
    }

    private static ExecutableQuery createQuery(Company company, boolean posted) throws Exception {
        ExecutableQuery query = QueryFactory.create(Transaction.class, null, "documentNr, seqNr");
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = TransactionBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", company.getId());
        filter = TransactionBO.addFilterTerm(filter, "state = ?_state");
        if (posted) {
            parameters.put("_state", new Integer(1));
        } else {
            parameters.put("_state", new Integer(0));
        }
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        return query;
    }

    public static Collection getTransactionsForDocument(Transaction transaction) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(transaction.getDBData());
        ExecutableQuery query = QueryFactory.create(Transaction.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = TransactionBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", transaction.getCompanyId());
        filter = TransactionBO.addFilterTerm(filter, "documentNr = ?_documentNr");
        parameters.put("_documentNr", new Integer(transaction.getDocumentNr()));
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        return manager.getCollection(query);
    }

    public static String delete(Transaction transaction, IncomingFinancialTransaction incomingFinancialTransaction, Credit credit) throws Exception {
        if (transaction.getState() != 0) {
            return "invalid_state";
        }
        Asset asset = transaction.getAsset();
        if (asset != null && asset.getIncomingFinancialTransactionId() != null && incomingFinancialTransaction != null && asset.getIncomingFinancialTransactionId().equals(incomingFinancialTransaction.getId())) {
            return AssetBO.delete(asset, incomingFinancialTransaction, null, true);
        }
        if (asset != null && asset.getCreditId() != null && credit != null && asset.getCreditId().equals(credit.getId())) {
            return AssetBO.delete(asset, null, credit, true);
        }
        BigDecimal amount = transaction.getMainTransactionType() == 2 ? transaction.getAmount3().negate() : (transaction.getMainTransactionType() == 3 ? transaction.getAmount2() : transaction.getAmount1());
        boolean alreadyActive = TransactionBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            if (transaction.getMainTransactionType() == 1 || transaction.getMainTransactionType() == 2) {
                Iterator iterator = TransactionBO.getTransactionsForDocument(transaction).iterator();
                while (iterator.hasNext()) {
                    ((Transaction)iterator.next()).delete();
                }
            } else {
                transaction.delete();
            }
            if (incomingFinancialTransaction != null) {
                incomingFinancialTransaction.setUnAllocatedValue(incomingFinancialTransaction.getUnAllocatedValue().add(amount));
            }
            if (credit != null) {
                credit.setAllocatedValue(credit.getAllocatedValue().subtract(amount));
            }
            TransactionBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return TransactionBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static Transaction getFirstTransaction(TransactionBatch transactionBatch) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(transactionBatch.getDBData());
        return manager.getFirstObject(TransactionBO.createQuery(transactionBatch, null));
    }

    public static Collection getTransactions(TransactionBatch transactionBatch) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(transactionBatch.getDBData());
        return manager.getCollection(TransactionBO.createQuery(transactionBatch, null));
    }

    public static Collection getAssetRelatedTransactions(TransactionBatch transactionBatch) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(transactionBatch.getDBData());
        return manager.getCollection(TransactionBO.createQuery(transactionBatch, "A"));
    }

    public static Collection getCreditRelatedTransactions(TransactionBatch transactionBatch) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(transactionBatch.getDBData());
        return manager.getCollection(TransactionBO.createQuery(transactionBatch, "C"));
    }

    private static ExecutableQuery createQuery(TransactionBatch transactionBatch, String cora) throws Exception {
        ExecutableQuery query = QueryFactory.create(Transaction.class, null, "assetId, documentNr, seqNr");
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = TransactionBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", transactionBatch.getCompanyId());
        filter = TransactionBO.addFilterTerm(filter, "batchId = ?_batchId");
        parameters.put("_batchId", "" + transactionBatch.getBatchId());
        if (cora != null) {
            filter = TransactionBO.addFilterTerm(filter, "cora = ?_cora");
            parameters.put("_cora", cora);
        }
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        return query;
    }

    public static Collection getTransactions(Map map, TransactionBatch transactionBatch) throws Exception {
        String to;
        if (Log.debug()) {
            Log.debug((String)"getCollection");
        }
        ExecutableQuery query = QueryFactory.create(Transaction.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = TransactionBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", transactionBatch.getCompanyId());
        filter = TransactionBO.addFilterTerm(filter, "batchId = ?_batchId");
        parameters.put("_batchId", "" + transactionBatch.getBatchId());
        String companyId = (String)map.get("Company");
        Company company = (Company)CompanyBO.get(BOAdapter.getDBData(map), companyId)[0];
        filter = TransactionBO.addFilterTerm(filter, "accountingPrinciple == ?_ap");
        int ap = 1;
        if (((Boolean)map.get(ACCOUNTINGPRINCIPLE2)).booleanValue()) {
            ap = (Boolean)map.get("governmentActivated") != false ? 3 : 2;
        }
        parameters.put("_ap", new Integer(ap));
        String from = (String)map.get("FromAsset");
        if (from != null && from.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "assetId >= ?_fromId");
            parameters.put("_fromId", AssetBO.formatId(company, from, false));
        }
        if ((to = (String)map.get("ToAsset")) != null && to.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "assetId <= ?_toId");
            parameters.put("_toId", AssetBO.formatId(company, to, false));
        }
        if ((from = (String)map.get("FromType")) != null && from.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "proFormaTypeId >= ?_fromType");
            parameters.put("_fromType", from);
        }
        if ((to = (String)map.get("ToType")) != null && to.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "proFormaTypeId <= ?_toType");
            parameters.put("_toType", to);
        }
        if ((from = (String)map.get(FROMFINDIMID1)) != null && from.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "finDimId1 >= ?_fromFinDimId1");
            parameters.put("_fromFinDimId1", from);
        }
        if ((to = (String)map.get(TOFINDIMID1)) != null && to.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "finDimId1 <= ?_toFinDimId1");
            parameters.put("_toFinDimId1", to);
        }
        if ((from = (String)map.get(FROMFINDIMID2)) != null && from.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "finDimId2 >= ?_fromFinDimId2");
            parameters.put("_fromFinDimId2", from);
        }
        if ((to = (String)map.get(TOFINDIMID2)) != null && to.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "finDimId2 <= ?_toFinDimId2");
            parameters.put("_toFinDimId2", to);
        }
        if ((from = (String)map.get(FROMFINDIMID3)) != null && from.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "finDimId3 >= ?_fromFinDimId3");
            parameters.put("_fromFinDimId3", from);
        }
        if ((to = (String)map.get(TOFINDIMID3)) != null && to.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "finDimId3 <= ?_toFinDimId3");
            parameters.put("_toFinDimId3", to);
        }
        if ((from = (String)map.get(FROMFINDIMID4)) != null && from.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "finDimId4 >= ?_fromFinDimId4");
            parameters.put("_fromFinDimId4", from);
        }
        if ((to = (String)map.get(TOFINDIMID4)) != null && to.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "finDimId4 <= ?_toFinDimId4");
            parameters.put("_toFinDimId4", to);
        }
        if ((from = (String)map.get(FROMFINDIMID5)) != null && from.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "finDimId5 >= ?_fromFinDimId5");
            parameters.put("_fromFinDimId5", from);
        }
        if ((to = (String)map.get(TOFINDIMID5)) != null && to.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "finDimId5 <= ?_toFinDimId5");
            parameters.put("_toFinDimId5", to);
        }
        if ((from = (String)map.get(REASONCODEFROM)) != null && from.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "reasonCode >= ?_fromReasonCode");
            parameters.put("_fromReasonCode", Integer.valueOf(from));
        }
        if ((to = (String)map.get(REASONCODETO)) != null && to.length() > 0) {
            filter = TransactionBO.addFilterTerm(filter, "finDimId5 <= ?_toReasonCode");
            parameters.put("_toReasonCode", Integer.valueOf(to));
        }
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        TransactionBO.addOrdering(query, map, "documentNr, seqNr");
        TransactionManager manager = TransactionManagerFactory.getInstance(transactionBatch.getDBData());
        return manager.getCollection(query);
    }

    public static void deleteTransactions(TransactionBatch transactionBatch) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(transactionBatch.getDBData());
        StringBuffer sb = new StringBuffer();
        sb.append("companyId");
        sb.append(" = '");
        sb.append(transactionBatch.getCompanyId());
        sb.append("' AND ");
        sb.append("batchId");
        sb.append(" = ");
        sb.append(transactionBatch.getBatchId());
        String whereClause = sb.toString();
        Log.debug((String)whereClause);
        manager.generalDelete(whereClause);
    }

    public static void deleteTransactions(Asset asset) throws Exception {
        TransactionManager manager = TransactionManagerFactory.getInstance(asset.getDBData());
        StringBuffer sb = new StringBuffer();
        sb.append("companyId");
        sb.append(" = '");
        sb.append(asset.getCompanyId());
        sb.append("' AND ");
        sb.append("cora");
        sb.append(" = '");
        sb.append("A");
        sb.append("' AND ");
        sb.append("assetId");
        sb.append(" = '");
        sb.append(asset.getId());
        sb.append("'");
        String whereClause = sb.toString();
        Log.debug((String)whereClause);
        manager.generalDelete(whereClause);
    }

    public static String updatePreviousBookValueBalance(Map map, Company company) throws Exception {
        for (Valuation valuation : ValuationBO.getValuations(map, false)) {
            if (valuation.getInterestCalculationMethod() == 0) continue;
            Log.debug((String)valuation.getAssetId());
            BigDecimal acquisitionAmount = new BigDecimal(0);
            BigDecimal depreciationAmount = new BigDecimal(0);
            for (Transaction transaction : TransactionBO.getTransactions(valuation, true)) {
                if (valuation.getInterestCalculationMethod() == 2 && PeriodHelper.isBefore(transaction.getBookYear(), transaction.getPeriod(), valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod())) {
                    acquisitionAmount = acquisitionAmount.add(transaction.getAmount1());
                    depreciationAmount = depreciationAmount.add(transaction.getAmount2());
                }
                if (valuation.getInterestCalculationMethod() != 1 || !PeriodHelper.isBefore(transaction.getBookYear(), transaction.getPeriod(), valuation.getLastDepreciationBookYear(), 1)) continue;
                acquisitionAmount = acquisitionAmount.add(transaction.getAmount1());
                depreciationAmount = depreciationAmount.add(transaction.getAmount2());
            }
            Log.debug((String)("TotalAcquisitionAmount: " + acquisitionAmount));
            Log.debug((String)("TotalDepreciationAmount: " + depreciationAmount));
            BigDecimal newPreviousBookvalueBalance = acquisitionAmount.subtract(depreciationAmount);
            Log.debug((String)("NewPreviousBookvalueBalance: " + newPreviousBookvalueBalance));
            BigDecimal previousBookvalueBalance = valuation.getPreviousBookvalueBalance();
            Log.debug((String)("PreviousBookvalueBalance: " + previousBookvalueBalance));
            if (newPreviousBookvalueBalance.equals(previousBookvalueBalance)) continue;
            valuation.setPreviousBookvalueBalance(newPreviousBookvalueBalance);
        }
        return null;
    }
}

