/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionBatchDataBean;
import nl.ibs.fac.db.TransactionBatchManager;
import nl.ibs.fac.db.TransactionBatchManagerFactory;
import nl.ibs.fac.db.TransactionBatchPK;
import nl.ibs.fac.db.TransactionBatchParameterManagerFactory;
import nl.ibs.fac.db.TransactionBatchParameterPK;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.exception.FinderException;

public abstract class TransactionBatchBO
extends BOAdapter {
    public static Object[] get(DBData dbData, String companyId, int batchId) throws Exception {
        Object[] result = new Object[2];
        TransactionBatchPK key = new TransactionBatchPK();
        key.setCompanyId(companyId);
        key.setBatchId(batchId);
        try {
            result[0] = TransactionBatchManagerFactory.getInstance(dbData).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Object[] create(DBData dbData, String companyId, String userId, int batchCode) throws Exception {
        Object[] result = new Object[2];
        TransactionBatchManager manager = TransactionBatchManagerFactory.getInstance(dbData);
        TransactionBatchDataBean bean = new TransactionBatchDataBean();
        bean.setCompanyId(companyId);
        bean.setBatchId(manager.getBatchIdMax(companyId) + 1);
        bean.setCreationDate(new Date());
        bean.setCreatedBy(userId);
        bean.setBatchCode(batchCode);
        bean.setState(0);
        boolean alreadyActive = TransactionBatchBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            TransactionBatchBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = TransactionBatchBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String delete(TransactionBatch transactionBatch) throws Exception {
        if (transactionBatch.getState() != 0) {
            return "invalid_state";
        }
        boolean alreadyActive = TransactionBatchBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            TransactionBO.deleteTransactions(transactionBatch);
            transactionBatch.delete();
            TransactionBatchBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return TransactionBatchBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static int numberOfSevereErrors(String companyId, int accountingPrinciple, TransactionBatch transactionBatch, boolean governmentActivated) throws Exception {
        int errors = 0;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Company", companyId);
        map.put("ReasonCodeFrom", "50");
        map.put("AccountingPrinciple2", new Boolean(accountingPrinciple == 2));
        map.put("governmentActivated", new Boolean(governmentActivated));
        Collection transactionsWithSevereErrors = TransactionBO.getTransactions(map, transactionBatch);
        if (transactionsWithSevereErrors != null && !transactionsWithSevereErrors.isEmpty()) {
            errors = transactionsWithSevereErrors.size();
        }
        return errors;
    }

    public static String getParameter(TransactionBatch transactionBatch, String parmName) throws Exception {
        TransactionBatchParameterPK key = new TransactionBatchParameterPK();
        key.setCompanyId(transactionBatch.getCompanyId());
        key.setBatchId(transactionBatch.getBatchId());
        key.setParameterName(parmName);
        try {
            return TransactionBatchParameterManagerFactory.getInstance(transactionBatch.getDBData()).findByPrimaryKey(key).getParameterValue();
        }
        catch (Exception e) {
            return "";
        }
    }
}

