/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.InterestTableBO;
import nl.ibs.fac.boadapters.YearPercentageTableBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.InterestTable;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionManager;
import nl.ibs.fac.db.TransactionManagerFactory;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.ValuationDataBean;
import nl.ibs.fac.db.ValuationManager;
import nl.ibs.fac.db.ValuationManagerFactory;
import nl.ibs.fac.db.ValuationPK;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class ValuationBO
extends BOAdapter {
    public static Object[] getValuation(DBData dbData, String companyId, String cora, String assetId, int accountingPrinciple) throws Exception {
        ValuationPK key = new ValuationPK();
        Object[] result = new Object[2];
        key.setCompanyId(companyId);
        key.setCora(cora);
        key.setAssetId(assetId);
        key.setAccountingPrinciple(accountingPrinciple);
        try {
            result[0] = ValuationManagerFactory.getInstance(dbData).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Collection getValuations(Asset asset, boolean ap1, boolean ap2) throws Exception {
        ExecutableQuery query = QueryFactory.create(Valuation.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = ValuationBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", asset.getCompanyId());
        filter = ValuationBO.addFilterTerm(filter, "assetId = ?_assetId");
        parameters.put("_assetId", asset.getId());
        filter = ValuationBO.addFilterTerm(filter, "cora = ?_cora");
        parameters.put("_cora", asset.getCora());
        if (!ap1 || !ap2) {
            filter = ValuationBO.addFilterTerm(filter, "accountingPrinciple = ?_ap");
            if (ap1) {
                parameters.put("_ap", new Integer(1));
            } else {
                parameters.put("_ap", new Integer(2));
            }
        }
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        ValuationBO.addOrdering(query, null, "accountingPrinciple");
        ValuationManager manager = ValuationManagerFactory.getInstance(asset.getDBData());
        return manager.getCollection(query);
    }

    public static Collection getValuations(Map map, boolean credit) throws Exception {
        if (Log.debug()) {
            Log.debug((String)"getCollection");
        }
        ExecutableQuery query = QueryFactory.create(Valuation.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String companyId = (String)map.get("Company");
        String filter = ValuationBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        filter = ValuationBO.addFilterTerm(filter, "cora = ?_cora");
        if (credit) {
            parameters.put("_cora", "C");
        } else {
            parameters.put("_cora", "A");
        }
        String value = (String)map.get("AP1");
        if (value != null) {
            boolean ap1 = Boolean.valueOf(value);
            value = (String)map.get("AP2");
            boolean ap2 = Boolean.valueOf(value);
            if (!ap1 || !ap2) {
                filter = ValuationBO.addFilterTerm(filter, "accountingPrinciple = ?_ap");
                if (ap1) {
                    parameters.put("_ap", new Integer(1));
                } else {
                    parameters.put("_ap", new Integer(2));
                }
            }
        }
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        ValuationBO.addOrdering(query, map, "assetId,accountingPrinciple");
        ValuationManager manager = ValuationManagerFactory.getInstance(ValuationBO.getDBData(map));
        return manager.getCollection(query);
    }

    public static Object[] get(DBData dbData, String companyId, String cora, String assetId, int accountingPrinciple) throws Exception {
        Object[] result = new Object[2];
        ValuationPK key = new ValuationPK();
        key.setCompanyId(companyId);
        key.setAssetId(assetId);
        key.setCora(cora);
        key.setAccountingPrinciple(accountingPrinciple);
        try {
            result[0] = ValuationManagerFactory.getInstance(dbData).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Object[] create(DBData dbData, String companyId, String cora, String assetId, int accountingPrinciple, int depreciationMethod, BigDecimal degressivePercentage, String annuityInterestTableId, BigDecimal annuityPercentage, String yearPercentageTableId, int startPeriodHandlingMethod, int startDepreciationBookYear, int startDepreciationPeriod, int depreciatableLife, BigDecimal residualValue, BigDecimal residualPercentage, boolean depreciationPaused, int interestCalculationMethod, String interestTableId, BigDecimal interestPercentage, int numberOfDepreciatedPeriods, int lastDepreciationBookYear, int lastDepreciationPeriod, BigDecimal postedDepreciationBalance, BigDecimal postedAcquisitionBalance, BigDecimal currentBookvalueBalance, BigDecimal previousBookvalueBalance, int startInterestYear, int startInterestPeriod, BigDecimal beyondEconomicLifePercentage) throws Exception {
        Object[] result = new Object[2];
        ValuationManager manager = ValuationManagerFactory.getInstance(dbData);
        ValuationDataBean bean = new ValuationDataBean();
        bean.setCompanyId(companyId);
        bean.setCora(cora);
        bean.setAssetId(assetId);
        bean.setAccountingPrinciple(accountingPrinciple);
        bean.setDepreciationMethod(depreciationMethod);
        bean.setDegressivePercentage(degressivePercentage);
        bean.setAnnuityPercentage(annuityPercentage);
        if (annuityInterestTableId != null && annuityInterestTableId.length() == 0) {
            annuityInterestTableId = null;
        }
        bean.setAnnuityInterestTableId(annuityInterestTableId);
        if (yearPercentageTableId != null && yearPercentageTableId.length() == 0) {
            yearPercentageTableId = null;
        }
        bean.setYearPercentageTableId(yearPercentageTableId);
        bean.setStartPeriodHandlingMethod(startPeriodHandlingMethod);
        bean.setStartDepreciationBookYear(startDepreciationBookYear);
        bean.setStartDepreciationPeriod(startDepreciationPeriod);
        bean.setDepreciatableLife(depreciatableLife);
        bean.setResidualValue(residualValue);
        bean.setResidualPercentage(residualPercentage);
        bean.setDepreciationPaused(depreciationPaused);
        bean.setInterestCalculationMethod(interestCalculationMethod);
        if (interestTableId != null && interestTableId.length() == 0) {
            interestTableId = null;
        }
        bean.setInterestTableId(interestTableId);
        bean.setInterestPercentage(interestPercentage);
        bean.setInterestBookYear(startInterestYear);
        bean.setInterestPeriod(startInterestPeriod);
        bean.setNumberOfDepreciatedPeriods(numberOfDepreciatedPeriods);
        bean.setLastDepreciationBookYear(lastDepreciationBookYear);
        bean.setLastDepreciationPeriod(lastDepreciationPeriod);
        bean.setPostedDepreciationBalance(postedDepreciationBalance);
        bean.setPostedAcquisitionBalance(postedAcquisitionBalance);
        bean.setCurrentBookvalueBalance(currentBookvalueBalance);
        bean.setPreviousBookvalueBalance(previousBookvalueBalance);
        bean.setBeyondEconomicLifePercentage(beyondEconomicLifePercentage);
        boolean alreadyActive = ValuationBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            ValuationBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = ValuationBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String update(DBData dbData, Valuation valuation, boolean currentCapitalization, BigDecimal postedDepreciationBalance, int numberOfDepreciatedPeriods, int depreciationMethod, BigDecimal degressivePercentage, String annuityInterestTableId, BigDecimal annuityPercentage, String yearPercentageTableId, int startPeriodHandlingMethod, int startDepreciationBookYear, int startDepreciationPeriod, int depreciatableLife, BigDecimal residualValue, BigDecimal residualPercentage, boolean depreciationPaused, int interestCalculationMethod, String interestTableId, int numberOfPeriods, BigDecimal interestPercentage, int startInterestYear, int startInterestPeriod, BigDecimal beyondEconomicLifePercentage) throws Exception {
        boolean alreadyActive = ValuationBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            if (currentCapitalization) {
                valuation.setPostedDepreciationBalance(postedDepreciationBalance);
                valuation.setNumberOfDepreciatedPeriods(numberOfDepreciatedPeriods);
            }
            valuation.setDepreciationMethod(depreciationMethod);
            valuation.setDegressivePercentage(degressivePercentage);
            valuation.setAnnuityPercentage(annuityPercentage);
            InterestTable interestTable = null;
            if (annuityInterestTableId != null && annuityInterestTableId.length() > 0) {
                interestTable = (InterestTable)InterestTableBO.get(dbData, annuityInterestTableId, numberOfPeriods)[0];
            }
            valuation.setAnnuityInterestTable(interestTable);
            YearPercentageTable yearPercentageTable = null;
            if (yearPercentageTableId != null && yearPercentageTableId.trim().length() > 0) {
                yearPercentageTable = (YearPercentageTable)YearPercentageTableBO.get(dbData, yearPercentageTableId)[0];
            }
            valuation.setYearPercentageTable(yearPercentageTable);
            valuation.setStartPeriodHandlingMethod(startPeriodHandlingMethod);
            valuation.setStartDepreciationBookYear(startDepreciationBookYear);
            valuation.setStartDepreciationPeriod(startDepreciationPeriod);
            valuation.setDepreciatableLife(depreciatableLife);
            valuation.setResidualValue(residualValue);
            valuation.setResidualPercentage(residualPercentage);
            valuation.setDepreciationPaused(depreciationPaused);
            valuation.setInterestCalculationMethod(interestCalculationMethod);
            interestTable = null;
            if (interestTableId != null && interestTableId.length() > 0) {
                interestTable = (InterestTable)InterestTableBO.get(dbData, interestTableId, numberOfPeriods)[0];
            }
            valuation.setInterestTable(interestTable);
            valuation.setInterestPercentage(interestPercentage);
            valuation.setInterestBookYear(startInterestYear);
            valuation.setInterestPeriod(startInterestPeriod);
            valuation.setBeyondEconomicLifePercentage(beyondEconomicLifePercentage);
            ValuationBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return ValuationBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(Valuation valuation) throws Exception {
        boolean alreadyActive = ValuationBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            valuation.delete();
            ValuationBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return ValuationBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static int[] getLastDepreciatedPeriod(Asset asset) throws Exception {
        int[] result = new int[2];
        int[] yearPeriod = new int[2];
        for (Valuation valuation : asset.getValuationsCollection(null)) {
            yearPeriod[0] = valuation.getLastDepreciationBookYear();
            yearPeriod[1] = valuation.getLastDepreciationPeriod();
            if (!PeriodHelper.isAfter(yearPeriod[0], yearPeriod[1], result[0], result[1])) continue;
            result[0] = yearPeriod[0];
            result[1] = yearPeriod[1];
        }
        return result;
    }

    public static BigDecimal getBookValue(Asset asset) throws Exception {
        Valuation valuation = ValuationBO.getFirstValuation(asset);
        if (valuation != null) {
            return valuation.getPostedAcquisitionBalance().subtract(valuation.getPostedDepreciationBalance());
        }
        return new BigDecimal(0);
    }

    public static BigDecimal getAcquisitionValue(Asset asset) throws Exception {
        Valuation valuation = ValuationBO.getFirstValuation(asset);
        if (valuation != null) {
            return valuation.getPostedAcquisitionBalance();
        }
        return new BigDecimal(0);
    }

    public static BigDecimal getDepreciationValue(Asset asset) throws Exception {
        Valuation valuation = ValuationBO.getFirstValuation(asset);
        if (valuation != null) {
            return valuation.getPostedDepreciationBalance();
        }
        return new BigDecimal(0);
    }

    public static BigDecimal getDepreciationValueBeyondEconomicLife(Valuation valuation) throws Exception {
        BigDecimal result = valuation.getPostedDepreciationBalanceBeyondEconomicLife();
        ExecutableQuery query = QueryFactory.create(Transaction.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = ValuationBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", valuation.getCompanyId());
        filter = ValuationBO.addFilterTerm(filter, "assetId = ?_assetId");
        parameters.put("_assetId", valuation.getAssetId());
        filter = ValuationBO.addFilterTerm(filter, "cora = ?_cora");
        parameters.put("_cora", valuation.getCora());
        filter = ValuationBO.addFilterTerm(filter, "accountingPrinciple = ?_ap");
        parameters.put("_ap", valuation.getAccountingPrinciple());
        filter = ValuationBO.addFilterTerm(filter, "mainTransactionType = 5");
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        TransactionManager manager = TransactionManagerFactory.getInstance(valuation.getDBData());
        for (Transaction transaction : manager.getCollection(query)) {
            result = result.add(transaction.getAmount2());
        }
        return result;
    }

    public static int[] getLastAcquisitionPeriod(Asset asset) throws Exception {
        int[] result = new int[2];
        Valuation valuation = ValuationBO.getFirstValuation(asset);
        if (valuation != null) {
            result[0] = valuation.getLastAcquisitionBookYear();
            result[1] = valuation.getLastAcquisitionPeriod();
            return result;
        }
        result[0] = 0;
        result[1] = 0;
        return result;
    }

    public static Valuation getFirstValuation(Asset asset) throws Exception {
        ExecutableQuery query = QueryFactory.create(Valuation.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = ValuationBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", asset.getCompanyId());
        filter = ValuationBO.addFilterTerm(filter, "cora = ?_cora");
        parameters.put("_cora", asset.getCora());
        filter = ValuationBO.addFilterTerm(filter, "assetId = ?_assetId");
        parameters.put("_assetId", asset.getId());
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        ValuationManager manager = ValuationManagerFactory.getInstance(asset.getDBData());
        return manager.getFirstObject(query);
    }

    public static Object[] getLastDepreciatedPeriod(Asset asset, int accountingPrinciple) throws Exception {
        int lastDepreciationBookYear = -1;
        int lastDepreciationPeriod = 0;
        BigDecimal totalBookValue = new BigDecimal(0);
        if (asset.getParentAsset() && asset.getSubAsset()) {
            Valuation valuation = (Valuation)ValuationBO.get(asset.getDBData(), asset.getCompanyId(), asset.getCora(), asset.getId(), accountingPrinciple)[0];
            if (valuation != null) {
                lastDepreciationBookYear = valuation.getLastDepreciationBookYear();
                lastDepreciationPeriod = valuation.getLastDepreciationPeriod();
                totalBookValue = valuation.getPostedAcquisitionBalance().subtract(valuation.getPostedDepreciationBalance());
            }
        } else {
            for (Asset subAsset : AssetBO.getSubAssets(asset.getDBData(), asset.getCompanyId(), asset.getId(), false)) {
                Valuation valuation = (Valuation)ValuationBO.get(asset.getDBData(), asset.getCompanyId(), subAsset.getCora(), subAsset.getId(), accountingPrinciple)[0];
                if (valuation == null) continue;
                if (PeriodHelper.isAfter(valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod(), lastDepreciationBookYear, lastDepreciationPeriod)) {
                    lastDepreciationBookYear = valuation.getLastDepreciationBookYear();
                    lastDepreciationPeriod = valuation.getLastDepreciationPeriod();
                }
                totalBookValue = totalBookValue.add(valuation.getPostedAcquisitionBalance().subtract(valuation.getPostedDepreciationBalance()));
            }
        }
        Object[] result = new Object[]{"" + lastDepreciationBookYear, "" + lastDepreciationPeriod, totalBookValue};
        return result;
    }
}

