/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.util.Collection;
import java.util.HashMap;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.ValuationMainAccount;
import nl.ibs.fac.db.ValuationMainAccountDataBean;
import nl.ibs.fac.db.ValuationMainAccountManager;
import nl.ibs.fac.db.ValuationMainAccountManagerFactory;
import nl.ibs.fac.db.ValuationMainAccountPK;
import nl.ibs.fac.queries.ValuationMainAccountQuery;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public abstract class ValuationMainAccountBO
extends BOAdapter {
    public static Object[] get(DBData dbData, String companyId, String cora, String assetId, int accountingPrinciple, int bookYearFrom, int periodFrom) throws Exception {
        Object[] result = new Object[2];
        ValuationMainAccountPK key = new ValuationMainAccountPK();
        key.setCompanyId(companyId);
        key.setCora(cora);
        key.setAssetId(assetId);
        key.setAccountingPrinciple(accountingPrinciple);
        key.setBookYearFrom(bookYearFrom);
        key.setPeriodFrom(periodFrom);
        try {
            result[0] = ValuationMainAccountManagerFactory.getInstance(dbData).findByPrimaryKey(key);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Collection<?> getCollection(DBData dbData, String companyId, String cora, String assetId, int accountingPrinciple) throws Exception {
        ExecutableQuery query = QueryFactory.create(ValuationMainAccount.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = ValuationMainAccountBO.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        filter = ValuationMainAccountBO.addFilterTerm(filter, "assetId = ?_assetId");
        parameters.put("_assetId", assetId);
        filter = ValuationMainAccountBO.addFilterTerm(filter, "cora = 'A'");
        filter = ValuationMainAccountBO.addFilterTerm(filter, "accountingPrinciple = ?_accountingPrinciple");
        parameters.put("_accountingPrinciple", accountingPrinciple);
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        ValuationMainAccountManager manager = ValuationMainAccountManagerFactory.getInstance(dbData);
        return manager.getCollection(query);
    }

    public static Object[] create(DBData dbData, String companyId, String cora, String assetId, int accountingPrinciple, int bookYearFrom, int periodFrom, String mainAccountId1, String mainAccountId2, String mainAccountId3, String mainAccountId4, String mainAccountId5, String mainAccountId6, String mainAccountId7, String mainAccountId8, String mainAccountId9) throws Exception {
        Object[] result = new Object[2];
        ValuationMainAccountManager manager = ValuationMainAccountManagerFactory.getInstance(dbData);
        ValuationMainAccountDataBean bean = new ValuationMainAccountDataBean();
        bean.setCompanyId(companyId);
        bean.setCora(cora);
        bean.setAssetId(assetId);
        bean.setAccountingPrinciple(accountingPrinciple);
        bean.setBookYearFrom(bookYearFrom);
        bean.setPeriodFrom(periodFrom);
        bean.setMainAccountId1(mainAccountId1);
        bean.setMainAccountId2(mainAccountId2);
        bean.setMainAccountId3(mainAccountId3);
        bean.setMainAccountId4(mainAccountId4);
        bean.setMainAccountId5(mainAccountId5);
        bean.setMainAccountId6(mainAccountId6);
        bean.setMainAccountId7(mainAccountId7);
        bean.setMainAccountId8(mainAccountId8);
        bean.setMainAccountId9(mainAccountId9);
        boolean alreadyActive = ValuationMainAccountBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            ValuationMainAccountBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = ValuationMainAccountBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String update(ValuationMainAccount valuationMainAccount, String mainAccountId1, String mainAccountId2, String mainAccountId3, String mainAccountId4, String mainAccountId5, String mainAccountId6, String mainAccountId7, String mainAccountId8, String mainAccountId9) throws Exception {
        boolean alreadyActive = ValuationMainAccountBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            valuationMainAccount.setMainAccountId1(mainAccountId1);
            valuationMainAccount.setMainAccountId2(mainAccountId2);
            valuationMainAccount.setMainAccountId3(mainAccountId3);
            valuationMainAccount.setMainAccountId4(mainAccountId4);
            valuationMainAccount.setMainAccountId5(mainAccountId5);
            valuationMainAccount.setMainAccountId6(mainAccountId6);
            valuationMainAccount.setMainAccountId7(mainAccountId7);
            valuationMainAccount.setMainAccountId8(mainAccountId8);
            valuationMainAccount.setMainAccountId9(mainAccountId9);
            ValuationMainAccountBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return ValuationMainAccountBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(ValuationMainAccount valuationMainAccount) throws Exception {
        boolean alreadyActive = ValuationMainAccountBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            valuationMainAccount.delete();
            ValuationMainAccountBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return ValuationMainAccountBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static ValuationMainAccount getValuationMainAccountToUse(Transaction transaction) throws Exception {
        String coraId = "C".equals(transaction.getCora()) ? transaction.getCreditId() : transaction.getAssetId();
        return ValuationMainAccountBO.getValuationMainAccountToUse(transaction.getDBData(), transaction.getCompanyId(), transaction.getCora(), coraId, transaction.getAccountingPrinciple(), transaction.getBookYearForJournalization(), transaction.getPeriodForJournalization());
    }

    public static ValuationMainAccount getValuationMainAccountToUse(DBData dbData, String companyId, String cora, String coraId, int ap, int theYear, int thePeriod) throws Exception {
        ValuationMainAccount vmaToUse = null;
        int bookYear = 0;
        int period = 0;
        ValuationMainAccountQuery query = new ValuationMainAccountQuery(dbData, companyId, cora, coraId, "" + ap);
        Collection vmas = query.fetchData(null, "bookYearFrom, periodFrom", null, 0);
        for (ValuationMainAccount vma : vmas) {
            int periodFrom;
            int bookYearFrom = vma.getBookYearFrom();
            if (PeriodHelper.isBefore(theYear, thePeriod, bookYearFrom, periodFrom = vma.getPeriodFrom()) || !PeriodHelper.isAfter(bookYearFrom, periodFrom, bookYear, period)) continue;
            bookYear = bookYearFrom;
            period = periodFrom;
            vmaToUse = vma;
        }
        return vmaToUse;
    }
}

