/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.boadapters;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.YearPercentageDetailBO;
import nl.ibs.fac.db.YearPercentageDetail;
import nl.ibs.fac.db.YearPercentageDetailDataBean;
import nl.ibs.fac.db.YearPercentageTable;
import nl.ibs.fac.db.YearPercentageTableDataBean;
import nl.ibs.fac.db.YearPercentageTableManager;
import nl.ibs.fac.db.YearPercentageTableManagerFactory;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;
import nl.ibs.jsql.exception.FinderException;

public class YearPercentageTableBO
extends BOAdapter {
    public static final String FROMID = "FromYearPercentageTable";
    public static final String TOID = "ToYearPercentageTable";

    public static Object[] get(DBData dbData, String id) throws Exception {
        Object[] result = new Object[2];
        try {
            result[0] = YearPercentageTableManagerFactory.getInstance(dbData).findByPrimaryKey(id);
        }
        catch (FinderException e) {
            result[1] = "key_not_found";
        }
        return result;
    }

    public static Collection getYearPercentageTables(Map map) throws Exception {
        if (Log.debug()) {
            Log.debug((String)"getCollection");
        }
        ExecutableQuery query = QueryFactory.create(YearPercentageTable.class);
        query.setCacheable(true);
        if (map != null) {
            String toId;
            HashMap<String, String> parameters = new HashMap<String, String>();
            String filter = null;
            String fromId = (String)map.get(FROMID);
            if (fromId != null && fromId.length() > 0) {
                filter = YearPercentageTableBO.addFilterTerm(filter, "id >= ?_fromId");
                parameters.put("_fromId", fromId);
            }
            if ((toId = (String)map.get(TOID)) != null && toId.length() > 0) {
                filter = YearPercentageTableBO.addFilterTerm(filter, "id <= ?_toId");
                parameters.put("_toId", toId);
            }
            if (Log.debug()) {
                Log.debug((String)("Filter: " + filter));
                Log.debug((String)("Parameters: " + parameters));
            }
            query.setFilter(filter);
            query.setParameters(parameters);
        }
        YearPercentageTableBO.addOrdering(query, map, "id");
        YearPercentageTableManager manager = YearPercentageTableManagerFactory.getInstance(BOAdapter.getDBData(map));
        return manager.getCollection(query);
    }

    public static String validatePercentage(BigDecimal[] details) throws Exception {
        String message = null;
        BigDecimal total = new BigDecimal(0);
        int i = 0;
        while (i < details.length) {
            total = total.add(details[i]);
            ++i;
        }
        if (total.compareTo(new BigDecimal(100)) > 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", "total_percentage_greater_hundred");
        }
        if (total.compareTo(new BigDecimal(100)) < 0) {
            message = LanguageHelper.getString("nl.ibs.fac.language", "total_percentage_lesser_hundred");
        }
        return message;
    }

    public static Object[] create(DBData dbData, String id, String desc, int actualYears, BigDecimal[] details) throws Exception {
        Object[] result = new Object[2];
        YearPercentageTableManager manager = YearPercentageTableManagerFactory.getInstance(dbData);
        YearPercentageTableDataBean bean = new YearPercentageTableDataBean();
        bean.setId(id);
        bean.setDescription(desc);
        bean.setActualYears(actualYears);
        boolean alreadyActive = YearPercentageTableBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            result[0] = manager.create(bean);
            int i = 0;
            while (i < actualYears) {
                result = YearPercentageDetailBO.create(dbData, id, i, details[i]);
                if (result[1] != null) {
                    YearPercentageTableBO.investigate(null, dbTransaction);
                    return result;
                }
                ++i;
            }
            YearPercentageTableBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            result[1] = YearPercentageTableBO.investigate(e, dbTransaction);
        }
        return result;
    }

    public static String update(YearPercentageTable yearPercentage, String desc, int actualYears, ArrayList list, BigDecimal[] details) throws Exception {
        YearPercentageTableDataBean bean = new YearPercentageTableDataBean();
        bean.setId(yearPercentage.getId());
        bean.setDescription(desc);
        bean.setActualYears(actualYears);
        boolean alreadyActive = YearPercentageTableBO.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            yearPercentage.update(bean);
            int i = 0;
            while (i < list.size()) {
                YearPercentageDetail detail = (YearPercentageDetail)list.get(i);
                YearPercentageDetailDataBean detailBean = new YearPercentageDetailDataBean();
                detailBean.setYearPercentageTableId(yearPercentage.getId());
                detailBean.setLifeCycleYear(i);
                detailBean.setPercentage(details[i]);
                detail.update(detailBean);
                ++i;
            }
            YearPercentageTableBO.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return YearPercentageTableBO.investigate(e, dbTransaction);
        }
        return null;
    }

    public static String delete(YearPercentageTable yearPercentageTable) throws Exception {
        try {
            yearPercentageTable.delete();
        }
        catch (Exception e) {
            return YearPercentageTableBO.investigate(e, null);
        }
        return null;
    }
}

