/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import com.ibm.as400.access.AS400;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import nl.ibs.api.fms.EkhyxfrAdapter;
import nl.ibs.api.fms.EkmwxfrAdapter;
import nl.ibs.fac.ComparisonValue;
import nl.ibs.fac.boadapters.AssetTypeBO;
import nl.ibs.fac.boadapters.MainAccountSchemeBO;
import nl.ibs.fac.db.AssetType;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.MainAccountScheme;
import nl.ibs.fac.db.Transaction;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.FreeQuery;
import nl.ibs.jsql.QueryFactory;

public class BaseComparisonBP
implements Serializable {
    private static final long serialVersionUID = -299511118700055739L;
    protected DBData dbData;
    protected AS400 as400;
    protected Company company;
    protected int numberOfPeriods;
    protected int numberOfCorrectionPeriods;
    protected Collection types;
    protected Vector<MainAccountScheme> allSchemes;
    protected Vector<ComparisonValue> glComparisonValues;
    protected EkhyxfrAdapter maAdapterFMS;
    protected EkmwxfrAdapter ekmwxfrAdapter;
    protected static final BigDecimal HUNDRED = new BigDecimal("100.00");
    protected FreeQuery ob1Query;
    protected FreeQuery ob2Query;
    protected FreeQuery perQuery;
    protected FreeQuery dprQuery;
    protected FreeQuery extPerQuery;
    protected FreeQuery extDprQuery;
    protected Object[][] ob1Data;
    protected Object[][] ob2Data;
    protected Object[][] perData;
    protected Object[][] dprData;
    protected boolean ob1QueryInitialized = false;
    protected boolean ob2QueryInitialized = false;
    protected boolean perQueryInitialized = false;
    protected boolean dprQueryInitialized = false;
    protected int year;
    protected int accountingPrinciple;

    public BaseComparisonBP(DBData dbData, AS400 as400, Company company, int numberOfPeriods) throws Exception {
        this.dbData = dbData;
        this.as400 = as400;
        this.company = company;
        this.numberOfPeriods = numberOfPeriods;
        this.numberOfCorrectionPeriods = company.getNumberOfCorrectionPeriods();
    }

    protected void retrieveSchemes() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("facLib", this.dbData.getSchema());
        map.put("Company", this.company.getId());
        this.types = AssetTypeBO.getAssetTypes(map);
        if (this.types == null || this.types.isEmpty()) {
            return;
        }
        this.allSchemes = new Vector();
        MainAccountScheme scheme = null;
        for (AssetType type : this.types) {
            scheme = MainAccountSchemeBO.getMainAccountSchemeToUse(type, this.accountingPrinciple, this.year, this.numberOfPeriods);
            if (scheme == null || scheme.getMainAccountId1() == null || scheme.getMainAccountId1().equals("")) continue;
            this.allSchemes.add(scheme);
        }
    }

    protected void createGLComparisonValues() throws Exception {
        this.glComparisonValues = new Vector();
        while (!this.allSchemes.isEmpty()) {
            String lowestMainAccount1Value = new String("ZZZZZZZZZZ");
            MainAccountScheme schemeToRemove = null;
            for (MainAccountScheme mainScheme : this.allSchemes) {
                if (mainScheme.getMainAccountId1().compareTo(lowestMainAccount1Value) >= 0) continue;
                lowestMainAccount1Value = mainScheme.getMainAccountId1();
                schemeToRemove = mainScheme;
            }
            if (schemeToRemove == null) continue;
            ComparisonValue glComparisonValue = new ComparisonValue(this.accountingPrinciple, 0, schemeToRemove.getTypeId(), schemeToRemove.getMainAccountId1(), schemeToRemove.getMainAccountId2(), schemeToRemove.getMainAccountId3(), this.numberOfPeriods, this.numberOfCorrectionPeriods);
            this.glComparisonValues.add(glComparisonValue);
            this.allSchemes.remove(schemeToRemove);
            boolean multipleTypes = false;
            boolean firstTime = true;
            Iterator<MainAccountScheme> asj = this.allSchemes.iterator();
            while (asj.hasNext()) {
                MainAccountScheme subScheme = asj.next();
                if (subScheme.getMainAccountId1().compareTo(lowestMainAccount1Value) != 0) continue;
                if (firstTime) {
                    this.glComparisonValues.add(new ComparisonValue(this.accountingPrinciple, 1, schemeToRemove.getTypeId(), schemeToRemove.getMainAccountId1(), schemeToRemove.getMainAccountId2(), schemeToRemove.getMainAccountId3(), this.numberOfPeriods, this.numberOfCorrectionPeriods));
                    firstTime = false;
                }
                this.glComparisonValues.add(new ComparisonValue(this.accountingPrinciple, 1, subScheme.getTypeId(), subScheme.getMainAccountId1(), subScheme.getMainAccountId2(), subScheme.getMainAccountId3(), this.numberOfPeriods, this.numberOfCorrectionPeriods));
                asj.remove();
                multipleTypes = true;
            }
            if (!multipleTypes) continue;
            glComparisonValue.setMultipleTypes(true);
        }
    }

    protected void initializeFMSAdapters() throws Exception {
        this.maAdapterFMS = new EkhyxfrAdapter(this.as400);
        this.maAdapterFMS.setP1PARMP1QFTS("");
        this.maAdapterFMS.setP1PARMP1R3CE("XC");
        this.maAdapterFMS.setP1PARMP1ABCD("" + this.year);
        this.maAdapterFMS.setP1PARMP1R5CE("" + this.year);
        this.maAdapterFMS.setP1PARMP1AZCD("0");
        this.maAdapterFMS.setP1PARMP1GFVA(new BigDecimal("0"));
        this.maAdapterFMS.setP1PARMP1I3NB(new BigDecimal("0"));
        this.ekmwxfrAdapter = new EkmwxfrAdapter(this.as400);
        this.ekmwxfrAdapter.setP1O2TT("RK");
        this.ekmwxfrAdapter.setP1FZCI("");
        this.ekmwxfrAdapter.setP1SMNB(new BigDecimal(1));
        this.ekmwxfrAdapter.setP1V3NO(new BigDecimal(0));
        this.ekmwxfrAdapter.setP1C3NZ("");
        this.ekmwxfrAdapter.setP1MGTT("1");
        this.ekmwxfrAdapter.setP1MHTT("2");
    }

    protected void retrieveFMSTotals() throws Exception {
        for (ComparisonValue glComparisonValue : this.glComparisonValues) {
            if (glComparisonValue.getBeanType() == 0) {
                this.ekmwxfrAdapter.setP1FZCI(glComparisonValue.getAcquisitionAccount());
                this.ekmwxfrAdapter.execute();
                glComparisonValue.setAcquisitionAccountDescription(this.ekmwxfrAdapter.getP2PARMWAAZTM(0));
                this.maAdapterFMS.setP1PARMP1LCCD(glComparisonValue.getAcquisitionAccount());
                this.maAdapterFMS.setP1PARMP1LHCD(glComparisonValue.getAcquisitionAccount());
                this.maAdapterFMS.setP1PARMP1ENNB(new BigDecimal("0"));
                this.maAdapterFMS.setP1PARMP1E2NB(new BigDecimal("0"));
                this.maAdapterFMS.execute();
                glComparisonValue.addFigure(this.maAdapterFMS.getP1PARMP1GFVA().divide(HUNDRED, 2, 4), 0, 0);
                this.maAdapterFMS.setP1PARMP1E2NB(new BigDecimal("99"));
                this.maAdapterFMS.execute();
                glComparisonValue.setGLAcquisitionTotal(this.maAdapterFMS.getP1PARMP1GFVA().divide(HUNDRED, 2, 4));
                if ("".equals(glComparisonValue.getDepreciationAccount())) {
                    glComparisonValue.setDepreciationAccountDescription("");
                } else {
                    this.ekmwxfrAdapter.setP1FZCI(glComparisonValue.getDepreciationAccount());
                    this.ekmwxfrAdapter.execute();
                    glComparisonValue.setDepreciationAccountDescription(this.ekmwxfrAdapter.getP2PARMWAAZTM(0));
                    this.maAdapterFMS.setP1PARMP1LCCD(glComparisonValue.getDepreciationAccount());
                    this.maAdapterFMS.setP1PARMP1LHCD(glComparisonValue.getDepreciationAccount());
                    this.maAdapterFMS.setP1PARMP1ENNB(new BigDecimal("0"));
                    this.maAdapterFMS.setP1PARMP1E2NB(new BigDecimal("0"));
                    this.maAdapterFMS.execute();
                    glComparisonValue.addFigure(this.maAdapterFMS.getP1PARMP1GFVA().negate().divide(HUNDRED, 2, 4), 2, 0);
                    this.maAdapterFMS.setP1PARMP1E2NB(new BigDecimal("99"));
                    this.maAdapterFMS.execute();
                    glComparisonValue.setGLDepreciationTotal(this.maAdapterFMS.getP1PARMP1GFVA().negate().divide(HUNDRED, 2, 4));
                }
                if ("".equals(glComparisonValue.getCostAccount())) {
                    glComparisonValue.setCostAccountDescription("");
                    continue;
                }
                this.ekmwxfrAdapter.setP1FZCI(glComparisonValue.getCostAccount());
                this.ekmwxfrAdapter.execute();
                glComparisonValue.setCostAccountDescription(this.ekmwxfrAdapter.getP2PARMWAAZTM(0));
                continue;
            }
            glComparisonValue.setAcquisitionAccountDescription("");
            glComparisonValue.setDepreciationAccountDescription("");
            glComparisonValue.setCostAccountDescription("");
        }
    }

    protected void retrieveFMSDetails(ComparisonValue glComparisonValue) throws Exception {
        this.maAdapterFMS.setP1PARMP1LCCD(glComparisonValue.getAcquisitionAccount());
        this.maAdapterFMS.setP1PARMP1LHCD(glComparisonValue.getAcquisitionAccount());
        this.retrieveFMSDetails(glComparisonValue, 0);
        if (!"".equals(glComparisonValue.getDepreciationAccount())) {
            this.maAdapterFMS.setP1PARMP1LCCD(glComparisonValue.getDepreciationAccount());
            this.maAdapterFMS.setP1PARMP1LHCD(glComparisonValue.getDepreciationAccount());
            this.retrieveFMSDetails(glComparisonValue, 2);
        }
        if (!"".equals(glComparisonValue.getCostAccount())) {
            this.maAdapterFMS.setP1PARMP1LCCD(glComparisonValue.getCostAccount());
            this.maAdapterFMS.setP1PARMP1LHCD(glComparisonValue.getCostAccount());
            this.retrieveFMSDetails(glComparisonValue, 4);
        }
        glComparisonValue.setDetailsAlreadyAvailable(true);
    }

    protected void retrieveFMSDetails(ComparisonValue glComparisonValue, int type) throws Exception {
        int i = 1;
        while (i <= this.numberOfPeriods) {
            this.maAdapterFMS.setP1PARMP1ENNB(new BigDecimal("" + i));
            this.maAdapterFMS.setP1PARMP1E2NB(new BigDecimal("" + i));
            this.maAdapterFMS.execute();
            if (type == 2) {
                glComparisonValue.addFigure(this.maAdapterFMS.getP1PARMP1GFVA().negate().divide(HUNDRED, 2, 4), type, i);
            } else {
                glComparisonValue.addFigure(this.maAdapterFMS.getP1PARMP1GFVA().divide(HUNDRED, 2, 4), type, i);
            }
            ++i;
        }
        if (this.numberOfCorrectionPeriods > 0) {
            this.maAdapterFMS.setP1PARMP1ENNB(new BigDecimal("" + (this.numberOfPeriods + 1)));
            this.maAdapterFMS.setP1PARMP1E2NB(new BigDecimal("" + (this.numberOfPeriods + this.numberOfCorrectionPeriods)));
            this.maAdapterFMS.execute();
            if (type == 2) {
                glComparisonValue.addFigure(this.maAdapterFMS.getP1PARMP1GFVA().negate().divide(HUNDRED, 2, 4), type, this.numberOfPeriods + 1);
            } else {
                glComparisonValue.addFigure(this.maAdapterFMS.getP1PARMP1GFVA().divide(HUNDRED, 2, 4), type, this.numberOfPeriods + 1);
            }
        }
    }

    protected void retrieveFACTotals() throws Exception {
        FreeQuery freeQuery = QueryFactory.createFreeQuery(Transaction.class);
        freeQuery.setQuery("SELECT SUM(amount1), SUM(amount2) FROM Transaction WHERE companyId = ?_companyId  AND accountingPrinciple = ?_ap  AND bookYearForJournalization <= ?_year AND proFormaTypeId = ?_type AND (mainTransactionType = ?_mtt_1 OR mainTransactionType = ?_mtt_2 OR mainTransactionType = ?_mtt_3) ");
        freeQuery.setParameter("_companyId", this.company.getId());
        freeQuery.setParameter("_ap", this.accountingPrinciple);
        freeQuery.setParameter("_year", this.year);
        freeQuery.setParameter("_mtt_1", 1);
        freeQuery.setParameter("_mtt_2", 2);
        freeQuery.setParameter("_mtt_3", 3);
        freeQuery.setCacheable(true);
        Iterator<ComparisonValue> cvi = this.glComparisonValues.iterator();
        boolean multipleTypes = false;
        while (cvi.hasNext()) {
            BigDecimal amount;
            ComparisonValue glComparisonValue = cvi.next();
            if (glComparisonValue.getMultipleTypes()) {
                multipleTypes = true;
                continue;
            }
            freeQuery.setParameter("_type", glComparisonValue.getAssetTypeId());
            Object[][] data = freeQuery.getResultArray();
            if (data[0][0] != null && (amount = (BigDecimal)data[0][0]).doubleValue() != 0.0) {
                glComparisonValue.setFACAcquisitionTotal(amount);
            }
            if (data[0][1] == null || (amount = (BigDecimal)data[0][1]).doubleValue() == 0.0) continue;
            glComparisonValue.setFACDepreciationTotal(amount);
        }
        if (multipleTypes) {
            this.retrieveFACTotalsContinued();
        }
    }

    protected void retrieveFACTotalsContinued() throws Exception {
        AssetType at = null;
        ComparisonValue mainBean = null;
        Iterator<ComparisonValue> cvi = this.glComparisonValues.iterator();
        boolean multipleTypes = false;
        while (cvi.hasNext()) {
            ComparisonValue subBean = cvi.next();
            if (subBean.getBeanType() == 0) {
                multipleTypes = false;
                if (subBean.getMultipleTypes()) {
                    mainBean = subBean;
                    multipleTypes = true;
                    continue;
                }
            }
            if (!multipleTypes) continue;
            mainBean.setFACAcquisitionTotal(mainBean.getFACAcquisitionTotal().add(subBean.getFACAcquisitionTotal()));
            mainBean.setFACDepreciationTotal(mainBean.getFACDepreciationTotal().add(subBean.getFACDepreciationTotal()));
            at = (AssetType)AssetTypeBO.get(this.dbData, this.company.getId(), subBean.getAssetTypeId())[0];
            subBean.setAssetTypeDescription(at.getDescription());
        }
    }

    protected void handleTotalDifferences() throws Exception {
        for (ComparisonValue glComparisonValue : this.glComparisonValues) {
            if (glComparisonValue.getBeanType() != 0) continue;
            glComparisonValue.setAcquisitionTotalDifference();
            glComparisonValue.setDepreciationTotalDifference();
        }
    }

    protected void retrieveFACDetails(ComparisonValue glComparisonValue) throws Exception {
        if (glComparisonValue.getMultipleTypes()) {
            Vector<ComparisonValue> subBeans = new Vector<ComparisonValue>();
            for (ComparisonValue subBean : this.glComparisonValues) {
                if (subBean.getBeanType() == 0 || !subBean.getAcquisitionAccount().trim().equals(glComparisonValue.getAcquisitionAccount().trim())) continue;
                subBeans.add(subBean);
            }
            for (ComparisonValue subBean : subBeans) {
                this.retrieveOBFigures_1(subBean);
                this.retrieveOBFigures_2(subBean);
                this.retrievePeriodFigures(subBean);
                this.retrieveDepreciationCostFigures(subBean);
                this.retrieveInvestmentsAndDisinvestments(subBean);
                glComparisonValue.addFigures(subBean);
            }
        } else {
            this.retrieveOBFigures_1(glComparisonValue);
            this.retrieveOBFigures_2(glComparisonValue);
            this.retrievePeriodFigures(glComparisonValue);
            this.retrieveDepreciationCostFigures(glComparisonValue);
            this.retrieveInvestmentsAndDisinvestments(glComparisonValue);
        }
    }

    protected void retrieveOBFigures_1(ComparisonValue glComparisonValue) throws Exception {
        if (!this.ob1QueryInitialized) {
            this.ob1Query = QueryFactory.createFreeQuery(Transaction.class);
            this.ob1Query.setQuery("SELECT SUM(amount1), SUM(amount2) FROM Transaction WHERE companyId = ?_companyId  AND accountingPrinciple = ?_ap  AND bookYearForJournalization < ?_year AND proFormaTypeId = ?_type AND (mainTransactionType = ?_mtt_1 OR mainTransactionType = ?_mtt_2 OR mainTransactionType = ?_mtt_3) ");
            this.ob1Query.setParameter("_mtt_1", 1);
            this.ob1Query.setParameter("_mtt_2", 2);
            this.ob1Query.setParameter("_mtt_3", 3);
            this.ob1Query.setCacheable(true);
            this.ob1QueryInitialized = true;
        }
        this.ob1Query.setParameter("_companyId", this.company.getId());
        this.ob1Query.setParameter("_ap", this.accountingPrinciple);
        this.ob1Query.setParameter("_year", this.year);
        this.ob1Query.setParameter("_type", glComparisonValue.getAssetTypeId());
        this.ob1Data = this.ob1Query.getResultArray();
        if (this.ob1Data != null) {
            BigDecimal value;
            if (this.ob1Data[0][0] != null && (value = (BigDecimal)this.ob1Data[0][0]).doubleValue() != 0.0) {
                glComparisonValue.addFigure(value, 1, 0);
            }
            if (this.ob1Data[0][1] != null && (value = (BigDecimal)this.ob1Data[0][1]).doubleValue() != 0.0) {
                glComparisonValue.addFigure(value, 3, 0);
            }
        }
    }

    protected void retrieveOBFigures_2(ComparisonValue glComparisonValue) throws Exception {
        if (!this.ob2QueryInitialized) {
            this.ob2Query = QueryFactory.createFreeQuery(Transaction.class);
            this.ob2Query.setQuery("SELECT SUM(amount1), SUM(amount2) FROM Transaction WHERE companyId = ?_companyId  AND accountingPrinciple = ?_ap  AND bookYearForJournalization = ?_year AND proFormaTypeId = ?_type AND transactionType = ?_tt AND (mainTransactionType = ?_mtt_1 OR mainTransactionType = ?_mtt_2 OR mainTransactionType = ?_mtt_3) ");
            this.ob2Query.setParameter("_tt", 20);
            this.ob2Query.setParameter("_mtt_1", 1);
            this.ob2Query.setParameter("_mtt_2", 2);
            this.ob2Query.setParameter("_mtt_3", 3);
            this.ob2Query.setCacheable(true);
            this.ob2QueryInitialized = true;
        }
        this.ob2Query.setParameter("_companyId", this.company.getId());
        this.ob2Query.setParameter("_ap", this.accountingPrinciple);
        this.ob2Query.setParameter("_year", this.year);
        this.ob2Query.setParameter("_type", glComparisonValue.getAssetTypeId());
        this.ob2Data = this.ob2Query.getResultArray();
        if (this.ob2Data != null) {
            BigDecimal value;
            if (this.ob2Data[0][0] != null && (value = (BigDecimal)this.ob2Data[0][0]).doubleValue() != 0.0) {
                glComparisonValue.addFigure(value, 1, 0);
            }
            if (this.ob2Data[0][1] != null && (value = (BigDecimal)this.ob2Data[0][1]).doubleValue() != 0.0) {
                glComparisonValue.addFigure(value, 3, 0);
            }
        }
    }

    protected void retrievePeriodFigures(ComparisonValue glComparisonValue) throws Exception {
        if (!this.perQueryInitialized) {
            this.perQuery = QueryFactory.createFreeQuery(Transaction.class);
            this.perQuery.setQuery("SELECT SUM(amount1), SUM(amount2) FROM Transaction WHERE companyId = ?_companyId  AND accountingPrinciple = ?_ap  AND bookYearForJournalization = ?_year AND periodForJournalization = ?_period AND proFormaTypeId = ?_type AND transactionType <> ?_tt AND (mainTransactionType = ?_mtt_1 OR mainTransactionType = ?_mtt_2 OR mainTransactionType = ?_mtt_3) ");
            this.perQuery.setParameter("_tt", 20);
            this.perQuery.setParameter("_mtt_1", 1);
            this.perQuery.setParameter("_mtt_2", 2);
            this.perQuery.setParameter("_mtt_3", 3);
            this.perQuery.setCacheable(true);
            if (this.numberOfCorrectionPeriods > 0) {
                this.initializeExtendedPeriodFiguresQuery();
            }
            this.perQueryInitialized = true;
        }
        this.perQuery.setParameter("_companyId", this.company.getId());
        this.perQuery.setParameter("_ap", this.accountingPrinciple);
        this.perQuery.setParameter("_year", this.year);
        this.perQuery.setParameter("_type", glComparisonValue.getAssetTypeId());
        int period = 1;
        while (period <= this.numberOfPeriods) {
            this.perQuery.setParameter("_period", period);
            this.perData = this.perQuery.getResultArray();
            if (this.perData != null) {
                BigDecimal value;
                if (this.perData[0][0] != null && (value = (BigDecimal)this.perData[0][0]).doubleValue() != 0.0) {
                    glComparisonValue.addFigure(value, 1, period);
                }
                if (this.perData[0][1] != null && (value = (BigDecimal)this.perData[0][1]).doubleValue() != 0.0) {
                    glComparisonValue.addFigure(value, 3, period);
                }
            }
            ++period;
        }
        if (this.numberOfCorrectionPeriods > 0) {
            this.executeExtendedPeriodFiguresQuery(glComparisonValue);
        }
    }

    protected void initializeExtendedPeriodFiguresQuery() throws Exception {
        this.extPerQuery = QueryFactory.createFreeQuery(Transaction.class);
        this.extPerQuery.setQuery("SELECT SUM(amount1), SUM(amount2) FROM Transaction WHERE companyId = ?_companyId  AND accountingPrinciple = ?_ap  AND bookYearForJournalization = ?_year AND periodForJournalization > ?_period AND proFormaTypeId = ?_type AND transactionType <> ?_tt AND (mainTransactionType = ?_mtt_1 OR mainTransactionType = ?_mtt_2 OR mainTransactionType = ?_mtt_3) ");
        this.extPerQuery.setParameter("_tt", 20);
        this.extPerQuery.setParameter("_mtt_1", 1);
        this.extPerQuery.setParameter("_mtt_2", 2);
        this.extPerQuery.setParameter("_mtt_3", 3);
        this.extPerQuery.setCacheable(true);
    }

    protected void executeExtendedPeriodFiguresQuery(ComparisonValue glComparisonValue) throws Exception {
        this.extPerQuery.setParameter("_companyId", this.company.getId());
        this.extPerQuery.setParameter("_ap", this.accountingPrinciple);
        this.extPerQuery.setParameter("_year", this.year);
        this.extPerQuery.setParameter("_type", glComparisonValue.getAssetTypeId());
        this.extPerQuery.setParameter("_period", this.numberOfPeriods);
        this.perData = this.extPerQuery.getResultArray();
        if (this.perData != null) {
            BigDecimal value;
            if (this.perData[0][0] != null && (value = (BigDecimal)this.perData[0][0]).doubleValue() != 0.0) {
                glComparisonValue.addFigure(value, 1, this.numberOfPeriods + 1);
            }
            if (this.perData[0][1] != null && (value = (BigDecimal)this.perData[0][1]).doubleValue() != 0.0) {
                glComparisonValue.addFigure(value, 3, this.numberOfPeriods + 1);
            }
        }
    }

    protected void retrieveDepreciationCostFigures(ComparisonValue glComparisonValue) throws Exception {
        if (!this.dprQueryInitialized) {
            this.dprQuery = QueryFactory.createFreeQuery(Transaction.class);
            this.dprQuery.setQuery("SELECT SUM(amount2), SUM(amount3) FROM Transaction WHERE companyId = ?_companyId  AND accountingPrinciple = ?_ap  AND bookYearForJournalization = ?_year AND periodForJournalization = ?_period AND proFormaTypeId = ?_type AND mainTransactionType = ?_mtt_3");
            this.dprQuery.setParameter("_mtt_3", 3);
            this.dprQuery.setCacheable(true);
            if (this.numberOfCorrectionPeriods > 0) {
                this.initializeExtendedCostFiguresQuery();
            }
            this.dprQueryInitialized = true;
        }
        this.dprQuery.setParameter("_companyId", this.company.getId());
        this.dprQuery.setParameter("_ap", this.accountingPrinciple);
        this.dprQuery.setParameter("_year", this.year);
        this.dprQuery.setParameter("_type", glComparisonValue.getAssetTypeId());
        int period = 1;
        while (period <= this.numberOfPeriods) {
            BigDecimal value;
            this.dprQuery.setParameter("_period", period);
            this.dprData = this.dprQuery.getResultArray();
            if (this.dprData != null && this.dprData[0][0] != null && (value = (BigDecimal)this.dprData[0][0]).doubleValue() != 0.0) {
                glComparisonValue.addFigure(value, 5, period);
            }
            ++period;
        }
        if (this.numberOfCorrectionPeriods > 0) {
            this.executeExtendedCostFiguresQuery(glComparisonValue);
        }
    }

    protected void initializeExtendedCostFiguresQuery() throws Exception {
        this.extDprQuery = QueryFactory.createFreeQuery(Transaction.class);
        this.extDprQuery.setQuery("SELECT SUM(amount2), SUM(amount3) FROM Transaction WHERE companyId = ?_companyId  AND accountingPrinciple = ?_ap  AND bookYearForJournalization = ?_year AND periodForJournalization > ?_period AND proFormaTypeId = ?_type AND mainTransactionType = ?_mtt_3");
        this.extDprQuery.setParameter("_mtt_3", 3);
        this.extDprQuery.setCacheable(true);
    }

    protected void executeExtendedCostFiguresQuery(ComparisonValue glComparisonValue) throws Exception {
        BigDecimal value;
        this.extDprQuery.setParameter("_companyId", this.company.getId());
        this.extDprQuery.setParameter("_ap", this.accountingPrinciple);
        this.extDprQuery.setParameter("_year", this.year);
        this.extDprQuery.setParameter("_type", glComparisonValue.getAssetTypeId());
        this.extDprQuery.setParameter("_period", this.numberOfPeriods);
        this.dprData = this.extDprQuery.getResultArray();
        if (this.dprData != null && this.dprData[0][0] != null && (value = (BigDecimal)this.dprData[0][0]).doubleValue() != 0.0) {
            glComparisonValue.addFigure(value, 5, this.numberOfPeriods + 1);
        }
    }

    protected void retrieveInvestmentsAndDisinvestments(ComparisonValue glComparisonValue) throws Exception {
        BigDecimal value;
        FreeQuery query = QueryFactory.createFreeQuery(Transaction.class);
        query.setQuery("SELECT SUM(amount1), SUM(amount2) FROM Transaction WHERE companyId = ?_companyId  AND accountingPrinciple = ?_ap  AND bookYearForJournalization = ?_year AND proFormaTypeId = ?_type AND transactionType <> ?_tt AND mainTransactionType = ?_mtt_1");
        query.setParameter("_tt", 20);
        query.setParameter("_companyId", this.company.getId());
        query.setParameter("_ap", this.accountingPrinciple);
        query.setParameter("_year", this.year);
        query.setParameter("_type", glComparisonValue.getAssetTypeId());
        query.setCacheable(true);
        query.setParameter("_mtt_1", 1);
        Object[][] data = query.getResultArray();
        if (data != null && data[0][0] != null && (value = (BigDecimal)data[0][0]).doubleValue() != 0.0) {
            glComparisonValue.setInvestmentTotalAcquisition(value);
        }
        query.setParameter("_mtt_1", 2);
        data = query.getResultArray();
        if (data != null) {
            if (data[0][0] != null && (value = (BigDecimal)data[0][0]).doubleValue() != 0.0) {
                glComparisonValue.setDisinvestmentTotalAcquisition(value);
            }
            if (data[0][1] != null && (value = (BigDecimal)data[0][1]).doubleValue() != 0.0) {
                glComparisonValue.setDisinvestmentTotalDepreciation(value);
            }
        }
    }
}

