/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.StandardDepreciationCalculator;
import nl.ibs.fac.WOZDepreciationCalculator;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.boadapters.WozValueBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.WozValue;

public class DepreciationBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 943448395178790461L;
    private HashSet<String> assetIdsWithNotPostedTransactions = new HashSet();
    private Collection<CalculationValue> allCalculationValues;
    private Collection calculationValues;
    private CalculationValue[] valueArray;
    private CalculationValue calculationValue;
    private Asset subAsset;
    private ArrayList<Asset> subAssets;
    private Iterator sai;
    private ArrayList valuations;
    private Iterator vi;
    private Valuation valuation;
    private Collection wozValues;
    private Object[] subAssetArray;
    private Object[] valuationArray;
    private WOZDepreciationCalculator[] calculatorArray;
    private WOZDepreciationCalculator calculator;
    private int currentYear;
    private int currentPeriod;

    public DepreciationBP(Company company, int numberOfPeriods, boolean depreciationProposal) throws Exception {
        super(company, numberOfPeriods);
        if (depreciationProposal) {
            this.getAssetIdsWithNotPostedTransactions();
        }
    }

    /*
     * Unable to fully structure code
     */
    public String depreciate(Asset parentAsset, int ap, int bookYearTo, int periodTo) throws Exception {
        block14: {
            block13: {
                this.allCalculationValues = new ArrayList<CalculationValue>();
                this.valuations = new ArrayList<E>();
                this.calculationValues = new ArrayList<E>();
                if (parentAsset.getSubAsset()) {
                    this.subAssets = new ArrayList<E>(1);
                    this.subAssets.add(parentAsset);
                } else {
                    this.subAssets = (ArrayList)AssetBO.getSubAssets(this.company.getDBData(), this.company.getId(), parentAsset.getId(), parentAsset.getCredit());
                    if (this.subAssets.isEmpty()) {
                        return "PARENT_ASSET_WITHOUT_SUB_ASSETS";
                    }
                }
                for (Asset this.subAsset : this.subAssets) {
                    if (this.subAsset.getState() > 2) {
                        this.sai.remove();
                        continue;
                    }
                    this.valuation = (Valuation)ValuationBO.getValuation(this.subAsset.getDBData(), this.subAsset.getCompanyId(), this.subAsset.getCora(), this.subAsset.getId(), ap)[0];
                    if (this.valuation != null) {
                        this.valuations.add(this.valuation);
                        continue;
                    }
                    this.sai.remove();
                }
                if (this.valuations.isEmpty()) {
                    return "NO_VALUATIONS_FOR_THIS_AP";
                }
                if (!this.assetIdsWithNotPostedTransactions.isEmpty()) {
                    for (Valuation this.valuation : this.valuations) {
                        if (!this.assetIdsWithNotPostedTransactions.contains(this.valuation.getAssetId())) continue;
                        asset = (Asset)AssetBO.get(this.company, this.valuation.getAssetId(), false)[0];
                        value = new CalculationValue(50, bookYearTo, periodTo, new BigDecimal("0"), new BigDecimal("0"), asset, this.valuation, null, null, null, null, null, null, null, false, new BigDecimal("0"));
                        this.allCalculationValues.add(value);
                    }
                    if (!this.allCalculationValues.isEmpty()) {
                        return "NOT_POSTED_TRANSACTIONS_FOUND";
                    }
                }
                this.wozValues = WozValueBO.getWozValues(parentAsset);
                if (!this.wozValues.isEmpty()) break block13;
                calculator = new StandardDepreciationCalculator(this.processParameters.getFullInterestIn1stPeriod());
                for (Valuation this.valuation : this.valuations) {
                    this.calculationValues = calculator.calculate(this.company.getDBData(), this.company, this.numberOfPeriods, false, bookYearTo, periodTo, this.valuation, null);
                    if (this.calculationValues.isEmpty()) continue;
                    this.allCalculationValues.addAll(this.calculationValues);
                }
                if (this.allCalculationValues.isEmpty()) {
                    return "NO_DEPRECIATION_AND_INTEREST_CALCULATED";
                }
                break block14;
            }
            this.subAssetArray = this.subAssets.toArray();
            this.valuationArray = this.valuations.toArray();
            this.retrieveFirstPeriod(ap, bookYearTo, periodTo);
            if (this.currentYear != 0) ** GOTO lbl56
            return "NO_DEPRECIATION_AND_INTEREST_CALCULATED";
lbl-1000:
            // 1 sources

            {
                this.handlePeriod(ap);
                this.applyWozChanges(ap);
                this.handleNextPeriod(ap);
lbl56:
                // 2 sources

                ** while (!PeriodHelper.isAfter((int)this.currentYear, (int)this.currentPeriod, (int)bookYearTo, (int)periodTo))
            }
        }
        return null;
    }

    private void getAssetIdsWithNotPostedTransactions() throws Exception {
        for (Transaction transaction : TransactionBO.getTransactions(this.company, false)) {
            String assetId = transaction.getAssetId();
            if (this.assetIdsWithNotPostedTransactions.contains(assetId)) continue;
            this.assetIdsWithNotPostedTransactions.add(assetId);
        }
    }

    private void retrieveFirstPeriod(int accountingPrinciple, int bookYearTo, int periodTo) throws Exception {
        int startYear = 0;
        int startPeriod = 0;
        this.currentYear = 0;
        this.currentPeriod = 0;
        this.calculatorArray = new WOZDepreciationCalculator[this.subAssets.size()];
        int i = 0;
        while (i < this.subAssetArray.length) {
            this.subAsset = (Asset)this.subAssetArray[i];
            this.valuation = (Valuation)this.valuationArray[i];
            this.calculatorArray[i] = this.calculator = new WOZDepreciationCalculator(this.subAsset, this.company, this.numberOfPeriods, false, bookYearTo, periodTo, this.valuation, this.processParameters.getFullInterestIn1stPeriod());
            startYear = this.calculator.getCurrentYear();
            startPeriod = this.calculator.getCurrentPeriod();
            if (startYear > 0 && (this.currentYear == 0 || PeriodHelper.isBefore(startYear, startPeriod, this.currentYear, this.currentPeriod))) {
                this.currentYear = startYear;
                this.currentPeriod = startPeriod;
            }
            ++i;
        }
    }

    private void handlePeriod(int accountingPrinciple) throws Exception {
        this.valueArray = new CalculationValue[this.subAssetArray.length];
        int i = 0;
        while (i < this.subAssetArray.length) {
            this.subAsset = (Asset)this.subAssetArray[i];
            this.valuation = (Valuation)this.valuationArray[i];
            this.calculator = this.calculatorArray[i];
            Object[] values = this.calculator.calculate(this.currentYear, this.currentPeriod).toArray();
            if (values.length != 0) {
                this.valueArray[i] = this.calculationValue = (CalculationValue)values[0];
                this.allCalculationValues.add(this.calculationValue);
            }
            ++i;
        }
    }

    private void applyWozChanges(int accountingPrinciple) throws Exception {
        BigDecimal limitValue = this.calculateLimitValue(accountingPrinciple);
        if (limitValue.doubleValue() > 0.0) {
            BigDecimal[] values = this.calculateValues(this.currentYear, this.currentPeriod);
            BigDecimal bookValue = values[0];
            BigDecimal depreciationValue = values[1];
            BigDecimal differenceValue = limitValue.subtract(bookValue).add(depreciationValue);
            if (differenceValue.doubleValue() < 0.0) {
                return;
            }
            differenceValue = depreciationValue.subtract(differenceValue);
            int i = 0;
            while (i < this.subAssetArray.length) {
                this.subAsset = (Asset)this.subAssetArray[i];
                this.calculationValue = this.valueArray[i];
                if (this.calculationValue != null && (depreciationValue = this.calculationValue.getDepreciationAmount()) != null && depreciationValue.doubleValue() != 0.0) {
                    this.calculator = this.calculatorArray[i];
                    differenceValue = this.updateCalculationValue(this.calculationValue, this.calculator, differenceValue);
                }
                ++i;
            }
        }
    }

    private void handleNextPeriod(int accountingPrinciple) throws Exception {
        int i = 0;
        while (i < this.subAssetArray.length) {
            this.subAsset = (Asset)this.subAssetArray[i];
            this.calculator = this.calculatorArray[i];
            this.calculator.handleNextPeriod();
            ++i;
        }
        int[] nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.currentYear, this.currentPeriod);
        this.currentYear = nextPeriod[0];
        this.currentPeriod = nextPeriod[1];
    }

    private BigDecimal calculateLimitValue(int accountingPrinciple) throws Exception {
        BigDecimal limitValue = new BigDecimal(0);
        int theYear = 0;
        int thePeriod = 0;
        for (WozValue wozValue : this.wozValues) {
            BigDecimal limitAmount;
            int limitPeriod;
            int limitYear;
            if (accountingPrinciple == 1) {
                limitYear = wozValue.getLimitValueYear1();
                limitPeriod = wozValue.getLimitValuePeriod1();
                limitAmount = wozValue.getLimitAmount1();
            } else {
                limitYear = wozValue.getLimitValueYear2();
                limitPeriod = wozValue.getLimitValuePeriod2();
                limitAmount = wozValue.getLimitAmount2();
            }
            if (PeriodHelper.isAfter(limitYear, limitPeriod, this.currentYear, this.currentPeriod) || !PeriodHelper.isAfter(limitYear, limitPeriod, theYear, thePeriod)) continue;
            theYear = limitYear;
            thePeriod = limitPeriod;
            limitValue = limitAmount;
        }
        return limitValue;
    }

    private BigDecimal[] calculateValues(int year, int period) throws Exception {
        BigDecimal[] values = new BigDecimal[]{new BigDecimal(0), new BigDecimal(0)};
        int i = 0;
        while (i < this.subAssetArray.length) {
            this.subAsset = (Asset)this.subAssetArray[i];
            this.calculationValue = this.valueArray[i];
            if (this.calculationValue != null) {
                values[0] = values[0].add(this.calculationValue.getBookValue());
                if (this.calculationValue.getDepreciationAmount() != null) {
                    values[1] = values[1].add(this.calculationValue.getDepreciationAmount());
                }
            }
            ++i;
        }
        return values;
    }

    private BigDecimal updateCalculationValue(CalculationValue calculationValue, WOZDepreciationCalculator calculator, BigDecimal differenceValue) throws Exception {
        if (calculationValue.getDepreciationAmount().doubleValue() > differenceValue.doubleValue()) {
            calculationValue.setReasonCode(12);
            boolean updatePreviousBookValueBalance = false;
            int valInterestCalculationMethod = calculationValue.getValuation().getInterestCalculationMethod();
            if (valInterestCalculationMethod == 2) {
                updatePreviousBookValueBalance = true;
            } else {
                int[] nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.currentYear, this.currentPeriod);
                if (valInterestCalculationMethod == 1 && this.currentYear != nextPeriod[0]) {
                    updatePreviousBookValueBalance = true;
                }
            }
            if (differenceValue.doubleValue() < 0.0) {
                calculationValue.setDepreciationAmount(new BigDecimal(0), updatePreviousBookValueBalance);
            } else {
                calculationValue.setDepreciationAmount(differenceValue, updatePreviousBookValueBalance);
            }
            calculator.setCurrentDepreciationAmount(calculationValue.getDepreciationAmount());
            calculationValue.setInterestAmount(calculator.calculateInterest());
        }
        differenceValue = differenceValue.subtract(calculationValue.getDepreciationAmount());
        return differenceValue;
    }

    public Collection getAllCalculationValues() {
        return this.allCalculationValues;
    }
}

