/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.CompanyBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.DepreciationBP;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.BookYear;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.CreditBalance;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionBatchManager;
import nl.ibs.fac.db.TransactionBatchManagerFactory;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.gov.boadapters.CreditBalanceDetailBO;
import nl.ibs.fac.gov.bp.CreditDepreciationBP;
import nl.ibs.fac.gov.queries.CreditQuery;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.fac.language.TokenList;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class DepreciationProposalBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 434563591945196003L;

    public DepreciationProposalBP(Company company, int numberOfPeriods, boolean governmentActivated) throws Exception {
        super(company, numberOfPeriods, governmentActivated);
    }

    public String[] retrieveYearsAndPeriods() throws Exception {
        String[] yps = new String[4];
        int[] nextPeriod = null;
        if (this.company.getLastDepreciationRunYear() > 0) {
            nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod());
        }
        if (nextPeriod != null) {
            yps[0] = "" + nextPeriod[0];
            yps[1] = "" + nextPeriod[1];
        } else {
            yps[0] = "" + this.company.getCurrentBookYear();
            yps[1] = "1";
        }
        if (!this.processParameters.getDefaultValueInBookPeriod()) {
            yps[2] = "";
            yps[3] = "";
        } else {
            yps[2] = yps[0];
            yps[3] = yps[1];
        }
        return yps;
    }

    public String addDepreciationTransactions(TransactionBatch transactionBatch, boolean ap1, boolean ap2, int bookYearTo, int periodTo, String user) throws Exception {
        CreditDepreciationBP creditDepreciationBP = null;
        CreditQuery creditQuery = null;
        Iterator creditIterator = null;
        Credit credit = null;
        DepreciationBP depreciationBP = new DepreciationBP(this.company, this.numberOfPeriods, true);
        Iterator<?> iterator = AssetBO.getParentAssets(this.company, false).iterator();
        if (this.governmentActivated) {
            creditDepreciationBP = new CreditDepreciationBP(this.company, this.numberOfPeriods);
            creditQuery = new CreditQuery(this.company.getDBData(), this.company.getId(), false, true);
            creditIterator = creditQuery.fetchData(null, null, null, 999).iterator();
        }
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            String message;
            while (iterator.hasNext()) {
                Asset parentAsset = (Asset)iterator.next();
                Log.debug((String)parentAsset.getId());
                if (ap1 && ((message = depreciationBP.depreciate(parentAsset, 1, bookYearTo, periodTo)) == null || message.trim().equals("NOT_POSTED_TRANSACTIONS_FOUND")) && (message = this.createDepreciations(transactionBatch, user, depreciationBP, message)) != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                if (!ap2 || (message = depreciationBP.depreciate(parentAsset, 2, bookYearTo, periodTo)) != null && !message.trim().equals("NOT_POSTED_TRANSACTIONS_FOUND") || (message = this.createDepreciations(transactionBatch, user, depreciationBP, message)) == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            if (this.governmentActivated) {
                while (creditIterator.hasNext()) {
                    credit = (Credit)creditIterator.next();
                    Log.debug((String)credit.getId());
                    message = creditDepreciationBP.depreciate(credit, bookYearTo, periodTo);
                    if (message != null || (message = this.createCreditDepreciations(transactionBatch, user, creditDepreciationBP)) == null) continue;
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }

    private String createDepreciations(TransactionBatch transactionBatch, String user, DepreciationBP depreciationBP, String message) throws Exception {
        ArrayList allCalculationValues = (ArrayList)depreciationBP.getAllCalculationValues();
        if (allCalculationValues.isEmpty()) {
            return null;
        }
        if (allCalculationValues.size() > 1) {
            Collections.sort(allCalculationValues, new CalculationValuesComparator());
        }
        String assetIdOld = "";
        this.seqNr = 0;
        this.documentNr = 0;
        for (CalculationValue calculationValue : allCalculationValues) {
            Valuation valuation = calculationValue.getValuation();
            if (this.documentNr == 0) {
                assetIdOld = valuation.getAssetId().trim();
            } else if (!valuation.getAssetId().trim().equals(assetIdOld)) {
                assetIdOld = valuation.getAssetId().trim();
                ++this.documentNr;
                this.seqNr = 0;
            }
            Object[] result = this.createDepreciation(calculationValue.getAsset(), valuation, calculationValue, transactionBatch, user);
            if (result[1] != null) {
                return (String)result[1];
            }
            if (message != null) continue;
            valuation.setCurrentBookvalueBalance(calculationValue.getPreviousBookvalueBalance());
        }
        return null;
    }

    private Object[] createDepreciation(Asset asset, Valuation valuation, CalculationValue calculationValue, TransactionBatch transactionBatch, String user) throws Exception {
        Object[] result;
        int transactionType;
        this.asset = asset;
        switch (calculationValue.getReasonCode()) {
            case 11: {
                transactionType = 71;
                break;
            }
            case 12: {
                transactionType = 72;
                break;
            }
            default: {
                transactionType = 70;
            }
        }
        int bookYearForJournalization = calculationValue.getYear();
        int periodForJournalization = calculationValue.getPeriod();
        if (transactionBatch.getFinYear() != 0) {
            bookYearForJournalization = transactionBatch.getFinYear();
            periodForJournalization = transactionBatch.getFinPeriod();
        }
        String genericTransactionDescription = "Run-" + transactionBatch.getBatchId() + "-" + transactionBatch.getEndYear() + "/" + transactionBatch.getEndPeriod();
        this.retrieveFinancialDimensions(calculationValue.getYear(), calculationValue.getPeriod());
        int mainTransactionType = 3;
        if (calculationValue.isDepreciationBeyondEconomicLife()) {
            mainTransactionType = 5;
            transactionType = 85;
        }
        if ((result = TransactionBO.create(valuation.getDBData(), valuation.getCompanyId(), this.documentNr, ++this.seqNr, genericTransactionDescription, valuation.getCora(), valuation.getAssetId(), valuation.getAccountingPrinciple(), mainTransactionType, transactionType, calculationValue.getYear(), calculationValue.getPeriod(), bookYearForJournalization, periodForJournalization, new BigDecimal(0), calculationValue.getDepreciationAmount(), calculationValue.getInterestAmount(), null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(valuation.getAccountingPrinciple(), 3), calculationValue.getReasonCode(), transactionBatch.getBatchId(), user, asset.getTypeId()))[1] != null) {
            return result;
        }
        Transaction transaction = (Transaction)result[0];
        if (this.use445Correction && calculationValue.getCorrectionAmount445().doubleValue() != 0.0) {
            transaction.setCorrectionAmount445(calculationValue.getCorrectionAmount445());
        }
        this.documentNr = transaction.getDocumentNr();
        if (calculationValue.getCurrentInterestPercentage() != null) {
            transaction.setOriginalInterestPercentage(calculationValue.getCurrentInterestPercentage());
        }
        return result;
    }

    private String createCreditDepreciations(TransactionBatch transactionBatch, String user, CreditDepreciationBP creditDepreciationBP) throws Exception {
        ArrayList allCalculationValues = (ArrayList)creditDepreciationBP.getAllCalculationValues();
        if (allCalculationValues == null || allCalculationValues.isEmpty()) {
            return null;
        }
        this.seqNr = 0;
        this.documentNr = 0;
        for (CalculationValue calculationValue : allCalculationValues) {
            Credit credit = calculationValue.getCredit();
            Log.debug((String)credit.getId());
            CreditBalance creditBalance = calculationValue.getCreditBalance();
            int bookYearForJournalization = calculationValue.getYear();
            int periodForJournalization = calculationValue.getPeriod();
            if (transactionBatch.getFinYear() != 0) {
                bookYearForJournalization = transactionBatch.getFinYear();
                periodForJournalization = transactionBatch.getFinPeriod();
            }
            String genericTransactionDescription = "Run-" + transactionBatch.getBatchId() + "-" + transactionBatch.getEndYear() + "/" + transactionBatch.getEndPeriod();
            Object[] result = TransactionBO.create(credit.getDBData(), credit.getCompanyId(), this.documentNr, ++this.seqNr, genericTransactionDescription, "C", null, 3, 3, 70, calculationValue.getYear(), calculationValue.getPeriod(), bookYearForJournalization, periodForJournalization, new BigDecimal(0), calculationValue.getDepreciationAmount(), calculationValue.getInterestAmount(), null, credit.getFinDimId1(), credit.getFinDimId2(), credit.getFinDimId3(), credit.getFinDimId4(), creditBalance.getGLAccountId(), this.retrieveJournalingState(3, 3), calculationValue.getReasonCode(), transactionBatch.getBatchId(), user, credit.getProFormaTypeId());
            if (result[1] != null) {
                return (String)result[1];
            }
            Transaction transaction = (Transaction)result[0];
            this.documentNr = transaction.getDocumentNr();
            transaction.setCreditId(credit.getId());
            if (calculationValue.getCurrentInterestPercentage() == null) continue;
            transaction.setOriginalInterestPercentage(calculationValue.getCurrentInterestPercentage());
        }
        return null;
    }

    public String postCurrentDepreciationBatch(TransactionBatch transactionBatch) throws Exception {
        if (Log.debug()) {
            Log.debug((String)("" + transactionBatch.getBatchId()));
        }
        DBData dbData = transactionBatch.getDBData();
        String companyId = transactionBatch.getCompanyId();
        Iterator iterator = TransactionBO.getTransactions(transactionBatch).iterator();
        if (!iterator.hasNext()) {
            return "batch_is_empty";
        }
        int endYear = transactionBatch.getEndYear();
        BookYear bookYear = (BookYear)BookYearBO.get(this.company, endYear)[0];
        if (bookYear == null) {
            TokenList tl = new TokenList();
            tl.addNonTranslatable("" + endYear);
            return LanguageHelper.getString("nl.ibs.fac.language", "bookYear_not_found", tl);
        }
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            if (this.governmentActivated) {
                iterator = TransactionBO.getAssetRelatedTransactions(transactionBatch).iterator();
            }
            boolean updateValuation = false;
            Transaction transaction2 = null;
            String cora = null;
            String prvCora = null;
            String assetId = null;
            String prvAssetId = null;
            int ap = -1;
            int prvAp = -1;
            int lastDepreciationBookYear = 0;
            int lastDepreciationPeriod = 0;
            int numberOfDepreciatedPeriods = 0;
            BigDecimal totalDepreciated = new BigDecimal("0");
            BigDecimal[] c445 = new BigDecimal[2];
            while (iterator.hasNext()) {
                transaction2 = (Transaction)iterator.next();
                cora = transaction2.getCora();
                assetId = transaction2.getAssetId();
                ap = transaction2.getAccountingPrinciple();
                if (prvAssetId == null) {
                    prvCora = cora;
                    prvAssetId = assetId;
                    prvAp = ap;
                }
                if (!prvCora.equals(cora) || !prvAssetId.equals(assetId) || prvAp != ap) {
                    this.updateValuation(dbData, companyId, prvCora, prvAssetId, prvAp, lastDepreciationBookYear, lastDepreciationPeriod, numberOfDepreciatedPeriods, totalDepreciated, c445, updateValuation);
                    prvCora = cora;
                    prvAssetId = assetId;
                    prvAp = ap;
                    lastDepreciationBookYear = 0;
                    lastDepreciationPeriod = 0;
                    numberOfDepreciatedPeriods = 0;
                    totalDepreciated = new BigDecimal("0");
                    c445[0] = null;
                    c445[1] = null;
                    updateValuation = false;
                }
                lastDepreciationBookYear = transaction2.getBookYear();
                lastDepreciationPeriod = transaction2.getPeriod();
                if (transaction2.getMainTransactionType() != 5 && (transaction2.getAmount2().doubleValue() != 0.0 || transaction2.getReasonCode() == 21 || transaction2.getReasonCode() == 5 || transaction2.getReasonCode() == 6)) {
                    numberOfDepreciatedPeriods += this.determineNumberOfDepreciatedPeriods(transaction2);
                    totalDepreciated = totalDepreciated.add(transaction2.getAmount2());
                    if (this.use445Correction) {
                        c445 = this.determine445Correction(transaction2, c445);
                    }
                }
                if (transaction2.getReasonCode() < 50) {
                    updateValuation = true;
                    transaction2.setState(1);
                    continue;
                }
                iterator.remove();
                transaction2.delete();
            }
            if (updateValuation) {
                this.updateValuation(dbData, companyId, cora, assetId, ap, lastDepreciationBookYear, lastDepreciationPeriod, numberOfDepreciatedPeriods, totalDepreciated, c445, updateValuation);
            }
            if (this.governmentActivated) {
                for (Transaction transaction2 : TransactionBO.getCreditRelatedTransactions(transactionBatch)) {
                    if (transaction2.getFinDimId5().trim().length() == 0) continue;
                    CreditBalanceDetailBO.updateInterestTotal(this.company, transaction2.getFinDimId5(), transaction2.getBookYearForJournalization(), 0, transaction2.getCreditId(), transaction2.getAmount3());
                    transaction2.setState(1);
                }
            }
            transactionBatch.setState(1);
            Company company = (Company)CompanyBO.get(dbData, companyId)[0];
            if (PeriodHelper.isAfter(transactionBatch.getEndYear(), transactionBatch.getEndPeriod(), company.getLastDepreciationRunYear(), company.getLastDepreciationRunPeriod())) {
                company.setLastDepreciationRunYear(transactionBatch.getEndYear());
                company.setLastDepreciationRunPeriod(transactionBatch.getEndPeriod());
            }
            if (this.processParameters.getAutoUpdateBlockedPeriods()) {
                BookYearBO.incrementBlockedPeriods(company, company.retrieveNumberOfPeriods(), transactionBatch.getEndYear(), transactionBatch.getEndPeriod());
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }

    private BigDecimal[] determine445Correction(Transaction transaction, BigDecimal[] c445) throws Exception {
        int remainder = transaction.getPeriod() % 3;
        switch (remainder) {
            case 1: {
                c445[0] = transaction.getCorrectionAmount445();
                break;
            }
            case 2: {
                c445[1] = transaction.getCorrectionAmount445();
                break;
            }
            case 0: {
                c445[0] = new BigDecimal("0.00");
                c445[1] = new BigDecimal("0.00");
            }
        }
        return c445;
    }

    private int determineNumberOfDepreciatedPeriods(Transaction transaction) throws Exception {
        int theNumberOfPeriods = 1;
        int startMonth = 1;
        if (transaction.getReasonCode() == 5) {
            theNumberOfPeriods = PeriodHelper.calculateNumberOfPeriods(this.numberOfPeriods, transaction.getBookYear(), startMonth, transaction.getBookYear(), transaction.getPeriod());
        }
        if (transaction.getReasonCode() == 6) {
            if (transaction.getPeriod() > 6) {
                startMonth = 7;
            }
            theNumberOfPeriods = PeriodHelper.calculateNumberOfPeriods(this.numberOfPeriods, transaction.getBookYear(), startMonth, transaction.getBookYear(), transaction.getPeriod());
        }
        return theNumberOfPeriods;
    }

    private void updateValuation(DBData dbData, String companyId, String cora, String assetId, int accountingPrinciple, int lastDepreciationBookYear, int lastDepreciationPeriod, int numberOfDepreciatedPeriods, BigDecimal totalDepreciated, BigDecimal[] c445, boolean updateValuation) throws Exception {
        if (!updateValuation) {
            return;
        }
        Valuation valuation = (Valuation)ValuationBO.get(dbData, companyId, cora, assetId, accountingPrinciple)[0];
        valuation.setPreviousBookvalueBalance(valuation.getCurrentBookvalueBalance());
        valuation.setCurrentBookvalueBalance(new BigDecimal(0));
        valuation.setLastDepreciationBookYear(lastDepreciationBookYear);
        valuation.setLastDepreciationPeriod(lastDepreciationPeriod);
        valuation.setNumberOfDepreciatedPeriods(valuation.getNumberOfDepreciatedPeriods() + numberOfDepreciatedPeriods);
        valuation.setPostedDepreciationBalance(valuation.getPostedDepreciationBalance().add(totalDepreciated));
        if (this.use445Correction) {
            if (c445[0] != null) {
                valuation.setCorrectionAmount445A(c445[0]);
            }
            if (c445[1] != null) {
                valuation.setCorrectionAmount445B(c445[1]);
            }
        }
        Asset asset = (Asset)AssetBO.get(this.company, assetId, false)[0];
        asset.setBookValue(ValuationBO.getBookValue(asset));
    }

    public static TransactionBatch getCurrentDepreciationBatch(DBData dbData, String companyId) throws Exception {
        if (Log.debug()) {
            Log.debug((String)companyId);
        }
        ExecutableQuery query = QueryFactory.create(TransactionBatch.class);
        query.setCacheable(true);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String filter = BOAdapter.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", companyId);
        filter = BOAdapter.addFilterTerm(filter, "batchCode = ?_batchCode");
        parameters.put("_batchCode", new Integer(1));
        filter = BOAdapter.addFilterTerm(filter, "state = ?_state");
        parameters.put("_state", new Integer(0));
        if (Log.debug()) {
            Log.debug((String)("Filter: " + filter));
            Log.debug((String)("Parameters: " + parameters));
        }
        query.setFilter(filter);
        query.setParameters(parameters);
        TransactionBatchManager manager = TransactionBatchManagerFactory.getInstance(dbData);
        return manager.getFirstObject(query);
    }

    public class CalculationValuesComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = -1075991651146289996L;

        public int compare(Object o1, Object o2) {
            try {
                return ((CalculationValue)o1).getAsset().getId().trim().compareTo(((CalculationValue)o2).getAsset().getId().trim());
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

