/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.ValuationManagerFactory;
import nl.ibs.fac.db.ValuationPK;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class DisInvestmentBP
extends GenericTransactionBP {
    private static final long serialVersionUID = -5353792318326500404L;
    private String description;
    private String extraDescription;
    private BigDecimal yieldValue;
    private BigDecimal disInvestmentValue;
    private Transaction disinvestmentTransaction;
    private IncomingFinancialTransaction ift;
    private int batchId;
    private Collection transactionsToBeReversed;
    private BigDecimal firstPeriodAcquisitionValue;
    private BigDecimal firstPeriodDepreciationValue;
    private BigDecimal acquisitionBalanceAP1;
    private boolean isFirstPeriodDisinvestment;
    private boolean isPartialDisinvestment;
    private int[] previousFacYP;
    protected boolean interCompany = false;

    public DisInvestmentBP(Company company, int numberOfPeriods, String origin) throws Exception {
        super(company, numberOfPeriods);
        this.originatingFromFIN = "FIN".equals(origin);
    }

    public String[] retrieveYearsAndPeriods(Asset asset, IncomingFinancialTransaction ift) throws Exception {
        String[] yps = new String[4];
        if (this.originatingFromFIN) {
            if (ift.getPeriod() > this.numberOfPeriods) {
                yps[0] = "" + ift.getBookYear();
                yps[1] = "" + this.numberOfPeriods;
                yps[2] = "" + ift.getBookYear();
                yps[3] = "" + ift.getPeriod();
            } else {
                yps[0] = "" + ift.getBookYear();
                yps[1] = "" + ift.getPeriod();
                if (!this.processParameters.getDefaultValueInBookPeriod()) {
                    yps[2] = "";
                    yps[3] = "";
                } else {
                    yps[2] = yps[0];
                    yps[3] = yps[1];
                }
            }
        } else {
            int[] nextPeriod = null;
            if (this.company.getLastDepreciationRunYear() > 0) {
                nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod());
            }
            if (nextPeriod != null) {
                yps[0] = "" + nextPeriod[0];
                yps[1] = "" + nextPeriod[1];
            } else {
                nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, asset.getStartUseYear(), asset.getStartUsePeriod());
                yps[0] = "" + nextPeriod[0];
                yps[1] = "" + nextPeriod[1];
            }
            if (!this.processParameters.getDefaultValueInBookPeriod()) {
                yps[2] = "";
                yps[3] = "";
            } else {
                yps[2] = yps[0];
                yps[3] = yps[1];
            }
        }
        return yps;
    }

    public String[] validateFACYearAndPeriod(Asset asset, int facYear, int facPeriod, boolean isPartialDisinvestment) throws Exception {
        int[] yearPeriod;
        int status;
        int thePeriod;
        String[] messages = new String[2];
        int index = 0;
        int theYear = asset.getStartUseYear();
        if (PeriodHelper.isBefore(facYear, facPeriod, theYear, thePeriod = asset.getStartUsePeriod())) {
            messages[index] = "FACPeriodBeforeStartUsePeriod";
            ++index;
        }
        if ((status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod)) == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index > 0) {
            return messages;
        }
        if (isPartialDisinvestment && (yearPeriod = AssetBO.getLastDepreciatedPeriod(asset))[0] != 0 && !PeriodHelper.isAfter(facYear, facPeriod, yearPeriod[0], yearPeriod[1])) {
            messages[index] = "PartialDisInvestmentOnlySustainedAfterLastDepreciatedPeriod";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String[] validateYieldValue(BigDecimal yieldValue) throws Exception {
        String[] messages = new String[1];
        int index = 0;
        if (yieldValue.doubleValue() == 0.0) {
            messages[index] = "YieldValueCannotBeZero";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String[] validatePartialDisInvestmentValue(Asset asset, BigDecimal partialValue, int year, int period) throws Exception {
        String[] messages = new String[2];
        int index = 0;
        if (partialValue.doubleValue() == 0.0) {
            messages[index] = "PartialDisInvestmentValueCannotBeZero";
            ++index;
        } else if (!asset.getNegativeInvestment()) {
            if (partialValue.doubleValue() < 0.0) {
                messages[index] = "PartialDisInvestmentShouldBePositive";
                ++index;
            }
        } else if (partialValue.doubleValue() > 0.0) {
            messages[index] = "PartialDisInvestmentShouldBeNegative";
            ++index;
        }
        if (index > 0) {
            return messages;
        }
        Collection valuations = asset.getValuationsCollection(null);
        for (Valuation valuation : valuations) {
            BigDecimal acquisitionValue = TransactionBO.calculateAcquisitionValue(asset, valuation.getAccountingPrinciple(), year, period)[0];
            if (!asset.getNegativeInvestment()) {
                if (!(acquisitionValue.doubleValue() - partialValue.doubleValue() < 0.0)) continue;
                messages[index] = "PartialDisInvestmentGreaterThanAcquisitionValue";
                ++index;
                break;
            }
            if (!(acquisitionValue.doubleValue() - partialValue.doubleValue() > 0.0)) continue;
            messages[index] = "PartialDisInvestmentSmallerThanAcquisitionValue";
            ++index;
            break;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String createDisInvestment(Asset asset, int facYear, int facPeriod, int finYear, int finPeriod, String description, BigDecimal yieldValue, BigDecimal disInvestmentValue, IncomingFinancialTransaction ift, boolean post, String user, int disinvestmentReasonCode) throws Exception {
        this.asset = asset;
        this.facYear = facYear;
        this.facPeriod = facPeriod;
        this.finYear = finYear;
        this.finPeriod = finPeriod;
        this.description = description;
        this.yieldValue = yieldValue;
        this.disInvestmentValue = disInvestmentValue;
        this.ift = ift;
        this.post = post;
        this.batchId = 0;
        if (post) {
            this.batchId = -1;
        }
        this.user = user;
        this.firstPeriodAcquisitionValue = new BigDecimal("0");
        this.firstPeriodDepreciationValue = new BigDecimal("0");
        this.isFirstPeriodDisinvestment = false;
        this.isPartialDisinvestment = false;
        this.documentNr = 0;
        this.seqNr = 0;
        if (disInvestmentValue.doubleValue() != 0.0) {
            this.isPartialDisinvestment = true;
        }
        if (PeriodHelper.equals(facYear, facPeriod, asset.getStartUseYear(), asset.getStartUsePeriod())) {
            this.isFirstPeriodDisinvestment = true;
        } else {
            this.previousFacYP = PeriodHelper.getPreviousPeriod(this.numberOfPeriods, facYear, facPeriod);
        }
        String message = null;
        Iterator iterator = asset.getValuationsCollection(null).iterator();
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            while (iterator.hasNext()) {
                Transaction transaction;
                Valuation valuation = (Valuation)iterator.next();
                this.transactionsToBeReversed = TransactionBO.getAfterOrEquals(asset, facYear, facPeriod, valuation.getAccountingPrinciple());
                message = this.createProFormaDisinvestmentTransaction(valuation);
                if (message != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                if (!this.isPartialDisinvestment) {
                    message = this.reverseFutureTransactions(valuation);
                    if (message != null) {
                        BOAdapter.investigate(null, dbTransaction);
                        return message;
                    }
                } else if (this.isFirstPeriodDisinvestment && (transaction = (Transaction)TransactionBO.get(this.company.getDBData(), this.company.getId(), valuation.getDocumentNr1stTransaction(), valuation.getSeqNr1stTransaction())[0]) != null) {
                    this.firstPeriodAcquisitionValue = transaction.getAmount1();
                    this.firstPeriodDepreciationValue = transaction.getAmount2();
                }
                if (!this.isFirstPeriodDisinvestment && PeriodHelper.isAfter(this.previousFacYP[0], this.previousFacYP[1], valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod()) && (message = this.createAdditionalDepreciationTransactions(valuation, this.previousFacYP, this.extraDescription, this.batchId, null, null)) != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                message = this.updateDisInvestmentTransaction(valuation, disinvestmentReasonCode);
                if (message == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            if (post && (this.disinvestmentTransaction.getTransactionType() == 30 || this.disinvestmentTransaction.getTransactionType() == 50)) {
                asset.setDisinvestmentYear(facYear);
                asset.setDisinvestmentPeriod(facPeriod);
                asset.setFinDisinvestmentYear(this.finBookYear);
                asset.setFinDisinvestmentPeriod(this.finBookPeriod);
                if (this.disinvestmentTransaction.getTransactionType() == 30) {
                    asset.setState(4);
                }
                if (this.disinvestmentTransaction.getTransactionType() == 50) {
                    asset.setState(5);
                }
            }
            if (ift != null && (message = IncomingFinancialTransactionBO.update(ift, ift.getUnAllocatedValue().subtract(yieldValue.negate()))) != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    private String createProFormaDisinvestmentTransaction(Valuation valuation) throws Exception {
        int transactionType;
        String message = null;
        String iftId = null;
        if (this.ift != null) {
            iftId = this.ift.getId();
        }
        if (this.description.trim().equals("")) {
            this.description = LanguageHelper.getString("nl.ibs.fac.language", "ContraBookingBalanceValues");
        }
        if (this.finYear == 0) {
            this.finBookYear = this.facYear;
            this.finBookPeriod = this.facPeriod;
        } else {
            this.finBookYear = this.finYear;
            this.finBookPeriod = this.finPeriod;
        }
        this.retrieveFinancialDimensions(this.facYear, this.facPeriod);
        if (this.interCompany) {
            transactionType = 50;
            this.extraDescription = LanguageHelper.getString("nl.ibs.fac.language", "MovementICReference");
        } else if (this.isPartialDisinvestment) {
            transactionType = 130;
            this.extraDescription = LanguageHelper.getString("nl.ibs.fac.language", "PartialDisinvestmentReference");
        } else {
            transactionType = 30;
            this.extraDescription = LanguageHelper.getString("nl.ibs.fac.language", "DisinvestmentReference");
        }
        this.extraDescription = String.valueOf(this.extraDescription) + " " + this.facYear + "/" + this.facPeriod;
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, this.description, this.asset.getCora(), this.asset.getId(), valuation.getAccountingPrinciple(), 2, transactionType, this.facYear, this.facPeriod, this.finBookYear, this.finBookPeriod, new BigDecimal("0"), new BigDecimal("0"), this.yieldValue, iftId, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(valuation.getAccountingPrinciple(), 2), 0, this.batchId, this.user, this.asset.getTypeId());
        if (objects[0] == null) {
            message = (String)objects[1];
            return message;
        }
        this.disinvestmentTransaction = (Transaction)objects[0];
        this.documentNr = this.disinvestmentTransaction.getDocumentNr();
        return message;
    }

    private String reverseFutureTransactions(Valuation valuation) throws Exception {
        String message = null;
        for (Transaction transactionToBeReversed : this.transactionsToBeReversed) {
            if (this.isFirstPeriodDisinvestment && valuation.getDocumentNr1stTransaction() == transactionToBeReversed.getDocumentNr() && valuation.getSeqNr1stTransaction() == transactionToBeReversed.getSeqNr()) {
                this.firstPeriodAcquisitionValue = transactionToBeReversed.getAmount1();
                this.firstPeriodDepreciationValue = transactionToBeReversed.getAmount2();
                continue;
            }
            if (transactionToBeReversed.getRevCode() > 0) continue;
            if (transactionToBeReversed.getMainTransactionType() == 9) {
                transactionToBeReversed.setInfoLevel(1);
                continue;
            }
            Object[] objects = this.createReversingTransaction(transactionToBeReversed, this.extraDescription, -1);
            if (objects[1] != null) {
                message = (String)objects[1];
                return message;
            }
            if (!this.post) continue;
            Transaction reversingTransaction = (Transaction)objects[0];
            ValuationPK key = new ValuationPK();
            key.setAccountingPrinciple(valuation.getAccountingPrinciple());
            key.setAssetId(valuation.getAssetId());
            key.setCompanyId(valuation.getCompanyId());
            key.setCora(valuation.getCora());
            valuation = ValuationManagerFactory.getInstance(valuation.getDBData()).findByPrimaryKey(key);
            switch (reversingTransaction.getMainTransactionType()) {
                case 3: {
                    DisInvestmentBP.updatePostedDepreciationBalance(this.asset, valuation, reversingTransaction, false);
                    reversingTransaction.setState(1);
                    break;
                }
                case 1: {
                    DisInvestmentBP.updatePostedAcquisitionBalance(this.asset, valuation, reversingTransaction, false);
                    reversingTransaction.setState(1);
                    break;
                }
                case 2: {
                    DisInvestmentBP.updatePostedAcquisitionBalance(this.asset, valuation, reversingTransaction, false);
                    reversingTransaction.setState(1);
                    break;
                }
                case 5: {
                    reversingTransaction.setState(1);
                }
            }
        }
        return message;
    }

    private String updateDisInvestmentTransaction(Valuation valuation, int disinvestmentReasonCode) throws Exception {
        BigDecimal depreciatedBalance;
        BigDecimal acquisitionBalance;
        String message = null;
        if (this.isFirstPeriodDisinvestment) {
            acquisitionBalance = this.firstPeriodAcquisitionValue;
            depreciatedBalance = this.firstPeriodDepreciationValue;
        } else {
            BigDecimal[] balanceValues = TransactionBO.calculateAcquisitionValue(this.asset, valuation.getAccountingPrinciple(), this.previousFacYP[0], this.previousFacYP[1]);
            acquisitionBalance = balanceValues[0];
            depreciatedBalance = balanceValues[1].add(TransactionBO.calculateDepreciatedTotal(this.asset, valuation.getAccountingPrinciple(), this.previousFacYP[0], this.previousFacYP[1])[0]);
        }
        if (this.isPartialDisinvestment) {
            if (this.asset.getAssetType().getUseDifferentAcquisitionValues()) {
                if (valuation.getAccountingPrinciple() == 1) {
                    this.acquisitionBalanceAP1 = acquisitionBalance;
                }
                if (valuation.getAccountingPrinciple() == 2) {
                    this.disInvestmentValue = this.disInvestmentValue.multiply(acquisitionBalance).divide(this.acquisitionBalanceAP1, 2, 4);
                }
            }
            BigDecimal partialDepreciatedBalance = new BigDecimal("0");
            if (acquisitionBalance.doubleValue() != 0.0) {
                partialDepreciatedBalance = depreciatedBalance.multiply(this.disInvestmentValue).divide(acquisitionBalance, 2, 4);
            }
            this.disinvestmentTransaction.setAmount1(this.disInvestmentValue.negate());
            this.disinvestmentTransaction.setAmount2(partialDepreciatedBalance.negate());
        } else {
            this.disinvestmentTransaction.setAmount1(acquisitionBalance.negate());
            this.disinvestmentTransaction.setAmount2(depreciatedBalance.negate());
        }
        if (this.interCompany) {
            this.disinvestmentTransaction.setAmount3(this.disinvestmentTransaction.getAmount2().subtract(this.disinvestmentTransaction.getAmount1()));
        }
        if (this.post) {
            ValuationPK key = new ValuationPK();
            key.setAccountingPrinciple(valuation.getAccountingPrinciple());
            key.setAssetId(valuation.getAssetId());
            key.setCompanyId(valuation.getCompanyId());
            key.setCora(valuation.getCora());
            valuation = ValuationManagerFactory.getInstance(valuation.getDBData()).findByPrimaryKey(key);
            DisInvestmentBP.updatePostedAcquisitionBalance(this.asset, valuation, this.disinvestmentTransaction, false);
            this.disinvestmentTransaction.setState(1);
        }
        this.disinvestmentTransaction.setDisinvestmentReasonCode(disinvestmentReasonCode);
        return message;
    }
}

