/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.StandardDepreciationCalculator;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.FinancialDimensionHistoryBO;
import nl.ibs.fac.boadapters.ProcessParametersBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.CompanyAccountingPrincipleDefault;
import nl.ibs.fac.db.FinancialDimensionHistory;
import nl.ibs.fac.db.ProcessParameters;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;

public class GenericTransactionBP
implements Serializable {
    private static final long serialVersionUID = -8214941378958831188L;
    protected Company company;
    protected Company dataSet;
    protected CompanyAccountingPrincipleDefault[] capDefaults;
    protected ProcessParameters processParameters;
    protected boolean governmentActivated;
    private FinancialDimensionHistory dimensions;
    protected int numberOfPeriods;
    protected Asset asset;
    protected int facYear;
    protected int facPeriod;
    protected int finYear;
    protected int finPeriod;
    protected int finBookYear;
    protected int finBookPeriod;
    private int[][] journalingStateArray;
    protected String finDimId1;
    protected String finDimId2;
    protected String finDimId3;
    protected String finDimId4;
    protected String finDimId5;
    protected int documentNr;
    protected int seqNr;
    protected boolean post;
    protected String user;
    public static final String FROM_FIN = "FIN";
    protected boolean originatingFromFIN = false;
    protected boolean use445Correction;

    public GenericTransactionBP(Company company, int numberOfPeriods) throws Exception {
        this.initialize(company, numberOfPeriods, false);
    }

    public GenericTransactionBP(Company company, int numberOfPeriods, boolean governmentActivated) throws Exception {
        this.initialize(company, numberOfPeriods, governmentActivated);
    }

    private void initialize(Company company, int numberOfPeriods, boolean governmentActivated) throws Exception {
        this.company = company;
        this.dataSet = company.getDataSet();
        if (this.dataSet == null) {
            this.dataSet = company;
        }
        this.capDefaults = new CompanyAccountingPrincipleDefault[5];
        Iterator iterator = this.dataSet.getAccountingPrincipleDefaultsCollection(null).iterator();
        while (iterator.hasNext()) {
            CompanyAccountingPrincipleDefault capDefault;
            this.capDefaults[capDefault.getAccountingPrinciple()] = capDefault = (CompanyAccountingPrincipleDefault)iterator.next();
        }
        this.numberOfPeriods = numberOfPeriods;
        this.processParameters = (ProcessParameters)ProcessParametersBO.get(company.getDBData(), this.dataSet.getId())[0];
        this.use445Correction = this.processParameters.getUse445Correction();
        this.governmentActivated = governmentActivated;
    }

    protected int retrieveJournalingState(int accountingPrinciple, int mainTransactionType) throws Exception {
        if (this.journalingStateArray == null) {
            this.createJournalingStateArray();
        }
        return this.journalingStateArray[accountingPrinciple][mainTransactionType];
    }

    private void createJournalingStateArray() throws Exception {
        this.journalingStateArray = new int[5][10];
        int i = 1;
        while (i < 5) {
            int j = 1;
            while (j < 10) {
                this.journalingStateArray[i][j] = 0;
                ++j;
            }
            ++i;
        }
        int capIndex = 1;
        while (capIndex < 5) {
            CompanyAccountingPrincipleDefault capDefault = this.capDefaults[capIndex];
            if (capDefault != null && capDefault.getJournalingMethod() != 9) {
                this.journalingStateArray[capIndex][3] = capDefault.getJournalingMethod();
                if (capDefault.getJournalingMethod() == 1) {
                    this.journalingStateArray[capIndex][1] = 1;
                    this.journalingStateArray[capIndex][2] = 1;
                    this.journalingStateArray[capIndex][4] = 1;
                }
            }
            ++capIndex;
        }
    }

    public String hasNotPostedTransactions(Asset asset) throws Exception {
        if (asset == null) {
            return null;
        }
        if (AssetBO.hasNotPostedTransactions(asset)) {
            return "asset_has_not_posted_transactions";
        }
        return null;
    }

    public String[] validateFINYearAndPeriod(int finYear, int finPeriod, int minYear, int maxYear) throws Exception {
        String[] messages = new String[2];
        int index = 0;
        if (finYear != 0 || finPeriod != 0) {
            if (finYear < minYear || finYear > maxYear) {
                messages[index] = "Invalid_bookYear";
                ++index;
            }
            if (finPeriod < 1 || finPeriod > this.numberOfPeriods + this.dataSet.getNumberOfCorrectionPeriods()) {
                messages[index] = "Invalid_bookPeriod";
                ++index;
            }
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    protected Object[] createReversingTransaction(Transaction toBeReversedTransaction, String reversingDescription, int batchId) throws Exception {
        if (this.finYear == 0) {
            this.finBookYear = toBeReversedTransaction.getBookYear();
            this.finBookPeriod = toBeReversedTransaction.getPeriod();
        } else {
            this.finBookYear = this.finYear;
            this.finBookPeriod = this.finPeriod;
        }
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, reversingDescription, toBeReversedTransaction.getCora(), toBeReversedTransaction.getAssetId(), toBeReversedTransaction.getAccountingPrinciple(), toBeReversedTransaction.getMainTransactionType(), toBeReversedTransaction.getTransactionType(), toBeReversedTransaction.getBookYear(), toBeReversedTransaction.getPeriod(), this.finBookYear, this.finBookPeriod, toBeReversedTransaction.getAmount1().negate(), toBeReversedTransaction.getAmount2().negate(), toBeReversedTransaction.getAmount3().negate(), null, toBeReversedTransaction.getFinDimId1(), toBeReversedTransaction.getFinDimId2(), toBeReversedTransaction.getFinDimId3(), toBeReversedTransaction.getFinDimId4(), toBeReversedTransaction.getFinDimId5(), this.retrieveJournalingState(toBeReversedTransaction.getAccountingPrinciple(), toBeReversedTransaction.getMainTransactionType()), 0, batchId, this.user, toBeReversedTransaction.getProFormaTypeId());
        if (objects[0] != null) {
            if (this.post) {
                toBeReversedTransaction.setInfoLevel(1);
                toBeReversedTransaction.setRevCode(2);
                toBeReversedTransaction.setRevDocumentNr(this.documentNr);
                toBeReversedTransaction.setRevSeqNr(this.seqNr);
            }
            Transaction reversingTransaction = (Transaction)objects[0];
            if (this.post) {
                reversingTransaction.setRevCode(1);
            } else {
                reversingTransaction.setRevCode(-1);
            }
            reversingTransaction.setInfoLevel(1);
            reversingTransaction.setRevDocumentNr(toBeReversedTransaction.getDocumentNr());
            reversingTransaction.setRevSeqNr(toBeReversedTransaction.getSeqNr());
            if (this.processParameters.getUseCorrectionCodeDC() && !toBeReversedTransaction.getCorrectionCodeDC().equals("J")) {
                reversingTransaction.setCorrectionCodeDC("J");
            }
            reversingTransaction.setBookingIndicator(toBeReversedTransaction.getBookingIndicator());
        }
        return objects;
    }

    protected void retrieveFinancialDimensions(int year, int period) throws Exception {
        if (PeriodHelper.isAfter(this.asset.getFinDimYearFrom(), this.asset.getFinDimPeriodFrom(), year, period)) {
            this.dimensions = FinancialDimensionHistoryBO.getLast(this.asset, year, period);
            if (this.dimensions != null) {
                this.finDimId1 = this.dimensions.getFinDimId1();
                this.finDimId2 = this.dimensions.getFinDimId2();
                this.finDimId3 = this.dimensions.getFinDimId3();
                this.finDimId4 = this.dimensions.getFinDimId4();
                this.finDimId5 = this.dimensions.getFinDimId5();
                return;
            }
        }
        this.finDimId1 = this.asset.getFinDimId1();
        this.finDimId2 = this.asset.getFinDimId2();
        this.finDimId3 = this.asset.getFinDimId3();
        this.finDimId4 = this.asset.getFinDimId4();
        this.finDimId5 = this.asset.getFinDimId5();
    }

    public static void updatePostedAcquisitionBalance(Asset asset, Valuation valuation, Transaction transaction, boolean postedAcquisitionBalanceOnly) throws Exception {
        valuation.setPostedAcquisitionBalance(valuation.getPostedAcquisitionBalance().add(transaction.getAmount1()));
        if (!postedAcquisitionBalanceOnly) {
            valuation.setPostedDepreciationBalance(valuation.getPostedDepreciationBalance().add(transaction.getAmount2()));
        }
        if (PeriodHelper.isAfter(transaction.getBookYear(), transaction.getPeriod(), valuation.getLastAcquisitionBookYear(), valuation.getLastAcquisitionPeriod())) {
            valuation.setLastAcquisitionBookYear(transaction.getBookYear());
            valuation.setLastAcquisitionPeriod(transaction.getPeriod());
        }
        GenericTransactionBP.updatePreviousBookValueBalance(valuation, transaction);
        asset.setBookValue(ValuationBO.getBookValue(asset));
    }

    public static void updatePostedDepreciationBalance(Asset asset, Valuation valuation, Transaction transaction, boolean periodUpdate) throws Exception {
        valuation.setPostedDepreciationBalance(valuation.getPostedDepreciationBalance().add(transaction.getAmount2()));
        if (periodUpdate) {
            if (transaction.getAmount2().doubleValue() != 0.0 && PeriodHelper.isAfter(transaction.getBookYear(), transaction.getPeriod(), valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod())) {
                valuation.setNumberOfDepreciatedPeriods(valuation.getNumberOfDepreciatedPeriods() + 1);
            }
            valuation.setLastDepreciationBookYear(transaction.getBookYear());
            valuation.setLastDepreciationPeriod(transaction.getPeriod());
        }
        GenericTransactionBP.updatePreviousBookValueBalanceWithDepreciationAmount(valuation, transaction);
        asset.setBookValue(ValuationBO.getBookValue(asset));
    }

    protected static void updatePreviousBookValueBalance(Valuation valuation, Transaction transaction) throws Exception {
        if (transaction.getAmount1().doubleValue() == 0.0 && transaction.getAmount2().doubleValue() == 0.0) {
            return;
        }
        if (valuation.getInterestCalculationMethod() == 2 && !PeriodHelper.isAfter(transaction.getBookYear(), transaction.getPeriod(), valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod())) {
            GenericTransactionBP.updatePreviousBookValueBalance(valuation, transaction.getAmount1(), transaction.getAmount2());
            return;
        }
        if (valuation.getInterestCalculationMethod() == 1 && PeriodHelper.isBefore(transaction.getBookYear(), transaction.getPeriod(), valuation.getLastDepreciationBookYear(), 1)) {
            GenericTransactionBP.updatePreviousBookValueBalance(valuation, transaction.getAmount1(), transaction.getAmount2());
            return;
        }
    }

    private static void updatePreviousBookValueBalanceWithDepreciationAmount(Valuation valuation, Transaction transaction) throws Exception {
        if (transaction.getAmount2().doubleValue() == 0.0) {
            return;
        }
        if (valuation.getInterestCalculationMethod() == 2 && !PeriodHelper.isAfter(transaction.getBookYear(), transaction.getPeriod(), valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod())) {
            GenericTransactionBP.updatePreviousBookValueBalance(valuation, transaction.getAmount1(), transaction.getAmount2());
            return;
        }
        if (valuation.getInterestCalculationMethod() == 1 && PeriodHelper.isBefore(transaction.getBookYear(), transaction.getPeriod(), valuation.getLastDepreciationBookYear(), 1)) {
            GenericTransactionBP.updatePreviousBookValueBalance(valuation, transaction.getAmount1(), transaction.getAmount2());
            return;
        }
    }

    private static void updatePreviousBookValueBalance(Valuation valuation, BigDecimal amount1, BigDecimal amount2) throws Exception {
        if (amount1.doubleValue() != 0.0) {
            valuation.setPreviousBookvalueBalance(valuation.getPreviousBookvalueBalance().add(amount1));
        }
        if (amount2.doubleValue() != 0.0) {
            valuation.setPreviousBookvalueBalance(valuation.getPreviousBookvalueBalance().subtract(amount2));
        }
    }

    protected String createAdditionalDepreciationTransactions(Valuation valuation, int[] previousFacYP, String transactionDescription, int batchId, String[] dimIds, Vector periodsToSkip) throws Exception {
        String message = null;
        StandardDepreciationCalculator calculator = new StandardDepreciationCalculator(this.processParameters.getFullInterestIn1stPeriod());
        if (periodsToSkip != null && !periodsToSkip.isEmpty()) {
            calculator.setPeriodsToSkipForDepreciation(periodsToSkip);
        }
        Collection values = calculator.calculate(this.company.getDBData(), this.company, this.numberOfPeriods, false, previousFacYP[0], previousFacYP[1], valuation, this.asset);
        Iterator vi = values.iterator();
        BigDecimal[] c445 = new BigDecimal[2];
        while (vi.hasNext()) {
            CalculationValue value = (CalculationValue)vi.next();
            BigDecimal depreciationAmount = value.getDepreciationAmount() != null ? value.getDepreciationAmount() : new BigDecimal("0");
            BigDecimal interestAmount = value.getInterestAmount() != null ? value.getInterestAmount() : new BigDecimal("0");
            if ((depreciationAmount.doubleValue() != 0.0 || interestAmount.doubleValue() != 0.0) && (message = this.createAdditionalDepreciationTransaction(valuation, value, depreciationAmount, interestAmount, transactionDescription, batchId, dimIds)) != null) {
                return message;
            }
            if (!this.use445Correction) continue;
            c445 = this.determine445Correction(value, c445);
        }
        if (this.post && this.use445Correction) {
            if (c445[0] != null || c445[1] != null) {
                valuation = (Valuation)ValuationBO.getValuation(valuation.getDBData(), valuation.getCompanyId(), valuation.getCora(), valuation.getAssetId(), valuation.getAccountingPrinciple())[0];
            }
            if (c445[0] != null) {
                valuation.setCorrectionAmount445A(c445[0]);
            }
            if (c445[1] != null) {
                valuation.setCorrectionAmount445B(c445[1]);
            }
        }
        return message;
    }

    private String createAdditionalDepreciationTransaction(Valuation valuation, CalculationValue value, BigDecimal depreciationAmount, BigDecimal interestAmount, String transactionDescription, int batchId, String[] dimIds) throws Exception {
        Object[] objects;
        String message = null;
        if (dimIds == null) {
            this.retrieveFinancialDimensions(value.getYear(), value.getPeriod());
        } else {
            this.finDimId1 = dimIds[0];
            this.finDimId2 = dimIds[1];
            this.finDimId3 = dimIds[2];
            this.finDimId4 = dimIds[3];
            this.finDimId5 = dimIds[4];
        }
        if (this.finYear == 0) {
            this.finBookYear = value.getYear();
            this.finBookPeriod = value.getPeriod();
        } else {
            this.finBookYear = this.finYear;
            this.finBookPeriod = this.finPeriod;
        }
        int mainTransactionType = 3;
        int transactionType = 70;
        if (value.isDepreciationBeyondEconomicLife()) {
            mainTransactionType = 5;
            transactionType = 85;
        }
        if ((objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, transactionDescription, this.asset.getCora(), this.asset.getId(), valuation.getAccountingPrinciple(), mainTransactionType, transactionType, value.getYear(), value.getPeriod(), this.finBookYear, this.finBookPeriod, new BigDecimal("0"), depreciationAmount, interestAmount, null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(valuation.getAccountingPrinciple(), 3), 0, batchId, this.user, this.asset.getTypeId()))[0] == null) {
            return (String)objects[1];
        }
        Transaction transaction = (Transaction)objects[0];
        if (value.getCurrentInterestPercentage() != null) {
            transaction.setOriginalInterestPercentage(value.getCurrentInterestPercentage());
        }
        if (this.post) {
            if (!value.isDepreciationBeyondEconomicLife()) {
                GenericTransactionBP.updatePostedDepreciationBalance(this.asset, valuation, transaction, true);
                valuation.setPreviousBookvalueBalance(value.getPreviousBookvalueBalance());
            }
            transaction.setState(1);
        }
        return message;
    }

    private BigDecimal[] determine445Correction(CalculationValue value, BigDecimal[] c445) throws Exception {
        int remainder = value.getPeriod() % 3;
        switch (remainder) {
            case 1: {
                c445[0] = value.getCorrectionAmount445();
                break;
            }
            case 2: {
                c445[1] = value.getCorrectionAmount445();
                break;
            }
            case 0: {
                c445[0] = new BigDecimal("0.00");
                c445[1] = new BigDecimal("0.00");
            }
        }
        return c445;
    }
}

