/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import nl.ibs.fac.CalculationValue;
import nl.ibs.fac.CalculatorParameter;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.ProofDepreciationCalculator;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.FinancialDimensionHistoryBO;
import nl.ibs.fac.boadapters.IncomingFinancialTransactionBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Credit;
import nl.ibs.fac.db.FinancialDimensionHistory;
import nl.ibs.fac.db.IncomingFinancialTransaction;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class InvestmentBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 4122477805617250210L;
    private String description;
    private String investmentDescription;
    private String backlogDescription;
    private Collection existingTransactions;
    private Transaction existingTransaction;
    private int correctionPeriods;
    private int depreciatableLife;
    private Collection<Transaction> futureMovementTransactions;
    private Collection values;
    private boolean ap2Only = false;
    private int batchId;
    private int myJournalingState;

    public InvestmentBP(Company company, int numberOfPeriods, String origin) throws Exception {
        super(company, numberOfPeriods);
        if (origin.trim().equals("FIN")) {
            this.originatingFromFIN = true;
        }
    }

    public String[] retrieveYearsAndPeriods(Asset asset, IncomingFinancialTransaction ift) throws Exception {
        String[] yps = new String[4];
        if (this.originatingFromFIN) {
            if (ift.getPeriod() > this.numberOfPeriods) {
                yps[0] = "" + ift.getBookYear();
                yps[1] = "" + this.numberOfPeriods;
                yps[2] = "" + ift.getBookYear();
                yps[3] = "" + ift.getPeriod();
            } else {
                yps[0] = "" + ift.getBookYear();
                yps[1] = "" + ift.getPeriod();
                if (!this.processParameters.getDefaultValueInBookPeriod()) {
                    yps[2] = "";
                    yps[3] = "";
                } else {
                    yps[2] = yps[0];
                    yps[3] = yps[1];
                }
            }
        } else {
            int[] nextPeriod = null;
            if (this.company.getLastDepreciationRunYear() > 0) {
                nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod());
            }
            if (nextPeriod != null) {
                yps[0] = "" + nextPeriod[0];
                yps[1] = "" + nextPeriod[1];
            } else if (asset == null) {
                yps[0] = "" + this.company.getCurrentBookYear();
                yps[1] = "1";
            } else {
                yps[0] = "" + asset.getStartUseYear();
                yps[1] = "" + asset.getStartUsePeriod();
            }
            if (!this.processParameters.getDefaultValueInBookPeriod()) {
                yps[2] = "";
                yps[3] = "";
            } else {
                yps[2] = yps[0];
                yps[3] = yps[1];
            }
        }
        return yps;
    }

    public String[] validateFACYearAndPeriod(Asset asset, int facYear, int facPeriod) throws Exception {
        int status;
        int thePeriod;
        int theYear;
        String[] messages = new String[2];
        int index = 0;
        if (asset != null && PeriodHelper.isBefore(facYear, facPeriod, theYear = asset.getStartUseYear(), thePeriod = asset.getStartUsePeriod())) {
            messages[index] = "FACPeriodBeforeStartUsePeriod";
            ++index;
        }
        if ((status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod)) == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (status == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String[] validateInvestmentValue(BigDecimal investmentValue) throws Exception {
        String[] messages = new String[1];
        int index = 0;
        if (investmentValue.doubleValue() == 0.0) {
            messages[index] = "InvestmentValueCannotBeZero";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String createInvestment(Asset asset, boolean initialInvestment, int facYear, int facPeriod, int finYear, int finPeriod, String description, BigDecimal investmentValue, IncomingFinancialTransaction incomingFinancialTransaction, boolean post, String user, boolean onlyAP2, Credit credit, int batchId, int journalingState) throws Exception {
        String message = null;
        this.asset = asset;
        this.facYear = facYear;
        this.facPeriod = facPeriod;
        this.finYear = finYear;
        this.finPeriod = finPeriod;
        this.description = description;
        this.post = post;
        this.user = user;
        this.ap2Only = onlyAP2;
        this.myJournalingState = journalingState;
        this.assembleDescriptions(investmentValue);
        if (batchId == 0 && post) {
            batchId = -1;
        }
        this.batchId = batchId;
        this.documentNr = 0;
        this.seqNr = 0;
        String iftId = null;
        if (incomingFinancialTransaction != null) {
            iftId = incomingFinancialTransaction.getId();
        }
        int transactionTypeInvestment = !this.ap2Only ? 10 : 15;
        Iterator vi = asset.getValuationsCollection(null).iterator();
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            while (vi.hasNext()) {
                Object[] result;
                Valuation valuation = (Valuation)vi.next();
                if (this.ap2Only && valuation.getAccountingPrinciple() != 2) continue;
                this.futureMovementTransactions = new ArrayList<Transaction>();
                this.values = null;
                if (finYear == 0) {
                    this.finBookYear = facYear;
                    this.finBookPeriod = facPeriod;
                } else {
                    this.finBookYear = finYear;
                    this.finBookPeriod = finPeriod;
                }
                this.retrieveFinancialDimensions(facYear, facPeriod);
                journalingState = this.myJournalingState == -1 ? this.retrieveJournalingState(valuation.getAccountingPrinciple(), 1) : this.myJournalingState;
                if (asset.getLoan()) {
                    journalingState = 0;
                }
                if ((message = (String)(result = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, this.investmentDescription.trim(), asset.getCora(), asset.getId(), valuation.getAccountingPrinciple(), 1, transactionTypeInvestment, facYear, facPeriod, this.finBookYear, this.finBookPeriod, investmentValue, new BigDecimal(0), new BigDecimal(0), iftId, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, journalingState, 0, batchId, user, asset.getTypeId()))[1]) != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                Transaction transaction = (Transaction)result[0];
                if (credit != null) {
                    transaction.setCreditId(credit.getId());
                    transaction.setTransactionType(120);
                    credit.setAllocatedValue(credit.getAllocatedValue().add(investmentValue));
                }
                if (incomingFinancialTransaction != null && incomingFinancialTransaction.getIFTType() == 3) {
                    transaction.setTransactionType(110);
                }
                this.documentNr = transaction.getDocumentNr();
                if (post) {
                    InvestmentBP.updatePostedAcquisitionBalance(asset, valuation, transaction, true);
                    transaction.setState(1);
                }
                if (this.processParameters.getUseCorrectionCodeDC() && (!asset.getNegativeInvestment() && investmentValue.doubleValue() < 0.0 || asset.getNegativeInvestment() && investmentValue.doubleValue() > 0.0)) {
                    transaction.setCorrectionCodeDC("J");
                }
                if (initialInvestment) {
                    valuation.setDocumentNr1stTransaction(this.documentNr);
                    valuation.setSeqNr1stTransaction(this.seqNr);
                } else if (valuation.getDepreciationMethod() != 11 && valuation.getDepreciationMethod() != 12) {
                    this.handleFutureMovements(valuation, transaction);
                    message = this.createAdditionalDepreciationTransactions(valuation, transaction, credit);
                    if (message != null) {
                        BOAdapter.investigate(null, dbTransaction);
                        return message;
                    }
                }
                if (this.futureMovementTransactions.isEmpty() || this.values == null || this.values.isEmpty()) continue;
                this.updateFutureMovementTransactions();
            }
            if (incomingFinancialTransaction != null && (message = IncomingFinancialTransactionBO.update(incomingFinancialTransaction, incomingFinancialTransaction.getUnAllocatedValue().subtract(investmentValue))) != null) {
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    private void assembleDescriptions(BigDecimal investmentValue) throws Exception {
        this.investmentDescription = this.description;
        if (!this.asset.getNegativeInvestment() && investmentValue.doubleValue() < 0.0 || this.asset.getNegativeInvestment() && investmentValue.doubleValue() >= 0.0) {
            if (this.description.trim().equals("")) {
                this.investmentDescription = LanguageHelper.getString("nl.ibs.fac.language", "AdditionalInvestmentNegative");
            }
            this.backlogDescription = LanguageHelper.getString("nl.ibs.fac.language", "AdditionalInvestmentNegativeReference");
        } else {
            if (this.description.trim().equals("")) {
                this.investmentDescription = LanguageHelper.getString("nl.ibs.fac.language", "AdditionalInvestmentPositive");
            }
            this.backlogDescription = LanguageHelper.getString("nl.ibs.fac.language", "AdditionalInvestmentPositiveReference");
        }
        this.backlogDescription = String.valueOf(this.backlogDescription) + " " + this.facYear + "/" + this.facPeriod;
    }

    private void handleFutureMovements(Valuation valuation, Transaction transaction) throws Exception {
        int futureMovementBookPeriod;
        int futureMovementBookYear;
        int futureMovementPeriod;
        int futureMovementYear;
        if (!PeriodHelper.isAfter(this.asset.getFinDimYearFrom(), this.asset.getFinDimPeriodFrom(), this.facYear, this.facPeriod)) {
            return;
        }
        Transaction currentTransaction = transaction;
        Collection futureMovements = FinancialDimensionHistoryBO.getAfter(this.asset, this.facYear, this.facPeriod);
        if (futureMovements != null && !futureMovements.isEmpty()) {
            for (FinancialDimensionHistory futureMovement : futureMovements) {
                futureMovementYear = futureMovement.getBookYear();
                futureMovementPeriod = futureMovement.getPeriod();
                if (this.finYear == 0) {
                    futureMovementBookYear = futureMovementYear;
                    futureMovementBookPeriod = futureMovementPeriod;
                } else {
                    futureMovementBookYear = this.finYear;
                    futureMovementBookPeriod = this.finPeriod;
                }
                Transaction investmentTransaction = this.handleFutureMovement(valuation, currentTransaction, futureMovement, futureMovementYear, futureMovementPeriod, futureMovementBookYear, futureMovementBookPeriod);
                if (investmentTransaction == null) break;
                currentTransaction = investmentTransaction;
            }
        }
        futureMovementYear = this.asset.getFinDimYearFrom();
        futureMovementPeriod = this.asset.getFinDimPeriodFrom();
        if (this.finYear == 0) {
            futureMovementBookYear = futureMovementYear;
            futureMovementBookPeriod = futureMovementPeriod;
        } else {
            futureMovementBookYear = this.finYear;
            futureMovementBookPeriod = this.finPeriod;
        }
        this.handleFutureMovement(valuation, currentTransaction, null, futureMovementYear, futureMovementPeriod, futureMovementBookYear, futureMovementBookPeriod);
    }

    private Transaction handleFutureMovement(Valuation valuation, Transaction currentTransaction, FinancialDimensionHistory futureMovement, int futureMovementYear, int futureMovementPeriod, int futureMovementBookYear, int futureMovementBookPeriod) throws Exception {
        String fd5;
        String fd4;
        String fd3;
        String fd2;
        String fd1;
        BigDecimal investmentBigDecimal;
        BigDecimal disinvestmentBigDecimal;
        Transaction investmentTransaction = null;
        this.retrieveFinancialDimensions(this.facYear, this.facPeriod);
        int journalingState = this.myJournalingState == -1 ? this.retrieveJournalingState(valuation.getAccountingPrinciple(), 9) : this.myJournalingState;
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, "Dim. wijz. aanv. investering", this.asset.getCora(), this.asset.getId(), valuation.getAccountingPrinciple(), 9, 40, futureMovementYear, futureMovementPeriod, futureMovementBookYear, futureMovementBookPeriod, new BigDecimal("0"), new BigDecimal("0"), new BigDecimal("0"), null, currentTransaction.getFinDimId1(), currentTransaction.getFinDimId2(), currentTransaction.getFinDimId3(), currentTransaction.getFinDimId4(), currentTransaction.getFinDimId5(), journalingState, 0, this.batchId, this.user, this.asset.getTypeId());
        if (objects[1] != null) {
            throw new Exception((String)objects[1]);
        }
        if (this.post) {
            Transaction anonymousTransaction = (Transaction)objects[0];
            anonymousTransaction.setState(1);
        }
        if (currentTransaction.getAmount1().doubleValue() < 0.0) {
            disinvestmentBigDecimal = new BigDecimal("1");
            investmentBigDecimal = new BigDecimal("-1");
        } else {
            disinvestmentBigDecimal = new BigDecimal("-1");
            investmentBigDecimal = new BigDecimal("1");
        }
        journalingState = this.myJournalingState == -1 ? this.retrieveJournalingState(valuation.getAccountingPrinciple(), 1) : this.myJournalingState;
        objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, "Afboeking balanswaarde", this.asset.getCora(), this.asset.getId(), valuation.getAccountingPrinciple(), 1, 40, futureMovementYear, futureMovementPeriod, futureMovementBookYear, futureMovementBookPeriod, currentTransaction.getAmount1().negate(), disinvestmentBigDecimal, new BigDecimal("0"), null, currentTransaction.getFinDimId1(), currentTransaction.getFinDimId2(), currentTransaction.getFinDimId3(), currentTransaction.getFinDimId4(), currentTransaction.getFinDimId5(), journalingState, 0, this.batchId, this.user, this.asset.getTypeId());
        if (objects[1] != null) {
            throw new Exception((String)objects[1]);
        }
        Transaction disinvestmentTransaction = (Transaction)objects[0];
        disinvestmentTransaction.setInfoLevel(1);
        if (this.post) {
            disinvestmentTransaction.setState(1);
        }
        this.futureMovementTransactions.add(disinvestmentTransaction);
        if (futureMovement != null) {
            fd1 = futureMovement.getFinDimId1();
            fd2 = futureMovement.getFinDimId2();
            fd3 = futureMovement.getFinDimId3();
            fd4 = futureMovement.getFinDimId4();
            fd5 = futureMovement.getFinDimId5();
        } else {
            fd1 = this.asset.getFinDimId1();
            fd2 = this.asset.getFinDimId2();
            fd3 = this.asset.getFinDimId3();
            fd4 = this.asset.getFinDimId4();
            fd5 = this.asset.getFinDimId5();
        }
        journalingState = this.myJournalingState == -1 ? this.retrieveJournalingState(valuation.getAccountingPrinciple(), 1) : this.myJournalingState;
        objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, "Opboeking balanswaarde", this.asset.getCora(), this.asset.getId(), valuation.getAccountingPrinciple(), 1, 40, futureMovementYear, futureMovementPeriod, futureMovementBookYear, futureMovementBookPeriod, currentTransaction.getAmount1(), new BigDecimal("1"), investmentBigDecimal, null, fd1, fd2, fd3, fd4, fd5, journalingState, 0, this.batchId, this.user, this.asset.getTypeId());
        if (objects[1] != null) {
            throw new Exception((String)objects[1]);
        }
        investmentTransaction = (Transaction)objects[0];
        investmentTransaction.setInfoLevel(1);
        if (this.post) {
            investmentTransaction.setState(1);
        }
        this.futureMovementTransactions.add(investmentTransaction);
        return investmentTransaction;
    }

    private String createAdditionalDepreciationTransactions(Valuation valuation, Transaction transaction, Credit credit) throws Exception {
        String message = null;
        if (PeriodHelper.isAfter(this.facYear, this.facPeriod, valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod())) {
            return message;
        }
        message = this.createReversingTransactionsForDepreciationBeyondEconomicLife(valuation);
        if (message != null) {
            return message;
        }
        this.correctionPeriods = PeriodHelper.isAfter(valuation.getStartDepreciationBookYear(), valuation.getStartDepreciationPeriod(), this.facYear, this.facPeriod) ? PeriodHelper.calculateNumberOfPeriods(this.numberOfPeriods, valuation.getStartDepreciationBookYear(), valuation.getStartDepreciationPeriod(), valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod()) : PeriodHelper.calculateNumberOfPeriods(this.numberOfPeriods, this.facYear, this.facPeriod, valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod());
        this.depreciatableLife = valuation.getDepreciatableLife() - valuation.getNumberOfDepreciatedPeriods() + this.correctionPeriods;
        ProofDepreciationCalculator calculator = new ProofDepreciationCalculator(this.processParameters.getFullInterestIn1stPeriod());
        Vector periodsToSkip = this.validateForPeriodsToSkip(valuation);
        if (!periodsToSkip.isEmpty()) {
            this.depreciatableLife -= periodsToSkip.size();
            calculator.setPeriodsToSkipForDepreciation(periodsToSkip);
        }
        CalculatorParameter parameter = this.initializeCalculatorParameter(valuation, transaction, credit);
        this.values = calculator.calculate(this.company.getDBData(), this.company, this.numberOfPeriods, false, valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod(), parameter);
        for (CalculationValue value : this.values) {
            message = this.createAdditionalDepreciationTransaction(valuation, value);
            if (message == null) continue;
            return message;
        }
        if (this.use445Correction && this.post) {
            BigDecimal c445A = null;
            BigDecimal c445B = null;
            for (CalculationValue value : this.values) {
                int remainder = value.getPeriod() % 3;
                switch (remainder) {
                    case 1: {
                        c445A = value.getCorrectionAmount445();
                        break;
                    }
                    case 2: {
                        c445B = value.getCorrectionAmount445();
                        break;
                    }
                    case 0: {
                        c445A = new BigDecimal("0.00");
                        c445B = new BigDecimal("0.00");
                    }
                }
            }
            if (c445A != null && c445A.doubleValue() != 0.0) {
                valuation.setCorrectionAmount445A(valuation.getCorrectionAmount445A().add(c445A));
            }
            if (c445B != null && c445B.doubleValue() != 0.0) {
                valuation.setCorrectionAmount445B(valuation.getCorrectionAmount445B().add(c445B));
            }
        }
        return message;
    }

    private CalculatorParameter initializeCalculatorParameter(Valuation valuation, Transaction transaction, Credit credit) throws Exception {
        IncomingFinancialTransaction ift;
        CalculatorParameter parameter = new CalculatorParameter();
        parameter.setCorrectionAmount445A(new BigDecimal("0.00"));
        parameter.setCorrectionAmount445B(new BigDecimal("0.00"));
        parameter.setStartUseYear(this.facYear);
        parameter.setStartUsePeriod(this.facPeriod);
        if (PeriodHelper.isAfter(valuation.getStartDepreciationBookYear(), valuation.getStartDepreciationPeriod(), this.facYear, this.facPeriod)) {
            parameter.setStartDepreciationBookYear(valuation.getStartDepreciationBookYear());
            parameter.setStartDepreciationPeriod(valuation.getStartDepreciationPeriod());
        } else {
            parameter.setStartDepreciationBookYear(this.facYear);
            parameter.setStartDepreciationPeriod(this.facPeriod);
        }
        parameter.setDepreciationMethod(valuation.getDepreciationMethod());
        parameter.setStartPeriodHandlingMethod(valuation.getStartPeriodHandlingMethod());
        parameter.setDegressivePercentage(valuation.getDegressivePercentage());
        parameter.setYearPercentageTableId(valuation.getYearPercentageTableId());
        parameter.setInterestCalculationMethod(valuation.getInterestCalculationMethod());
        parameter.setInterestPercentage(valuation.getInterestPercentage());
        parameter.setInterestTableId(valuation.getInterestTableId());
        if (valuation.getInterestBookYear() != 0) {
            if (PeriodHelper.isAfter(valuation.getInterestBookYear(), valuation.getInterestPeriod(), this.facYear, this.facPeriod)) {
                parameter.setInterestBookYear(valuation.getInterestBookYear());
                parameter.setInterestPeriod(valuation.getInterestPeriod());
            } else {
                parameter.setInterestBookYear(this.facYear);
                parameter.setInterestPeriod(this.facPeriod);
            }
        }
        parameter.setDepreciatableLife(this.depreciatableLife);
        if (valuation.getStartPeriodHandlingMethod() == 3 || valuation.getStartPeriodHandlingMethod() == 4) {
            parameter.setDepreciatableLife(valuation.getDepreciatableLife());
        }
        parameter.setNumberOfDepreciatedPeriods(0);
        parameter.setPostedAcquisitionBalance(transaction.getAmount1());
        if (transaction.getAmount1().doubleValue() < 0.0) {
            parameter.setNegativeInvestment(true);
        }
        parameter.setPostedDepreciationBalance(new BigDecimal(0));
        parameter.setPreviousBookvalueBalance(new BigDecimal(0));
        if (credit != null && valuation.getInterestCalculationMethod() == 1) {
            parameter.setPreviousBookvalueBalance(parameter.getPostedAcquisitionBalance());
        }
        if (credit == null && transaction.getIncomingFinancialTransactionId() != null && (ift = transaction.getIncomingFinancialTransaction()) != null && ift.getGovernmentCode() == 1 && valuation.getInterestCalculationMethod() == 1) {
            parameter.setPreviousBookvalueBalance(parameter.getPostedAcquisitionBalance());
        }
        parameter.setResidualPercentage(valuation.getResidualPercentage());
        parameter.setResidualValue(new BigDecimal("0.00"));
        parameter.setDepreciationPaused(false);
        return parameter;
    }

    private Vector validateForPeriodsToSkip(Valuation valuation) throws Exception {
        Vector<String> periods = new Vector<String>();
        this.existingTransactions = TransactionBO.getAfterOrEquals(this.asset, this.facYear, this.facPeriod, valuation.getAccountingPrinciple());
        for (Transaction this.existingTransaction : this.existingTransactions) {
            if (this.existingTransaction.getMainTransactionType() != 3 || this.existingTransaction.getTransactionType() != 71 && this.existingTransaction.getTransactionType() != 72) continue;
            periods.add("" + (this.existingTransaction.getBookYear() * 100 + this.existingTransaction.getPeriod()));
        }
        return periods;
    }

    private String createReversingTransactionsForDepreciationBeyondEconomicLife(Valuation valuation) throws Exception {
        for (Transaction transactionToBeReversed : TransactionBO.getTransactions(valuation, true)) {
            if (transactionToBeReversed.getMainTransactionType() != 5 || PeriodHelper.isBefore(transactionToBeReversed.getBookYear(), transactionToBeReversed.getPeriod(), this.facYear, this.facPeriod)) continue;
            Object[] objects = this.createReversingTransaction(transactionToBeReversed, this.backlogDescription, -1);
            if (objects[1] != null) {
                String message = (String)objects[1];
                return message;
            }
            Transaction transaction = (Transaction)objects[0];
            if (!this.post) continue;
            transaction.setState(1);
        }
        return null;
    }

    private String createAdditionalDepreciationTransaction(Valuation valuation, CalculationValue value) throws Exception {
        Object[] objects;
        String message = null;
        if (value.getDepreciationAmount().doubleValue() == 0.0 && value.getInterestAmount().doubleValue() == 0.0) {
            return message;
        }
        if (this.finYear == 0) {
            this.finBookYear = value.getYear();
            this.finBookPeriod = value.getPeriod();
        } else {
            this.finBookYear = this.finYear;
            this.finBookPeriod = this.finPeriod;
        }
        this.retrieveFinancialDimensions(value.getYear(), value.getPeriod());
        int journalingState = this.myJournalingState == -1 ? this.retrieveJournalingState(valuation.getAccountingPrinciple(), 3) : this.myJournalingState;
        int mainTransactionType = 3;
        int transactionType = 80;
        if (value.isDepreciationBeyondEconomicLife()) {
            mainTransactionType = 5;
            transactionType = 85;
        }
        if ((objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, this.backlogDescription, this.asset.getCora(), this.asset.getId(), valuation.getAccountingPrinciple(), mainTransactionType, transactionType, value.getYear(), value.getPeriod(), this.finBookYear, this.finBookPeriod, new BigDecimal(0), value.getDepreciationAmount(), value.getInterestAmount(), null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, journalingState, 0, this.batchId, this.user, this.asset.getTypeId()))[0] == null) {
            message = (String)objects[1];
            return message;
        }
        Transaction transaction = (Transaction)objects[0];
        if (value.getCurrentInterestPercentage() != null) {
            transaction.setOriginalInterestPercentage(value.getCurrentInterestPercentage());
        }
        if (this.use445Correction && value.getCorrectionAmount445().doubleValue() != 0.0) {
            transaction.setCorrectionAmount445(value.getCorrectionAmount445());
        }
        if (this.post) {
            if (!value.isDepreciationBeyondEconomicLife()) {
                InvestmentBP.updatePostedDepreciationBalance(this.asset, valuation, transaction, false);
            }
            transaction.setState(1);
        }
        return message;
    }

    private void updateFutureMovementTransactions() throws Exception {
        for (Transaction transaction : this.futureMovementTransactions) {
            BigDecimal depreciatedTotal = this.summarizeValues(transaction);
            transaction.setAmount2(depreciatedTotal.multiply(transaction.getAmount2()));
        }
    }

    private BigDecimal summarizeValues(Transaction transaction) throws Exception {
        BigDecimal depreciatedTotal = new BigDecimal("0");
        int transactionYear = transaction.getBookYearForJournalization();
        int transactionPeriod = transaction.getPeriodForJournalization();
        for (CalculationValue value : this.values) {
            if (value.getDepreciationAmount() == null || !PeriodHelper.isBefore(value.getYear(), value.getPeriod(), transactionYear, transactionPeriod)) continue;
            depreciatedTotal = depreciatedTotal.add(value.getDepreciationAmount());
        }
        return depreciatedTotal;
    }

    public static String updateInvestment(Transaction transaction, int facYear, int facPeriod, int finYear, int finPeriod, BigDecimal transactionValue) throws Exception {
        BigDecimal oldAmount = transaction.getAmount1();
        if (finYear == 0) {
            finYear = facYear;
            finPeriod = facPeriod;
        }
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            for (Transaction trans : TransactionBO.getTransactionsForDocument(transaction)) {
                trans.setBookYear(facYear);
                trans.setPeriod(facPeriod);
                trans.setBookYearForJournalization(finYear);
                trans.setPeriodForJournalization(finPeriod);
                trans.setAmount1(transactionValue);
            }
            IncomingFinancialTransaction incomingFinancialTransaction = transaction.getIncomingFinancialTransaction();
            if (incomingFinancialTransaction != null) {
                incomingFinancialTransaction.setUnAllocatedValue(incomingFinancialTransaction.getUnAllocatedValue().add(oldAmount).subtract(transactionValue));
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            return BOAdapter.investigate(e, dbTransaction);
        }
        return null;
    }
}

