/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.Iterator;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.AdditionalDepreciationBP;
import nl.ibs.fac.bp.InvestmentBP;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class MassImportBP
extends MassTransactionBP {
    private static final long serialVersionUID = -4886986842375239773L;
    public static final String TYPE = "TYPE";
    private Valuation valuation;
    private InvestmentBP investmentBP;
    private AdditionalDepreciationBP additionalDepreciationBP;

    public MassImportBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
        this.investmentBP = new InvestmentBP(company, numberOfPeriods, "FAC");
        this.additionalDepreciationBP = new AdditionalDepreciationBP(company, numberOfPeriods);
    }

    public String addToProposal(TransactionBatch transactionBatch, int transType, String journalize, String cora, String id, int facYear, int facPeriod, int finYear, int finPeriod, BigDecimal amountA, String description, BigDecimal amountB, int accPrin, int bbvCat) throws Exception {
        if (transType == 15 && !this.processParameters.getUseDifferentAcquisitionValues()) {
            return "transType " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value") + "( company level)";
        }
        if (facPeriod < 1 || facPeriod > this.numberOfPeriods) {
            return "facPeriod " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value");
        }
        Object[] objects = AssetBO.get(this.company, id, false);
        if (objects[0] == null) {
            return (String)objects[1];
        }
        this.asset = (Asset)objects[0];
        if (this.asset.getState() != 2) {
            return "assetState " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value");
        }
        if (transType == 15) {
            if (!this.asset.getAssetType().getUseDifferentAcquisitionValues()) {
                return "transType " + LanguageHelper.getString("nl.ibs.fac.language", "incorrect_value") + "( type level)";
            }
            objects = ValuationBO.get(transactionBatch.getDBData(), this.company.getId(), cora, this.asset.getId(), accPrin);
            if (objects[0] == null) {
                return "AP2 not found ?!?";
            }
        }
        String[] messages = null;
        messages = this.validateFINYearAndPeriod(finYear, finPeriod, 0, 9999);
        if (messages != null) {
            return messages[0];
        }
        BigDecimal amount1 = BigDecimal.ZERO;
        BigDecimal amount2 = BigDecimal.ZERO;
        BigDecimal amount3 = BigDecimal.ZERO;
        if (transType == 10 || transType == 15) {
            messages = this.investmentBP.validateFACYearAndPeriod(this.asset, facYear, facPeriod);
            if (messages == null) {
                messages = this.investmentBP.validateInvestmentValue(amountA);
            }
            amount1 = amountA;
        } else {
            objects = ValuationBO.get(transactionBatch.getDBData(), this.company.getId(), cora, this.asset.getId(), accPrin);
            if (objects[0] == null) {
                return (String)objects[1];
            }
            this.valuation = (Valuation)objects[0];
            messages = this.additionalDepreciationBP.validateFACYearAndPeriod(this.valuation, facYear, facPeriod);
            if (messages == null) {
                messages = accPrin == 1 ? this.additionalDepreciationBP.validateAmounts(amountA, amountB, BigDecimal.ZERO, BigDecimal.ZERO) : this.additionalDepreciationBP.validateAmounts(BigDecimal.ZERO, BigDecimal.ZERO, amountA, amountB);
            }
            if (messages == null) {
                messages = this.additionalDepreciationBP.validateDepreciationAmount(this.asset, this.valuation, amountA);
            }
            amount2 = amountA;
            amount3 = amountB;
        }
        if (messages != null) {
            return messages[0];
        }
        if (finYear == 0) {
            finYear = facYear;
            finPeriod = facPeriod;
        }
        this.retrieveFinancialDimensions(facYear, facPeriod);
        if (description == null || description.trim().length() == 0) {
            switch (transType) {
                case 10: {
                    description = String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "IMPORT_ADDITIONAL_INVESTMENT_PROCTYPE")) + " (MT)";
                    break;
                }
                case 15: {
                    description = String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "IMPORT_ADDITIONAL_INVESTMENT_AP2_PROCTYPE")) + " (MT)";
                    break;
                }
                case 90: {
                    description = String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "IMPORT_ADDITIONAL_DEPRECIATION_AND_INTEREST_PROCTYPE")) + " (MT)";
                }
            }
        }
        if ((objects = TransactionBO.create(transactionBatch.getDBData(), this.company.getId(), 0, 1, description, cora, this.asset.getId(), accPrin, 9, transType, facYear, facPeriod, finYear, finPeriod, amount1, amount2, amount3, null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, 0, 0, transactionBatch.getBatchId(), transactionBatch.getCreatedBy(), ""))[0] == null) {
            return (String)objects[1];
        }
        Transaction transaction = (Transaction)objects[0];
        transaction.setBookingIndicator(bbvCat);
        if (!"false".equals(journalize)) {
            if ("true".equals(journalize)) {
                transaction.setJournalingState(1);
            } else {
                transaction.setJournalingState(-1);
            }
        }
        if (transactionBatch.getEndYear() == 0) {
            transactionBatch.setEndYear(facYear);
            transactionBatch.setEndPeriod(facPeriod);
            transactionBatch.setFinYear(finYear);
            transactionBatch.setFinPeriod(finPeriod);
        }
        return null;
    }

    @Override
    public String postProposal(TransactionBatch transactionBatch, String user) throws Exception {
        this.user = user;
        this.getParameters(transactionBatch);
        String message = null;
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            Transaction transaction = null;
            Iterator transactions = TransactionBO.getTransactions(transactionBatch).iterator();
            while (transactions.hasNext()) {
                transaction = (Transaction)transactions.next();
                this.asset = (Asset)AssetBO.get(this.company, transaction.getAssetId(), false)[0];
                switch (transaction.getTransactionType()) {
                    case 10: {
                        message = this.investmentBP.createInvestment(this.asset, false, transaction.getBookYear(), transaction.getPeriod(), transaction.getBookYearForJournalization(), transaction.getPeriodForJournalization(), transaction.getDescription(), transaction.getAmount1(), null, true, user, false, null, transaction.getBatchId(), transaction.getJournalingState());
                        break;
                    }
                    case 15: {
                        message = this.investmentBP.createInvestment(this.asset, false, transaction.getBookYear(), transaction.getPeriod(), transaction.getBookYearForJournalization(), transaction.getPeriodForJournalization(), transaction.getDescription(), transaction.getAmount1(), null, true, user, true, null, transaction.getBatchId(), transaction.getJournalingState());
                        break;
                    }
                    case 90: {
                        Object[] objects;
                        this.valuation = (Valuation)ValuationBO.get(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId(), transaction.getAccountingPrinciple())[0];
                        if (this.valuation == null) break;
                        this.retrieveFinancialDimensions(transaction.getBookYear(), transaction.getPeriod());
                        int journalingState = transaction.getJournalingState();
                        if (transaction.getJournalingState() == -1) {
                            journalingState = this.retrieveJournalingState(transaction.getAccountingPrinciple(), 3);
                        }
                        if ((objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), 0, 1, transaction.getDescription(), this.asset.getCora(), this.asset.getId(), transaction.getAccountingPrinciple(), 3, 90, transaction.getBookYear(), transaction.getPeriod(), transaction.getBookYearForJournalization(), transaction.getPeriodForJournalization(), new BigDecimal(0), transaction.getAmount2(), transaction.getAmount3(), null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, journalingState, 0, transaction.getBatchId(), user, this.asset.getTypeId()))[0] == null) {
                            message = (String)objects[1];
                            break;
                        }
                        Transaction newTransaction = (Transaction)objects[0];
                        MassImportBP.updatePostedDepreciationBalance(this.asset, this.valuation, newTransaction, false);
                        newTransaction.setState(1);
                    }
                }
                if (message != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                transactions.remove();
                message = TransactionBO.delete(transaction, null, null);
                if (message == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            transactionBatch.setState(1);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    @Override
    public String[] retrieveYearsAndPeriods() throws Exception {
        return null;
    }

    @Override
    public String createProposal(TransactionBatch transactionBatch, String user) throws Exception {
        return null;
    }

    @Override
    public String[] validateFACYearAndPeriod(int facYear, int facPeriod) throws Exception {
        String[] messages = new String[2];
        return messages;
    }

    @Override
    public void addParameters(TransactionBatch transactionBatch, String[][] selections) throws Exception {
    }

    private void getParameters(TransactionBatch transactionBatch) throws Exception {
    }

    public String getParameter(TransactionBatch transactionBatch, String parmName) throws Exception {
        return "";
    }

    @Override
    public String[][] getExtraBatchDetails(TransactionBatch transactionBatch) throws Exception {
        String[][] details = new String[0][0];
        return details;
    }

    @Override
    public String getTransactionDescription(TransactionBatch transactionBatch) throws Exception {
        return "";
    }
}

