/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.MassTransactionBP;
import nl.ibs.fac.bp.WriteOffBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetManager;
import nl.ibs.fac.db.AssetManagerFactory;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.TransactionBatchParameterDataBean;
import nl.ibs.fac.db.TransactionBatchParameterManager;
import nl.ibs.fac.db.TransactionBatchParameterManagerFactory;
import nl.ibs.fac.db.TransactionBatchParameterPK;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class MassWriteOffBP
extends MassTransactionBP {
    private static final long serialVersionUID = -4886986842375239773L;
    public static final String TYPEFROM = "TYPEFROM";
    public static final String TYPETO = "TYPETO";
    public static final String WOFPER_YEAR = "WOFPERYEAR";
    public static final String WOFPER_PER = "WOFPERPER";
    private int wofYear;
    private int wofPeriod;
    private String typeFrom;
    private String typeTo;
    private TransactionBatchParameterManager manager;
    private TransactionBatchParameterDataBean bean;
    private TransactionBatchParameterPK key;

    public MassWriteOffBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
        this.manager = TransactionBatchParameterManagerFactory.getInstance(company.getDBData());
        this.bean = new TransactionBatchParameterDataBean();
        this.key = new TransactionBatchParameterPK();
    }

    public String[] retrieveWriteOffYearAndPeriod() throws Exception {
        String[] pyp = new String[2];
        if (this.company.getLastDepreciationRunYear() == 0) {
            pyp[0] = "" + this.company.getCurrentBookYear();
            pyp[1] = "1";
        } else {
            int i2;
            int i1 = this.company.getLastDepreciationRunYear() - 1;
            if (BookYearBO.getPeriodStatus(this.company, i1, i2 = this.company.getNumberOfPeriods()) == 0) {
                pyp[0] = "" + this.company.getLastDepreciationRunYear();
                pyp[1] = "1";
            } else {
                pyp[0] = "" + i1;
                pyp[1] = "" + i2;
            }
        }
        return pyp;
    }

    @Override
    public String[] retrieveYearsAndPeriods() throws Exception {
        String[] yps = new String[4];
        if (this.company.getLastDepreciationRunYear() > 0) {
            int[] nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod());
            yps[0] = "" + nextPeriod[0];
            yps[1] = "" + nextPeriod[1];
        } else {
            yps[0] = "" + this.company.getCurrentBookYear();
            yps[1] = "1";
        }
        if (!this.processParameters.getDefaultValueInBookPeriod()) {
            yps[2] = "";
            yps[3] = "";
        } else {
            yps[2] = yps[0];
            yps[3] = yps[1];
        }
        return yps;
    }

    public String[] validateWriteOffYearAndPeriod(int wofYear, int wofPeriod, int facYear, int facPeriod) throws Exception {
        String[] messages = new String[2];
        int index = 0;
        int status = BookYearBO.getPeriodStatus(this.company, wofYear, wofPeriod);
        if (status == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        } else if (!PeriodHelper.isBefore(wofYear, wofPeriod, facYear, facPeriod)) {
            messages[index] = "facPeriod_must_be_greater_than_writeOffPeriod";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    @Override
    public String[] validateFACYearAndPeriod(int facYear, int facPeriod) throws Exception {
        String[] messages = new String[2];
        int index = 0;
        int status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod);
        if (status == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (status == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    @Override
    public String createProposal(TransactionBatch transactionBatch, String user) throws Exception {
        this.user = user;
        this.getParameters(transactionBatch);
        String message = null;
        String transactionDescription = this.getTransactionDescription(transactionBatch);
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            for (Asset this.asset : this.retrieveAssets()) {
                message = this.createAnonymousTransaction(transactionBatch.getBatchId(), 1, transactionDescription);
                if (message == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    private Collection retrieveAssets() throws Exception {
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setCacheable(true);
        String filter = BOAdapter.addFilterTerm(null, "companyId = ?_companyId");
        filter = BOAdapter.addFilterTerm(filter, "credit = ?_credit");
        filter = BOAdapter.addFilterTerm(filter, "subAsset = ?_subAsset");
        filter = BOAdapter.addFilterTerm(filter, "state = ?_state");
        query.setFilter(filter);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", this.company.getId());
        parameters.put("_credit", Boolean.toString(false));
        parameters.put("_subAsset", Boolean.toString(true));
        parameters.put("_state", "2");
        query.setParameters(parameters);
        query.setOrdering("id");
        String typeId = null;
        AssetManager manager = AssetManagerFactory.getInstance(this.company.getDBData());
        ArrayList<Asset> assets = new ArrayList<Asset>();
        Iterator iter = manager.getCollection(query).iterator();
        int[] nextYearPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.wofYear, this.wofPeriod);
        while (iter.hasNext()) {
            this.asset = (Asset)iter.next();
            typeId = this.asset.getAssetType().getId();
            if (this.typeFrom.length() > 0 && typeId.compareTo(this.typeFrom) < 0 || this.typeTo.length() > 0 && typeId.compareTo(this.typeTo) > 0 || this.asset.getAssetType().getExclWriteOff() || PeriodHelper.isBefore(this.wofYear, this.wofPeriod, this.asset.getStartUseYear(), this.asset.getStartUsePeriod()) || !this.validateForWriteOff(this.asset, nextYearPeriod[0], nextYearPeriod[1])) continue;
            assets.add(this.asset);
        }
        return assets;
    }

    private boolean validateForWriteOff(Asset asset, int nextYear, int nextPeriod) throws Exception {
        Iterator valuations = asset.getValuationsCollection(null).iterator();
        boolean writeOff = true;
        while (valuations.hasNext() && writeOff) {
            Valuation valuation = (Valuation)valuations.next();
            if (!valuation.getPostedAcquisitionBalance().equals(valuation.getPostedDepreciationBalance())) {
                writeOff = false;
                continue;
            }
            if (PeriodHelper.isAfter(valuation.getLastAcquisitionBookYear(), valuation.getLastAcquisitionPeriod(), this.wofYear, this.wofPeriod) || PeriodHelper.isAfter(valuation.getLastDepreciationBookYear(), valuation.getLastDepreciationPeriod(), this.wofYear, this.wofPeriod)) {
                writeOff = false;
                continue;
            }
            if (TransactionBO.getAfterOrEquals(asset, nextYear, nextPeriod, valuation.getAccountingPrinciple()).isEmpty()) continue;
            writeOff = false;
        }
        return writeOff;
    }

    private String createAnonymousTransaction(int batchId, int accountingPrinciple, String reasonDescription) throws Exception {
        String message = null;
        boolean hasNotPostedTransactions = false;
        hasNotPostedTransactions = AssetBO.hasNotPostedTransactions(this.asset);
        this.finDimId1 = this.asset.getFinDimId1();
        this.finDimId2 = this.asset.getFinDimId2();
        this.finDimId3 = this.asset.getFinDimId3();
        this.finDimId4 = this.asset.getFinDimId4();
        this.finDimId5 = this.asset.getFinDimId5();
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), 0, 0, reasonDescription, this.asset.getCora(), this.asset.getId(), accountingPrinciple, 9, 140, this.facYear, this.facPeriod, this.finYear, this.finPeriod, new BigDecimal("0"), new BigDecimal("0"), new BigDecimal("0"), null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(accountingPrinciple, 9), 0, batchId, this.user, this.asset.getTypeId());
        if (objects[0] == null) {
            message = (String)objects[1];
            return message;
        }
        Transaction anonymousTransaction = (Transaction)objects[0];
        anonymousTransaction.setDescription(reasonDescription);
        if (hasNotPostedTransactions) {
            anonymousTransaction.setReasonCode(50);
        } else {
            Valuation valuation = (Valuation)ValuationBO.get(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId(), 1)[0];
            anonymousTransaction.setAmount1(valuation == null ? ZERO : valuation.getPostedAcquisitionBalance().negate());
            anonymousTransaction.setAmount2(valuation == null ? ZERO : valuation.getPostedDepreciationBalance().negate());
            if (valuation.getDepreciatableLife() - valuation.getNumberOfDepreciatedPeriods() != 0) {
                anonymousTransaction.setReasonCode(70);
            }
            if ((valuation = (Valuation)ValuationBO.get(this.asset.getDBData(), this.asset.getCompanyId(), this.asset.getCora(), this.asset.getId(), 2)[0]) != null && valuation.getDepreciatableLife() - valuation.getNumberOfDepreciatedPeriods() != 0) {
                anonymousTransaction.setReasonCode(70);
            }
        }
        return message;
    }

    @Override
    public String postProposal(TransactionBatch transactionBatch, String user) throws Exception {
        this.user = user;
        this.getParameters(transactionBatch);
        String message = null;
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            WriteOffBP writeOffBP = new WriteOffBP(this.company, 0);
            Transaction transaction = null;
            Iterator transactions = TransactionBO.getTransactions(transactionBatch).iterator();
            while (transactions.hasNext()) {
                transaction = (Transaction)transactions.next();
                if (transaction.getReasonCode() != 50) {
                    this.asset = transaction.getAsset();
                    message = writeOffBP.createWriteOff(this.asset, transaction, user, transactionBatch.getBatchId(), transaction.getDocumentNr());
                    if (message != null) {
                        BOAdapter.investigate(null, dbTransaction);
                        return message;
                    }
                }
                transactions.remove();
                message = TransactionBO.delete(transaction, null, null);
                if (message == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            transactionBatch.setState(1);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    @Override
    public void addParameters(TransactionBatch transactionBatch, String[][] selections) throws Exception {
        this.key.setCompanyId(transactionBatch.getCompanyId());
        this.key.setBatchId(transactionBatch.getBatchId());
        this.bean.setCompanyId(transactionBatch.getCompanyId());
        this.bean.setBatchId(transactionBatch.getBatchId());
        this.addParameter(TYPEFROM, selections);
        this.addParameter(TYPETO, selections);
        this.addParameter(WOFPER_YEAR, selections);
        this.addParameter(WOFPER_PER, selections);
        transactionBatch.setEndYear(Integer.parseInt(MassWriteOffBP.retrieve("FACPERYEAR", selections)));
        transactionBatch.setEndPeriod(Integer.parseInt(MassWriteOffBP.retrieve("FACPERPER", selections)));
        transactionBatch.setFinYear(Integer.parseInt(MassWriteOffBP.retrieve("FINPERYEAR", selections)));
        transactionBatch.setFinPeriod(Integer.parseInt(MassWriteOffBP.retrieve("FINPERPER", selections)));
    }

    private void addParameter(String parmName, String[][] selections) throws Exception {
        this.bean.setParameterName(parmName);
        int i = 0;
        while (i < selections.length) {
            if (selections[i][0].equals(parmName)) {
                this.bean.setParameterValue(selections[i][1]);
                this.manager.create(this.bean);
                return;
            }
            ++i;
        }
    }

    private void getParameters(TransactionBatch transactionBatch) throws Exception {
        this.key.setCompanyId(transactionBatch.getCompanyId());
        this.key.setBatchId(transactionBatch.getBatchId());
        this.facYear = transactionBatch.getEndYear();
        this.facPeriod = transactionBatch.getEndPeriod();
        this.finYear = transactionBatch.getFinYear();
        this.finPeriod = transactionBatch.getFinPeriod();
        this.typeFrom = this.getParameter(TYPEFROM);
        this.typeTo = this.getParameter(TYPETO);
        this.wofYear = Integer.parseInt(this.getParameter(WOFPER_YEAR));
        this.wofPeriod = Integer.parseInt(this.getParameter(WOFPER_PER));
    }

    private String getParameter(String parmName) throws Exception {
        this.key.setParameterName(parmName);
        try {
            return this.manager.findByPrimaryKey(this.key).getParameterValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getParameter(TransactionBatch transactionBatch, String parmName) throws Exception {
        this.key.setCompanyId(transactionBatch.getCompanyId());
        this.key.setBatchId(transactionBatch.getBatchId());
        this.key.setParameterName(parmName);
        try {
            return this.manager.findByPrimaryKey(this.key).getParameterValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String[][] getExtraBatchDetails(TransactionBatch transactionBatch) throws Exception {
        String[][] details = new String[3][2];
        this.getParameters(transactionBatch);
        details[0][0] = "Label.AssetTypeFrom";
        details[0][1] = this.typeFrom;
        details[1][0] = "Label.AssetTypeTo";
        details[1][1] = this.typeTo;
        details[2][0] = "Label.WriteOffPeriod";
        details[2][1] = this.wofYear + "-" + this.wofPeriod;
        return details;
    }

    @Override
    public String getTransactionDescription(TransactionBatch transactionBatch) throws Exception {
        StringBuffer result = new StringBuffer();
        this.getParameters(transactionBatch);
        result.append(LanguageHelper.getString("nl.ibs.fac.language", "WriteOffPeriod"));
        result.append(" ");
        result.append("" + this.wofYear);
        result.append("-");
        result.append("" + this.wofPeriod);
        return result.toString();
    }
}

