/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import nl.ibs.fac.PeriodHelper;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.FinancialDimensionHistoryBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;

public class MovementBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 6818921037493184301L;
    private String[] ids;
    private String reasonDescription;
    private boolean isFirstPeriodMovement;
    private int documentNr1stTransaction;
    private int seqNr1stTransaction;
    private Valuation valuation;
    private int[] previousFacYP;
    private int limitYear;
    private int limitPeriod;

    public MovementBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
    }

    public String[] retrieveYearsAndPeriods(Asset asset) throws Exception {
        String[] yps = new String[4];
        if (this.company.getLastDepreciationRunYear() > 0) {
            int[] nextPeriod = PeriodHelper.getNextPeriod(this.numberOfPeriods, this.company.getLastDepreciationRunYear(), this.company.getLastDepreciationRunPeriod());
            yps[0] = "" + nextPeriod[0];
            yps[1] = "" + nextPeriod[1];
        } else {
            yps[0] = "" + asset.getStartUseYear();
            yps[1] = "" + asset.getStartUsePeriod();
        }
        if (!this.processParameters.getDefaultValueInBookPeriod()) {
            yps[2] = "";
            yps[3] = "";
        } else {
            yps[2] = yps[0];
            yps[3] = yps[1];
        }
        return yps;
    }

    public String[] validateFACYearAndPeriod(Asset asset, int facYear, int facPeriod) throws Exception {
        int status;
        int thePeriod;
        String[] messages = new String[2];
        int index = 0;
        int theYear = asset.getStartUseYear();
        if (PeriodHelper.isBefore(facYear, facPeriod, theYear, thePeriod = asset.getStartUsePeriod())) {
            messages[index] = "FACPeriodBeforeStartUsePeriod";
            ++index;
        }
        if ((status = BookYearBO.getPeriodStatus(this.company, facYear, facPeriod)) == 0) {
            messages[index] = "bookYear_not_found";
            ++index;
        }
        if (status == 1) {
            messages[index] = "FACPeriodBlockedForManualTransactions";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String move(Asset asset, int movementYear, int movementPeriod, int financialYear, int financialPeriod, String[] ids, String reasonDescription, String user, int limitYear, int limitPeriod, int batchId, int transactionNumber) throws Exception {
        this.asset = asset;
        this.facYear = movementYear;
        this.facPeriod = movementPeriod;
        this.finYear = financialYear;
        this.finPeriod = financialPeriod;
        this.ids = ids;
        this.reasonDescription = reasonDescription;
        this.user = user;
        this.limitYear = limitYear;
        this.limitPeriod = limitPeriod;
        this.documentNr = transactionNumber;
        this.seqNr = 0;
        this.post = true;
        this.isFirstPeriodMovement = false;
        if (PeriodHelper.equals(this.facYear, this.facPeriod, asset.getStartUseYear(), asset.getStartUsePeriod())) {
            this.isFirstPeriodMovement = true;
        } else {
            this.previousFacYP = PeriodHelper.getPreviousPeriod(this.numberOfPeriods, this.facYear, this.facPeriod);
        }
        String message = null;
        Iterator vi = asset.getValuationsCollection(null).iterator();
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            while (vi.hasNext()) {
                this.valuation = (Valuation)vi.next();
                message = this.createAnonymousTransaction(this.valuation.getAccountingPrinciple(), batchId);
                if (message != null) {
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                if (!this.isFirstPeriodMovement) {
                    if (!PeriodHelper.isBefore(this.previousFacYP[0], this.previousFacYP[1], this.valuation.getLastDepreciationBookYear(), this.valuation.getLastDepreciationPeriod()) && (message = this.createAdditionalDepreciationTransactions(this.valuation, this.previousFacYP, String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "MovementReference")) + " " + this.facYear + "/" + this.facPeriod + " " + this.documentNr, batchId, null, null)) != null) {
                        BOAdapter.investigate(null, dbTransaction);
                        return message;
                    }
                    message = this.handleBalanceValues(this.valuation.getAccountingPrinciple(), batchId);
                    if (message != null) {
                        BOAdapter.investigate(null, dbTransaction);
                        return message;
                    }
                } else {
                    this.documentNr1stTransaction = this.valuation.getDocumentNr1stTransaction();
                    this.seqNr1stTransaction = this.valuation.getSeqNr1stTransaction();
                }
                if ((message = this.handleTransactions(this.valuation.getAccountingPrinciple(), batchId)) == null) continue;
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            Object[] objects = FinancialDimensionHistoryBO.create(asset, movementYear, movementPeriod, ids[0], ids[1], ids[2], ids[3], ids[4]);
            if (objects[1] != null) {
                message = (String)objects[1];
                BOAdapter.investigate(null, dbTransaction);
                return message;
            }
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    private String createAnonymousTransaction(int accountingPrinciple, int batchId) throws Exception {
        String message = null;
        if (this.finYear == 0) {
            this.finBookYear = this.facYear;
            this.finBookPeriod = this.facPeriod;
        } else {
            this.finBookYear = this.finYear;
            this.finBookPeriod = this.finPeriod;
        }
        this.retrieveFinancialDimensions(this.facYear, this.facPeriod);
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, this.reasonDescription, this.asset.getCora(), this.asset.getId(), accountingPrinciple, 9, 40, this.facYear, this.facPeriod, this.finBookYear, this.finBookPeriod, new BigDecimal("0"), new BigDecimal("0"), new BigDecimal("0"), null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(accountingPrinciple, 9), 0, batchId, this.user, this.asset.getTypeId());
        if (objects[0] == null) {
            message = (String)objects[1];
        } else {
            Transaction anonymousTransaction = (Transaction)objects[0];
            anonymousTransaction.setState(1);
            if (this.documentNr == 0) {
                this.documentNr = anonymousTransaction.getDocumentNr();
            }
        }
        return message;
    }

    private String handleBalanceValues(int accountingPrinciple, int batchId) throws Exception {
        String message = null;
        int[] previous = PeriodHelper.getPreviousPeriod(this.numberOfPeriods, this.facYear, this.facPeriod);
        BigDecimal[] balanceValues = TransactionBO.calculateAcquisitionValue(this.asset, accountingPrinciple, previous[0], previous[1]);
        BigDecimal acquisitionBalance = balanceValues[0];
        BigDecimal depreciatedBalance = balanceValues[1].add(TransactionBO.calculateDepreciatedTotal(this.asset, accountingPrinciple, previous[0], previous[1])[0]);
        if (this.finYear == 0) {
            this.finBookYear = this.facYear;
            this.finBookPeriod = this.facPeriod;
        } else {
            this.finBookYear = this.finYear;
            this.finBookPeriod = this.finPeriod;
        }
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, LanguageHelper.getString("nl.ibs.fac.language", "ContraBookingBalanceValues"), this.asset.getCora(), this.asset.getId(), accountingPrinciple, 1, 40, this.facYear, this.facPeriod, this.finBookYear, this.finBookPeriod, acquisitionBalance.negate(), depreciatedBalance.negate(), new BigDecimal("0"), null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(accountingPrinciple, 1), 0, batchId, this.user, this.asset.getTypeId());
        if (objects[0] == null) {
            message = (String)objects[1];
            return message;
        }
        Transaction disinvestmentTransaction = (Transaction)objects[0];
        disinvestmentTransaction.setInfoLevel(1);
        if (this.processParameters.getUseCorrectionCodeDC()) {
            disinvestmentTransaction.setCorrectionCodeDC("J");
        }
        disinvestmentTransaction.setState(1);
        objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, LanguageHelper.getString("nl.ibs.fac.language", "PlusBookingBalanceValues"), this.asset.getCora(), this.asset.getId(), accountingPrinciple, 1, 40, this.facYear, this.facPeriod, this.finBookYear, this.finBookPeriod, acquisitionBalance, depreciatedBalance, new BigDecimal("0"), null, this.ids[0], this.ids[1], this.ids[2], this.ids[3], this.ids[4], this.retrieveJournalingState(accountingPrinciple, 1), 0, batchId, this.user, this.asset.getTypeId());
        if (objects[0] == null) {
            message = (String)objects[1];
            return message;
        }
        Transaction investmentTransaction = (Transaction)objects[0];
        investmentTransaction.setInfoLevel(1);
        investmentTransaction.setState(1);
        return message;
    }

    private String handleTransactions(int accountingPrinciple, int batchId) throws Exception {
        String message = null;
        Collection transactionsToBeReversed = TransactionBO.getAfterOrEquals(this.asset, this.facYear, this.facPeriod, accountingPrinciple);
        if (transactionsToBeReversed == null || transactionsToBeReversed.isEmpty()) {
            return message;
        }
        for (Transaction transaction : transactionsToBeReversed) {
            if (transaction.getDocumentNr() == this.documentNr || transaction.getRevCode() > 0) continue;
            if (transaction.getMainTransactionType() == 9) {
                if (transaction.getTransactionType() != 40 || transaction.getDocumentNr() == this.documentNr) continue;
                transaction.setInfoLevel(1);
                continue;
            }
            if (this.limitYear != 0 && transaction.getTransactionType() != 40 && !PeriodHelper.isBefore(transaction.getBookYear(), transaction.getPeriod(), this.limitYear, this.limitPeriod)) continue;
            if (transaction.getAmount1().doubleValue() == 0.0 && transaction.getAmount2().doubleValue() == 0.0 && transaction.getAmount3().doubleValue() == 0.0) {
                this.updateTransactionDimensions(transaction);
                continue;
            }
            Object[] objects = this.createReversingTransaction(transaction, this.reasonDescription, batchId);
            if (objects[0] == null) {
                message = (String)objects[1];
                return message;
            }
            Transaction reversingTransaction = (Transaction)objects[0];
            reversingTransaction.setState(1);
            if (transaction.getTransactionType() == 40) continue;
            objects = this.createTransactionCopy(transaction, batchId);
            if (objects[0] == null) {
                message = (String)objects[1];
                return message;
            }
            Transaction transactionCopy = (Transaction)objects[0];
            this.updateTransactionDimensions(transactionCopy);
            transactionCopy.setOriginalInterestPercentage(transaction.getOriginalInterestPercentage());
            transactionCopy.setState(1);
            if (!this.isFirstPeriodMovement || transaction.getDocumentNr() != this.documentNr1stTransaction || transaction.getSeqNr() != this.seqNr1stTransaction) continue;
            this.valuation.setDocumentNr1stTransaction(transactionCopy.getDocumentNr());
            this.valuation.setSeqNr1stTransaction(transactionCopy.getSeqNr());
        }
        return message;
    }

    private Object[] createTransactionCopy(Transaction transaction, int batchId) throws Exception {
        int year = transaction.getBookYear();
        int period = transaction.getPeriod();
        if (this.finYear == 0) {
            this.finBookYear = year;
            this.finBookPeriod = period;
        } else {
            this.finBookYear = this.finYear;
            this.finBookPeriod = this.finPeriod;
        }
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, ++this.seqNr, this.reasonDescription, transaction.getCora(), transaction.getAssetId(), transaction.getAccountingPrinciple(), transaction.getMainTransactionType(), transaction.getTransactionType(), year, period, this.finBookYear, this.finBookPeriod, transaction.getAmount1(), transaction.getAmount2(), transaction.getAmount3(), null, transaction.getFinDimId1(), transaction.getFinDimId2(), transaction.getFinDimId3(), transaction.getFinDimId4(), transaction.getFinDimId5(), this.retrieveJournalingState(transaction.getAccountingPrinciple(), transaction.getMainTransactionType()), 0, batchId, this.user, transaction.getProFormaTypeId());
        return objects;
    }

    private void updateTransactionDimensions(Transaction transaction) throws Exception {
        transaction.setFinDimId1(this.ids[0]);
        transaction.setFinDimId2(this.ids[1]);
        transaction.setFinDimId3(this.ids[2]);
        transaction.setFinDimId4(this.ids[3]);
        transaction.setFinDimId5(this.ids[4]);
    }
}

