/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.bp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.fac.boadapters.BOAdapter;
import nl.ibs.fac.boadapters.BookYearBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.bp.GenericTransactionBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetManager;
import nl.ibs.fac.db.AssetManagerFactory;
import nl.ibs.fac.db.BookYear;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.language.LanguageHelper;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class TransactionAggregationBP
extends GenericTransactionBP {
    private static final long serialVersionUID = 4518615748928350799L;
    public static String BOOKYEAR = "BOOKYEAR_TO_AGGREGATE";
    private static BigDecimal ZERO = new BigDecimal(0.0);
    private int bookYearToAggregate;
    private BigDecimal amount1;
    private BigDecimal amount2;
    private BigDecimal amount3;
    private String transactionDescription;

    public TransactionAggregationBP(Company company, int numberOfPeriods) throws Exception {
        super(company, numberOfPeriods);
    }

    public String[] retrieveYears() throws Exception {
        String[] year = new String[4];
        int yr = 0;
        yr = this.company.getInitialBookYear();
        year[0] = yr == 0 ? "" : "" + yr;
        yr = this.company.getLastDepreciationRunYear();
        year[1] = yr == 0 ? "" : "" + yr;
        yr = this.company.getLastAggregatedBookYear();
        year[2] = yr == 0 ? "" : "" + yr;
        yr = this.company.getLastAggregatedBookYear() + 1;
        year[3] = yr == 1 ? "" + this.company.getInitialBookYear() : "" + yr;
        return year;
    }

    public String[] validate(Company company, int yearToAggregate) throws Exception {
        String[] messages = new String[2];
        int index = 0;
        if (yearToAggregate >= company.getLastDepreciationRunYear()) {
            messages[index] = "bookyear_must_be_less_depr_year";
            ++index;
        }
        BookYear bookYear = (BookYear)BookYearBO.get(company, yearToAggregate)[0];
        boolean allPeriodsClosed = true;
        int period = 1;
        while (period <= this.numberOfPeriods) {
            if (bookYear.getPeriodTo() < period && (bookYear.getPeriodFrom() <= 0 || period < bookYear.getPeriodFrom())) {
                allPeriodsClosed = false;
            }
            ++period;
        }
        if (!allPeriodsClosed) {
            messages[index] = "bookYear_not_completely_blocked";
            ++index;
        }
        if (bookYear.getAggregated()) {
            messages[index] = "bookYear_already_aggregated";
            ++index;
        }
        if (index == 0) {
            messages = null;
        }
        return messages;
    }

    public String aggregate(Company company, int bookYear, String user) throws Exception {
        this.bookYearToAggregate = bookYear;
        this.user = user;
        this.facYear = bookYear;
        this.facPeriod = this.numberOfPeriods;
        this.finBookYear = this.facYear;
        this.finBookPeriod = this.facPeriod;
        this.transactionDescription = String.valueOf(LanguageHelper.getString("nl.ibs.fac.language", "TotalBookYear")) + " " + bookYear;
        String message = null;
        company.setAggregationInProgress(true);
        boolean alreadyActive = BOAdapter.beginTransaction();
        DBTransaction dbTransaction = DBPersistenceManager.getCurrentTransaction();
        try {
            Iterator assets = this.retrieveAssets().iterator();
            Valuation valuation2 = null;
            while (assets.hasNext()) {
                this.asset = (Asset)assets.next();
                this.finDimId1 = this.asset.getFinDimId1();
                this.finDimId2 = this.asset.getFinDimId2();
                this.finDimId3 = this.asset.getFinDimId3();
                this.finDimId4 = this.asset.getFinDimId4();
                this.finDimId5 = this.asset.getFinDimId5();
                this.documentNr = 0;
                for (Valuation valuation2 : this.asset.getValuationsCollection(null)) {
                    this.seqNr = valuation2.getAccountingPrinciple();
                    Collection transactions = TransactionBO.get(this.asset, this.bookYearToAggregate, valuation2.getAccountingPrinciple(), true, false);
                    if (transactions.size() < 2 || (message = this.createAnonymousTransaction(valuation2.getAccountingPrinciple(), transactions)) == null) continue;
                    BOAdapter.investigate(null, dbTransaction);
                    return message;
                }
                BOAdapter.commitTransaction(alreadyActive);
            }
            BookYear bookYearToBlock = (BookYear)BookYearBO.get(company, this.bookYearToAggregate)[0];
            if (bookYearToBlock != null) {
                bookYearToBlock.setAggregated(true);
            }
            company.setLastAggregatedBookYear(this.bookYearToAggregate);
            company.setAggregationInProgress(false);
            BOAdapter.commitTransaction(alreadyActive);
        }
        catch (Exception e) {
            message = BOAdapter.investigate(e, dbTransaction);
        }
        return message;
    }

    private Collection retrieveAssets() throws Exception {
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setCacheable(true);
        String filter = BOAdapter.addFilterTerm(null, "companyId = ?_companyId");
        filter = BOAdapter.addFilterTerm(filter, "credit = ?_credit");
        filter = BOAdapter.addFilterTerm(filter, "subAsset = ?_subAsset");
        filter = BOAdapter.addFilterTerm(filter, "state != ?_state");
        query.setFilter(filter);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("_companyId", this.company.getId());
        parameters.put("_credit", Boolean.toString(false));
        parameters.put("_subAsset", Boolean.toString(true));
        parameters.put("_state", "0");
        query.setParameters(parameters);
        query.setOrdering("id");
        AssetManager manager = AssetManagerFactory.getInstance(this.company.getDBData());
        ArrayList<Asset> assets = new ArrayList<Asset>();
        for (Asset this.asset : manager.getCollection(query)) {
            if (!this.validateForAggregation(this.asset)) continue;
            assets.add(this.asset);
        }
        return assets;
    }

    private boolean validateForAggregation(Asset asset) throws Exception {
        if (asset.getStartUseYear() > this.bookYearToAggregate) {
            return false;
        }
        return asset.getDisinvestmentYear() == 0 || asset.getDisinvestmentYear() > this.bookYearToAggregate;
    }

    private String createAnonymousTransaction(int accountingPrinciple, Collection transactions) throws Exception {
        String message = null;
        Object[] objects = TransactionBO.create(this.company.getDBData(), this.company.getId(), this.documentNr, this.seqNr, this.transactionDescription, this.asset.getCora(), this.asset.getId(), accountingPrinciple, 9, 150, this.facYear, this.facPeriod, this.finBookYear, this.finBookPeriod, ZERO, ZERO, ZERO, null, this.finDimId1, this.finDimId2, this.finDimId3, this.finDimId4, this.finDimId5, this.retrieveJournalingState(accountingPrinciple, 9), 0, 0, this.user, this.asset.getTypeId());
        if (objects[0] == null) {
            message = (String)objects[1];
            return message;
        }
        Transaction anonymousTransaction = (Transaction)objects[0];
        this.documentNr = anonymousTransaction.getDocumentNr();
        this.handleTransactions(transactions, anonymousTransaction.getDocumentNr(), anonymousTransaction.getSeqNr());
        anonymousTransaction.setAmount1(this.amount1);
        anonymousTransaction.setAmount2(this.amount2);
        anonymousTransaction.setAmount3(this.amount3);
        anonymousTransaction.setState(1);
        return message;
    }

    private void handleTransactions(Collection transactions, int aggregationDocumentNr, int aggregationSeqNr) throws Exception {
        this.amount1 = ZERO;
        this.amount2 = ZERO;
        this.amount3 = ZERO;
        int mainTransactionType = 0;
        Iterator ti = transactions.iterator();
        Transaction transaction = null;
        while (ti.hasNext()) {
            transaction = (Transaction)ti.next();
            mainTransactionType = transaction.getMainTransactionType();
            switch (mainTransactionType) {
                case 1: {
                    this.amount1 = this.amount1.add(transaction.getAmount1());
                    this.amount2 = this.amount2.add(transaction.getAmount2());
                    break;
                }
                case 2: {
                    this.amount1 = this.amount1.add(transaction.getAmount1());
                    this.amount2 = this.amount2.add(transaction.getAmount2());
                    break;
                }
                case 3: {
                    this.amount2 = this.amount2.add(transaction.getAmount2());
                    this.amount3 = this.amount3.add(transaction.getAmount3());
                    break;
                }
                case 5: {
                    this.amount2 = this.amount2.add(transaction.getAmount2());
                }
            }
            transaction.setAggregationDocumentNr(aggregationDocumentNr);
            transaction.setAggregationSeqNr(aggregationSeqNr);
            transaction.setInfoLevel(2);
        }
    }
}

